# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFirewallResult',
    'AwaitableGetFirewallResult',
    'get_firewall',
    'get_firewall_output',
]

@pulumi.output_type
class GetFirewallResult:
    """
    A collection of values returned by getFirewall.
    """
    def __init__(__self__, dns_proxy_enabled=None, dns_servers=None, firewall_policy_id=None, id=None, ip_configurations=None, location=None, management_ip_configurations=None, name=None, resource_group_name=None, sku_name=None, sku_tier=None, tags=None, threat_intel_mode=None, virtual_hubs=None, zones=None):
        if dns_proxy_enabled and not isinstance(dns_proxy_enabled, bool):
            raise TypeError("Expected argument 'dns_proxy_enabled' to be a bool")
        pulumi.set(__self__, "dns_proxy_enabled", dns_proxy_enabled)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if firewall_policy_id and not isinstance(firewall_policy_id, str):
            raise TypeError("Expected argument 'firewall_policy_id' to be a str")
        pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_configurations and not isinstance(ip_configurations, list):
            raise TypeError("Expected argument 'ip_configurations' to be a list")
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if management_ip_configurations and not isinstance(management_ip_configurations, list):
            raise TypeError("Expected argument 'management_ip_configurations' to be a list")
        pulumi.set(__self__, "management_ip_configurations", management_ip_configurations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if sku_tier and not isinstance(sku_tier, str):
            raise TypeError("Expected argument 'sku_tier' to be a str")
        pulumi.set(__self__, "sku_tier", sku_tier)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if threat_intel_mode and not isinstance(threat_intel_mode, str):
            raise TypeError("Expected argument 'threat_intel_mode' to be a str")
        pulumi.set(__self__, "threat_intel_mode", threat_intel_mode)
        if virtual_hubs and not isinstance(virtual_hubs, list):
            raise TypeError("Expected argument 'virtual_hubs' to be a list")
        pulumi.set(__self__, "virtual_hubs", virtual_hubs)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="dnsProxyEnabled")
    def dns_proxy_enabled(self) -> builtins.bool:
        """
        Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when it is `true`.
        """
        return pulumi.get(self, "dns_proxy_enabled")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[builtins.str]:
        """
        The list of DNS servers that the Azure Firewall will direct DNS traffic to for name resolution.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> builtins.str:
        """
        The ID of the Firewall Policy applied to the Azure Firewall.
        """
        return pulumi.get(self, "firewall_policy_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetFirewallIpConfigurationResult']:
        """
        A `ip_configuration` block as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location where the Azure Firewall exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managementIpConfigurations")
    def management_ip_configurations(self) -> Sequence['outputs.GetFirewallManagementIpConfigurationResult']:
        """
        A `management_ip_configuration` block as defined below, which allows force-tunnelling of traffic to be performed by the firewall.
        """
        return pulumi.get(self, "management_ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> builtins.str:
        """
        The SKU name of the Azure Firewall.
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> builtins.str:
        """
        The SKU tier of the Azure Firewall.
        """
        return pulumi.get(self, "sku_tier")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Azure Firewall.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="threatIntelMode")
    def threat_intel_mode(self) -> builtins.str:
        """
        The operation mode for threat intelligence-based filtering.
        """
        return pulumi.get(self, "threat_intel_mode")

    @property
    @pulumi.getter(name="virtualHubs")
    def virtual_hubs(self) -> Sequence['outputs.GetFirewallVirtualHubResult']:
        """
        A `virtual_hub` block as defined below.
        """
        return pulumi.get(self, "virtual_hubs")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        """
        A list of Availability Zones in which this Azure Firewall is located.
        """
        return pulumi.get(self, "zones")


class AwaitableGetFirewallResult(GetFirewallResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallResult(
            dns_proxy_enabled=self.dns_proxy_enabled,
            dns_servers=self.dns_servers,
            firewall_policy_id=self.firewall_policy_id,
            id=self.id,
            ip_configurations=self.ip_configurations,
            location=self.location,
            management_ip_configurations=self.management_ip_configurations,
            name=self.name,
            resource_group_name=self.resource_group_name,
            sku_name=self.sku_name,
            sku_tier=self.sku_tier,
            tags=self.tags,
            threat_intel_mode=self.threat_intel_mode,
            virtual_hubs=self.virtual_hubs,
            zones=self.zones)


def get_firewall(dns_proxy_enabled: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 resource_group_name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallResult:
    """
    Use this data source to access information about an existing Azure Firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_firewall(name="firewall1",
        resource_group_name="firewall-RG")
    pulumi.export("firewallPrivateIp", example.ip_configurations[0].private_ip_address)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.bool dns_proxy_enabled: Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when it is `true`.
    :param builtins.str name: The name of the Azure Firewall.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Azure Firewall exists.
    """
    __args__ = dict()
    __args__['dnsProxyEnabled'] = dns_proxy_enabled
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getFirewall:getFirewall', __args__, opts=opts, typ=GetFirewallResult).value

    return AwaitableGetFirewallResult(
        dns_proxy_enabled=pulumi.get(__ret__, 'dns_proxy_enabled'),
        dns_servers=pulumi.get(__ret__, 'dns_servers'),
        firewall_policy_id=pulumi.get(__ret__, 'firewall_policy_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_configurations=pulumi.get(__ret__, 'ip_configurations'),
        location=pulumi.get(__ret__, 'location'),
        management_ip_configurations=pulumi.get(__ret__, 'management_ip_configurations'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        sku_tier=pulumi.get(__ret__, 'sku_tier'),
        tags=pulumi.get(__ret__, 'tags'),
        threat_intel_mode=pulumi.get(__ret__, 'threat_intel_mode'),
        virtual_hubs=pulumi.get(__ret__, 'virtual_hubs'),
        zones=pulumi.get(__ret__, 'zones'))
def get_firewall_output(dns_proxy_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                        name: Optional[pulumi.Input[builtins.str]] = None,
                        resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallResult]:
    """
    Use this data source to access information about an existing Azure Firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_firewall(name="firewall1",
        resource_group_name="firewall-RG")
    pulumi.export("firewallPrivateIp", example.ip_configurations[0].private_ip_address)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.bool dns_proxy_enabled: Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when it is `true`.
    :param builtins.str name: The name of the Azure Firewall.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Azure Firewall exists.
    """
    __args__ = dict()
    __args__['dnsProxyEnabled'] = dns_proxy_enabled
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getFirewall:getFirewall', __args__, opts=opts, typ=GetFirewallResult)
    return __ret__.apply(lambda __response__: GetFirewallResult(
        dns_proxy_enabled=pulumi.get(__response__, 'dns_proxy_enabled'),
        dns_servers=pulumi.get(__response__, 'dns_servers'),
        firewall_policy_id=pulumi.get(__response__, 'firewall_policy_id'),
        id=pulumi.get(__response__, 'id'),
        ip_configurations=pulumi.get(__response__, 'ip_configurations'),
        location=pulumi.get(__response__, 'location'),
        management_ip_configurations=pulumi.get(__response__, 'management_ip_configurations'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        sku_tier=pulumi.get(__response__, 'sku_tier'),
        tags=pulumi.get(__response__, 'tags'),
        threat_intel_mode=pulumi.get(__response__, 'threat_intel_mode'),
        virtual_hubs=pulumi.get(__response__, 'virtual_hubs'),
        zones=pulumi.get(__response__, 'zones')))
