# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkManagerConnectivityConfigurationResult',
    'AwaitableGetNetworkManagerConnectivityConfigurationResult',
    'get_network_manager_connectivity_configuration',
    'get_network_manager_connectivity_configuration_output',
]

@pulumi.output_type
class GetNetworkManagerConnectivityConfigurationResult:
    """
    A collection of values returned by getNetworkManagerConnectivityConfiguration.
    """
    def __init__(__self__, applies_to_groups=None, connectivity_topology=None, delete_existing_peering_enabled=None, description=None, global_mesh_enabled=None, hubs=None, id=None, name=None, network_manager_id=None):
        if applies_to_groups and not isinstance(applies_to_groups, list):
            raise TypeError("Expected argument 'applies_to_groups' to be a list")
        pulumi.set(__self__, "applies_to_groups", applies_to_groups)
        if connectivity_topology and not isinstance(connectivity_topology, str):
            raise TypeError("Expected argument 'connectivity_topology' to be a str")
        pulumi.set(__self__, "connectivity_topology", connectivity_topology)
        if delete_existing_peering_enabled and not isinstance(delete_existing_peering_enabled, bool):
            raise TypeError("Expected argument 'delete_existing_peering_enabled' to be a bool")
        pulumi.set(__self__, "delete_existing_peering_enabled", delete_existing_peering_enabled)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if global_mesh_enabled and not isinstance(global_mesh_enabled, bool):
            raise TypeError("Expected argument 'global_mesh_enabled' to be a bool")
        pulumi.set(__self__, "global_mesh_enabled", global_mesh_enabled)
        if hubs and not isinstance(hubs, list):
            raise TypeError("Expected argument 'hubs' to be a list")
        pulumi.set(__self__, "hubs", hubs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_manager_id and not isinstance(network_manager_id, str):
            raise TypeError("Expected argument 'network_manager_id' to be a str")
        pulumi.set(__self__, "network_manager_id", network_manager_id)

    @property
    @pulumi.getter(name="appliesToGroups")
    def applies_to_groups(self) -> Sequence['outputs.GetNetworkManagerConnectivityConfigurationAppliesToGroupResult']:
        """
        An `applies_to_group` block as defined below.
        """
        return pulumi.get(self, "applies_to_groups")

    @property
    @pulumi.getter(name="connectivityTopology")
    def connectivity_topology(self) -> builtins.str:
        """
        The connectivity topology type.
        """
        return pulumi.get(self, "connectivity_topology")

    @property
    @pulumi.getter(name="deleteExistingPeeringEnabled")
    def delete_existing_peering_enabled(self) -> builtins.bool:
        """
        Whether to current existing Virtual Network Peering in the Connectivity Configuration affected scope.
        """
        return pulumi.get(self, "delete_existing_peering_enabled")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Connectivity Configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="globalMeshEnabled")
    def global_mesh_enabled(self) -> builtins.bool:
        """
        Whether global mesh is supported.
        """
        return pulumi.get(self, "global_mesh_enabled")

    @property
    @pulumi.getter
    def hubs(self) -> Sequence['outputs.GetNetworkManagerConnectivityConfigurationHubResult']:
        """
        A `hub` block as defined below.
        """
        return pulumi.get(self, "hubs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> builtins.str:
        return pulumi.get(self, "network_manager_id")


class AwaitableGetNetworkManagerConnectivityConfigurationResult(GetNetworkManagerConnectivityConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkManagerConnectivityConfigurationResult(
            applies_to_groups=self.applies_to_groups,
            connectivity_topology=self.connectivity_topology,
            delete_existing_peering_enabled=self.delete_existing_peering_enabled,
            description=self.description,
            global_mesh_enabled=self.global_mesh_enabled,
            hubs=self.hubs,
            id=self.id,
            name=self.name,
            network_manager_id=self.network_manager_id)


def get_network_manager_connectivity_configuration(name: Optional[builtins.str] = None,
                                                   network_manager_id: Optional[builtins.str] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkManagerConnectivityConfigurationResult:
    """
    Use this data source to access information about an existing Network Manager Connectivity Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_network_manager_connectivity_configuration(name="existing",
        network_manager_id="TODO")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: The name of this Network Manager Connectivity Configuration.
    :param builtins.str network_manager_id: The ID of the Network Manager.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkManagerId'] = network_manager_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getNetworkManagerConnectivityConfiguration:getNetworkManagerConnectivityConfiguration', __args__, opts=opts, typ=GetNetworkManagerConnectivityConfigurationResult).value

    return AwaitableGetNetworkManagerConnectivityConfigurationResult(
        applies_to_groups=pulumi.get(__ret__, 'applies_to_groups'),
        connectivity_topology=pulumi.get(__ret__, 'connectivity_topology'),
        delete_existing_peering_enabled=pulumi.get(__ret__, 'delete_existing_peering_enabled'),
        description=pulumi.get(__ret__, 'description'),
        global_mesh_enabled=pulumi.get(__ret__, 'global_mesh_enabled'),
        hubs=pulumi.get(__ret__, 'hubs'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_manager_id=pulumi.get(__ret__, 'network_manager_id'))
def get_network_manager_connectivity_configuration_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                                          network_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkManagerConnectivityConfigurationResult]:
    """
    Use this data source to access information about an existing Network Manager Connectivity Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_network_manager_connectivity_configuration(name="existing",
        network_manager_id="TODO")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: The name of this Network Manager Connectivity Configuration.
    :param builtins.str network_manager_id: The ID of the Network Manager.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkManagerId'] = network_manager_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getNetworkManagerConnectivityConfiguration:getNetworkManagerConnectivityConfiguration', __args__, opts=opts, typ=GetNetworkManagerConnectivityConfigurationResult)
    return __ret__.apply(lambda __response__: GetNetworkManagerConnectivityConfigurationResult(
        applies_to_groups=pulumi.get(__response__, 'applies_to_groups'),
        connectivity_topology=pulumi.get(__response__, 'connectivity_topology'),
        delete_existing_peering_enabled=pulumi.get(__response__, 'delete_existing_peering_enabled'),
        description=pulumi.get(__response__, 'description'),
        global_mesh_enabled=pulumi.get(__response__, 'global_mesh_enabled'),
        hubs=pulumi.get(__response__, 'hubs'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_manager_id=pulumi.get(__response__, 'network_manager_id')))
