# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPublicIpPrefixResult',
    'AwaitableGetPublicIpPrefixResult',
    'get_public_ip_prefix',
    'get_public_ip_prefix_output',
]

@pulumi.output_type
class GetPublicIpPrefixResult:
    """
    A collection of values returned by getPublicIpPrefix.
    """
    def __init__(__self__, id=None, ip_prefix=None, location=None, name=None, prefix_length=None, resource_group_name=None, sku=None, sku_tier=None, tags=None, zones=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_prefix and not isinstance(ip_prefix, str):
            raise TypeError("Expected argument 'ip_prefix' to be a str")
        pulumi.set(__self__, "ip_prefix", ip_prefix)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if prefix_length and not isinstance(prefix_length, int):
            raise TypeError("Expected argument 'prefix_length' to be a int")
        pulumi.set(__self__, "prefix_length", prefix_length)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if sku_tier and not isinstance(sku_tier, str):
            raise TypeError("Expected argument 'sku_tier' to be a str")
        pulumi.set(__self__, "sku_tier", sku_tier)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipPrefix")
    def ip_prefix(self) -> builtins.str:
        """
        The Public IP address range, in CIDR notation.
        """
        return pulumi.get(self, "ip_prefix")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The supported Azure location where the resource exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> builtins.int:
        """
        The number of bits of the prefix.
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The SKU of the Public IP Prefix.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> builtins.str:
        """
        The SKU Tier of the Public IP.
        """
        return pulumi.get(self, "sku_tier")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        """
        A list of Availability Zones in which this Public IP Prefix is located.
        """
        return pulumi.get(self, "zones")


class AwaitableGetPublicIpPrefixResult(GetPublicIpPrefixResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIpPrefixResult(
            id=self.id,
            ip_prefix=self.ip_prefix,
            location=self.location,
            name=self.name,
            prefix_length=self.prefix_length,
            resource_group_name=self.resource_group_name,
            sku=self.sku,
            sku_tier=self.sku_tier,
            tags=self.tags,
            zones=self.zones)


def get_public_ip_prefix(name: Optional[builtins.str] = None,
                         resource_group_name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIpPrefixResult:
    """
    Use this data source to access information about an existing Public IP Prefix.

    ## Example Usage

    ### Reference An Existing)

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_public_ip_prefix(name="name_of_public_ip",
        resource_group_name="name_of_resource_group")
    pulumi.export("publicIpPrefix", example.ip_prefix)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: Specifies the name of the public IP prefix.
    :param builtins.str resource_group_name: Specifies the name of the resource group.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getPublicIpPrefix:getPublicIpPrefix', __args__, opts=opts, typ=GetPublicIpPrefixResult).value

    return AwaitableGetPublicIpPrefixResult(
        id=pulumi.get(__ret__, 'id'),
        ip_prefix=pulumi.get(__ret__, 'ip_prefix'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        prefix_length=pulumi.get(__ret__, 'prefix_length'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku=pulumi.get(__ret__, 'sku'),
        sku_tier=pulumi.get(__ret__, 'sku_tier'),
        tags=pulumi.get(__ret__, 'tags'),
        zones=pulumi.get(__ret__, 'zones'))
def get_public_ip_prefix_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublicIpPrefixResult]:
    """
    Use this data source to access information about an existing Public IP Prefix.

    ## Example Usage

    ### Reference An Existing)

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_public_ip_prefix(name="name_of_public_ip",
        resource_group_name="name_of_resource_group")
    pulumi.export("publicIpPrefix", example.ip_prefix)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: Specifies the name of the public IP prefix.
    :param builtins.str resource_group_name: Specifies the name of the resource group.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getPublicIpPrefix:getPublicIpPrefix', __args__, opts=opts, typ=GetPublicIpPrefixResult)
    return __ret__.apply(lambda __response__: GetPublicIpPrefixResult(
        id=pulumi.get(__response__, 'id'),
        ip_prefix=pulumi.get(__response__, 'ip_prefix'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        prefix_length=pulumi.get(__response__, 'prefix_length'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku=pulumi.get(__response__, 'sku'),
        sku_tier=pulumi.get(__response__, 'sku_tier'),
        tags=pulumi.get(__response__, 'tags'),
        zones=pulumi.get(__response__, 'zones')))
