# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVirtualNetworkResult',
    'AwaitableGetVirtualNetworkResult',
    'get_virtual_network',
    'get_virtual_network_output',
]

@pulumi.output_type
class GetVirtualNetworkResult:
    """
    A collection of values returned by getVirtualNetwork.
    """
    def __init__(__self__, address_spaces=None, dns_servers=None, guid=None, id=None, location=None, name=None, resource_group_name=None, subnets=None, tags=None, vnet_peerings=None, vnet_peerings_addresses=None):
        if address_spaces and not isinstance(address_spaces, list):
            raise TypeError("Expected argument 'address_spaces' to be a list")
        pulumi.set(__self__, "address_spaces", address_spaces)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if guid and not isinstance(guid, str):
            raise TypeError("Expected argument 'guid' to be a str")
        pulumi.set(__self__, "guid", guid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vnet_peerings and not isinstance(vnet_peerings, dict):
            raise TypeError("Expected argument 'vnet_peerings' to be a dict")
        pulumi.set(__self__, "vnet_peerings", vnet_peerings)
        if vnet_peerings_addresses and not isinstance(vnet_peerings_addresses, list):
            raise TypeError("Expected argument 'vnet_peerings_addresses' to be a list")
        pulumi.set(__self__, "vnet_peerings_addresses", vnet_peerings_addresses)

    @property
    @pulumi.getter(name="addressSpaces")
    def address_spaces(self) -> Sequence[builtins.str]:
        """
        The list of address spaces used by the virtual network.
        """
        return pulumi.get(self, "address_spaces")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[builtins.str]:
        """
        The list of DNS servers used by the virtual network.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter
    def guid(self) -> builtins.str:
        """
        The GUID of the virtual network.
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Location of the virtual network.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        The list of name of the subnets that are attached to this virtual network.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vnetPeerings")
    def vnet_peerings(self) -> Mapping[str, builtins.str]:
        """
        A mapping of name - virtual network id of the virtual network peerings.
        """
        return pulumi.get(self, "vnet_peerings")

    @property
    @pulumi.getter(name="vnetPeeringsAddresses")
    def vnet_peerings_addresses(self) -> Sequence[builtins.str]:
        """
        A list of virtual network peerings IP addresses.
        """
        return pulumi.get(self, "vnet_peerings_addresses")


class AwaitableGetVirtualNetworkResult(GetVirtualNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNetworkResult(
            address_spaces=self.address_spaces,
            dns_servers=self.dns_servers,
            guid=self.guid,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            subnets=self.subnets,
            tags=self.tags,
            vnet_peerings=self.vnet_peerings,
            vnet_peerings_addresses=self.vnet_peerings_addresses)


def get_virtual_network(name: Optional[builtins.str] = None,
                        resource_group_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNetworkResult:
    """
    Use this data source to access information about an existing Virtual Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_network(name="production",
        resource_group_name="networking")
    pulumi.export("virtualNetworkId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: Specifies the name of the Virtual Network.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Virtual Network is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVirtualNetwork:getVirtualNetwork', __args__, opts=opts, typ=GetVirtualNetworkResult).value

    return AwaitableGetVirtualNetworkResult(
        address_spaces=pulumi.get(__ret__, 'address_spaces'),
        dns_servers=pulumi.get(__ret__, 'dns_servers'),
        guid=pulumi.get(__ret__, 'guid'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        subnets=pulumi.get(__ret__, 'subnets'),
        tags=pulumi.get(__ret__, 'tags'),
        vnet_peerings=pulumi.get(__ret__, 'vnet_peerings'),
        vnet_peerings_addresses=pulumi.get(__ret__, 'vnet_peerings_addresses'))
def get_virtual_network_output(name: Optional[pulumi.Input[builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualNetworkResult]:
    """
    Use this data source to access information about an existing Virtual Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_network(name="production",
        resource_group_name="networking")
    pulumi.export("virtualNetworkId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: Specifies the name of the Virtual Network.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Virtual Network is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVirtualNetwork:getVirtualNetwork', __args__, opts=opts, typ=GetVirtualNetworkResult)
    return __ret__.apply(lambda __response__: GetVirtualNetworkResult(
        address_spaces=pulumi.get(__response__, 'address_spaces'),
        dns_servers=pulumi.get(__response__, 'dns_servers'),
        guid=pulumi.get(__response__, 'guid'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        subnets=pulumi.get(__response__, 'subnets'),
        tags=pulumi.get(__response__, 'tags'),
        vnet_peerings=pulumi.get(__response__, 'vnet_peerings'),
        vnet_peerings_addresses=pulumi.get(__response__, 'vnet_peerings_addresses')))
