# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkInterfaceSecurityGroupAssociationArgs', 'NetworkInterfaceSecurityGroupAssociation']

@pulumi.input_type
class NetworkInterfaceSecurityGroupAssociationArgs:
    def __init__(__self__, *,
                 network_interface_id: pulumi.Input[builtins.str],
                 network_security_group_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a NetworkInterfaceSecurityGroupAssociation resource.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_id: The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_id")

    @network_security_group_id.setter
    def network_security_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_security_group_id", value)


@pulumi.input_type
class _NetworkInterfaceSecurityGroupAssociationState:
    def __init__(__self__, *,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkInterfaceSecurityGroupAssociation resources.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_id: The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_id")

    @network_security_group_id.setter
    def network_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_security_group_id", value)


@pulumi.type_token("azure:network/networkInterfaceSecurityGroupAssociation:NetworkInterfaceSecurityGroupAssociation")
class NetworkInterfaceSecurityGroupAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the association between a Network Interface and a Network Security Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-nsg",
            location=example.location,
            resource_group_name=example.name)
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_network_interface_security_group_association = azure.network.NetworkInterfaceSecurityGroupAssociation("example",
            network_interface_id=example_network_interface.id,
            network_security_group_id=example_network_security_group.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Associations between Network Interfaces and Network Security Group can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkInterfaceSecurityGroupAssociation:NetworkInterfaceSecurityGroupAssociation association1 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkInterfaces/example|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/networkSecurityGroups/group1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_id: The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceSecurityGroupAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the association between a Network Interface and a Network Security Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-nsg",
            location=example.location,
            resource_group_name=example.name)
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_network_interface_security_group_association = azure.network.NetworkInterfaceSecurityGroupAssociation("example",
            network_interface_id=example_network_interface.id,
            network_security_group_id=example_network_security_group.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Associations between Network Interfaces and Network Security Group can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkInterfaceSecurityGroupAssociation:NetworkInterfaceSecurityGroupAssociation association1 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkInterfaces/example|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/networkSecurityGroups/group1"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceSecurityGroupAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceSecurityGroupAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceSecurityGroupAssociationArgs.__new__(NetworkInterfaceSecurityGroupAssociationArgs)

            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            if network_security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_security_group_id'")
            __props__.__dict__["network_security_group_id"] = network_security_group_id
        super(NetworkInterfaceSecurityGroupAssociation, __self__).__init__(
            'azure:network/networkInterfaceSecurityGroupAssociation:NetworkInterfaceSecurityGroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
            network_security_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkInterfaceSecurityGroupAssociation':
        """
        Get an existing NetworkInterfaceSecurityGroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_id: The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfaceSecurityGroupAssociationState.__new__(_NetworkInterfaceSecurityGroupAssociationState)

        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["network_security_group_id"] = network_security_group_id
        return NetworkInterfaceSecurityGroupAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Network Security Group which should be attached to the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_id")

