# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkManagerAdminRuleArgs', 'NetworkManagerAdminRule']

@pulumi.input_type
class NetworkManagerAdminRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 admin_rule_collection_id: pulumi.Input[builtins.str],
                 direction: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int],
                 protocol: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkManagerAdminRule resource.
        :param pulumi.Input[builtins.str] action: Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        :param pulumi.Input[builtins.str] admin_rule_collection_id: Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.str] direction: Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.int] priority: The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Admin Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]] destinations: One or more `destination` blocks as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]] sources: One or more `source` blocks as defined below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "admin_rule_collection_id", admin_rule_collection_id)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="adminRuleCollectionId")
    def admin_rule_collection_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        """
        return pulumi.get(self, "admin_rule_collection_id")

    @admin_rule_collection_id.setter
    def admin_rule_collection_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_rule_collection_id", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[builtins.str]:
        """
        Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Network Manager Admin Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        """
        return pulumi.get(self, "destination_port_ranges")

    @destination_port_ranges.setter
    def destination_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_port_ranges", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]]]:
        """
        One or more `destination` blocks as defined below.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_port_ranges", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]]]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]]]):
        pulumi.set(self, "sources", value)


@pulumi.input_type
class _NetworkManagerAdminRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 admin_rule_collection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerAdminRule resources.
        :param pulumi.Input[builtins.str] action: Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        :param pulumi.Input[builtins.str] admin_rule_collection_id: Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Admin Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]] destinations: One or more `destination` blocks as defined below.
        :param pulumi.Input[builtins.str] direction: Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.int] priority: The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]] sources: One or more `source` blocks as defined below.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if admin_rule_collection_id is not None:
            pulumi.set(__self__, "admin_rule_collection_id", admin_rule_collection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="adminRuleCollectionId")
    def admin_rule_collection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        """
        return pulumi.get(self, "admin_rule_collection_id")

    @admin_rule_collection_id.setter
    def admin_rule_collection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_rule_collection_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Network Manager Admin Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        """
        return pulumi.get(self, "destination_port_ranges")

    @destination_port_ranges.setter
    def destination_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_port_ranges", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]]]:
        """
        One or more `destination` blocks as defined below.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_port_ranges", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]]]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerAdminRuleSourceArgs']]]]):
        pulumi.set(self, "sources", value)


@pulumi.type_token("azure:network/networkManagerAdminRule:NetworkManagerAdminRule")
class NetworkManagerAdminRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 admin_rule_collection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleDestinationArgs', 'NetworkManagerAdminRuleDestinationArgsDict']]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleSourceArgs', 'NetworkManagerAdminRuleSourceArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Network Manager Admin Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_security_admin_configuration = azure.network.NetworkManagerSecurityAdminConfiguration("example",
            name="example-admin-conf",
            network_manager_id=example_network_manager.id)
        example_network_manager_admin_rule_collection = azure.network.NetworkManagerAdminRuleCollection("example",
            name="example-admin-rule-collection",
            security_admin_configuration_id=example_network_manager_security_admin_configuration.id,
            network_group_ids=[example_network_manager_network_group.id])
        example_network_manager_admin_rule = azure.network.NetworkManagerAdminRule("example",
            name="example-admin-rule",
            admin_rule_collection_id=example_network_manager_admin_rule_collection.id,
            action="Deny",
            direction="Outbound",
            priority=1,
            protocol="Tcp",
            source_port_ranges=[
                "80",
                "1024-65535",
            ],
            destination_port_ranges=["80"],
            sources=[{
                "address_prefix_type": "ServiceTag",
                "address_prefix": "Internet",
            }],
            destinations=[
                {
                    "address_prefix_type": "IPPrefix",
                    "address_prefix": "10.1.0.1",
                },
                {
                    "address_prefix_type": "IPPrefix",
                    "address_prefix": "10.0.0.0/24",
                },
            ],
            description="example admin rule")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Manager Admin Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerAdminRule:NetworkManagerAdminRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/securityAdminConfigurations/configuration1/ruleCollections/ruleCollection1/rules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        :param pulumi.Input[builtins.str] admin_rule_collection_id: Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Admin Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleDestinationArgs', 'NetworkManagerAdminRuleDestinationArgsDict']]]] destinations: One or more `destination` blocks as defined below.
        :param pulumi.Input[builtins.str] direction: Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.int] priority: The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleSourceArgs', 'NetworkManagerAdminRuleSourceArgsDict']]]] sources: One or more `source` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerAdminRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Admin Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_security_admin_configuration = azure.network.NetworkManagerSecurityAdminConfiguration("example",
            name="example-admin-conf",
            network_manager_id=example_network_manager.id)
        example_network_manager_admin_rule_collection = azure.network.NetworkManagerAdminRuleCollection("example",
            name="example-admin-rule-collection",
            security_admin_configuration_id=example_network_manager_security_admin_configuration.id,
            network_group_ids=[example_network_manager_network_group.id])
        example_network_manager_admin_rule = azure.network.NetworkManagerAdminRule("example",
            name="example-admin-rule",
            admin_rule_collection_id=example_network_manager_admin_rule_collection.id,
            action="Deny",
            direction="Outbound",
            priority=1,
            protocol="Tcp",
            source_port_ranges=[
                "80",
                "1024-65535",
            ],
            destination_port_ranges=["80"],
            sources=[{
                "address_prefix_type": "ServiceTag",
                "address_prefix": "Internet",
            }],
            destinations=[
                {
                    "address_prefix_type": "IPPrefix",
                    "address_prefix": "10.1.0.1",
                },
                {
                    "address_prefix_type": "IPPrefix",
                    "address_prefix": "10.0.0.0/24",
                },
            ],
            description="example admin rule")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Manager Admin Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerAdminRule:NetworkManagerAdminRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/securityAdminConfigurations/configuration1/ruleCollections/ruleCollection1/rules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerAdminRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerAdminRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 admin_rule_collection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleDestinationArgs', 'NetworkManagerAdminRuleDestinationArgsDict']]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleSourceArgs', 'NetworkManagerAdminRuleSourceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerAdminRuleArgs.__new__(NetworkManagerAdminRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if admin_rule_collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'admin_rule_collection_id'")
            __props__.__dict__["admin_rule_collection_id"] = admin_rule_collection_id
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_port_ranges"] = destination_port_ranges
            __props__.__dict__["destinations"] = destinations
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["source_port_ranges"] = source_port_ranges
            __props__.__dict__["sources"] = sources
        super(NetworkManagerAdminRule, __self__).__init__(
            'azure:network/networkManagerAdminRule:NetworkManagerAdminRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            admin_rule_collection_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleDestinationArgs', 'NetworkManagerAdminRuleDestinationArgsDict']]]]] = None,
            direction: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleSourceArgs', 'NetworkManagerAdminRuleSourceArgsDict']]]]] = None) -> 'NetworkManagerAdminRule':
        """
        Get an existing NetworkManagerAdminRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        :param pulumi.Input[builtins.str] admin_rule_collection_id: Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Admin Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleDestinationArgs', 'NetworkManagerAdminRuleDestinationArgsDict']]]] destinations: One or more `destination` blocks as defined below.
        :param pulumi.Input[builtins.str] direction: Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        :param pulumi.Input[builtins.int] priority: The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerAdminRuleSourceArgs', 'NetworkManagerAdminRuleSourceArgsDict']]]] sources: One or more `source` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerAdminRuleState.__new__(_NetworkManagerAdminRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["admin_rule_collection_id"] = admin_rule_collection_id
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_port_ranges"] = destination_port_ranges
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["direction"] = direction
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["source_port_ranges"] = source_port_ranges
        __props__.__dict__["sources"] = sources
        return NetworkManagerAdminRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the action allowed for this Network Manager Admin Rule. Possible values are `Allow`, `AlwaysAllow`, and `Deny`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="adminRuleCollectionId")
    def admin_rule_collection_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule to be created.
        """
        return pulumi.get(self, "admin_rule_collection_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the Network Manager Admin Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of string specifies the destination port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkManagerAdminRuleDestination']]]:
        """
        One or more `destination` blocks as defined below.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        Indicates if the traffic matched against the rule in inbound or outbound. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Network Manager Admin Rule. Changing this forces a new Network Manager Admin Rule to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        The priority of the rule. Possible values are integers between `1` and `4096`. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Specifies which network protocol this Network Manager Admin Rule applies to. Possible values are `Ah`, `Any`, `Esp`, `Icmp`, `Tcp`, and `Udp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of string specifies the source port ranges. Specify one or more single port number or port ranges such as `1024-65535`. Use `*` to specify any port.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkManagerAdminRuleSource']]]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "sources")

