# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkManagerScopeConnectionArgs', 'NetworkManagerScopeConnection']

@pulumi.input_type
class NetworkManagerScopeConnectionArgs:
    def __init__(__self__, *,
                 network_manager_id: pulumi.Input[builtins.str],
                 target_scope_id: pulumi.Input[builtins.str],
                 tenant_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerScopeConnection resource.
        :param pulumi.Input[builtins.str] network_manager_id: Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] target_scope_id: Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        :param pulumi.Input[builtins.str] tenant_id: Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Scope Connection.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        pulumi.set(__self__, "network_manager_id", network_manager_id)
        pulumi.set(__self__, "target_scope_id", target_scope_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        return pulumi.get(self, "network_manager_id")

    @network_manager_id.setter
    def network_manager_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_manager_id", value)

    @property
    @pulumi.getter(name="targetScopeId")
    def target_scope_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        """
        return pulumi.get(self, "target_scope_id")

    @target_scope_id.setter
    def target_scope_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_scope_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Network Manager Scope Connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerScopeConnectionState:
    def __init__(__self__, *,
                 connection_state: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerScopeConnection resources.
        :param pulumi.Input[builtins.str] connection_state: The Connection state of the Network Manager Scope Connection.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Scope Connection.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] network_manager_id: Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] target_scope_id: Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        :param pulumi.Input[builtins.str] tenant_id: Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        """
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_manager_id is not None:
            pulumi.set(__self__, "network_manager_id", network_manager_id)
        if target_scope_id is not None:
            pulumi.set(__self__, "target_scope_id", target_scope_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Connection state of the Network Manager Scope Connection.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_state", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Network Manager Scope Connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        return pulumi.get(self, "network_manager_id")

    @network_manager_id.setter
    def network_manager_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_manager_id", value)

    @property
    @pulumi.getter(name="targetScopeId")
    def target_scope_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        """
        return pulumi.get(self, "target_scope_id")

    @target_scope_id.setter
    def target_scope_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_scope_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:network/networkManagerScopeConnection:NetworkManagerScopeConnection")
class NetworkManagerScopeConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager Scope Connection which may cross tenants.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        current_get_subscription = azure.core.get_subscription()
        alt = azure.core.get_subscription(subscription_id="00000000-0000-0000-0000-000000000000")
        example_network_manager = azure.network.NetworkManager("example",
            name="example-networkmanager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current_get_subscription.id],
            },
            scope_accesses=["SecurityAdmin"])
        example_network_manager_scope_connection = azure.network.NetworkManagerScopeConnection("example",
            name="example-nsc",
            network_manager_id=example_network_manager.id,
            tenant_id=current.tenant_id,
            target_scope_id=alt.id,
            description="example")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Manager Scope Connection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerScopeConnection:NetworkManagerScopeConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/scopeConnections/scopeConnection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Scope Connection.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] network_manager_id: Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] target_scope_id: Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        :param pulumi.Input[builtins.str] tenant_id: Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerScopeConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Scope Connection which may cross tenants.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        current_get_subscription = azure.core.get_subscription()
        alt = azure.core.get_subscription(subscription_id="00000000-0000-0000-0000-000000000000")
        example_network_manager = azure.network.NetworkManager("example",
            name="example-networkmanager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current_get_subscription.id],
            },
            scope_accesses=["SecurityAdmin"])
        example_network_manager_scope_connection = azure.network.NetworkManagerScopeConnection("example",
            name="example-nsc",
            network_manager_id=example_network_manager.id,
            tenant_id=current.tenant_id,
            target_scope_id=alt.id,
            description="example")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Manager Scope Connection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerScopeConnection:NetworkManagerScopeConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/scopeConnections/scopeConnection1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerScopeConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerScopeConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerScopeConnectionArgs.__new__(NetworkManagerScopeConnectionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if network_manager_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_manager_id'")
            __props__.__dict__["network_manager_id"] = network_manager_id
            if target_scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_scope_id'")
            __props__.__dict__["target_scope_id"] = target_scope_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["connection_state"] = None
        super(NetworkManagerScopeConnection, __self__).__init__(
            'azure:network/networkManagerScopeConnection:NetworkManagerScopeConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_state: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_manager_id: Optional[pulumi.Input[builtins.str]] = None,
            target_scope_id: Optional[pulumi.Input[builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkManagerScopeConnection':
        """
        Get an existing NetworkManagerScopeConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] connection_state: The Connection state of the Network Manager Scope Connection.
        :param pulumi.Input[builtins.str] description: A description of the Network Manager Scope Connection.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] network_manager_id: Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        :param pulumi.Input[builtins.str] target_scope_id: Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        :param pulumi.Input[builtins.str] tenant_id: Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerScopeConnectionState.__new__(_NetworkManagerScopeConnectionState)

        __props__.__dict__["connection_state"] = connection_state
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["network_manager_id"] = network_manager_id
        __props__.__dict__["target_scope_id"] = target_scope_id
        __props__.__dict__["tenant_id"] = tenant_id
        return NetworkManagerScopeConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> pulumi.Output[builtins.str]:
        """
        The Connection state of the Network Manager Scope Connection.
        """
        return pulumi.get(self, "connection_state")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the Network Manager Scope Connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Network Manager Scope Connection. Changing this forces a new Network Manager Scope Connection to be created.
        """
        return pulumi.get(self, "network_manager_id")

    @property
    @pulumi.getter(name="targetScopeId")
    def target_scope_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Resource ID of the target scope which the Network Manager is connected to. It should be either Subscription ID or Management Group ID.
        """
        return pulumi.get(self, "target_scope_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Tenant ID of the Resource which the Network Manager is connected to.
        """
        return pulumi.get(self, "tenant_id")

