# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkSecurityRuleArgs', 'NetworkSecurityRule']

@pulumi.input_type
class NetworkSecurityRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[builtins.str],
                 direction: pulumi.Input[builtins.str],
                 network_security_group_name: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int],
                 protocol: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destination_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkSecurityRule resource.
        :param pulumi.Input[builtins.str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[builtins.str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: A description for this rule. Restricted to 140 characters.
        :param pulumi.Input[builtins.str] destination_address_prefix: CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_address_prefixes: List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] destination_application_security_group_ids: A List of destination Application Security Group IDs
        :param pulumi.Input[builtins.str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        :param pulumi.Input[builtins.str] name: The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_address_prefix: CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_address_prefixes: List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] source_application_security_group_ids: A List of source Application Security Group IDs
        :param pulumi.Input[builtins.str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "network_security_group_name", network_security_group_name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_address_prefixes is not None:
            pulumi.set(__self__, "destination_address_prefixes", destination_address_prefixes)
        if destination_application_security_group_ids is not None:
            pulumi.set(__self__, "destination_application_security_group_ids", destination_application_security_group_ids)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_address_prefixes is not None:
            pulumi.set(__self__, "source_address_prefixes", source_address_prefixes)
        if source_application_security_group_ids is not None:
            pulumi.set(__self__, "source_application_security_group_ids", source_application_security_group_ids)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[builtins.str]:
        """
        Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[builtins.str]:
        """
        The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="networkSecurityGroupName")
    def network_security_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_name")

    @network_security_group_name.setter
    def network_security_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_security_group_name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for this rule. Restricted to 140 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @destination_address_prefixes.setter
    def destination_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_address_prefixes", value)

    @property
    @pulumi.getter(name="destinationApplicationSecurityGroupIds")
    def destination_application_security_group_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A List of destination Application Security Group IDs
        """
        return pulumi.get(self, "destination_application_security_group_ids")

    @destination_application_security_group_ids.setter
    def destination_application_security_group_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_application_security_group_ids", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        """
        return pulumi.get(self, "destination_port_ranges")

    @destination_port_ranges.setter
    def destination_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_port_ranges", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        """
        return pulumi.get(self, "source_address_prefixes")

    @source_address_prefixes.setter
    def source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_address_prefixes", value)

    @property
    @pulumi.getter(name="sourceApplicationSecurityGroupIds")
    def source_application_security_group_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A List of source Application Security Group IDs
        """
        return pulumi.get(self, "source_application_security_group_ids")

    @source_application_security_group_ids.setter
    def source_application_security_group_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_application_security_group_ids", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_port_range", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_port_ranges", value)


@pulumi.input_type
class _NetworkSecurityRuleState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destination_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_security_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkSecurityRule resources.
        :param pulumi.Input[builtins.str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[builtins.str] description: A description for this rule. Restricted to 140 characters.
        :param pulumi.Input[builtins.str] destination_address_prefix: CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_address_prefixes: List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] destination_application_security_group_ids: A List of destination Application Security Group IDs
        :param pulumi.Input[builtins.str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        :param pulumi.Input[builtins.str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] name: The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_address_prefix: CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_address_prefixes: List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] source_application_security_group_ids: A List of source Application Security Group IDs
        :param pulumi.Input[builtins.str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_address_prefixes is not None:
            pulumi.set(__self__, "destination_address_prefixes", destination_address_prefixes)
        if destination_application_security_group_ids is not None:
            pulumi.set(__self__, "destination_application_security_group_ids", destination_application_security_group_ids)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group_name is not None:
            pulumi.set(__self__, "network_security_group_name", network_security_group_name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_address_prefixes is not None:
            pulumi.set(__self__, "source_address_prefixes", source_address_prefixes)
        if source_application_security_group_ids is not None:
            pulumi.set(__self__, "source_application_security_group_ids", source_application_security_group_ids)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for this rule. Restricted to 140 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @destination_address_prefixes.setter
    def destination_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_address_prefixes", value)

    @property
    @pulumi.getter(name="destinationApplicationSecurityGroupIds")
    def destination_application_security_group_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A List of destination Application Security Group IDs
        """
        return pulumi.get(self, "destination_application_security_group_ids")

    @destination_application_security_group_ids.setter
    def destination_application_security_group_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_application_security_group_ids", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        """
        return pulumi.get(self, "destination_port_ranges")

    @destination_port_ranges.setter
    def destination_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_port_ranges", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSecurityGroupName")
    def network_security_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_name")

    @network_security_group_name.setter
    def network_security_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_security_group_name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        """
        return pulumi.get(self, "source_address_prefixes")

    @source_address_prefixes.setter
    def source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_address_prefixes", value)

    @property
    @pulumi.getter(name="sourceApplicationSecurityGroupIds")
    def source_application_security_group_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A List of source Application Security Group IDs
        """
        return pulumi.get(self, "source_application_security_group_ids")

    @source_application_security_group_ids.setter
    def source_application_security_group_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_application_security_group_ids", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_port_range", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_port_ranges", value)


@pulumi.type_token("azure:network/networkSecurityRule:NetworkSecurityRule")
class NetworkSecurityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destination_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_security_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Network Security Rule.

        > **NOTE on Network Security Groups and Network Security Rules:** This provider currently
        provides both a standalone Network Security Rule resource, and allows for Network Security Rules to be defined in-line within the Network Security Group resource.
        At this time you cannot use a Network Security Group with in-line Network Security Rules in conjunction with any Network Security Rule resources. Doing so will cause a conflict of rule settings and will overwrite rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="acceptanceTestSecurityGroup1",
            location=example.location,
            resource_group_name=example.name)
        example_network_security_rule = azure.network.NetworkSecurityRule("example",
            name="test123",
            priority=100,
            direction="Outbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Security Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkSecurityRule:NetworkSecurityRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkSecurityGroups/mySecurityGroup/securityRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[builtins.str] description: A description for this rule. Restricted to 140 characters.
        :param pulumi.Input[builtins.str] destination_address_prefix: CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_address_prefixes: List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] destination_application_security_group_ids: A List of destination Application Security Group IDs
        :param pulumi.Input[builtins.str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        :param pulumi.Input[builtins.str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] name: The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_address_prefix: CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_address_prefixes: List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] source_application_security_group_ids: A List of source Application Security Group IDs
        :param pulumi.Input[builtins.str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkSecurityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Security Rule.

        > **NOTE on Network Security Groups and Network Security Rules:** This provider currently
        provides both a standalone Network Security Rule resource, and allows for Network Security Rules to be defined in-line within the Network Security Group resource.
        At this time you cannot use a Network Security Group with in-line Network Security Rules in conjunction with any Network Security Rule resources. Doing so will cause a conflict of rule settings and will overwrite rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="acceptanceTestSecurityGroup1",
            location=example.location,
            resource_group_name=example.name)
        example_network_security_rule = azure.network.NetworkSecurityRule("example",
            name="test123",
            priority=100,
            direction="Outbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Security Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkSecurityRule:NetworkSecurityRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkSecurityGroups/mySecurityGroup/securityRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkSecurityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkSecurityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destination_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_security_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkSecurityRuleArgs.__new__(NetworkSecurityRuleArgs)

            if access is None and not opts.urn:
                raise TypeError("Missing required property 'access'")
            __props__.__dict__["access"] = access
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_address_prefix"] = destination_address_prefix
            __props__.__dict__["destination_address_prefixes"] = destination_address_prefixes
            __props__.__dict__["destination_application_security_group_ids"] = destination_application_security_group_ids
            __props__.__dict__["destination_port_range"] = destination_port_range
            __props__.__dict__["destination_port_ranges"] = destination_port_ranges
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["name"] = name
            if network_security_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'network_security_group_name'")
            __props__.__dict__["network_security_group_name"] = network_security_group_name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["source_address_prefix"] = source_address_prefix
            __props__.__dict__["source_address_prefixes"] = source_address_prefixes
            __props__.__dict__["source_application_security_group_ids"] = source_application_security_group_ids
            __props__.__dict__["source_port_range"] = source_port_range
            __props__.__dict__["source_port_ranges"] = source_port_ranges
        super(NetworkSecurityRule, __self__).__init__(
            'azure:network/networkSecurityRule:NetworkSecurityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
            destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            destination_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
            destination_port_range: Optional[pulumi.Input[builtins.str]] = None,
            destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            direction: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_security_group_name: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            source_address_prefix: Optional[pulumi.Input[builtins.str]] = None,
            source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source_application_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
            source_port_range: Optional[pulumi.Input[builtins.str]] = None,
            source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'NetworkSecurityRule':
        """
        Get an existing NetworkSecurityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[builtins.str] description: A description for this rule. Restricted to 140 characters.
        :param pulumi.Input[builtins.str] destination_address_prefix: CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_address_prefixes: List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] destination_application_security_group_ids: A List of destination Application Security Group IDs
        :param pulumi.Input[builtins.str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_port_ranges: List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        :param pulumi.Input[builtins.str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[builtins.str] name: The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[builtins.str] protocol: Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_address_prefix: CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_address_prefixes: List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        :param pulumi.Input[builtins.str] source_application_security_group_ids: A List of source Application Security Group IDs
        :param pulumi.Input[builtins.str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkSecurityRuleState.__new__(_NetworkSecurityRuleState)

        __props__.__dict__["access"] = access
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_address_prefix"] = destination_address_prefix
        __props__.__dict__["destination_address_prefixes"] = destination_address_prefixes
        __props__.__dict__["destination_application_security_group_ids"] = destination_application_security_group_ids
        __props__.__dict__["destination_port_range"] = destination_port_range
        __props__.__dict__["destination_port_ranges"] = destination_port_ranges
        __props__.__dict__["direction"] = direction
        __props__.__dict__["name"] = name
        __props__.__dict__["network_security_group_name"] = network_security_group_name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["source_address_prefix"] = source_address_prefix
        __props__.__dict__["source_address_prefixes"] = source_address_prefixes
        __props__.__dict__["source_application_security_group_ids"] = source_application_security_group_ids
        __props__.__dict__["source_port_range"] = source_port_range
        __props__.__dict__["source_port_ranges"] = source_port_ranges
        return NetworkSecurityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for this rule. Restricted to 140 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        CIDR or destination IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. Besides, it also supports all available Service Tags like ‘Sql.WestEurope‘, ‘Storage.EastUS‘, etc. You can list the available service tags with the CLI: ```shell az network list-service-tags --location westcentralus```. For further information please see [Azure CLI - az network list-service-tags](https://docs.microsoft.com/cli/azure/network?view=azure-cli-latest#az-network-list-service-tags). This is required if `destination_address_prefixes` is not specified.
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of destination address prefixes. Tags may not be used. This is required if `destination_address_prefix` is not specified.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @property
    @pulumi.getter(name="destinationApplicationSecurityGroupIds")
    def destination_application_security_group_ids(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A List of destination Application Security Group IDs
        """
        return pulumi.get(self, "destination_application_security_group_ids")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `destination_port_ranges` is not specified.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of destination ports or port ranges. This is required if `destination_port_range` is not specified.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the security rule. This needs to be unique across all Rules in the Network Security Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityGroupName")
    def network_security_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Network Security Group that we want to attach the rule to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Network protocol this rule applies to. Possible values include `Tcp`, `Udp`, `Icmp`, `Esp`, `Ah` or `*` (which matches all).
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Network Security Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        CIDR or source IP range or * to match any IP. Tags such as `VirtualNetwork`, `AzureLoadBalancer` and `Internet` can also be used. This is required if `source_address_prefixes` is not specified.
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of source address prefixes. Tags may not be used. This is required if `source_address_prefix` is not specified.
        """
        return pulumi.get(self, "source_address_prefixes")

    @property
    @pulumi.getter(name="sourceApplicationSecurityGroupIds")
    def source_application_security_group_ids(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A List of source Application Security Group IDs
        """
        return pulumi.get(self, "source_application_security_group_ids")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Source Port or Range. Integer or range between `0` and `65535` or `*` to match any. This is required if `source_port_ranges` is not specified.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of source ports or port ranges. This is required if `source_port_range` is not specified.
        """
        return pulumi.get(self, "source_port_ranges")

