# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicIpArgs', 'PublicIp']

@pulumi.input_type
class PublicIpArgs:
    def __init__(__self__, *,
                 allocation_method: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 ddos_protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label_scope: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 ip_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a PublicIp resource.
        :param pulumi.Input[builtins.str] allocation_method: Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.
               
               > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] ddos_protection_mode: The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        :param pulumi.Input[builtins.str] ddos_protection_plan_id: The ID of DDoS protection plan associated with the public IP. 
               
               > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        :param pulumi.Input[builtins.str] domain_name_label: Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param pulumi.Input[builtins.str] domain_name_label_scope: Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] ip_tags: A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.
               
               > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        :param pulumi.Input[builtins.str] ip_version: The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.
               
               > **Note** Only `static` IP address allocation is supported for IPv6.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] public_ip_prefix_id: If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] reverse_fqdn: A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :param pulumi.Input[builtins.str] sku: The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        :param pulumi.Input[builtins.str] sku_tier: The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.
               
               > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.
               
               > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        pulumi.set(__self__, "allocation_method", allocation_method)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if ddos_protection_mode is not None:
            pulumi.set(__self__, "ddos_protection_mode", ddos_protection_mode)
        if ddos_protection_plan_id is not None:
            pulumi.set(__self__, "ddos_protection_plan_id", ddos_protection_plan_id)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if domain_name_label_scope is not None:
            pulumi.set(__self__, "domain_name_label_scope", domain_name_label_scope)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip_prefix_id is not None:
            pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> pulumi.Input[builtins.str]:
        """
        Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.

        > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        """
        return pulumi.get(self, "allocation_method")

    @allocation_method.setter
    def allocation_method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "allocation_method", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="ddosProtectionMode")
    def ddos_protection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        """
        return pulumi.get(self, "ddos_protection_mode")

    @ddos_protection_mode.setter
    def ddos_protection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ddos_protection_mode", value)

    @property
    @pulumi.getter(name="ddosProtectionPlanId")
    def ddos_protection_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of DDoS protection plan associated with the public IP. 

        > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        """
        return pulumi.get(self, "ddos_protection_plan_id")

    @ddos_protection_plan_id.setter
    def ddos_protection_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ddos_protection_plan_id", value)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name_label", value)

    @property
    @pulumi.getter(name="domainNameLabelScope")
    def domain_name_label_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "domain_name_label_scope")

    @domain_name_label_scope.setter
    def domain_name_label_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name_label_scope", value)

    @property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.

        > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        """
        return pulumi.get(self, "ip_tags")

    @ip_tags.setter
    def ip_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_tags", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.

        > **Note** Only `static` IP address allocation is supported for IPv6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @public_ip_prefix_id.setter
    def public_ip_prefix_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip_prefix_id", value)

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        return pulumi.get(self, "reverse_fqdn")

    @reverse_fqdn.setter
    def reverse_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reverse_fqdn", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.

        > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.

        > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.

        > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _PublicIpState:
    def __init__(__self__, *,
                 allocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label_scope: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PublicIp resources.
        :param pulumi.Input[builtins.str] allocation_method: Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.
               
               > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        :param pulumi.Input[builtins.str] ddos_protection_mode: The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        :param pulumi.Input[builtins.str] ddos_protection_plan_id: The ID of DDoS protection plan associated with the public IP. 
               
               > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        :param pulumi.Input[builtins.str] domain_name_label: Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param pulumi.Input[builtins.str] domain_name_label_scope: Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] fqdn: Fully qualified domain name of the A DNS record associated with the public IP. `domain_name_label` must be specified to get the `fqdn`. This is the concatenation of the `domain_name_label` and the regionalized DNS zone
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        :param pulumi.Input[builtins.str] ip_address: The IP address value that was allocated.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] ip_tags: A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.
               
               > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        :param pulumi.Input[builtins.str] ip_version: The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.
               
               > **Note** Only `static` IP address allocation is supported for IPv6.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] public_ip_prefix_id: If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] reverse_fqdn: A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :param pulumi.Input[builtins.str] sku: The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        :param pulumi.Input[builtins.str] sku_tier: The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.
               
               > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.
               
               > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        if allocation_method is not None:
            pulumi.set(__self__, "allocation_method", allocation_method)
        if ddos_protection_mode is not None:
            pulumi.set(__self__, "ddos_protection_mode", ddos_protection_mode)
        if ddos_protection_plan_id is not None:
            pulumi.set(__self__, "ddos_protection_plan_id", ddos_protection_plan_id)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if domain_name_label_scope is not None:
            pulumi.set(__self__, "domain_name_label_scope", domain_name_label_scope)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip_prefix_id is not None:
            pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.

        > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        """
        return pulumi.get(self, "allocation_method")

    @allocation_method.setter
    def allocation_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_method", value)

    @property
    @pulumi.getter(name="ddosProtectionMode")
    def ddos_protection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        """
        return pulumi.get(self, "ddos_protection_mode")

    @ddos_protection_mode.setter
    def ddos_protection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ddos_protection_mode", value)

    @property
    @pulumi.getter(name="ddosProtectionPlanId")
    def ddos_protection_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of DDoS protection plan associated with the public IP. 

        > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        """
        return pulumi.get(self, "ddos_protection_plan_id")

    @ddos_protection_plan_id.setter
    def ddos_protection_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ddos_protection_plan_id", value)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name_label", value)

    @property
    @pulumi.getter(name="domainNameLabelScope")
    def domain_name_label_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "domain_name_label_scope")

    @domain_name_label_scope.setter
    def domain_name_label_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name_label_scope", value)

    @property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain name of the A DNS record associated with the public IP. `domain_name_label` must be specified to get the `fqdn`. This is the concatenation of the `domain_name_label` and the regionalized DNS zone
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address value that was allocated.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.

        > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        """
        return pulumi.get(self, "ip_tags")

    @ip_tags.setter
    def ip_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_tags", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.

        > **Note** Only `static` IP address allocation is supported for IPv6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @public_ip_prefix_id.setter
    def public_ip_prefix_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip_prefix_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        return pulumi.get(self, "reverse_fqdn")

    @reverse_fqdn.setter
    def reverse_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reverse_fqdn", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.

        > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.

        > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.

        > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:network/publicIp:PublicIp")
class PublicIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label_scope: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 ip_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Public IP Address.

        > **Note** If this resource is to be associated with a resource that requires disassociation before destruction (such as `network.NetworkInterface`) it is recommended to set the `lifecycle` argument `create_before_destroy = true`. Otherwise, it can fail to disassociate on destruction.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="acceptanceTestPublicIp1",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Public IPs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/publicIp:PublicIp myPublicIp /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/publicIPAddresses/myPublicIpAddress1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allocation_method: Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.
               
               > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        :param pulumi.Input[builtins.str] ddos_protection_mode: The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        :param pulumi.Input[builtins.str] ddos_protection_plan_id: The ID of DDoS protection plan associated with the public IP. 
               
               > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        :param pulumi.Input[builtins.str] domain_name_label: Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param pulumi.Input[builtins.str] domain_name_label_scope: Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] ip_tags: A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.
               
               > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        :param pulumi.Input[builtins.str] ip_version: The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.
               
               > **Note** Only `static` IP address allocation is supported for IPv6.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] public_ip_prefix_id: If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] reverse_fqdn: A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :param pulumi.Input[builtins.str] sku: The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        :param pulumi.Input[builtins.str] sku_tier: The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.
               
               > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.
               
               > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicIpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Public IP Address.

        > **Note** If this resource is to be associated with a resource that requires disassociation before destruction (such as `network.NetworkInterface`) it is recommended to set the `lifecycle` argument `create_before_destroy = true`. Otherwise, it can fail to disassociate on destruction.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="acceptanceTestPublicIp1",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Public IPs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/publicIp:PublicIp myPublicIp /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/publicIPAddresses/myPublicIpAddress1
        ```

        :param str resource_name: The name of the resource.
        :param PublicIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ddos_protection_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_label_scope: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 ip_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicIpArgs.__new__(PublicIpArgs)

            if allocation_method is None and not opts.urn:
                raise TypeError("Missing required property 'allocation_method'")
            __props__.__dict__["allocation_method"] = allocation_method
            __props__.__dict__["ddos_protection_mode"] = ddos_protection_mode
            __props__.__dict__["ddos_protection_plan_id"] = ddos_protection_plan_id
            __props__.__dict__["domain_name_label"] = domain_name_label
            __props__.__dict__["domain_name_label_scope"] = domain_name_label_scope
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
            __props__.__dict__["ip_tags"] = ip_tags
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_ip_prefix_id"] = public_ip_prefix_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["reverse_fqdn"] = reverse_fqdn
            __props__.__dict__["sku"] = sku
            __props__.__dict__["sku_tier"] = sku_tier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zones"] = zones
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["ip_address"] = None
        super(PublicIp, __self__).__init__(
            'azure:network/publicIp:PublicIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_method: Optional[pulumi.Input[builtins.str]] = None,
            ddos_protection_mode: Optional[pulumi.Input[builtins.str]] = None,
            ddos_protection_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            domain_name_label: Optional[pulumi.Input[builtins.str]] = None,
            domain_name_label_scope: Optional[pulumi.Input[builtins.str]] = None,
            edge_zone: Optional[pulumi.Input[builtins.str]] = None,
            fqdn: Optional[pulumi.Input[builtins.str]] = None,
            idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ip_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ip_version: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            reverse_fqdn: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[builtins.str]] = None,
            sku_tier: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'PublicIp':
        """
        Get an existing PublicIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allocation_method: Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.
               
               > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        :param pulumi.Input[builtins.str] ddos_protection_mode: The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        :param pulumi.Input[builtins.str] ddos_protection_plan_id: The ID of DDoS protection plan associated with the public IP. 
               
               > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        :param pulumi.Input[builtins.str] domain_name_label: Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param pulumi.Input[builtins.str] domain_name_label_scope: Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] fqdn: Fully qualified domain name of the A DNS record associated with the public IP. `domain_name_label` must be specified to get the `fqdn`. This is the concatenation of the `domain_name_label` and the regionalized DNS zone
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        :param pulumi.Input[builtins.str] ip_address: The IP address value that was allocated.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] ip_tags: A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.
               
               > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        :param pulumi.Input[builtins.str] ip_version: The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.
               
               > **Note** Only `static` IP address allocation is supported for IPv6.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] public_ip_prefix_id: If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        :param pulumi.Input[builtins.str] reverse_fqdn: A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :param pulumi.Input[builtins.str] sku: The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        :param pulumi.Input[builtins.str] sku_tier: The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.
               
               > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.
               
               > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicIpState.__new__(_PublicIpState)

        __props__.__dict__["allocation_method"] = allocation_method
        __props__.__dict__["ddos_protection_mode"] = ddos_protection_mode
        __props__.__dict__["ddos_protection_plan_id"] = ddos_protection_plan_id
        __props__.__dict__["domain_name_label"] = domain_name_label
        __props__.__dict__["domain_name_label_scope"] = domain_name_label_scope
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_tags"] = ip_tags
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_ip_prefix_id"] = public_ip_prefix_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["reverse_fqdn"] = reverse_fqdn
        __props__.__dict__["sku"] = sku
        __props__.__dict__["sku_tier"] = sku_tier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zones"] = zones
        return PublicIp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> pulumi.Output[builtins.str]:
        """
        Defines the allocation method for this IP address. Possible values are `Static` or `Dynamic`.

        > **Note** `Dynamic` Public IP Addresses aren't allocated until they're assigned to a resource (such as a Virtual Machine or a Load Balancer) by design within Azure. See `ip_address` argument.
        """
        return pulumi.get(self, "allocation_method")

    @property
    @pulumi.getter(name="ddosProtectionMode")
    def ddos_protection_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The DDoS protection mode of the public IP. Possible values are `Disabled`, `Enabled`, and `VirtualNetworkInherited`. Defaults to `VirtualNetworkInherited`.
        """
        return pulumi.get(self, "ddos_protection_mode")

    @property
    @pulumi.getter(name="ddosProtectionPlanId")
    def ddos_protection_plan_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of DDoS protection plan associated with the public IP. 

        > **Note:** `ddos_protection_plan_id` can only be set when `ddos_protection_mode` is `Enabled`.
        """
        return pulumi.get(self, "ddos_protection_plan_id")

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Label for the Domain Name. Will be used to make up the FQDN. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @property
    @pulumi.getter(name="domainNameLabelScope")
    def domain_name_label_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Scope for the domain name label. If a domain name label scope is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN. Possible values are `NoReuse`, `ResourceGroupReuse`, `SubscriptionReuse` and `TenantReuse`. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "domain_name_label_scope")

    @property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Public IP should exist. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "edge_zone")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[builtins.str]:
        """
        Fully qualified domain name of the A DNS record associated with the public IP. `domain_name_label` must be specified to get the `fqdn`. This is the concatenation of the `domain_name_label` and the regionalized DNS zone
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the timeout for the TCP idle connection. The value can be set between 4 and 30 minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        The IP address value that was allocated.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of IP tags to assign to the public IP. Changing this forces a new resource to be created.

        > **Note** IP Tag `RoutingPreference` requires multiple `zones` and `Standard` SKU to be set.
        """
        return pulumi.get(self, "ip_tags")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP Version to use, IPv6 or IPv4. Changing this forces a new resource to be created. Defaults to `IPv4`.

        > **Note** Only `static` IP address allocation is supported for IPv6.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the Public IP should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Public IP. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If specified then public IP address allocated will be provided from the public IP prefix resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where this Public IP should exist. Changing this forces a new Public IP to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        return pulumi.get(self, "reverse_fqdn")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The SKU of the Public IP. Accepted values are `Basic` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.

        > **Note** Public IP Standard SKUs require `allocation_method` to be set to `Static`.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The SKU Tier that should be used for the Public IP. Possible values are `Regional` and `Global`. Defaults to `Regional`. Changing this forces a new resource to be created.

        > **Note** When `sku_tier` is set to `Global`, `sku` must be set to `Standard`.
        """
        return pulumi.get(self, "sku_tier")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A collection containing the availability zone to allocate the Public IP in. Changing this forces a new resource to be created.

        > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/virtual-network/virtual-network-ip-addresses-overview-arm#standard) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time. Standard SKU Public IP Addresses that do not specify a zone are **not** zone-redundant by default.
        """
        return pulumi.get(self, "zones")

