# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 address_prefix: pulumi.Input[builtins.str],
                 next_hop_type: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 route_table_name: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_in_ip_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[builtins.str] address_prefix: The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        :param pulumi.Input[builtins.str] next_hop_type: The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] route_table_name: The name of the route table within which create the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] next_hop_in_ip_address: Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        """
        pulumi.set(__self__, "address_prefix", address_prefix)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "route_table_name", route_table_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_in_ip_address is not None:
            pulumi.set(__self__, "next_hop_in_ip_address", next_hop_in_ip_address)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> pulumi.Input[builtins.str]:
        """
        The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "next_hop_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the route table within which create the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_name")

    @route_table_name.setter
    def route_table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_table_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopInIpAddress")
    def next_hop_in_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        """
        return pulumi.get(self, "next_hop_in_ip_address")

    @next_hop_in_ip_address.setter
    def next_hop_in_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_in_ip_address", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_in_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[builtins.str] address_prefix: The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        :param pulumi.Input[builtins.str] name: The name of the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] next_hop_in_ip_address: Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        :param pulumi.Input[builtins.str] next_hop_type: The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] route_table_name: The name of the route table within which create the route. Changing this forces a new resource to be created.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_in_ip_address is not None:
            pulumi.set(__self__, "next_hop_in_ip_address", next_hop_in_ip_address)
        if next_hop_type is not None:
            pulumi.set(__self__, "next_hop_type", next_hop_type)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if route_table_name is not None:
            pulumi.set(__self__, "route_table_name", route_table_name)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopInIpAddress")
    def next_hop_in_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        """
        return pulumi.get(self, "next_hop_in_ip_address")

    @next_hop_in_ip_address.setter
    def next_hop_in_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_in_ip_address", value)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the route table within which create the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_name")

    @route_table_name.setter
    def route_table_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_table_name", value)


@pulumi.type_token("azure:network/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_in_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Route within a Route Table.

        > **NOTE on Route Tables and Routes:** This provider currently
        provides both a standalone Route resource, and allows for Routes to be defined in-line within the Route Table resource.
        At this time you cannot use a Route Table with in-line Routes in conjunction with any Route resources. Doing so will cause a conflict of Route configurations and will overwrite Routes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_route_table = azure.network.RouteTable("example",
            name="acceptanceTestRouteTable1",
            location=example.location,
            resource_group_name=example.name)
        example_route = azure.network.Route("example",
            name="acceptanceTestRoute1",
            resource_group_name=example.name,
            route_table_name=example_route_table.name,
            address_prefix="10.1.0.0/16",
            next_hop_type="VnetLocal")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Routes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/route:Route exampleRoute /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/routeTables/mytable1/routes/myroute1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_prefix: The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        :param pulumi.Input[builtins.str] name: The name of the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] next_hop_in_ip_address: Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        :param pulumi.Input[builtins.str] next_hop_type: The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] route_table_name: The name of the route table within which create the route. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Route within a Route Table.

        > **NOTE on Route Tables and Routes:** This provider currently
        provides both a standalone Route resource, and allows for Routes to be defined in-line within the Route Table resource.
        At this time you cannot use a Route Table with in-line Routes in conjunction with any Route resources. Doing so will cause a conflict of Route configurations and will overwrite Routes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_route_table = azure.network.RouteTable("example",
            name="acceptanceTestRouteTable1",
            location=example.location,
            resource_group_name=example.name)
        example_route = azure.network.Route("example",
            name="acceptanceTestRoute1",
            resource_group_name=example.name,
            route_table_name=example_route_table.name,
            address_prefix="10.1.0.0/16",
            next_hop_type="VnetLocal")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Routes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/route:Route exampleRoute /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/routeTables/mytable1/routes/myroute1
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_in_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            if address_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'address_prefix'")
            __props__.__dict__["address_prefix"] = address_prefix
            __props__.__dict__["name"] = name
            __props__.__dict__["next_hop_in_ip_address"] = next_hop_in_ip_address
            if next_hop_type is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop_type'")
            __props__.__dict__["next_hop_type"] = next_hop_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if route_table_name is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_name'")
            __props__.__dict__["route_table_name"] = route_table_name
        super(Route, __self__).__init__(
            'azure:network/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_prefix: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_in_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_type: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            route_table_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_prefix: The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        :param pulumi.Input[builtins.str] name: The name of the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] next_hop_in_ip_address: Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        :param pulumi.Input[builtins.str] next_hop_type: The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] route_table_name: The name of the route table within which create the route. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["address_prefix"] = address_prefix
        __props__.__dict__["name"] = name
        __props__.__dict__["next_hop_in_ip_address"] = next_hop_in_ip_address
        __props__.__dict__["next_hop_type"] = next_hop_type
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["route_table_name"] = route_table_name
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> pulumi.Output[builtins.str]:
        """
        The destination to which the route applies. Can be CIDR (such as `10.1.0.0/16`) or [Azure Service Tag](https://docs.microsoft.com/azure/virtual-network/service-tags-overview) (such as `ApiManagement`, `AzureBackup` or `AzureMonitor`) format.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopInIpAddress")
    def next_hop_in_ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Contains the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is `VirtualAppliance`.
        """
        return pulumi.get(self, "next_hop_in_ip_address")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of Azure hop the packet should be sent to. Possible values are `VirtualNetworkGateway`, `VnetLocal`, `Internet`, `VirtualAppliance` and `None`.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the route table within which create the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_name")

