# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubnetNatGatewayAssociationArgs', 'SubnetNatGatewayAssociation']

@pulumi.input_type
class SubnetNatGatewayAssociationArgs:
    def __init__(__self__, *,
                 nat_gateway_id: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a SubnetNatGatewayAssociation resource.
        :param pulumi.Input[builtins.str] nat_gateway_id: The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _SubnetNatGatewayAssociationState:
    def __init__(__self__, *,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SubnetNatGatewayAssociation resources.
        :param pulumi.Input[builtins.str] nat_gateway_id: The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("azure:network/subnetNatGatewayAssociation:SubnetNatGatewayAssociation")
class SubnetNatGatewayAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Associates a NAT Gateway with a Subnet within a Virtual Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-nat-gateway-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_nat_gateway = azure.network.NatGateway("example",
            name="example-natgateway",
            location=example.location,
            resource_group_name=example.name)
        example_subnet_nat_gateway_association = azure.network.SubnetNatGatewayAssociation("example",
            subnet_id=example_subnet.id,
            nat_gateway_id=example_nat_gateway.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Subnet NAT Gateway Associations can be imported using the `resource id` of the Subnet, e.g.

        ```sh
        $ pulumi import azure:network/subnetNatGatewayAssociation:SubnetNatGatewayAssociation association1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/subnets/mysubnet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] nat_gateway_id: The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetNatGatewayAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a NAT Gateway with a Subnet within a Virtual Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-nat-gateway-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_nat_gateway = azure.network.NatGateway("example",
            name="example-natgateway",
            location=example.location,
            resource_group_name=example.name)
        example_subnet_nat_gateway_association = azure.network.SubnetNatGatewayAssociation("example",
            subnet_id=example_subnet.id,
            nat_gateway_id=example_nat_gateway.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Subnet NAT Gateway Associations can be imported using the `resource id` of the Subnet, e.g.

        ```sh
        $ pulumi import azure:network/subnetNatGatewayAssociation:SubnetNatGatewayAssociation association1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/subnets/mysubnet1
        ```

        :param str resource_name: The name of the resource.
        :param SubnetNatGatewayAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetNatGatewayAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetNatGatewayAssociationArgs.__new__(SubnetNatGatewayAssociationArgs)

            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
        super(SubnetNatGatewayAssociation, __self__).__init__(
            'azure:network/subnetNatGatewayAssociation:SubnetNatGatewayAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SubnetNatGatewayAssociation':
        """
        Get an existing SubnetNatGatewayAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] nat_gateway_id: The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetNatGatewayAssociationState.__new__(_SubnetNatGatewayAssociationState)

        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["subnet_id"] = subnet_id
        return SubnetNatGatewayAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the NAT Gateway which should be associated with the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

