# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrafficManagerNestedEndpointArgs', 'TrafficManagerNestedEndpoint']

@pulumi.input_type
class TrafficManagerNestedEndpointArgs:
    def __init__(__self__, *,
                 minimum_child_endpoints: pulumi.Input[builtins.int],
                 profile_id: pulumi.Input[builtins.str],
                 target_resource_id: pulumi.Input[builtins.str],
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_location: Optional[pulumi.Input[builtins.str]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 minimum_required_child_endpoints_ipv4: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv6: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a TrafficManagerNestedEndpoint resource.
        :param pulumi.Input[builtins.int] minimum_child_endpoints: This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.
               
               > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        :param pulumi.Input[builtins.str] profile_id: The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_id: The resource id of an Azure resource to target.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] endpoint_location: Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv4: This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv6: This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.str] name: The name of the External Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        pulumi.set(__self__, "minimum_child_endpoints", minimum_child_endpoints)
        pulumi.set(__self__, "profile_id", profile_id)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_location is not None:
            pulumi.set(__self__, "endpoint_location", endpoint_location)
        if geo_mappings is not None:
            pulumi.set(__self__, "geo_mappings", geo_mappings)
        if minimum_required_child_endpoints_ipv4 is not None:
            pulumi.set(__self__, "minimum_required_child_endpoints_ipv4", minimum_required_child_endpoints_ipv4)
        if minimum_required_child_endpoints_ipv6 is not None:
            pulumi.set(__self__, "minimum_required_child_endpoints_ipv6", minimum_required_child_endpoints_ipv6)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="minimumChildEndpoints")
    def minimum_child_endpoints(self) -> pulumi.Input[builtins.int]:
        """
        This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.

        > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        """
        return pulumi.get(self, "minimum_child_endpoints")

    @minimum_child_endpoints.setter
    def minimum_child_endpoints(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minimum_child_endpoints", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource id of an Azure resource to target.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]]]:
        """
        One or more `custom_header` blocks as defined below.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the endpoint enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endpointLocation")
    def endpoint_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        """
        return pulumi.get(self, "endpoint_location")

    @endpoint_location.setter
    def endpoint_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_location", value)

    @property
    @pulumi.getter(name="geoMappings")
    def geo_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        """
        return pulumi.get(self, "geo_mappings")

    @geo_mappings.setter
    def geo_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "geo_mappings", value)

    @property
    @pulumi.getter(name="minimumRequiredChildEndpointsIpv4")
    def minimum_required_child_endpoints_ipv4(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        """
        return pulumi.get(self, "minimum_required_child_endpoints_ipv4")

    @minimum_required_child_endpoints_ipv4.setter
    def minimum_required_child_endpoints_ipv4(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_required_child_endpoints_ipv4", value)

    @property
    @pulumi.getter(name="minimumRequiredChildEndpointsIpv6")
    def minimum_required_child_endpoints_ipv6(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        """
        return pulumi.get(self, "minimum_required_child_endpoints_ipv6")

    @minimum_required_child_endpoints_ipv6.setter
    def minimum_required_child_endpoints_ipv6(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_required_child_endpoints_ipv6", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the External Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]]]:
        """
        One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _TrafficManagerNestedEndpointState:
    def __init__(__self__, *,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_location: Optional[pulumi.Input[builtins.str]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 minimum_child_endpoints: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv4: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv6: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering TrafficManagerNestedEndpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] endpoint_location: Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[builtins.int] minimum_child_endpoints: This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.
               
               > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv4: This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv6: This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.str] name: The name of the External Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[builtins.str] profile_id: The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_id: The resource id of an Azure resource to target.
        :param pulumi.Input[builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_location is not None:
            pulumi.set(__self__, "endpoint_location", endpoint_location)
        if geo_mappings is not None:
            pulumi.set(__self__, "geo_mappings", geo_mappings)
        if minimum_child_endpoints is not None:
            pulumi.set(__self__, "minimum_child_endpoints", minimum_child_endpoints)
        if minimum_required_child_endpoints_ipv4 is not None:
            pulumi.set(__self__, "minimum_required_child_endpoints_ipv4", minimum_required_child_endpoints_ipv4)
        if minimum_required_child_endpoints_ipv6 is not None:
            pulumi.set(__self__, "minimum_required_child_endpoints_ipv6", minimum_required_child_endpoints_ipv6)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]]]:
        """
        One or more `custom_header` blocks as defined below.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the endpoint enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endpointLocation")
    def endpoint_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        """
        return pulumi.get(self, "endpoint_location")

    @endpoint_location.setter
    def endpoint_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_location", value)

    @property
    @pulumi.getter(name="geoMappings")
    def geo_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        """
        return pulumi.get(self, "geo_mappings")

    @geo_mappings.setter
    def geo_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "geo_mappings", value)

    @property
    @pulumi.getter(name="minimumChildEndpoints")
    def minimum_child_endpoints(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.

        > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        """
        return pulumi.get(self, "minimum_child_endpoints")

    @minimum_child_endpoints.setter
    def minimum_child_endpoints(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_child_endpoints", value)

    @property
    @pulumi.getter(name="minimumRequiredChildEndpointsIpv4")
    def minimum_required_child_endpoints_ipv4(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        """
        return pulumi.get(self, "minimum_required_child_endpoints_ipv4")

    @minimum_required_child_endpoints_ipv4.setter
    def minimum_required_child_endpoints_ipv4(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_required_child_endpoints_ipv4", value)

    @property
    @pulumi.getter(name="minimumRequiredChildEndpointsIpv6")
    def minimum_required_child_endpoints_ipv6(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        """
        return pulumi.get(self, "minimum_required_child_endpoints_ipv6")

    @minimum_required_child_endpoints_ipv6.setter
    def minimum_required_child_endpoints_ipv6(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_required_child_endpoints_ipv6", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the External Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]]]:
        """
        One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerNestedEndpointSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource id of an Azure resource to target.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("azure:network/trafficManagerNestedEndpoint:TrafficManagerNestedEndpoint")
class TrafficManagerNestedEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointCustomHeaderArgs', 'TrafficManagerNestedEndpointCustomHeaderArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_location: Optional[pulumi.Input[builtins.str]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 minimum_child_endpoints: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv4: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv6: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointSubnetArgs', 'TrafficManagerNestedEndpointSubnetArgsDict']]]]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages a Nested Endpoint within a Traffic Manager Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example-publicip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            domain_name_label="example-pip")
        parent = azure.network.TrafficManagerProfile("parent",
            name="parent-profile",
            resource_group_name=example.name,
            traffic_routing_method="Weighted",
            dns_config={
                "relative_name": "parent-profile",
                "ttl": 100,
            },
            monitor_config={
                "protocol": "HTTP",
                "port": 80,
                "path": "/",
                "interval_in_seconds": 30,
                "timeout_in_seconds": 9,
                "tolerated_number_of_failures": 3,
            },
            tags={
                "environment": "Production",
            })
        nested = azure.network.TrafficManagerProfile("nested",
            name="nested-profile",
            resource_group_name=example.name,
            traffic_routing_method="Priority",
            dns_config={
                "relative_name": "nested-profile",
                "ttl": 30,
            },
            monitor_config={
                "protocol": "HTTP",
                "port": 443,
                "path": "/",
            })
        example_traffic_manager_nested_endpoint = azure.network.TrafficManagerNestedEndpoint("example",
            name="example-endpoint",
            target_resource_id=nested.id,
            priority=1,
            profile_id=parent.id,
            minimum_child_endpoints=9,
            weight=5)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2022-04-01

        ## Import

        Nested Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/trafficManagerNestedEndpoint:TrafficManagerNestedEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.Network/trafficManagerProfiles/example-profile/NestedEndpoints/example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointCustomHeaderArgs', 'TrafficManagerNestedEndpointCustomHeaderArgsDict']]]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] endpoint_location: Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[builtins.int] minimum_child_endpoints: This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.
               
               > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv4: This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv6: This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.str] name: The name of the External Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[builtins.str] profile_id: The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointSubnetArgs', 'TrafficManagerNestedEndpointSubnetArgsDict']]]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_id: The resource id of an Azure resource to target.
        :param pulumi.Input[builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficManagerNestedEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Nested Endpoint within a Traffic Manager Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example-publicip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            domain_name_label="example-pip")
        parent = azure.network.TrafficManagerProfile("parent",
            name="parent-profile",
            resource_group_name=example.name,
            traffic_routing_method="Weighted",
            dns_config={
                "relative_name": "parent-profile",
                "ttl": 100,
            },
            monitor_config={
                "protocol": "HTTP",
                "port": 80,
                "path": "/",
                "interval_in_seconds": 30,
                "timeout_in_seconds": 9,
                "tolerated_number_of_failures": 3,
            },
            tags={
                "environment": "Production",
            })
        nested = azure.network.TrafficManagerProfile("nested",
            name="nested-profile",
            resource_group_name=example.name,
            traffic_routing_method="Priority",
            dns_config={
                "relative_name": "nested-profile",
                "ttl": 30,
            },
            monitor_config={
                "protocol": "HTTP",
                "port": 443,
                "path": "/",
            })
        example_traffic_manager_nested_endpoint = azure.network.TrafficManagerNestedEndpoint("example",
            name="example-endpoint",
            target_resource_id=nested.id,
            priority=1,
            profile_id=parent.id,
            minimum_child_endpoints=9,
            weight=5)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2022-04-01

        ## Import

        Nested Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/trafficManagerNestedEndpoint:TrafficManagerNestedEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.Network/trafficManagerProfiles/example-profile/NestedEndpoints/example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param TrafficManagerNestedEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficManagerNestedEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointCustomHeaderArgs', 'TrafficManagerNestedEndpointCustomHeaderArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_location: Optional[pulumi.Input[builtins.str]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 minimum_child_endpoints: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv4: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_required_child_endpoints_ipv6: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointSubnetArgs', 'TrafficManagerNestedEndpointSubnetArgsDict']]]]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficManagerNestedEndpointArgs.__new__(TrafficManagerNestedEndpointArgs)

            __props__.__dict__["custom_headers"] = custom_headers
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["endpoint_location"] = endpoint_location
            __props__.__dict__["geo_mappings"] = geo_mappings
            if minimum_child_endpoints is None and not opts.urn:
                raise TypeError("Missing required property 'minimum_child_endpoints'")
            __props__.__dict__["minimum_child_endpoints"] = minimum_child_endpoints
            __props__.__dict__["minimum_required_child_endpoints_ipv4"] = minimum_required_child_endpoints_ipv4
            __props__.__dict__["minimum_required_child_endpoints_ipv6"] = minimum_required_child_endpoints_ipv6
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["subnets"] = subnets
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            __props__.__dict__["weight"] = weight
        super(TrafficManagerNestedEndpoint, __self__).__init__(
            'azure:network/trafficManagerNestedEndpoint:TrafficManagerNestedEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointCustomHeaderArgs', 'TrafficManagerNestedEndpointCustomHeaderArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            endpoint_location: Optional[pulumi.Input[builtins.str]] = None,
            geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            minimum_child_endpoints: Optional[pulumi.Input[builtins.int]] = None,
            minimum_required_child_endpoints_ipv4: Optional[pulumi.Input[builtins.int]] = None,
            minimum_required_child_endpoints_ipv6: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            profile_id: Optional[pulumi.Input[builtins.str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointSubnetArgs', 'TrafficManagerNestedEndpointSubnetArgsDict']]]]] = None,
            target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            weight: Optional[pulumi.Input[builtins.int]] = None) -> 'TrafficManagerNestedEndpoint':
        """
        Get an existing TrafficManagerNestedEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointCustomHeaderArgs', 'TrafficManagerNestedEndpointCustomHeaderArgsDict']]]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] endpoint_location: Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[builtins.int] minimum_child_endpoints: This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.
               
               > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv4: This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.int] minimum_required_child_endpoints_ipv6: This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        :param pulumi.Input[builtins.str] name: The name of the External Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[builtins.str] profile_id: The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerNestedEndpointSubnetArgs', 'TrafficManagerNestedEndpointSubnetArgsDict']]]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_id: The resource id of an Azure resource to target.
        :param pulumi.Input[builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficManagerNestedEndpointState.__new__(_TrafficManagerNestedEndpointState)

        __props__.__dict__["custom_headers"] = custom_headers
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["endpoint_location"] = endpoint_location
        __props__.__dict__["geo_mappings"] = geo_mappings
        __props__.__dict__["minimum_child_endpoints"] = minimum_child_endpoints
        __props__.__dict__["minimum_required_child_endpoints_ipv4"] = minimum_required_child_endpoints_ipv4
        __props__.__dict__["minimum_required_child_endpoints_ipv6"] = minimum_required_child_endpoints_ipv6
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["weight"] = weight
        return TrafficManagerNestedEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> pulumi.Output[Optional[Sequence['outputs.TrafficManagerNestedEndpointCustomHeader']]]:
        """
        One or more `custom_header` blocks as defined below.
        """
        return pulumi.get(self, "custom_headers")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the endpoint enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endpointLocation")
    def endpoint_location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure location of the Endpoint, this must be specified for Profiles using the `Performance` routing method.
        """
        return pulumi.get(self, "endpoint_location")

    @property
    @pulumi.getter(name="geoMappings")
    def geo_mappings(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        """
        return pulumi.get(self, "geo_mappings")

    @property
    @pulumi.getter(name="minimumChildEndpoints")
    def minimum_child_endpoints(self) -> pulumi.Output[builtins.int]:
        """
        This argument specifies the minimum number of endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This value must be larger than `0`.

        > **Note:** If `min_child_endpoints` is less than either `minimum_required_child_endpoints_ipv4` or `minimum_required_child_endpoints_ipv6`, then it won't have any effect.
        """
        return pulumi.get(self, "minimum_child_endpoints")

    @property
    @pulumi.getter(name="minimumRequiredChildEndpointsIpv4")
    def minimum_required_child_endpoints_ipv4(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        This argument specifies the minimum number of IPv4 (DNS record type A) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        """
        return pulumi.get(self, "minimum_required_child_endpoints_ipv4")

    @property
    @pulumi.getter(name="minimumRequiredChildEndpointsIpv6")
    def minimum_required_child_endpoints_ipv6(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        This argument specifies the minimum number of IPv6 (DNS record type AAAA) endpoints that must be ‘online’ in the child profile in order for the parent profile to direct traffic to any of the endpoints in that child profile. This argument only applies to Endpoints of type `nestedEndpoints` and
        """
        return pulumi.get(self, "minimum_required_child_endpoints_ipv6")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the External Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Traffic Manager Profile that this External Endpoint should be created within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence['outputs.TrafficManagerNestedEndpointSubnet']]]:
        """
        One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource id of an Azure resource to target.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        return pulumi.get(self, "weight")

