# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualHubArgs', 'VirtualHub']

@pulumi.input_type
class VirtualHubArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 hub_routing_preference: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_router_auto_scale_min_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_wan_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualHub resource.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] address_prefix: The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        :param pulumi.Input[builtins.str] hub_routing_preference: The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Hub. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]] routes: One or more `route` blocks as defined below.
        :param pulumi.Input[builtins.str] sku: The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Virtual Hub.
        :param pulumi.Input[builtins.int] virtual_router_auto_scale_min_capacity: Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        :param pulumi.Input[builtins.str] virtual_wan_id: The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if hub_routing_preference is not None:
            pulumi.set(__self__, "hub_routing_preference", hub_routing_preference)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_router_auto_scale_min_capacity is not None:
            pulumi.set(__self__, "virtual_router_auto_scale_min_capacity", virtual_router_auto_scale_min_capacity)
        if virtual_wan_id is not None:
            pulumi.set(__self__, "virtual_wan_id", virtual_wan_id)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="hubRoutingPreference")
    def hub_routing_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        """
        return pulumi.get(self, "hub_routing_preference")

    @hub_routing_preference.setter
    def hub_routing_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hub_routing_preference", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Virtual Hub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]]:
        """
        One or more `route` blocks as defined below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Virtual Hub.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualRouterAutoScaleMinCapacity")
    def virtual_router_auto_scale_min_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        """
        return pulumi.get(self, "virtual_router_auto_scale_min_capacity")

    @virtual_router_auto_scale_min_capacity.setter
    def virtual_router_auto_scale_min_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "virtual_router_auto_scale_min_capacity", value)

    @property
    @pulumi.getter(name="virtualWanId")
    def virtual_wan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_wan_id")

    @virtual_wan_id.setter
    def virtual_wan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_wan_id", value)


@pulumi.input_type
class _VirtualHubState:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 default_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 hub_routing_preference: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_router_asn: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_router_auto_scale_min_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_router_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 virtual_wan_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualHub resources.
        :param pulumi.Input[builtins.str] address_prefix: The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        :param pulumi.Input[builtins.str] default_route_table_id: The ID of the default Route Table in the Virtual Hub.
        :param pulumi.Input[builtins.str] hub_routing_preference: The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Hub. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]] routes: One or more `route` blocks as defined below.
        :param pulumi.Input[builtins.str] sku: The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Virtual Hub.
        :param pulumi.Input[builtins.int] virtual_router_asn: The Autonomous System Number of the Virtual Hub BGP router.
        :param pulumi.Input[builtins.int] virtual_router_auto_scale_min_capacity: Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] virtual_router_ips: The IP addresses of the Virtual Hub BGP router.
        :param pulumi.Input[builtins.str] virtual_wan_id: The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if default_route_table_id is not None:
            pulumi.set(__self__, "default_route_table_id", default_route_table_id)
        if hub_routing_preference is not None:
            pulumi.set(__self__, "hub_routing_preference", hub_routing_preference)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_router_asn is not None:
            pulumi.set(__self__, "virtual_router_asn", virtual_router_asn)
        if virtual_router_auto_scale_min_capacity is not None:
            pulumi.set(__self__, "virtual_router_auto_scale_min_capacity", virtual_router_auto_scale_min_capacity)
        if virtual_router_ips is not None:
            pulumi.set(__self__, "virtual_router_ips", virtual_router_ips)
        if virtual_wan_id is not None:
            pulumi.set(__self__, "virtual_wan_id", virtual_wan_id)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the default Route Table in the Virtual Hub.
        """
        return pulumi.get(self, "default_route_table_id")

    @default_route_table_id.setter
    def default_route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_route_table_id", value)

    @property
    @pulumi.getter(name="hubRoutingPreference")
    def hub_routing_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        """
        return pulumi.get(self, "hub_routing_preference")

    @hub_routing_preference.setter
    def hub_routing_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hub_routing_preference", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Virtual Hub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]]:
        """
        One or more `route` blocks as defined below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Virtual Hub.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualRouterAsn")
    def virtual_router_asn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Autonomous System Number of the Virtual Hub BGP router.
        """
        return pulumi.get(self, "virtual_router_asn")

    @virtual_router_asn.setter
    def virtual_router_asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "virtual_router_asn", value)

    @property
    @pulumi.getter(name="virtualRouterAutoScaleMinCapacity")
    def virtual_router_auto_scale_min_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        """
        return pulumi.get(self, "virtual_router_auto_scale_min_capacity")

    @virtual_router_auto_scale_min_capacity.setter
    def virtual_router_auto_scale_min_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "virtual_router_auto_scale_min_capacity", value)

    @property
    @pulumi.getter(name="virtualRouterIps")
    def virtual_router_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IP addresses of the Virtual Hub BGP router.
        """
        return pulumi.get(self, "virtual_router_ips")

    @virtual_router_ips.setter
    def virtual_router_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "virtual_router_ips", value)

    @property
    @pulumi.getter(name="virtualWanId")
    def virtual_wan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_wan_id")

    @virtual_wan_id.setter
    def virtual_wan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_wan_id", value)


@pulumi.type_token("azure:network/virtualHub:VirtualHub")
class VirtualHub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 hub_routing_preference: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualHubRouteArgs', 'VirtualHubRouteArgsDict']]]]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_router_auto_scale_min_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_wan_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Hub within a Virtual WAN.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-virtualwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-virtualhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.0.0/23")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualHub:VirtualHub example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/hub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_prefix: The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        :param pulumi.Input[builtins.str] hub_routing_preference: The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Hub. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualHubRouteArgs', 'VirtualHubRouteArgsDict']]]] routes: One or more `route` blocks as defined below.
        :param pulumi.Input[builtins.str] sku: The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Virtual Hub.
        :param pulumi.Input[builtins.int] virtual_router_auto_scale_min_capacity: Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        :param pulumi.Input[builtins.str] virtual_wan_id: The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualHubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Hub within a Virtual WAN.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-virtualwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-virtualhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.0.0/23")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualHub:VirtualHub example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/hub1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualHubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualHubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 hub_routing_preference: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualHubRouteArgs', 'VirtualHubRouteArgsDict']]]]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_router_auto_scale_min_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_wan_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualHubArgs.__new__(VirtualHubArgs)

            __props__.__dict__["address_prefix"] = address_prefix
            __props__.__dict__["hub_routing_preference"] = hub_routing_preference
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["routes"] = routes
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_router_auto_scale_min_capacity"] = virtual_router_auto_scale_min_capacity
            __props__.__dict__["virtual_wan_id"] = virtual_wan_id
            __props__.__dict__["default_route_table_id"] = None
            __props__.__dict__["virtual_router_asn"] = None
            __props__.__dict__["virtual_router_ips"] = None
        super(VirtualHub, __self__).__init__(
            'azure:network/virtualHub:VirtualHub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_prefix: Optional[pulumi.Input[builtins.str]] = None,
            default_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
            hub_routing_preference: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualHubRouteArgs', 'VirtualHubRouteArgsDict']]]]] = None,
            sku: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            virtual_router_asn: Optional[pulumi.Input[builtins.int]] = None,
            virtual_router_auto_scale_min_capacity: Optional[pulumi.Input[builtins.int]] = None,
            virtual_router_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            virtual_wan_id: Optional[pulumi.Input[builtins.str]] = None) -> 'VirtualHub':
        """
        Get an existing VirtualHub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_prefix: The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        :param pulumi.Input[builtins.str] default_route_table_id: The ID of the default Route Table in the Virtual Hub.
        :param pulumi.Input[builtins.str] hub_routing_preference: The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Hub. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualHubRouteArgs', 'VirtualHubRouteArgsDict']]]] routes: One or more `route` blocks as defined below.
        :param pulumi.Input[builtins.str] sku: The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Virtual Hub.
        :param pulumi.Input[builtins.int] virtual_router_asn: The Autonomous System Number of the Virtual Hub BGP router.
        :param pulumi.Input[builtins.int] virtual_router_auto_scale_min_capacity: Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] virtual_router_ips: The IP addresses of the Virtual Hub BGP router.
        :param pulumi.Input[builtins.str] virtual_wan_id: The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualHubState.__new__(_VirtualHubState)

        __props__.__dict__["address_prefix"] = address_prefix
        __props__.__dict__["default_route_table_id"] = default_route_table_id
        __props__.__dict__["hub_routing_preference"] = hub_routing_preference
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["routes"] = routes
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_router_asn"] = virtual_router_asn
        __props__.__dict__["virtual_router_auto_scale_min_capacity"] = virtual_router_auto_scale_min_capacity
        __props__.__dict__["virtual_router_ips"] = virtual_router_ips
        __props__.__dict__["virtual_wan_id"] = virtual_wan_id
        return VirtualHub(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Address Prefix which should be used for this Virtual Hub. Changing this forces a new resource to be created. [The address prefix subnet cannot be smaller than a `/24`. Azure recommends using a `/23`](https://docs.microsoft.com/azure/virtual-wan/virtual-wan-faq#what-is-the-recommended-hub-address-space-during-hub-creation).
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the default Route Table in the Virtual Hub.
        """
        return pulumi.get(self, "default_route_table_id")

    @property
    @pulumi.getter(name="hubRoutingPreference")
    def hub_routing_preference(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The hub routing preference. Possible values are `ExpressRoute`, `ASPath` and `VpnGateway`. Defaults to `ExpressRoute`.
        """
        return pulumi.get(self, "hub_routing_preference")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the Virtual Hub should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Virtual Hub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the Virtual Hub should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualHubRoute']]]:
        """
        One or more `route` blocks as defined below.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The SKU of the Virtual Hub. Possible values are `Basic` and `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the Virtual Hub.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualRouterAsn")
    def virtual_router_asn(self) -> pulumi.Output[builtins.int]:
        """
        The Autonomous System Number of the Virtual Hub BGP router.
        """
        return pulumi.get(self, "virtual_router_asn")

    @property
    @pulumi.getter(name="virtualRouterAutoScaleMinCapacity")
    def virtual_router_auto_scale_min_capacity(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Minimum instance capacity for the scaling configuration of the Virtual Hub Router. Defaults to `2`.
        """
        return pulumi.get(self, "virtual_router_auto_scale_min_capacity")

    @property
    @pulumi.getter(name="virtualRouterIps")
    def virtual_router_ips(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The IP addresses of the Virtual Hub BGP router.
        """
        return pulumi.get(self, "virtual_router_ips")

    @property
    @pulumi.getter(name="virtualWanId")
    def virtual_wan_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of a Virtual WAN within which the Virtual Hub should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_wan_id")

