# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualHubIpArgs', 'VirtualHubIp']

@pulumi.input_type
class VirtualHubIpArgs:
    def __init__(__self__, *,
                 public_ip_address_id: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str],
                 virtual_hub_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualHubIp resource.
        :param pulumi.Input[builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[builtins.str] private_ip_allocation_method: The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        """
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "public_ip_address_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @virtual_hub_id.setter
    def virtual_hub_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_hub_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip_allocation_method", value)


@pulumi.input_type
class _VirtualHubIpState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_hub_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualHubIp resources.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[builtins.str] private_ip_allocation_method: The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        :param pulumi.Input[builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if virtual_hub_id is not None:
            pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip_address_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @virtual_hub_id.setter
    def virtual_hub_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_hub_id", value)


@pulumi.type_token("azure:network/virtualHubIp:VirtualHubIp")
class VirtualHubIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_hub_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Hub IP. This resource is also known as a Route Server.

        > **Note:** Virtual Hub IP only supports Standard Virtual Hub without Virtual Wan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard")
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.5.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"])
        example_virtual_hub_ip = azure.network.VirtualHubIp("example",
            name="example-vhubipconfig",
            virtual_hub_id=example_virtual_hub.id,
            private_ip_address="10.5.1.18",
            private_ip_allocation_method="Static",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub IPs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualHubIp:VirtualHubIp example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/virtualHub1/ipConfigurations/ipConfig1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[builtins.str] private_ip_allocation_method: The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        :param pulumi.Input[builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualHubIpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Hub IP. This resource is also known as a Route Server.

        > **Note:** Virtual Hub IP only supports Standard Virtual Hub without Virtual Wan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard")
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.5.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"])
        example_virtual_hub_ip = azure.network.VirtualHubIp("example",
            name="example-vhubipconfig",
            virtual_hub_id=example_virtual_hub.id,
            private_ip_address="10.5.1.18",
            private_ip_allocation_method="Static",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub IPs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualHubIp:VirtualHubIp example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/virtualHub1/ipConfigurations/ipConfig1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualHubIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualHubIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_hub_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualHubIpArgs.__new__(VirtualHubIpArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["private_ip_allocation_method"] = private_ip_allocation_method
            if public_ip_address_id is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip_address_id'")
            __props__.__dict__["public_ip_address_id"] = public_ip_address_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if virtual_hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_hub_id'")
            __props__.__dict__["virtual_hub_id"] = virtual_hub_id
        super(VirtualHubIp, __self__).__init__(
            'azure:network/virtualHubIp:VirtualHubIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            private_ip_allocation_method: Optional[pulumi.Input[builtins.str]] = None,
            public_ip_address_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            virtual_hub_id: Optional[pulumi.Input[builtins.str]] = None) -> 'VirtualHubIp':
        """
        Get an existing VirtualHubIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[builtins.str] private_ip_allocation_method: The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        :param pulumi.Input[builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualHubIpState.__new__(_VirtualHubIpState)

        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["private_ip_allocation_method"] = private_ip_allocation_method
        __props__.__dict__["public_ip_address_id"] = public_ip_address_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["virtual_hub_id"] = virtual_hub_id
        return VirtualHubIp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Virtual Hub IP. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The private IP address allocation method. Possible values are `Static` and `Dynamic` is allowed. Defaults to `Dynamic`.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Subnet that the IP will reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Virtual Hub within which this IP configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

