# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualNetworkDnsServersArgs', 'VirtualNetworkDnsServers']

@pulumi.input_type
class VirtualNetworkDnsServersArgs:
    def __init__(__self__, *,
                 virtual_network_id: pulumi.Input[builtins.str],
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualNetworkDnsServers resource.
        :param pulumi.Input[builtins.str] virtual_network_id: The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: List of IP addresses of DNS servers
        """
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_network_id", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IP addresses of DNS servers
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)


@pulumi.input_type
class _VirtualNetworkDnsServersState:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualNetworkDnsServers resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: List of IP addresses of DNS servers
        :param pulumi.Input[builtins.str] virtual_network_id: The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IP addresses of DNS servers
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.type_token("azure:network/virtualNetworkDnsServers:VirtualNetworkDnsServers")
class VirtualNetworkDnsServers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Virtual Network DNS Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkDnsServers:VirtualNetworkDnsServers exampleNetwork /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/dnsServers/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: List of IP addresses of DNS servers
        :param pulumi.Input[builtins.str] virtual_network_id: The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkDnsServersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Virtual Network DNS Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkDnsServers:VirtualNetworkDnsServers exampleNetwork /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/dnsServers/default
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkDnsServersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkDnsServersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkDnsServersArgs.__new__(VirtualNetworkDnsServersArgs)

            __props__.__dict__["dns_servers"] = dns_servers
            if virtual_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_network_id'")
            __props__.__dict__["virtual_network_id"] = virtual_network_id
        super(VirtualNetworkDnsServers, __self__).__init__(
            'azure:network/virtualNetworkDnsServers:VirtualNetworkDnsServers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            virtual_network_id: Optional[pulumi.Input[builtins.str]] = None) -> 'VirtualNetworkDnsServers':
        """
        Get an existing VirtualNetworkDnsServers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: List of IP addresses of DNS servers
        :param pulumi.Input[builtins.str] virtual_network_id: The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkDnsServersState.__new__(_VirtualNetworkDnsServersState)

        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return VirtualNetworkDnsServers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of IP addresses of DNS servers
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Virtual Network that should be linked to the DNS Zone. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

