# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualNetworkPeeringArgs', 'VirtualNetworkPeering']

@pulumi.input_type
class VirtualNetworkPeeringArgs:
    def __init__(__self__, *,
                 remote_virtual_network_id: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 virtual_network_name: pulumi.Input[builtins.str],
                 allow_forwarded_traffic: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_gateway_transit: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_virtual_network_access: Optional[pulumi.Input[builtins.bool]] = None,
                 local_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 only_ipv6_peering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_complete_virtual_networks_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 remote_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_remote_gateways: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a VirtualNetworkPeering resource.
        :param pulumi.Input[builtins.str] remote_virtual_network_id: The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_network_name: The name of the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] allow_forwarded_traffic: Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_gateway_transit: Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_virtual_network_access: Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] local_subnet_names: A list of local Subnet names that are Subnet peered with remote Virtual Network.
        :param pulumi.Input[builtins.str] name: The name of the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] only_ipv6_peering_enabled: Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] peer_complete_virtual_networks_enabled: Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] remote_subnet_names: A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        :param pulumi.Input[builtins.bool] use_remote_gateways: Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.
               
               > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        """
        pulumi.set(__self__, "remote_virtual_network_id", remote_virtual_network_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "virtual_network_name", virtual_network_name)
        if allow_forwarded_traffic is not None:
            pulumi.set(__self__, "allow_forwarded_traffic", allow_forwarded_traffic)
        if allow_gateway_transit is not None:
            pulumi.set(__self__, "allow_gateway_transit", allow_gateway_transit)
        if allow_virtual_network_access is not None:
            pulumi.set(__self__, "allow_virtual_network_access", allow_virtual_network_access)
        if local_subnet_names is not None:
            pulumi.set(__self__, "local_subnet_names", local_subnet_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if only_ipv6_peering_enabled is not None:
            pulumi.set(__self__, "only_ipv6_peering_enabled", only_ipv6_peering_enabled)
        if peer_complete_virtual_networks_enabled is not None:
            pulumi.set(__self__, "peer_complete_virtual_networks_enabled", peer_complete_virtual_networks_enabled)
        if remote_subnet_names is not None:
            pulumi.set(__self__, "remote_subnet_names", remote_subnet_names)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if use_remote_gateways is not None:
            pulumi.set(__self__, "use_remote_gateways", use_remote_gateways)

    @property
    @pulumi.getter(name="remoteVirtualNetworkId")
    def remote_virtual_network_id(self) -> pulumi.Input[builtins.str]:
        """
        The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_virtual_network_id")

    @remote_virtual_network_id.setter
    def remote_virtual_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_virtual_network_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="virtualNetworkName")
    def virtual_network_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_name")

    @virtual_network_name.setter
    def virtual_network_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_network_name", value)

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @allow_forwarded_traffic.setter
    def allow_forwarded_traffic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_forwarded_traffic", value)

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @allow_gateway_transit.setter
    def allow_gateway_transit(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_gateway_transit", value)

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @allow_virtual_network_access.setter
    def allow_virtual_network_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_virtual_network_access", value)

    @property
    @pulumi.getter(name="localSubnetNames")
    def local_subnet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of local Subnet names that are Subnet peered with remote Virtual Network.
        """
        return pulumi.get(self, "local_subnet_names")

    @local_subnet_names.setter
    def local_subnet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "local_subnet_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the virtual network peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onlyIpv6PeeringEnabled")
    def only_ipv6_peering_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "only_ipv6_peering_enabled")

    @only_ipv6_peering_enabled.setter
    def only_ipv6_peering_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_ipv6_peering_enabled", value)

    @property
    @pulumi.getter(name="peerCompleteVirtualNetworksEnabled")
    def peer_complete_virtual_networks_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_complete_virtual_networks_enabled")

    @peer_complete_virtual_networks_enabled.setter
    def peer_complete_virtual_networks_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "peer_complete_virtual_networks_enabled", value)

    @property
    @pulumi.getter(name="remoteSubnetNames")
    def remote_subnet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        """
        return pulumi.get(self, "remote_subnet_names")

    @remote_subnet_names.setter
    def remote_subnet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "remote_subnet_names", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.

        > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        """
        return pulumi.get(self, "use_remote_gateways")

    @use_remote_gateways.setter
    def use_remote_gateways(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_remote_gateways", value)


@pulumi.input_type
class _VirtualNetworkPeeringState:
    def __init__(__self__, *,
                 allow_forwarded_traffic: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_gateway_transit: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_virtual_network_access: Optional[pulumi.Input[builtins.bool]] = None,
                 local_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 only_ipv6_peering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_complete_virtual_networks_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 remote_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 remote_virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_remote_gateways: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualNetworkPeering resources.
        :param pulumi.Input[builtins.bool] allow_forwarded_traffic: Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_gateway_transit: Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_virtual_network_access: Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] local_subnet_names: A list of local Subnet names that are Subnet peered with remote Virtual Network.
        :param pulumi.Input[builtins.str] name: The name of the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] only_ipv6_peering_enabled: Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] peer_complete_virtual_networks_enabled: Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] remote_subnet_names: A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        :param pulumi.Input[builtins.str] remote_virtual_network_id: The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        :param pulumi.Input[builtins.bool] use_remote_gateways: Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.
               
               > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        :param pulumi.Input[builtins.str] virtual_network_name: The name of the virtual network. Changing this forces a new resource to be created.
        """
        if allow_forwarded_traffic is not None:
            pulumi.set(__self__, "allow_forwarded_traffic", allow_forwarded_traffic)
        if allow_gateway_transit is not None:
            pulumi.set(__self__, "allow_gateway_transit", allow_gateway_transit)
        if allow_virtual_network_access is not None:
            pulumi.set(__self__, "allow_virtual_network_access", allow_virtual_network_access)
        if local_subnet_names is not None:
            pulumi.set(__self__, "local_subnet_names", local_subnet_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if only_ipv6_peering_enabled is not None:
            pulumi.set(__self__, "only_ipv6_peering_enabled", only_ipv6_peering_enabled)
        if peer_complete_virtual_networks_enabled is not None:
            pulumi.set(__self__, "peer_complete_virtual_networks_enabled", peer_complete_virtual_networks_enabled)
        if remote_subnet_names is not None:
            pulumi.set(__self__, "remote_subnet_names", remote_subnet_names)
        if remote_virtual_network_id is not None:
            pulumi.set(__self__, "remote_virtual_network_id", remote_virtual_network_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if use_remote_gateways is not None:
            pulumi.set(__self__, "use_remote_gateways", use_remote_gateways)
        if virtual_network_name is not None:
            pulumi.set(__self__, "virtual_network_name", virtual_network_name)

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @allow_forwarded_traffic.setter
    def allow_forwarded_traffic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_forwarded_traffic", value)

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @allow_gateway_transit.setter
    def allow_gateway_transit(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_gateway_transit", value)

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @allow_virtual_network_access.setter
    def allow_virtual_network_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_virtual_network_access", value)

    @property
    @pulumi.getter(name="localSubnetNames")
    def local_subnet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of local Subnet names that are Subnet peered with remote Virtual Network.
        """
        return pulumi.get(self, "local_subnet_names")

    @local_subnet_names.setter
    def local_subnet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "local_subnet_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the virtual network peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onlyIpv6PeeringEnabled")
    def only_ipv6_peering_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "only_ipv6_peering_enabled")

    @only_ipv6_peering_enabled.setter
    def only_ipv6_peering_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_ipv6_peering_enabled", value)

    @property
    @pulumi.getter(name="peerCompleteVirtualNetworksEnabled")
    def peer_complete_virtual_networks_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_complete_virtual_networks_enabled")

    @peer_complete_virtual_networks_enabled.setter
    def peer_complete_virtual_networks_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "peer_complete_virtual_networks_enabled", value)

    @property
    @pulumi.getter(name="remoteSubnetNames")
    def remote_subnet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        """
        return pulumi.get(self, "remote_subnet_names")

    @remote_subnet_names.setter
    def remote_subnet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "remote_subnet_names", value)

    @property
    @pulumi.getter(name="remoteVirtualNetworkId")
    def remote_virtual_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_virtual_network_id")

    @remote_virtual_network_id.setter
    def remote_virtual_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_virtual_network_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.

        > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        """
        return pulumi.get(self, "use_remote_gateways")

    @use_remote_gateways.setter
    def use_remote_gateways(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_remote_gateways", value)

    @property
    @pulumi.getter(name="virtualNetworkName")
    def virtual_network_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_name")

    @virtual_network_name.setter
    def virtual_network_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_name", value)


@pulumi.type_token("azure:network/virtualNetworkPeering:VirtualNetworkPeering")
class VirtualNetworkPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_forwarded_traffic: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_gateway_transit: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_virtual_network_access: Optional[pulumi.Input[builtins.bool]] = None,
                 local_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 only_ipv6_peering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_complete_virtual_networks_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 remote_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 remote_virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_remote_gateways: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a virtual network peering which allows resources to access other
        resources in the linked virtual network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="peeredvnets-rg",
            location="West Europe")
        example_1 = azure.network.VirtualNetwork("example-1",
            name="peternetwork1",
            resource_group_name=example.name,
            address_spaces=["10.0.1.0/24"],
            location=example.location)
        example_2 = azure.network.VirtualNetwork("example-2",
            name="peternetwork2",
            resource_group_name=example.name,
            address_spaces=["10.0.2.0/24"],
            location=example.location)
        example_1_virtual_network_peering = azure.network.VirtualNetworkPeering("example-1",
            name="peer1to2",
            resource_group_name=example.name,
            virtual_network_name=example_1.name,
            remote_virtual_network_id=example_2.id)
        example_2_virtual_network_peering = azure.network.VirtualNetworkPeering("example-2",
            name="peer2to1",
            resource_group_name=example.name,
            virtual_network_name=example_2.name,
            remote_virtual_network_id=example_1.id)
        ```

        ### Triggers)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="peeredvnets-rg",
            location="West Europe")
        example_1 = azure.network.VirtualNetwork("example-1",
            name="peternetwork1",
            resource_group_name=example.name,
            address_spaces=["10.0.1.0/24"],
            location=example.location)
        example_2 = azure.network.VirtualNetwork("example-2",
            name="peternetwork2",
            resource_group_name=example.name,
            address_spaces=["10.0.2.0/24"],
            location=example.location)
        example_1_virtual_network_peering = azure.network.VirtualNetworkPeering("example-1",
            name="peer1to2",
            resource_group_name=example.name,
            virtual_network_name=example_1.name,
            remote_virtual_network_id=example_2.id,
            triggers={
                "remote_address_space": example_2.address_spaces.apply(lambda address_spaces: std.join_output(separator=",",
                    input=address_spaces)).apply(lambda invoke: invoke.result),
            })
        example_2_virtual_network_peering = azure.network.VirtualNetworkPeering("example-2",
            name="peer2to1",
            resource_group_name=example.name,
            virtual_network_name=example_2.name,
            remote_virtual_network_id=example_1.id,
            triggers={
                "remote_address_space": example_1.address_spaces.apply(lambda address_spaces: std.join_output(separator=",",
                    input=address_spaces)).apply(lambda invoke: invoke.result),
            })
        ```

        ## Note

        Virtual Network peerings cannot be created, updated or deleted concurrently.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Network Peerings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkPeering:VirtualNetworkPeering examplePeering /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/virtualNetworkPeerings/myvnet1peering
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_forwarded_traffic: Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_gateway_transit: Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_virtual_network_access: Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] local_subnet_names: A list of local Subnet names that are Subnet peered with remote Virtual Network.
        :param pulumi.Input[builtins.str] name: The name of the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] only_ipv6_peering_enabled: Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] peer_complete_virtual_networks_enabled: Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] remote_subnet_names: A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        :param pulumi.Input[builtins.str] remote_virtual_network_id: The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        :param pulumi.Input[builtins.bool] use_remote_gateways: Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.
               
               > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        :param pulumi.Input[builtins.str] virtual_network_name: The name of the virtual network. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a virtual network peering which allows resources to access other
        resources in the linked virtual network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="peeredvnets-rg",
            location="West Europe")
        example_1 = azure.network.VirtualNetwork("example-1",
            name="peternetwork1",
            resource_group_name=example.name,
            address_spaces=["10.0.1.0/24"],
            location=example.location)
        example_2 = azure.network.VirtualNetwork("example-2",
            name="peternetwork2",
            resource_group_name=example.name,
            address_spaces=["10.0.2.0/24"],
            location=example.location)
        example_1_virtual_network_peering = azure.network.VirtualNetworkPeering("example-1",
            name="peer1to2",
            resource_group_name=example.name,
            virtual_network_name=example_1.name,
            remote_virtual_network_id=example_2.id)
        example_2_virtual_network_peering = azure.network.VirtualNetworkPeering("example-2",
            name="peer2to1",
            resource_group_name=example.name,
            virtual_network_name=example_2.name,
            remote_virtual_network_id=example_1.id)
        ```

        ### Triggers)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="peeredvnets-rg",
            location="West Europe")
        example_1 = azure.network.VirtualNetwork("example-1",
            name="peternetwork1",
            resource_group_name=example.name,
            address_spaces=["10.0.1.0/24"],
            location=example.location)
        example_2 = azure.network.VirtualNetwork("example-2",
            name="peternetwork2",
            resource_group_name=example.name,
            address_spaces=["10.0.2.0/24"],
            location=example.location)
        example_1_virtual_network_peering = azure.network.VirtualNetworkPeering("example-1",
            name="peer1to2",
            resource_group_name=example.name,
            virtual_network_name=example_1.name,
            remote_virtual_network_id=example_2.id,
            triggers={
                "remote_address_space": example_2.address_spaces.apply(lambda address_spaces: std.join_output(separator=",",
                    input=address_spaces)).apply(lambda invoke: invoke.result),
            })
        example_2_virtual_network_peering = azure.network.VirtualNetworkPeering("example-2",
            name="peer2to1",
            resource_group_name=example.name,
            virtual_network_name=example_2.name,
            remote_virtual_network_id=example_1.id,
            triggers={
                "remote_address_space": example_1.address_spaces.apply(lambda address_spaces: std.join_output(separator=",",
                    input=address_spaces)).apply(lambda invoke: invoke.result),
            })
        ```

        ## Note

        Virtual Network peerings cannot be created, updated or deleted concurrently.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Network Peerings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkPeering:VirtualNetworkPeering examplePeering /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/virtualNetworkPeerings/myvnet1peering
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_forwarded_traffic: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_gateway_transit: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_virtual_network_access: Optional[pulumi.Input[builtins.bool]] = None,
                 local_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 only_ipv6_peering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_complete_virtual_networks_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 remote_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 remote_virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_remote_gateways: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkPeeringArgs.__new__(VirtualNetworkPeeringArgs)

            __props__.__dict__["allow_forwarded_traffic"] = allow_forwarded_traffic
            __props__.__dict__["allow_gateway_transit"] = allow_gateway_transit
            __props__.__dict__["allow_virtual_network_access"] = allow_virtual_network_access
            __props__.__dict__["local_subnet_names"] = local_subnet_names
            __props__.__dict__["name"] = name
            __props__.__dict__["only_ipv6_peering_enabled"] = only_ipv6_peering_enabled
            __props__.__dict__["peer_complete_virtual_networks_enabled"] = peer_complete_virtual_networks_enabled
            __props__.__dict__["remote_subnet_names"] = remote_subnet_names
            if remote_virtual_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'remote_virtual_network_id'")
            __props__.__dict__["remote_virtual_network_id"] = remote_virtual_network_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["use_remote_gateways"] = use_remote_gateways
            if virtual_network_name is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_network_name'")
            __props__.__dict__["virtual_network_name"] = virtual_network_name
        super(VirtualNetworkPeering, __self__).__init__(
            'azure:network/virtualNetworkPeering:VirtualNetworkPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_forwarded_traffic: Optional[pulumi.Input[builtins.bool]] = None,
            allow_gateway_transit: Optional[pulumi.Input[builtins.bool]] = None,
            allow_virtual_network_access: Optional[pulumi.Input[builtins.bool]] = None,
            local_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            only_ipv6_peering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            peer_complete_virtual_networks_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            remote_subnet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            remote_virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            use_remote_gateways: Optional[pulumi.Input[builtins.bool]] = None,
            virtual_network_name: Optional[pulumi.Input[builtins.str]] = None) -> 'VirtualNetworkPeering':
        """
        Get an existing VirtualNetworkPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_forwarded_traffic: Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_gateway_transit: Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        :param pulumi.Input[builtins.bool] allow_virtual_network_access: Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] local_subnet_names: A list of local Subnet names that are Subnet peered with remote Virtual Network.
        :param pulumi.Input[builtins.str] name: The name of the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] only_ipv6_peering_enabled: Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] peer_complete_virtual_networks_enabled: Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] remote_subnet_names: A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        :param pulumi.Input[builtins.str] remote_virtual_network_id: The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        :param pulumi.Input[builtins.bool] use_remote_gateways: Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.
               
               > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        :param pulumi.Input[builtins.str] virtual_network_name: The name of the virtual network. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkPeeringState.__new__(_VirtualNetworkPeeringState)

        __props__.__dict__["allow_forwarded_traffic"] = allow_forwarded_traffic
        __props__.__dict__["allow_gateway_transit"] = allow_gateway_transit
        __props__.__dict__["allow_virtual_network_access"] = allow_virtual_network_access
        __props__.__dict__["local_subnet_names"] = local_subnet_names
        __props__.__dict__["name"] = name
        __props__.__dict__["only_ipv6_peering_enabled"] = only_ipv6_peering_enabled
        __props__.__dict__["peer_complete_virtual_networks_enabled"] = peer_complete_virtual_networks_enabled
        __props__.__dict__["remote_subnet_names"] = remote_subnet_names
        __props__.__dict__["remote_virtual_network_id"] = remote_virtual_network_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["use_remote_gateways"] = use_remote_gateways
        __props__.__dict__["virtual_network_name"] = virtual_network_name
        return VirtualNetworkPeering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls if forwarded traffic from VMs in the remote virtual network is allowed. Defaults to `false`.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls gatewayLinks can be used in the remote virtual network’s link to the local virtual network. Defaults to `false`.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls if the traffic from the local virtual network can reach the remote virtual network. Defaults to `true`.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @property
    @pulumi.getter(name="localSubnetNames")
    def local_subnet_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of local Subnet names that are Subnet peered with remote Virtual Network.
        """
        return pulumi.get(self, "local_subnet_names")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the virtual network peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onlyIpv6PeeringEnabled")
    def only_ipv6_peering_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether only IPv6 address space is peered for Subnet peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "only_ipv6_peering_enabled")

    @property
    @pulumi.getter(name="peerCompleteVirtualNetworksEnabled")
    def peer_complete_virtual_networks_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether complete Virtual Network address space is peered. Defaults to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_complete_virtual_networks_enabled")

    @property
    @pulumi.getter(name="remoteSubnetNames")
    def remote_subnet_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of remote Subnet names from remote Virtual Network that are Subnet peered.
        """
        return pulumi.get(self, "remote_subnet_names")

    @property
    @pulumi.getter(name="remoteVirtualNetworkId")
    def remote_virtual_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The full Azure resource ID of the remote virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_virtual_network_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the virtual network peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of key values pairs that can be used to sync network routes from the remote virtual network to the local virtual network. See the trigger example for an example on how to set it up.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls if remote gateways can be used on the local virtual network. If the flag is set to `true`, and `allow_gateway_transit` on the remote peering is also `true`, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to `true`. This flag cannot be set if virtual network already has a gateway. Defaults to `false`.

        > **Note:** `use_remote_gateways` must be set to `false` if using Global Virtual Network Peerings.
        """
        return pulumi.get(self, "use_remote_gateways")

    @property
    @pulumi.getter(name="virtualNetworkName")
    def virtual_network_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_name")

