# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VnpGatewayNatRuleArgs', 'VnpGatewayNatRule']

@pulumi.input_type
class VnpGatewayNatRuleArgs:
    def __init__(__self__, *,
                 vpn_gateway_id: pulumi.Input[builtins.str],
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VnpGatewayNatRule resource.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]] external_mappings: One of more `external_mapping` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]] internal_mappings: One of more `internal_mapping` blocks as defined below.
        :param pulumi.Input[builtins.str] ip_configuration_id: The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        :param pulumi.Input[builtins.str] mode: The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if external_mappings is not None:
            pulumi.set(__self__, "external_mappings", external_mappings)
        if internal_mappings is not None:
            pulumi.set(__self__, "internal_mappings", internal_mappings)
        if ip_configuration_id is not None:
            pulumi.set(__self__, "ip_configuration_id", ip_configuration_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpn_gateway_id", value)

    @property
    @pulumi.getter(name="externalMappings")
    def external_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]]]:
        """
        One of more `external_mapping` blocks as defined below.
        """
        return pulumi.get(self, "external_mappings")

    @external_mappings.setter
    def external_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]]]):
        pulumi.set(self, "external_mappings", value)

    @property
    @pulumi.getter(name="internalMappings")
    def internal_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]]]:
        """
        One of more `internal_mapping` blocks as defined below.
        """
        return pulumi.get(self, "internal_mappings")

    @internal_mappings.setter
    def internal_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]]]):
        pulumi.set(self, "internal_mappings", value)

    @property
    @pulumi.getter(name="ipConfigurationId")
    def ip_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        """
        return pulumi.get(self, "ip_configuration_id")

    @ip_configuration_id.setter
    def ip_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_configuration_id", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _VnpGatewayNatRuleState:
    def __init__(__self__, *,
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VnpGatewayNatRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]] external_mappings: One of more `external_mapping` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]] internal_mappings: One of more `internal_mapping` blocks as defined below.
        :param pulumi.Input[builtins.str] ip_configuration_id: The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        :param pulumi.Input[builtins.str] mode: The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        """
        if external_mappings is not None:
            pulumi.set(__self__, "external_mappings", external_mappings)
        if internal_mappings is not None:
            pulumi.set(__self__, "internal_mappings", internal_mappings)
        if ip_configuration_id is not None:
            pulumi.set(__self__, "ip_configuration_id", ip_configuration_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter(name="externalMappings")
    def external_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]]]:
        """
        One of more `external_mapping` blocks as defined below.
        """
        return pulumi.get(self, "external_mappings")

    @external_mappings.setter
    def external_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleExternalMappingArgs']]]]):
        pulumi.set(self, "external_mappings", value)

    @property
    @pulumi.getter(name="internalMappings")
    def internal_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]]]:
        """
        One of more `internal_mapping` blocks as defined below.
        """
        return pulumi.get(self, "internal_mappings")

    @internal_mappings.setter
    def internal_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VnpGatewayNatRuleInternalMappingArgs']]]]):
        pulumi.set(self, "internal_mappings", value)

    @property
    @pulumi.getter(name="ipConfigurationId")
    def ip_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        """
        return pulumi.get(self, "ip_configuration_id")

    @ip_configuration_id.setter
    def ip_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_configuration_id", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_gateway_id", value)


@pulumi.type_token("azure:network/vnpGatewayNatRule:VnpGatewayNatRule")
class VnpGatewayNatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleExternalMappingArgs', 'VnpGatewayNatRuleExternalMappingArgsDict']]]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleInternalMappingArgs', 'VnpGatewayNatRuleInternalMappingArgsDict']]]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPN Gateway NAT Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            address_prefix="10.0.1.0/24",
            virtual_wan_id=example_virtual_wan.id)
        example_vpn_gateway = azure.network.VpnGateway("example",
            name="example-vpngateway",
            location=example.location,
            resource_group_name=example.name,
            virtual_hub_id=example_virtual_hub.id)
        example_vnp_gateway_nat_rule = azure.network.VnpGatewayNatRule("example",
            name="example-vpngatewaynatrule",
            vpn_gateway_id=example_vpn_gateway.id,
            external_mappings=[{
                "address_space": "192.168.21.0/26",
            }],
            internal_mappings=[{
                "address_space": "10.4.0.0/26",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        VPN Gateway NAT Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/vnpGatewayNatRule:VnpGatewayNatRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Network/vpnGateways/vpnGateway1/natRules/natRule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleExternalMappingArgs', 'VnpGatewayNatRuleExternalMappingArgsDict']]]] external_mappings: One of more `external_mapping` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleInternalMappingArgs', 'VnpGatewayNatRuleInternalMappingArgsDict']]]] internal_mappings: One of more `internal_mapping` blocks as defined below.
        :param pulumi.Input[builtins.str] ip_configuration_id: The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        :param pulumi.Input[builtins.str] mode: The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VnpGatewayNatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN Gateway NAT Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            address_prefix="10.0.1.0/24",
            virtual_wan_id=example_virtual_wan.id)
        example_vpn_gateway = azure.network.VpnGateway("example",
            name="example-vpngateway",
            location=example.location,
            resource_group_name=example.name,
            virtual_hub_id=example_virtual_hub.id)
        example_vnp_gateway_nat_rule = azure.network.VnpGatewayNatRule("example",
            name="example-vpngatewaynatrule",
            vpn_gateway_id=example_vpn_gateway.id,
            external_mappings=[{
                "address_space": "192.168.21.0/26",
            }],
            internal_mappings=[{
                "address_space": "10.4.0.0/26",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        VPN Gateway NAT Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/vnpGatewayNatRule:VnpGatewayNatRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Network/vpnGateways/vpnGateway1/natRules/natRule1
        ```

        :param str resource_name: The name of the resource.
        :param VnpGatewayNatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VnpGatewayNatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleExternalMappingArgs', 'VnpGatewayNatRuleExternalMappingArgsDict']]]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleInternalMappingArgs', 'VnpGatewayNatRuleInternalMappingArgsDict']]]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VnpGatewayNatRuleArgs.__new__(VnpGatewayNatRuleArgs)

            __props__.__dict__["external_mappings"] = external_mappings
            __props__.__dict__["internal_mappings"] = internal_mappings
            __props__.__dict__["ip_configuration_id"] = ip_configuration_id
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["type"] = type
            if vpn_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_gateway_id'")
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        super(VnpGatewayNatRule, __self__).__init__(
            'azure:network/vnpGatewayNatRule:VnpGatewayNatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleExternalMappingArgs', 'VnpGatewayNatRuleExternalMappingArgsDict']]]]] = None,
            internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleInternalMappingArgs', 'VnpGatewayNatRuleInternalMappingArgsDict']]]]] = None,
            ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None) -> 'VnpGatewayNatRule':
        """
        Get an existing VnpGatewayNatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleExternalMappingArgs', 'VnpGatewayNatRuleExternalMappingArgsDict']]]] external_mappings: One of more `external_mapping` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VnpGatewayNatRuleInternalMappingArgs', 'VnpGatewayNatRuleInternalMappingArgsDict']]]] internal_mappings: One of more `internal_mapping` blocks as defined below.
        :param pulumi.Input[builtins.str] ip_configuration_id: The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        :param pulumi.Input[builtins.str] mode: The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VnpGatewayNatRuleState.__new__(_VnpGatewayNatRuleState)

        __props__.__dict__["external_mappings"] = external_mappings
        __props__.__dict__["internal_mappings"] = internal_mappings
        __props__.__dict__["ip_configuration_id"] = ip_configuration_id
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        return VnpGatewayNatRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="externalMappings")
    def external_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.VnpGatewayNatRuleExternalMapping']]]:
        """
        One of more `external_mapping` blocks as defined below.
        """
        return pulumi.get(self, "external_mappings")

    @property
    @pulumi.getter(name="internalMappings")
    def internal_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.VnpGatewayNatRuleInternalMapping']]]:
        """
        One of more `internal_mapping` blocks as defined below.
        """
        return pulumi.get(self, "internal_mappings")

    @property
    @pulumi.getter(name="ipConfigurationId")
    def ip_configuration_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the IP Configuration this VPN Gateway NAT Rule applies to. Possible values are `Instance0` and `Instance1`.
        """
        return pulumi.get(self, "ip_configuration_id")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The source NAT direction of the VPN NAT. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this VPN Gateway NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of the VPN Gateway NAT Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPN Gateway that this VPN Gateway NAT Rule belongs to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vpn_gateway_id")

