# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CollectorPolicyArgs', 'CollectorPolicy']

@pulumi.input_type
class CollectorPolicyArgs:
    def __init__(__self__, *,
                 ipfx_emission: pulumi.Input['CollectorPolicyIpfxEmissionArgs'],
                 ipfx_ingestion: pulumi.Input['CollectorPolicyIpfxIngestionArgs'],
                 traffic_collector_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a CollectorPolicy resource.
        :param pulumi.Input['CollectorPolicyIpfxEmissionArgs'] ipfx_emission: An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input['CollectorPolicyIpfxIngestionArgs'] ipfx_ingestion: An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] traffic_collector_id: Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Network Function Collector Policy.
        """
        pulumi.set(__self__, "ipfx_emission", ipfx_emission)
        pulumi.set(__self__, "ipfx_ingestion", ipfx_ingestion)
        pulumi.set(__self__, "traffic_collector_id", traffic_collector_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ipfxEmission")
    def ipfx_emission(self) -> pulumi.Input['CollectorPolicyIpfxEmissionArgs']:
        """
        An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "ipfx_emission")

    @ipfx_emission.setter
    def ipfx_emission(self, value: pulumi.Input['CollectorPolicyIpfxEmissionArgs']):
        pulumi.set(self, "ipfx_emission", value)

    @property
    @pulumi.getter(name="ipfxIngestion")
    def ipfx_ingestion(self) -> pulumi.Input['CollectorPolicyIpfxIngestionArgs']:
        """
        An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "ipfx_ingestion")

    @ipfx_ingestion.setter
    def ipfx_ingestion(self, value: pulumi.Input['CollectorPolicyIpfxIngestionArgs']):
        pulumi.set(self, "ipfx_ingestion", value)

    @property
    @pulumi.getter(name="trafficCollectorId")
    def traffic_collector_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "traffic_collector_id")

    @traffic_collector_id.setter
    def traffic_collector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "traffic_collector_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Network Function Collector Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CollectorPolicyState:
    def __init__(__self__, *,
                 ipfx_emission: Optional[pulumi.Input['CollectorPolicyIpfxEmissionArgs']] = None,
                 ipfx_ingestion: Optional[pulumi.Input['CollectorPolicyIpfxIngestionArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_collector_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CollectorPolicy resources.
        :param pulumi.Input['CollectorPolicyIpfxEmissionArgs'] ipfx_emission: An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input['CollectorPolicyIpfxIngestionArgs'] ipfx_ingestion: An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Network Function Collector Policy.
        :param pulumi.Input[builtins.str] traffic_collector_id: Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        if ipfx_emission is not None:
            pulumi.set(__self__, "ipfx_emission", ipfx_emission)
        if ipfx_ingestion is not None:
            pulumi.set(__self__, "ipfx_ingestion", ipfx_ingestion)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_collector_id is not None:
            pulumi.set(__self__, "traffic_collector_id", traffic_collector_id)

    @property
    @pulumi.getter(name="ipfxEmission")
    def ipfx_emission(self) -> Optional[pulumi.Input['CollectorPolicyIpfxEmissionArgs']]:
        """
        An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "ipfx_emission")

    @ipfx_emission.setter
    def ipfx_emission(self, value: Optional[pulumi.Input['CollectorPolicyIpfxEmissionArgs']]):
        pulumi.set(self, "ipfx_emission", value)

    @property
    @pulumi.getter(name="ipfxIngestion")
    def ipfx_ingestion(self) -> Optional[pulumi.Input['CollectorPolicyIpfxIngestionArgs']]:
        """
        An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "ipfx_ingestion")

    @ipfx_ingestion.setter
    def ipfx_ingestion(self, value: Optional[pulumi.Input['CollectorPolicyIpfxIngestionArgs']]):
        pulumi.set(self, "ipfx_ingestion", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Network Function Collector Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficCollectorId")
    def traffic_collector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "traffic_collector_id")

    @traffic_collector_id.setter
    def traffic_collector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traffic_collector_id", value)


@pulumi.type_token("azure:networkfunction/collectorPolicy:CollectorPolicy")
class CollectorPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipfx_emission: Optional[pulumi.Input[Union['CollectorPolicyIpfxEmissionArgs', 'CollectorPolicyIpfxEmissionArgsDict']]] = None,
                 ipfx_ingestion: Optional[pulumi.Input[Union['CollectorPolicyIpfxIngestionArgs', 'CollectorPolicyIpfxIngestionArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_collector_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Function Collector Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US 2")
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="example-erp",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Equinix-Seattle-SE2",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="example-erc",
            location=example.location,
            resource_group_name=example.name,
            express_route_port_id=example_express_route_port.id,
            bandwidth_in_gbps=1,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="MicrosoftPeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            peer_asn=100,
            primary_peer_address_prefix="192.168.199.0/30",
            secondary_peer_address_prefix="192.168.200.0/30",
            vlan_id=300,
            microsoft_peering_config={
                "advertised_public_prefixes": ["123.6.0.0/24"],
            })
        example_azure_traffic_collector = azure.networkfunction.AzureTrafficCollector("example",
            name="example-nfatc",
            location=example.location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_express_route_circuit_peering]))
        example_collector_policy = azure.networkfunction.CollectorPolicy("example",
            name="example-nfcp",
            traffic_collector_id=example_azure_traffic_collector.id,
            location=example.location,
            ipfx_emission={
                "destination_types": "AzureMonitor",
            },
            ipfx_ingestion={
                "source_resource_ids": [example_express_route_circuit.id],
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetworkFunction`: 2022-11-01

        ## Import

        Network Function Collector Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:networkfunction/collectorPolicy:CollectorPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.NetworkFunction/azureTrafficCollectors/azureTrafficCollector1/collectorPolicies/collectorPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CollectorPolicyIpfxEmissionArgs', 'CollectorPolicyIpfxEmissionArgsDict']] ipfx_emission: An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[Union['CollectorPolicyIpfxIngestionArgs', 'CollectorPolicyIpfxIngestionArgsDict']] ipfx_ingestion: An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Network Function Collector Policy.
        :param pulumi.Input[builtins.str] traffic_collector_id: Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CollectorPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Function Collector Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US 2")
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="example-erp",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Equinix-Seattle-SE2",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="example-erc",
            location=example.location,
            resource_group_name=example.name,
            express_route_port_id=example_express_route_port.id,
            bandwidth_in_gbps=1,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="MicrosoftPeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            peer_asn=100,
            primary_peer_address_prefix="192.168.199.0/30",
            secondary_peer_address_prefix="192.168.200.0/30",
            vlan_id=300,
            microsoft_peering_config={
                "advertised_public_prefixes": ["123.6.0.0/24"],
            })
        example_azure_traffic_collector = azure.networkfunction.AzureTrafficCollector("example",
            name="example-nfatc",
            location=example.location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_express_route_circuit_peering]))
        example_collector_policy = azure.networkfunction.CollectorPolicy("example",
            name="example-nfcp",
            traffic_collector_id=example_azure_traffic_collector.id,
            location=example.location,
            ipfx_emission={
                "destination_types": "AzureMonitor",
            },
            ipfx_ingestion={
                "source_resource_ids": [example_express_route_circuit.id],
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetworkFunction`: 2022-11-01

        ## Import

        Network Function Collector Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:networkfunction/collectorPolicy:CollectorPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.NetworkFunction/azureTrafficCollectors/azureTrafficCollector1/collectorPolicies/collectorPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param CollectorPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CollectorPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipfx_emission: Optional[pulumi.Input[Union['CollectorPolicyIpfxEmissionArgs', 'CollectorPolicyIpfxEmissionArgsDict']]] = None,
                 ipfx_ingestion: Optional[pulumi.Input[Union['CollectorPolicyIpfxIngestionArgs', 'CollectorPolicyIpfxIngestionArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_collector_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CollectorPolicyArgs.__new__(CollectorPolicyArgs)

            if ipfx_emission is None and not opts.urn:
                raise TypeError("Missing required property 'ipfx_emission'")
            __props__.__dict__["ipfx_emission"] = ipfx_emission
            if ipfx_ingestion is None and not opts.urn:
                raise TypeError("Missing required property 'ipfx_ingestion'")
            __props__.__dict__["ipfx_ingestion"] = ipfx_ingestion
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if traffic_collector_id is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_collector_id'")
            __props__.__dict__["traffic_collector_id"] = traffic_collector_id
        super(CollectorPolicy, __self__).__init__(
            'azure:networkfunction/collectorPolicy:CollectorPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ipfx_emission: Optional[pulumi.Input[Union['CollectorPolicyIpfxEmissionArgs', 'CollectorPolicyIpfxEmissionArgsDict']]] = None,
            ipfx_ingestion: Optional[pulumi.Input[Union['CollectorPolicyIpfxIngestionArgs', 'CollectorPolicyIpfxIngestionArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            traffic_collector_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CollectorPolicy':
        """
        Get an existing CollectorPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CollectorPolicyIpfxEmissionArgs', 'CollectorPolicyIpfxEmissionArgsDict']] ipfx_emission: An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[Union['CollectorPolicyIpfxIngestionArgs', 'CollectorPolicyIpfxIngestionArgsDict']] ipfx_ingestion: An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Network Function Collector Policy.
        :param pulumi.Input[builtins.str] traffic_collector_id: Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CollectorPolicyState.__new__(_CollectorPolicyState)

        __props__.__dict__["ipfx_emission"] = ipfx_emission
        __props__.__dict__["ipfx_ingestion"] = ipfx_ingestion
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["traffic_collector_id"] = traffic_collector_id
        return CollectorPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ipfxEmission")
    def ipfx_emission(self) -> pulumi.Output['outputs.CollectorPolicyIpfxEmission']:
        """
        An `ipfx_emission` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "ipfx_emission")

    @property
    @pulumi.getter(name="ipfxIngestion")
    def ipfx_ingestion(self) -> pulumi.Output['outputs.CollectorPolicyIpfxIngestion']:
        """
        An `ipfx_ingestion` block as defined below. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "ipfx_ingestion")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Network Function Collector Policy should exist. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Network Function Collector Policy.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficCollectorId")
    def traffic_collector_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Traffic Collector ID of the Network Function Collector Policy. Changing this forces a new Network Function Collector Policy to be created.
        """
        return pulumi.get(self, "traffic_collector_id")

