# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'MonitorIdentity',
    'MonitorPlan',
    'MonitorUser',
    'TagRuleLogTagFilter',
    'TagRuleMetricTagFilter',
]

@pulumi.output_type
class MonitorIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the identity type of the Azure Native New Relic Monitor. The only possible value is `SystemAssigned`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this Azure Native New Relic Monitor.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this Azure Native New Relic Monitor.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the identity type of the Azure Native New Relic Monitor. The only possible value is `SystemAssigned`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Identity of this Azure Native New Relic Monitor.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this Azure Native New Relic Monitor.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class MonitorPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveDate":
            suggest = "effective_date"
        elif key == "billingCycle":
            suggest = "billing_cycle"
        elif key == "planId":
            suggest = "plan_id"
        elif key == "usageType":
            suggest = "usage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_date: builtins.str,
                 billing_cycle: Optional[builtins.str] = None,
                 plan_id: Optional[builtins.str] = None,
                 usage_type: Optional[builtins.str] = None):
        """
        :param builtins.str effective_date: Specifies the date when plan was applied. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str billing_cycle: Specifies the billing cycles. Possible values are `MONTHLY`, `WEEKLY` and `YEARLY`. Defaults to `MONTHLY`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str plan_id: Specifies the plan id published by NewRelic. The only possible value is `newrelic-pay-as-you-go-free-live`. Defaults to `newrelic-pay-as-you-go-free-live`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str usage_type: Specifies the usage type. Possible values are `COMMITTED` and `PAYG`. Defaults to `PAYG`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        pulumi.set(__self__, "effective_date", effective_date)
        if billing_cycle is not None:
            pulumi.set(__self__, "billing_cycle", billing_cycle)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if usage_type is not None:
            pulumi.set(__self__, "usage_type", usage_type)

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> builtins.str:
        """
        Specifies the date when plan was applied. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> Optional[builtins.str]:
        """
        Specifies the billing cycles. Possible values are `MONTHLY`, `WEEKLY` and `YEARLY`. Defaults to `MONTHLY`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[builtins.str]:
        """
        Specifies the plan id published by NewRelic. The only possible value is `newrelic-pay-as-you-go-free-live`. Defaults to `newrelic-pay-as-you-go-free-live`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> Optional[builtins.str]:
        """
        Specifies the usage type. Possible values are `COMMITTED` and `PAYG`. Defaults to `PAYG`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "usage_type")


@pulumi.output_type
class MonitorUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 first_name: builtins.str,
                 last_name: builtins.str,
                 phone_number: builtins.str):
        """
        :param builtins.str email: Specifies the user Email. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str first_name: Specifies the first name. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str last_name: Specifies the last name. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param builtins.str phone_number: Specifies the contact phone number. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Specifies the user Email. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        Specifies the first name. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Specifies the last name. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Specifies the contact phone number. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class TagRuleLogTagFilter(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str action: Valid actions for a filtering tag. Possible values are `Exclude` and `Include`. Exclusion takes priority over inclusion.
        :param builtins.str name: Specifies the name (also known as the key) of the tag.
        :param builtins.str value: Specifies the value of the tag.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Valid actions for a filtering tag. Possible values are `Exclude` and `Include`. Exclusion takes priority over inclusion.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name (also known as the key) of the tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Specifies the value of the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TagRuleMetricTagFilter(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str action: Valid actions for a filtering tag. Possible values are `Exclude` and `Include`. Exclusion takes priority over inclusion.
        :param builtins.str name: Specifies the name (also known as the key) of the tag.
        :param builtins.str value: Specifies the value of the tag.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Valid actions for a filtering tag. Possible values are `Exclude` and `Include`. Exclusion takes priority over inclusion.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name (also known as the key) of the tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Specifies the value of the tag.
        """
        return pulumi.get(self, "value")


