# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConfigurationConfigFileArgs',
    'ConfigurationConfigFileArgsDict',
    'ConfigurationProtectedFileArgs',
    'ConfigurationProtectedFileArgsDict',
    'DeploymentAutoScaleProfileArgs',
    'DeploymentAutoScaleProfileArgsDict',
    'DeploymentFrontendPrivateArgs',
    'DeploymentFrontendPrivateArgsDict',
    'DeploymentFrontendPublicArgs',
    'DeploymentFrontendPublicArgsDict',
    'DeploymentIdentityArgs',
    'DeploymentIdentityArgsDict',
    'DeploymentLoggingStorageAccountArgs',
    'DeploymentLoggingStorageAccountArgsDict',
    'DeploymentNetworkInterfaceArgs',
    'DeploymentNetworkInterfaceArgsDict',
    'DeploymentWebApplicationFirewallArgs',
    'DeploymentWebApplicationFirewallArgsDict',
    'DeploymentWebApplicationFirewallStatusArgs',
    'DeploymentWebApplicationFirewallStatusArgsDict',
    'DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs',
    'DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgsDict',
    'DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs',
    'DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgsDict',
    'DeploymentWebApplicationFirewallStatusComponentVersionArgs',
    'DeploymentWebApplicationFirewallStatusComponentVersionArgsDict',
    'DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs',
    'DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgsDict',
]

MYPY = False

if not MYPY:
    class ConfigurationConfigFileArgsDict(TypedDict):
        content: pulumi.Input[builtins.str]
        """
        Specifies the base-64 encoded contents of this config file.
        """
        virtual_path: pulumi.Input[builtins.str]
        """
        Specifies the path of this config file.
        """
elif False:
    ConfigurationConfigFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationConfigFileArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[builtins.str],
                 virtual_path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] content: Specifies the base-64 encoded contents of this config file.
        :param pulumi.Input[builtins.str] virtual_path: Specifies the path of this config file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the base-64 encoded contents of this config file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the path of this config file.
        """
        return pulumi.get(self, "virtual_path")

    @virtual_path.setter
    def virtual_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_path", value)


if not MYPY:
    class ConfigurationProtectedFileArgsDict(TypedDict):
        content: pulumi.Input[builtins.str]
        """
        Specifies the base-64 encoded contents of this config file (Sensitive).
        """
        virtual_path: pulumi.Input[builtins.str]
        """
        Specifies the path of this config file.
        """
        content_hash: NotRequired[pulumi.Input[builtins.str]]
        """
        The hash of the contents of this configuration file prefixed by the algorithm used.
        """
elif False:
    ConfigurationProtectedFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationProtectedFileArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[builtins.str],
                 virtual_path: pulumi.Input[builtins.str],
                 content_hash: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] content: Specifies the base-64 encoded contents of this config file (Sensitive).
        :param pulumi.Input[builtins.str] virtual_path: Specifies the path of this config file.
        :param pulumi.Input[builtins.str] content_hash: The hash of the contents of this configuration file prefixed by the algorithm used.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "virtual_path", virtual_path)
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the base-64 encoded contents of this config file (Sensitive).
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the path of this config file.
        """
        return pulumi.get(self, "virtual_path")

    @virtual_path.setter
    def virtual_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_path", value)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hash of the contents of this configuration file prefixed by the algorithm used.
        """
        return pulumi.get(self, "content_hash")

    @content_hash.setter
    def content_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_hash", value)


if not MYPY:
    class DeploymentAutoScaleProfileArgsDict(TypedDict):
        max_capacity: pulumi.Input[builtins.int]
        min_capacity: pulumi.Input[builtins.int]
        """
        Specify the minimum number of NGINX capacity units for this NGINX Deployment.
        """
        name: pulumi.Input[builtins.str]
        """
        Specify the name of the autoscaling profile.
        """
elif False:
    DeploymentAutoScaleProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentAutoScaleProfileArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[builtins.int],
                 min_capacity: pulumi.Input[builtins.int],
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.int] min_capacity: Specify the minimum number of NGINX capacity units for this NGINX Deployment.
        :param pulumi.Input[builtins.str] name: Specify the name of the autoscaling profile.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[builtins.int]:
        """
        Specify the minimum number of NGINX capacity units for this NGINX Deployment.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Specify the name of the autoscaling profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DeploymentFrontendPrivateArgsDict(TypedDict):
        allocation_method: pulumi.Input[builtins.str]
        """
        Specify the method for allocating the private IP. Possible values are `Static` and `Dynamic`.
        """
        ip_address: pulumi.Input[builtins.str]
        """
        Specify the private IP Address.
        """
        subnet_id: pulumi.Input[builtins.str]
        """
        Specify the Subnet Resource ID for this NGINX Deployment.
        """
elif False:
    DeploymentFrontendPrivateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentFrontendPrivateArgs:
    def __init__(__self__, *,
                 allocation_method: pulumi.Input[builtins.str],
                 ip_address: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] allocation_method: Specify the method for allocating the private IP. Possible values are `Static` and `Dynamic`.
        :param pulumi.Input[builtins.str] ip_address: Specify the private IP Address.
        :param pulumi.Input[builtins.str] subnet_id: Specify the Subnet Resource ID for this NGINX Deployment.
        """
        pulumi.set(__self__, "allocation_method", allocation_method)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> pulumi.Input[builtins.str]:
        """
        Specify the method for allocating the private IP. Possible values are `Static` and `Dynamic`.
        """
        return pulumi.get(self, "allocation_method")

    @allocation_method.setter
    def allocation_method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "allocation_method", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[builtins.str]:
        """
        Specify the private IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        Specify the Subnet Resource ID for this NGINX Deployment.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class DeploymentFrontendPublicArgsDict(TypedDict):
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of Public IP Resource ID to this NGINX Deployment.
        """
elif False:
    DeploymentFrontendPublicArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentFrontendPublicArgs:
    def __init__(__self__, *,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_addresses: Specifies a list of Public IP Resource ID to this NGINX Deployment.
        """
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Public IP Resource ID to this NGINX Deployment.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)


if not MYPY:
    class DeploymentIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the identity type of the NGINX Deployment. Possible values are `SystemAssigned`, `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of user managed identity ids to be assigned.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DeploymentIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the identity type of the NGINX Deployment. Possible values are `SystemAssigned`, `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of user managed identity ids to be assigned.
               
               > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the identity type of the NGINX Deployment. Possible values are `SystemAssigned`, `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of user managed identity ids to be assigned.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class DeploymentLoggingStorageAccountArgsDict(TypedDict):
        container_name: NotRequired[pulumi.Input[builtins.str]]
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
elif False:
    DeploymentLoggingStorageAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentLoggingStorageAccountArgs:
    def __init__(__self__, *,
                 container_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DeploymentNetworkInterfaceArgsDict(TypedDict):
        subnet_id: pulumi.Input[builtins.str]
        """
        Specify The Subnet Resource ID for this NGINX Deployment.
        """
elif False:
    DeploymentNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentNetworkInterfaceArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] subnet_id: Specify The Subnet Resource ID for this NGINX Deployment.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        Specify The Subnet Resource ID for this NGINX Deployment.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class DeploymentWebApplicationFirewallArgsDict(TypedDict):
        activation_state_enabled: pulumi.Input[builtins.bool]
        """
        Whether WAF is enabled/disabled for this NGINX Deployment.
        """
        statuses: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusArgsDict']]]]
        """
        A `web_application_firewall.status` block as defined below:
        """
elif False:
    DeploymentWebApplicationFirewallArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentWebApplicationFirewallArgs:
    def __init__(__self__, *,
                 activation_state_enabled: pulumi.Input[builtins.bool],
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusArgs']]]] = None):
        """
        :param pulumi.Input[builtins.bool] activation_state_enabled: Whether WAF is enabled/disabled for this NGINX Deployment.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusArgs']]] statuses: A `web_application_firewall.status` block as defined below:
        """
        pulumi.set(__self__, "activation_state_enabled", activation_state_enabled)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="activationStateEnabled")
    def activation_state_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether WAF is enabled/disabled for this NGINX Deployment.
        """
        return pulumi.get(self, "activation_state_enabled")

    @activation_state_enabled.setter
    def activation_state_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "activation_state_enabled", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusArgs']]]]:
        """
        A `web_application_firewall.status` block as defined below:
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusArgs']]]]):
        pulumi.set(self, "statuses", value)


if not MYPY:
    class DeploymentWebApplicationFirewallStatusArgsDict(TypedDict):
        attack_signatures_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgsDict']]]]
        """
        Indicates the version of the attack signatures package used by NGINX App Protect.
        """
        bot_signatures_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgsDict']]]]
        """
        Indicates the version of the bot signatures package used by NGINX App Protect.
        """
        component_versions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusComponentVersionArgsDict']]]]
        """
        Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        """
        threat_campaigns_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgsDict']]]]
        """
        Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
elif False:
    DeploymentWebApplicationFirewallStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentWebApplicationFirewallStatusArgs:
    def __init__(__self__, *,
                 attack_signatures_packages: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs']]]] = None,
                 bot_signatures_packages: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs']]]] = None,
                 component_versions: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusComponentVersionArgs']]]] = None,
                 threat_campaigns_packages: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs']]] attack_signatures_packages: Indicates the version of the attack signatures package used by NGINX App Protect.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs']]] bot_signatures_packages: Indicates the version of the bot signatures package used by NGINX App Protect.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusComponentVersionArgs']]] component_versions: Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs']]] threat_campaigns_packages: Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
        if attack_signatures_packages is not None:
            pulumi.set(__self__, "attack_signatures_packages", attack_signatures_packages)
        if bot_signatures_packages is not None:
            pulumi.set(__self__, "bot_signatures_packages", bot_signatures_packages)
        if component_versions is not None:
            pulumi.set(__self__, "component_versions", component_versions)
        if threat_campaigns_packages is not None:
            pulumi.set(__self__, "threat_campaigns_packages", threat_campaigns_packages)

    @property
    @pulumi.getter(name="attackSignaturesPackages")
    def attack_signatures_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs']]]]:
        """
        Indicates the version of the attack signatures package used by NGINX App Protect.
        """
        return pulumi.get(self, "attack_signatures_packages")

    @attack_signatures_packages.setter
    def attack_signatures_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs']]]]):
        pulumi.set(self, "attack_signatures_packages", value)

    @property
    @pulumi.getter(name="botSignaturesPackages")
    def bot_signatures_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs']]]]:
        """
        Indicates the version of the bot signatures package used by NGINX App Protect.
        """
        return pulumi.get(self, "bot_signatures_packages")

    @bot_signatures_packages.setter
    def bot_signatures_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs']]]]):
        pulumi.set(self, "bot_signatures_packages", value)

    @property
    @pulumi.getter(name="componentVersions")
    def component_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusComponentVersionArgs']]]]:
        """
        Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        """
        return pulumi.get(self, "component_versions")

    @component_versions.setter
    def component_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusComponentVersionArgs']]]]):
        pulumi.set(self, "component_versions", value)

    @property
    @pulumi.getter(name="threatCampaignsPackages")
    def threat_campaigns_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs']]]]:
        """
        Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
        return pulumi.get(self, "threat_campaigns_packages")

    @threat_campaigns_packages.setter
    def threat_campaigns_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs']]]]):
        pulumi.set(self, "threat_campaigns_packages", value)


if not MYPY:
    class DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgsDict(TypedDict):
        revision_datetime: NotRequired[pulumi.Input[builtins.str]]
        version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs:
    def __init__(__self__, *,
                 revision_datetime: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        if revision_datetime is not None:
            pulumi.set(__self__, "revision_datetime", revision_datetime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "revision_datetime")

    @revision_datetime.setter
    def revision_datetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_datetime", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgsDict(TypedDict):
        revision_datetime: NotRequired[pulumi.Input[builtins.str]]
        version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs:
    def __init__(__self__, *,
                 revision_datetime: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        if revision_datetime is not None:
            pulumi.set(__self__, "revision_datetime", revision_datetime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "revision_datetime")

    @revision_datetime.setter
    def revision_datetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_datetime", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class DeploymentWebApplicationFirewallStatusComponentVersionArgsDict(TypedDict):
        waf_engine_version: NotRequired[pulumi.Input[builtins.str]]
        waf_nginx_version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DeploymentWebApplicationFirewallStatusComponentVersionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentWebApplicationFirewallStatusComponentVersionArgs:
    def __init__(__self__, *,
                 waf_engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 waf_nginx_version: Optional[pulumi.Input[builtins.str]] = None):
        if waf_engine_version is not None:
            pulumi.set(__self__, "waf_engine_version", waf_engine_version)
        if waf_nginx_version is not None:
            pulumi.set(__self__, "waf_nginx_version", waf_nginx_version)

    @property
    @pulumi.getter(name="wafEngineVersion")
    def waf_engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "waf_engine_version")

    @waf_engine_version.setter
    def waf_engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waf_engine_version", value)

    @property
    @pulumi.getter(name="wafNginxVersion")
    def waf_nginx_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "waf_nginx_version")

    @waf_nginx_version.setter
    def waf_nginx_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waf_nginx_version", value)


if not MYPY:
    class DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgsDict(TypedDict):
        revision_datetime: NotRequired[pulumi.Input[builtins.str]]
        version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs:
    def __init__(__self__, *,
                 revision_datetime: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        if revision_datetime is not None:
            pulumi.set(__self__, "revision_datetime", revision_datetime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "revision_datetime")

    @revision_datetime.setter
    def revision_datetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_datetime", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


