# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigurationConfigFile',
    'ConfigurationProtectedFile',
    'DeploymentAutoScaleProfile',
    'DeploymentFrontendPrivate',
    'DeploymentFrontendPublic',
    'DeploymentIdentity',
    'DeploymentLoggingStorageAccount',
    'DeploymentNetworkInterface',
    'DeploymentWebApplicationFirewall',
    'DeploymentWebApplicationFirewallStatus',
    'DeploymentWebApplicationFirewallStatusAttackSignaturesPackage',
    'DeploymentWebApplicationFirewallStatusBotSignaturesPackage',
    'DeploymentWebApplicationFirewallStatusComponentVersion',
    'DeploymentWebApplicationFirewallStatusThreatCampaignsPackage',
    'GetConfigurationConfigFileResult',
    'GetConfigurationProtectedFileResult',
    'GetDeploymentAutoScaleProfileResult',
    'GetDeploymentFrontendPrivateResult',
    'GetDeploymentFrontendPublicResult',
    'GetDeploymentIdentityResult',
    'GetDeploymentLoggingStorageAccountResult',
    'GetDeploymentNetworkInterfaceResult',
    'GetDeploymentWebApplicationFirewallResult',
    'GetDeploymentWebApplicationFirewallStatusResult',
    'GetDeploymentWebApplicationFirewallStatusAttackSignaturesPackageResult',
    'GetDeploymentWebApplicationFirewallStatusBotSignaturesPackageResult',
    'GetDeploymentWebApplicationFirewallStatusComponentVersionResult',
    'GetDeploymentWebApplicationFirewallStatusThreatCampaignsPackageResult',
]

@pulumi.output_type
class ConfigurationConfigFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualPath":
            suggest = "virtual_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationConfigFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationConfigFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationConfigFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 virtual_path: builtins.str):
        """
        :param builtins.str content: Specifies the base-64 encoded contents of this config file.
        :param builtins.str virtual_path: Specifies the path of this config file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Specifies the base-64 encoded contents of this config file.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> builtins.str:
        """
        Specifies the path of this config file.
        """
        return pulumi.get(self, "virtual_path")


@pulumi.output_type
class ConfigurationProtectedFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualPath":
            suggest = "virtual_path"
        elif key == "contentHash":
            suggest = "content_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationProtectedFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationProtectedFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationProtectedFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 virtual_path: builtins.str,
                 content_hash: Optional[builtins.str] = None):
        """
        :param builtins.str content: Specifies the base-64 encoded contents of this config file (Sensitive).
        :param builtins.str virtual_path: Specifies the path of this config file.
        :param builtins.str content_hash: The hash of the contents of this configuration file prefixed by the algorithm used.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "virtual_path", virtual_path)
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Specifies the base-64 encoded contents of this config file (Sensitive).
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> builtins.str:
        """
        Specifies the path of this config file.
        """
        return pulumi.get(self, "virtual_path")

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional[builtins.str]:
        """
        The hash of the contents of this configuration file prefixed by the algorithm used.
        """
        return pulumi.get(self, "content_hash")


@pulumi.output_type
class DeploymentAutoScaleProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentAutoScaleProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentAutoScaleProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentAutoScaleProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: builtins.int,
                 min_capacity: builtins.int,
                 name: builtins.str):
        """
        :param builtins.int min_capacity: Specify the minimum number of NGINX capacity units for this NGINX Deployment.
        :param builtins.str name: Specify the name of the autoscaling profile.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> builtins.int:
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> builtins.int:
        """
        Specify the minimum number of NGINX capacity units for this NGINX Deployment.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specify the name of the autoscaling profile.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeploymentFrontendPrivate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationMethod":
            suggest = "allocation_method"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentFrontendPrivate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentFrontendPrivate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentFrontendPrivate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_method: builtins.str,
                 ip_address: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.str allocation_method: Specify the method for allocating the private IP. Possible values are `Static` and `Dynamic`.
        :param builtins.str ip_address: Specify the private IP Address.
        :param builtins.str subnet_id: Specify the Subnet Resource ID for this NGINX Deployment.
        """
        pulumi.set(__self__, "allocation_method", allocation_method)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> builtins.str:
        """
        Specify the method for allocating the private IP. Possible values are `Static` and `Dynamic`.
        """
        return pulumi.get(self, "allocation_method")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        Specify the private IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Specify the Subnet Resource ID for this NGINX Deployment.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class DeploymentFrontendPublic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentFrontendPublic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentFrontendPublic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentFrontendPublic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_addresses: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] ip_addresses: Specifies a list of Public IP Resource ID to this NGINX Deployment.
        """
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of Public IP Resource ID to this NGINX Deployment.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class DeploymentIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the identity type of the NGINX Deployment. Possible values are `SystemAssigned`, `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of user managed identity ids to be assigned.
               
               > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the identity type of the NGINX Deployment. Possible values are `SystemAssigned`, `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of user managed identity ids to be assigned.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DeploymentLoggingStorageAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentLoggingStorageAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentLoggingStorageAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentLoggingStorageAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeploymentNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str):
        """
        :param builtins.str subnet_id: Specify The Subnet Resource ID for this NGINX Deployment.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Specify The Subnet Resource ID for this NGINX Deployment.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class DeploymentWebApplicationFirewall(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationStateEnabled":
            suggest = "activation_state_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWebApplicationFirewall. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWebApplicationFirewall.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWebApplicationFirewall.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_state_enabled: builtins.bool,
                 statuses: Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatus']] = None):
        """
        :param builtins.bool activation_state_enabled: Whether WAF is enabled/disabled for this NGINX Deployment.
        :param Sequence['DeploymentWebApplicationFirewallStatusArgs'] statuses: A `web_application_firewall.status` block as defined below:
        """
        pulumi.set(__self__, "activation_state_enabled", activation_state_enabled)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="activationStateEnabled")
    def activation_state_enabled(self) -> builtins.bool:
        """
        Whether WAF is enabled/disabled for this NGINX Deployment.
        """
        return pulumi.get(self, "activation_state_enabled")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatus']]:
        """
        A `web_application_firewall.status` block as defined below:
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class DeploymentWebApplicationFirewallStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attackSignaturesPackages":
            suggest = "attack_signatures_packages"
        elif key == "botSignaturesPackages":
            suggest = "bot_signatures_packages"
        elif key == "componentVersions":
            suggest = "component_versions"
        elif key == "threatCampaignsPackages":
            suggest = "threat_campaigns_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWebApplicationFirewallStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWebApplicationFirewallStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWebApplicationFirewallStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attack_signatures_packages: Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusAttackSignaturesPackage']] = None,
                 bot_signatures_packages: Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusBotSignaturesPackage']] = None,
                 component_versions: Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusComponentVersion']] = None,
                 threat_campaigns_packages: Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusThreatCampaignsPackage']] = None):
        """
        :param Sequence['DeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs'] attack_signatures_packages: Indicates the version of the attack signatures package used by NGINX App Protect.
        :param Sequence['DeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs'] bot_signatures_packages: Indicates the version of the bot signatures package used by NGINX App Protect.
        :param Sequence['DeploymentWebApplicationFirewallStatusComponentVersionArgs'] component_versions: Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        :param Sequence['DeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs'] threat_campaigns_packages: Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
        if attack_signatures_packages is not None:
            pulumi.set(__self__, "attack_signatures_packages", attack_signatures_packages)
        if bot_signatures_packages is not None:
            pulumi.set(__self__, "bot_signatures_packages", bot_signatures_packages)
        if component_versions is not None:
            pulumi.set(__self__, "component_versions", component_versions)
        if threat_campaigns_packages is not None:
            pulumi.set(__self__, "threat_campaigns_packages", threat_campaigns_packages)

    @property
    @pulumi.getter(name="attackSignaturesPackages")
    def attack_signatures_packages(self) -> Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusAttackSignaturesPackage']]:
        """
        Indicates the version of the attack signatures package used by NGINX App Protect.
        """
        return pulumi.get(self, "attack_signatures_packages")

    @property
    @pulumi.getter(name="botSignaturesPackages")
    def bot_signatures_packages(self) -> Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusBotSignaturesPackage']]:
        """
        Indicates the version of the bot signatures package used by NGINX App Protect.
        """
        return pulumi.get(self, "bot_signatures_packages")

    @property
    @pulumi.getter(name="componentVersions")
    def component_versions(self) -> Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusComponentVersion']]:
        """
        Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        """
        return pulumi.get(self, "component_versions")

    @property
    @pulumi.getter(name="threatCampaignsPackages")
    def threat_campaigns_packages(self) -> Optional[Sequence['outputs.DeploymentWebApplicationFirewallStatusThreatCampaignsPackage']]:
        """
        Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
        return pulumi.get(self, "threat_campaigns_packages")


@pulumi.output_type
class DeploymentWebApplicationFirewallStatusAttackSignaturesPackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionDatetime":
            suggest = "revision_datetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWebApplicationFirewallStatusAttackSignaturesPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWebApplicationFirewallStatusAttackSignaturesPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWebApplicationFirewallStatusAttackSignaturesPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_datetime: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        if revision_datetime is not None:
            pulumi.set(__self__, "revision_datetime", revision_datetime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> Optional[builtins.str]:
        return pulumi.get(self, "revision_datetime")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class DeploymentWebApplicationFirewallStatusBotSignaturesPackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionDatetime":
            suggest = "revision_datetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWebApplicationFirewallStatusBotSignaturesPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWebApplicationFirewallStatusBotSignaturesPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWebApplicationFirewallStatusBotSignaturesPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_datetime: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        if revision_datetime is not None:
            pulumi.set(__self__, "revision_datetime", revision_datetime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> Optional[builtins.str]:
        return pulumi.get(self, "revision_datetime")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class DeploymentWebApplicationFirewallStatusComponentVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "wafEngineVersion":
            suggest = "waf_engine_version"
        elif key == "wafNginxVersion":
            suggest = "waf_nginx_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWebApplicationFirewallStatusComponentVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWebApplicationFirewallStatusComponentVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWebApplicationFirewallStatusComponentVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 waf_engine_version: Optional[builtins.str] = None,
                 waf_nginx_version: Optional[builtins.str] = None):
        if waf_engine_version is not None:
            pulumi.set(__self__, "waf_engine_version", waf_engine_version)
        if waf_nginx_version is not None:
            pulumi.set(__self__, "waf_nginx_version", waf_nginx_version)

    @property
    @pulumi.getter(name="wafEngineVersion")
    def waf_engine_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "waf_engine_version")

    @property
    @pulumi.getter(name="wafNginxVersion")
    def waf_nginx_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "waf_nginx_version")


@pulumi.output_type
class DeploymentWebApplicationFirewallStatusThreatCampaignsPackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionDatetime":
            suggest = "revision_datetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWebApplicationFirewallStatusThreatCampaignsPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWebApplicationFirewallStatusThreatCampaignsPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWebApplicationFirewallStatusThreatCampaignsPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_datetime: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        if revision_datetime is not None:
            pulumi.set(__self__, "revision_datetime", revision_datetime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> Optional[builtins.str]:
        return pulumi.get(self, "revision_datetime")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetConfigurationConfigFileResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 virtual_path: builtins.str):
        """
        :param builtins.str content: The base-64 encoded contents of this configuration file.
        :param builtins.str virtual_path: The path of this configuration file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The base-64 encoded contents of this configuration file.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> builtins.str:
        """
        The path of this configuration file.
        """
        return pulumi.get(self, "virtual_path")


@pulumi.output_type
class GetConfigurationProtectedFileResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 content_hash: builtins.str,
                 virtual_path: builtins.str):
        """
        :param builtins.str content: The base-64 encoded contents of this configuration file.
        :param builtins.str content_hash: The hash of the contents of this configuration file prefixed by the algorithm used.
        :param builtins.str virtual_path: The path of this configuration file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_hash", content_hash)
        pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter
    @_utilities.deprecated("""the `content` property is deprecated and will be removed in v5.0 of the AzureRM Provider.""")
    def content(self) -> builtins.str:
        """
        The base-64 encoded contents of this configuration file.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> builtins.str:
        """
        The hash of the contents of this configuration file prefixed by the algorithm used.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> builtins.str:
        """
        The path of this configuration file.
        """
        return pulumi.get(self, "virtual_path")


@pulumi.output_type
class GetDeploymentAutoScaleProfileResult(dict):
    def __init__(__self__, *,
                 max_capacity: builtins.int,
                 min_capacity: builtins.int,
                 name: builtins.str):
        """
        :param builtins.int max_capacity: The maximum number of NGINX capacity units for this NGINX Deployment.
        :param builtins.int min_capacity: The minimum number of NGINX capacity units for this NGINX Deployment.
        :param builtins.str name: The name of this NGINX Deployment.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> builtins.int:
        """
        The maximum number of NGINX capacity units for this NGINX Deployment.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> builtins.int:
        """
        The minimum number of NGINX capacity units for this NGINX Deployment.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this NGINX Deployment.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDeploymentFrontendPrivateResult(dict):
    def __init__(__self__, *,
                 allocation_method: builtins.str,
                 ip_address: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.str allocation_method: The method of allocating the private IP to the NGINX Deployment.
        :param builtins.str ip_address: The list of Public IP Resource IDs for this NGINX Deployment.
        :param builtins.str subnet_id: The subnet resource ID of the NGINX Deployment.
        """
        pulumi.set(__self__, "allocation_method", allocation_method)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> builtins.str:
        """
        The method of allocating the private IP to the NGINX Deployment.
        """
        return pulumi.get(self, "allocation_method")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The list of Public IP Resource IDs for this NGINX Deployment.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The subnet resource ID of the NGINX Deployment.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDeploymentFrontendPublicResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] ip_addresses: The list of Public IP Resource IDs for this NGINX Deployment.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[builtins.str]:
        """
        The list of Public IP Resource IDs for this NGINX Deployment.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetDeploymentIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: List of identities attached to the NGINX Deployment.
        :param builtins.str type: Type of identity attached to the NGINX Deployment.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        List of identities attached to the NGINX Deployment.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of identity attached to the NGINX Deployment.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDeploymentLoggingStorageAccountResult(dict):
    def __init__(__self__, *,
                 container_name: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str name: The name of this NGINX Deployment.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this NGINX Deployment.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDeploymentNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 subnet_id: builtins.str):
        """
        :param builtins.str subnet_id: The subnet resource ID of the NGINX Deployment.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The subnet resource ID of the NGINX Deployment.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDeploymentWebApplicationFirewallResult(dict):
    def __init__(__self__, *,
                 activation_state_enabled: builtins.bool,
                 statuses: Sequence['outputs.GetDeploymentWebApplicationFirewallStatusResult']):
        """
        :param builtins.bool activation_state_enabled: Whether WAF is enabled/disabled for this NGINX Deployment.
        :param Sequence['GetDeploymentWebApplicationFirewallStatusArgs'] statuses: A `status` block as defined below.
        """
        pulumi.set(__self__, "activation_state_enabled", activation_state_enabled)
        pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="activationStateEnabled")
    def activation_state_enabled(self) -> builtins.bool:
        """
        Whether WAF is enabled/disabled for this NGINX Deployment.
        """
        return pulumi.get(self, "activation_state_enabled")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence['outputs.GetDeploymentWebApplicationFirewallStatusResult']:
        """
        A `status` block as defined below.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class GetDeploymentWebApplicationFirewallStatusResult(dict):
    def __init__(__self__, *,
                 attack_signatures_packages: Sequence['outputs.GetDeploymentWebApplicationFirewallStatusAttackSignaturesPackageResult'],
                 bot_signatures_packages: Sequence['outputs.GetDeploymentWebApplicationFirewallStatusBotSignaturesPackageResult'],
                 component_versions: Sequence['outputs.GetDeploymentWebApplicationFirewallStatusComponentVersionResult'],
                 threat_campaigns_packages: Sequence['outputs.GetDeploymentWebApplicationFirewallStatusThreatCampaignsPackageResult']):
        """
        :param Sequence['GetDeploymentWebApplicationFirewallStatusAttackSignaturesPackageArgs'] attack_signatures_packages: Indicates the version of the attack signatures package used by NGINX App Protect.
        :param Sequence['GetDeploymentWebApplicationFirewallStatusBotSignaturesPackageArgs'] bot_signatures_packages: Indicates the version of the bot signatures package used by NGINX App Protect.
        :param Sequence['GetDeploymentWebApplicationFirewallStatusComponentVersionArgs'] component_versions: Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        :param Sequence['GetDeploymentWebApplicationFirewallStatusThreatCampaignsPackageArgs'] threat_campaigns_packages: Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
        pulumi.set(__self__, "attack_signatures_packages", attack_signatures_packages)
        pulumi.set(__self__, "bot_signatures_packages", bot_signatures_packages)
        pulumi.set(__self__, "component_versions", component_versions)
        pulumi.set(__self__, "threat_campaigns_packages", threat_campaigns_packages)

    @property
    @pulumi.getter(name="attackSignaturesPackages")
    def attack_signatures_packages(self) -> Sequence['outputs.GetDeploymentWebApplicationFirewallStatusAttackSignaturesPackageResult']:
        """
        Indicates the version of the attack signatures package used by NGINX App Protect.
        """
        return pulumi.get(self, "attack_signatures_packages")

    @property
    @pulumi.getter(name="botSignaturesPackages")
    def bot_signatures_packages(self) -> Sequence['outputs.GetDeploymentWebApplicationFirewallStatusBotSignaturesPackageResult']:
        """
        Indicates the version of the bot signatures package used by NGINX App Protect.
        """
        return pulumi.get(self, "bot_signatures_packages")

    @property
    @pulumi.getter(name="componentVersions")
    def component_versions(self) -> Sequence['outputs.GetDeploymentWebApplicationFirewallStatusComponentVersionResult']:
        """
        Indicates the version of the WAF Engine and Nginx WAF Module used by NGINX App Protect.
        """
        return pulumi.get(self, "component_versions")

    @property
    @pulumi.getter(name="threatCampaignsPackages")
    def threat_campaigns_packages(self) -> Sequence['outputs.GetDeploymentWebApplicationFirewallStatusThreatCampaignsPackageResult']:
        """
        Indicates the version of the threat campaigns package used by NGINX App Protect.
        """
        return pulumi.get(self, "threat_campaigns_packages")


@pulumi.output_type
class GetDeploymentWebApplicationFirewallStatusAttackSignaturesPackageResult(dict):
    def __init__(__self__, *,
                 revision_datetime: builtins.str,
                 version: builtins.str):
        pulumi.set(__self__, "revision_datetime", revision_datetime)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> builtins.str:
        return pulumi.get(self, "revision_datetime")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentWebApplicationFirewallStatusBotSignaturesPackageResult(dict):
    def __init__(__self__, *,
                 revision_datetime: builtins.str,
                 version: builtins.str):
        pulumi.set(__self__, "revision_datetime", revision_datetime)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> builtins.str:
        return pulumi.get(self, "revision_datetime")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentWebApplicationFirewallStatusComponentVersionResult(dict):
    def __init__(__self__, *,
                 waf_engine_version: builtins.str,
                 waf_nginx_version: builtins.str):
        pulumi.set(__self__, "waf_engine_version", waf_engine_version)
        pulumi.set(__self__, "waf_nginx_version", waf_nginx_version)

    @property
    @pulumi.getter(name="wafEngineVersion")
    def waf_engine_version(self) -> builtins.str:
        return pulumi.get(self, "waf_engine_version")

    @property
    @pulumi.getter(name="wafNginxVersion")
    def waf_nginx_version(self) -> builtins.str:
        return pulumi.get(self, "waf_nginx_version")


@pulumi.output_type
class GetDeploymentWebApplicationFirewallStatusThreatCampaignsPackageResult(dict):
    def __init__(__self__, *,
                 revision_datetime: builtins.str,
                 version: builtins.str):
        pulumi.set(__self__, "revision_datetime", revision_datetime)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="revisionDatetime")
    def revision_datetime(self) -> builtins.str:
        return pulumi.get(self, "revision_datetime")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


