# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthorizationRuleArgs', 'AuthorizationRule']

@pulumi.input_type
class AuthorizationRuleArgs:
    def __init__(__self__, *,
                 namespace_name: pulumi.Input[builtins.str],
                 notification_hub_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 listen: Optional[pulumi.Input[builtins.bool]] = None,
                 manage: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 send: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a AuthorizationRule resource.
        :param pulumi.Input[builtins.str] namespace_name: The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] notification_hub_name: The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] listen: Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        :param pulumi.Input[builtins.bool] manage: Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.
               
               > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        :param pulumi.Input[builtins.str] name: The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] send: Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "notification_hub_name", notification_hub_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if listen is not None:
            pulumi.set(__self__, "listen", listen)
        if manage is not None:
            pulumi.set(__self__, "manage", manage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if send is not None:
            pulumi.set(__self__, "send", send)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="notificationHubName")
    def notification_hub_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "notification_hub_name")

    @notification_hub_name.setter
    def notification_hub_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "notification_hub_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def listen(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        """
        return pulumi.get(self, "listen")

    @listen.setter
    def listen(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "listen", value)

    @property
    @pulumi.getter
    def manage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.

        > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        """
        return pulumi.get(self, "manage")

    @manage.setter
    def manage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def send(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send", value)


@pulumi.input_type
class _AuthorizationRuleState:
    def __init__(__self__, *,
                 listen: Optional[pulumi.Input[builtins.bool]] = None,
                 manage: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_hub_name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 send: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AuthorizationRule resources.
        :param pulumi.Input[builtins.bool] listen: Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        :param pulumi.Input[builtins.bool] manage: Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.
               
               > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        :param pulumi.Input[builtins.str] name: The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] namespace_name: The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] notification_hub_name: The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_access_key: The Primary Access Key associated with this Authorization Rule.
        :param pulumi.Input[builtins.str] primary_connection_string: The Primary Connetion String associated with this Authorization Rule.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_access_key: The Secondary Access Key associated with this Authorization Rule.
        :param pulumi.Input[builtins.str] secondary_connection_string: The Secondary Connetion String associated with this Authorization Rule.
        :param pulumi.Input[builtins.bool] send: Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        if listen is not None:
            pulumi.set(__self__, "listen", listen)
        if manage is not None:
            pulumi.set(__self__, "manage", manage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if notification_hub_name is not None:
            pulumi.set(__self__, "notification_hub_name", notification_hub_name)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if send is not None:
            pulumi.set(__self__, "send", send)

    @property
    @pulumi.getter
    def listen(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        """
        return pulumi.get(self, "listen")

    @listen.setter
    def listen(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "listen", value)

    @property
    @pulumi.getter
    def manage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.

        > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        """
        return pulumi.get(self, "manage")

    @manage.setter
    def manage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="notificationHubName")
    def notification_hub_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "notification_hub_name")

    @notification_hub_name.setter
    def notification_hub_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_hub_name", value)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Primary Access Key associated with this Authorization Rule.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Primary Connetion String associated with this Authorization Rule.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary Access Key associated with this Authorization Rule.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary Connetion String associated with this Authorization Rule.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @property
    @pulumi.getter
    def send(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send", value)


@pulumi.type_token("azure:notificationhub/authorizationRule:AuthorizationRule")
class AuthorizationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 listen: Optional[pulumi.Input[builtins.bool]] = None,
                 manage: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_hub_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 send: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages an Authorization Rule associated with a Notification Hub within a Notification Hub Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="notificationhub-resources",
            location="West Europe")
        example_namespace = azure.notificationhub.Namespace("example",
            name="myappnamespace",
            resource_group_name=example.name,
            location=example.location,
            namespace_type="NotificationHub",
            sku_name="Free")
        example_hub = azure.notificationhub.Hub("example",
            name="mynotificationhub",
            namespace_name=example_namespace.name,
            resource_group_name=example.name,
            location=example.location)
        example_authorization_rule = azure.notificationhub.AuthorizationRule("example",
            name="management-auth-rule",
            notification_hub_name=example_hub.name,
            namespace_name=example_namespace.name,
            resource_group_name=example.name,
            manage=True,
            send=True,
            listen=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NotificationHubs`: 2023-09-01

        ## Import

        Notification Hub Authorization Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:notificationhub/authorizationRule:AuthorizationRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.NotificationHubs/namespaces/namespace1/notificationHubs/hub1/authorizationRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] listen: Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        :param pulumi.Input[builtins.bool] manage: Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.
               
               > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        :param pulumi.Input[builtins.str] name: The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] namespace_name: The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] notification_hub_name: The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] send: Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Authorization Rule associated with a Notification Hub within a Notification Hub Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="notificationhub-resources",
            location="West Europe")
        example_namespace = azure.notificationhub.Namespace("example",
            name="myappnamespace",
            resource_group_name=example.name,
            location=example.location,
            namespace_type="NotificationHub",
            sku_name="Free")
        example_hub = azure.notificationhub.Hub("example",
            name="mynotificationhub",
            namespace_name=example_namespace.name,
            resource_group_name=example.name,
            location=example.location)
        example_authorization_rule = azure.notificationhub.AuthorizationRule("example",
            name="management-auth-rule",
            notification_hub_name=example_hub.name,
            namespace_name=example_namespace.name,
            resource_group_name=example.name,
            manage=True,
            send=True,
            listen=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NotificationHubs`: 2023-09-01

        ## Import

        Notification Hub Authorization Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:notificationhub/authorizationRule:AuthorizationRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.NotificationHubs/namespaces/namespace1/notificationHubs/hub1/authorizationRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 listen: Optional[pulumi.Input[builtins.bool]] = None,
                 manage: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_hub_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 send: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationRuleArgs.__new__(AuthorizationRuleArgs)

            __props__.__dict__["listen"] = listen
            __props__.__dict__["manage"] = manage
            __props__.__dict__["name"] = name
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            if notification_hub_name is None and not opts.urn:
                raise TypeError("Missing required property 'notification_hub_name'")
            __props__.__dict__["notification_hub_name"] = notification_hub_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["send"] = send
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["secondary_access_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "primaryConnectionString", "secondaryAccessKey", "secondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthorizationRule, __self__).__init__(
            'azure:notificationhub/authorizationRule:AuthorizationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            listen: Optional[pulumi.Input[builtins.bool]] = None,
            manage: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[builtins.str]] = None,
            notification_hub_name: Optional[pulumi.Input[builtins.str]] = None,
            primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            send: Optional[pulumi.Input[builtins.bool]] = None) -> 'AuthorizationRule':
        """
        Get an existing AuthorizationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] listen: Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        :param pulumi.Input[builtins.bool] manage: Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.
               
               > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        :param pulumi.Input[builtins.str] name: The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] namespace_name: The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] notification_hub_name: The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_access_key: The Primary Access Key associated with this Authorization Rule.
        :param pulumi.Input[builtins.str] primary_connection_string: The Primary Connetion String associated with this Authorization Rule.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_access_key: The Secondary Access Key associated with this Authorization Rule.
        :param pulumi.Input[builtins.str] secondary_connection_string: The Secondary Connetion String associated with this Authorization Rule.
        :param pulumi.Input[builtins.bool] send: Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationRuleState.__new__(_AuthorizationRuleState)

        __props__.__dict__["listen"] = listen
        __props__.__dict__["manage"] = manage
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["notification_hub_name"] = notification_hub_name
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["send"] = send
        return AuthorizationRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def listen(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Does this Authorization Rule have Listen access to the Notification Hub? Defaults to `false`.
        """
        return pulumi.get(self, "listen")

    @property
    @pulumi.getter
    def manage(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Does this Authorization Rule have Manage access to the Notification Hub? Defaults to `false`.

        > **Note:** If `manage` is set to `true` then both `send` and `listen` must also be set to `true`.
        """
        return pulumi.get(self, "manage")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name to use for this Authorization Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Notification Hub Namespace in which the Notification Hub exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter(name="notificationHubName")
    def notification_hub_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Notification Hub for which the Authorization Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "notification_hub_name")

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The Primary Access Key associated with this Authorization Rule.
        """
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The Primary Connetion String associated with this Authorization Rule.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in which the Notification Hub Namespace exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The Secondary Access Key associated with this Authorization Rule.
        """
        return pulumi.get(self, "secondary_access_key")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The Secondary Connetion String associated with this Authorization Rule.
        """
        return pulumi.get(self, "secondary_connection_string")

    @property
    @pulumi.getter
    def send(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Does this Authorization Rule have Send access to the Notification Hub? Defaults to `false`.
        """
        return pulumi.get(self, "send")

