# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbNodesResult',
    'AwaitableGetDbNodesResult',
    'get_db_nodes',
    'get_db_nodes_output',
]

@pulumi.output_type
class GetDbNodesResult:
    """
    A collection of values returned by getDbNodes.
    """
    def __init__(__self__, cloud_vm_cluster_id=None, db_nodes=None, id=None):
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if db_nodes and not isinstance(db_nodes, list):
            raise TypeError("Expected argument 'db_nodes' to be a list")
        pulumi.set(__self__, "db_nodes", db_nodes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "cloud_vm_cluster_id")

    @property
    @pulumi.getter(name="dbNodes")
    def db_nodes(self) -> Sequence['outputs.GetDbNodesDbNodeResult']:
        """
        A `db_nodes` block as defined below.
        """
        return pulumi.get(self, "db_nodes")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDbNodesResult(GetDbNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodesResult(
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            db_nodes=self.db_nodes,
            id=self.id)


def get_db_nodes(cloud_vm_cluster_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodesResult:
    """
    Lists the database nodes for the specified Cloud VM Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_db_nodes(cloud_vm_cluster_id="existing")
    pulumi.export("example", example)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database`: 2024-06-01


    :param builtins.str cloud_vm_cluster_id: The id of the Cloud VM cluster.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:oracle/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult).value

    return AwaitableGetDbNodesResult(
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        db_nodes=pulumi.get(__ret__, 'db_nodes'),
        id=pulumi.get(__ret__, 'id'))
def get_db_nodes_output(cloud_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbNodesResult]:
    """
    Lists the database nodes for the specified Cloud VM Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_db_nodes(cloud_vm_cluster_id="existing")
    pulumi.export("example", example)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database`: 2024-06-01


    :param builtins.str cloud_vm_cluster_id: The id of the Cloud VM cluster.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:oracle/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult)
    return __ret__.apply(lambda __response__: GetDbNodesResult(
        cloud_vm_cluster_id=pulumi.get(__response__, 'cloud_vm_cluster_id'),
        db_nodes=pulumi.get(__response__, 'db_nodes'),
        id=pulumi.get(__response__, 'id')))
