# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CloudVmClusterDataCollectionOptions',
    'ExadataInfrastructureMaintenanceWindow',
    'GetAdbsCharacterSetsCharacterSetResult',
    'GetAdbsNationalCharacterSetsCharacterSetResult',
    'GetCloudVmClusterDataCollectionOptionResult',
    'GetCloudVmClusterIormConfigCachResult',
    'GetCloudVmClusterIormConfigCachDbPlanResult',
    'GetDbNodesDbNodeResult',
    'GetDbServersDbServerResult',
    'GetDbSystemShapesDbSystemShapeResult',
    'GetExadataInfrastructureEstimatedPatchingTimeResult',
    'GetExadataInfrastructureMaintenanceWindowResult',
]

@pulumi.output_type
class CloudVmClusterDataCollectionOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diagnosticsEventsEnabled":
            suggest = "diagnostics_events_enabled"
        elif key == "healthMonitoringEnabled":
            suggest = "health_monitoring_enabled"
        elif key == "incidentLogsEnabled":
            suggest = "incident_logs_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudVmClusterDataCollectionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudVmClusterDataCollectionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudVmClusterDataCollectionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 diagnostics_events_enabled: Optional[builtins.bool] = None,
                 health_monitoring_enabled: Optional[builtins.bool] = None,
                 incident_logs_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool diagnostics_events_enabled: Indicates whether diagnostic collection is enabled for the VM Cluster/Cloud VM Cluster/VMBM DBCS. Enabling diagnostic collection allows you to receive Events service notifications for guest VM issues. Diagnostic collection also allows Oracle to provide enhanced service and proactive support for your Exadata system. You can enable diagnostic collection during VM Cluster/Cloud VM Cluster provisioning. You can also disable or enable it at any time using the `UpdateVmCluster` or `updateCloudVmCluster` API. Changing this forces a new Cloud VM Cluster to be created.
        :param builtins.bool health_monitoring_enabled: Indicates whether health monitoring is enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling health monitoring allows Oracle to collect diagnostic data and share it with its operations and support personnel. You may also receive notifications for some events. Collecting health diagnostics enables Oracle to provide proactive support and enhanced service for your system. Optionally enable health monitoring while provisioning a system. You can also disable or enable health monitoring anytime using the `UpdateVmCluster`, `UpdateCloudVmCluster` or `updateDbsystem` API. Changing this forces a new Cloud VM Cluster to be created.
        :param builtins.bool incident_logs_enabled: Indicates whether incident logs and trace collection are enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling incident logs collection allows Oracle to receive Events service notifications for guest VM issues, collect incident logs and traces, and use them to diagnose issues and resolve them. Optionally enable incident logs collection while provisioning a system. You can also disable or enable incident logs collection anytime using the `UpdateVmCluster`, `updateCloudVmCluster` or `updateDbsystem` API. Changing this forces a new Cloud VM Cluster to be created.
        """
        if diagnostics_events_enabled is not None:
            pulumi.set(__self__, "diagnostics_events_enabled", diagnostics_events_enabled)
        if health_monitoring_enabled is not None:
            pulumi.set(__self__, "health_monitoring_enabled", health_monitoring_enabled)
        if incident_logs_enabled is not None:
            pulumi.set(__self__, "incident_logs_enabled", incident_logs_enabled)

    @property
    @pulumi.getter(name="diagnosticsEventsEnabled")
    def diagnostics_events_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether diagnostic collection is enabled for the VM Cluster/Cloud VM Cluster/VMBM DBCS. Enabling diagnostic collection allows you to receive Events service notifications for guest VM issues. Diagnostic collection also allows Oracle to provide enhanced service and proactive support for your Exadata system. You can enable diagnostic collection during VM Cluster/Cloud VM Cluster provisioning. You can also disable or enable it at any time using the `UpdateVmCluster` or `updateCloudVmCluster` API. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "diagnostics_events_enabled")

    @property
    @pulumi.getter(name="healthMonitoringEnabled")
    def health_monitoring_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether health monitoring is enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling health monitoring allows Oracle to collect diagnostic data and share it with its operations and support personnel. You may also receive notifications for some events. Collecting health diagnostics enables Oracle to provide proactive support and enhanced service for your system. Optionally enable health monitoring while provisioning a system. You can also disable or enable health monitoring anytime using the `UpdateVmCluster`, `UpdateCloudVmCluster` or `updateDbsystem` API. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "health_monitoring_enabled")

    @property
    @pulumi.getter(name="incidentLogsEnabled")
    def incident_logs_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether incident logs and trace collection are enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling incident logs collection allows Oracle to receive Events service notifications for guest VM issues, collect incident logs and traces, and use them to diagnose issues and resolve them. Optionally enable incident logs collection while provisioning a system. You can also disable or enable incident logs collection anytime using the `UpdateVmCluster`, `updateCloudVmCluster` or `updateDbsystem` API. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "incident_logs_enabled")


@pulumi.output_type
class ExadataInfrastructureMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "hoursOfDays":
            suggest = "hours_of_days"
        elif key == "leadTimeInWeeks":
            suggest = "lead_time_in_weeks"
        elif key == "patchingMode":
            suggest = "patching_mode"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExadataInfrastructureMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExadataInfrastructureMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExadataInfrastructureMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_weeks: Optional[Sequence[builtins.str]] = None,
                 hours_of_days: Optional[Sequence[builtins.int]] = None,
                 lead_time_in_weeks: Optional[builtins.int] = None,
                 months: Optional[Sequence[builtins.str]] = None,
                 patching_mode: Optional[builtins.str] = None,
                 preference: Optional[builtins.str] = None,
                 weeks_of_months: Optional[Sequence[builtins.int]] = None):
        """
        :param Sequence[builtins.str] days_of_weeks: Days during the week when maintenance should be performed. Valid values are: `0` - represents time slot `0:00 - 3:59 UTC - 4` - represents time slot `4:00 - 7:59 UTC - 8` - represents time slot 8:00 - 11:59 UTC - 12 - represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 - represents time slot `20:00 - 23:59 UTC`. Changing this forces a new Cloud Exadata Infrastructure to be created.
        :param Sequence[builtins.int] hours_of_days: The window of hours during the day when maintenance should be performed. The window is a 4 hour slot. Changing this forces a new Cloud Exadata Infrastructure to be created.
        :param builtins.int lead_time_in_weeks: Lead time window allows user to set a lead time to prepare for a down time. The lead time is in weeks and valid value is between `1` to `4`. Changing this forces a new Cloud Exadata Infrastructure to be created.
        :param Sequence[builtins.str] months: Months during the year when maintenance should be performed. Changing this forces a new Cloud Exadata Infrastructure to be created.
        :param builtins.str patching_mode: Cloud Exadata Infrastructure node patching method, either `ROLLING` or `NONROLLING`. Default value is `ROLLING`. IMPORTANT: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information. Changing this forces a new Cloud Exadata Infrastructure to be created.
        :param builtins.str preference: The maintenance window scheduling preference. Changing this forces a new Cloud Exadata Infrastructure to be created.
        :param Sequence[builtins.int] weeks_of_months: Weeks during the month when maintenance should be performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks start and end based on calendar dates, not days of the week. For example, to allow maintenance during the 2nd week of the month (from the 8th day to the 14th day of the month), use the value 2. Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days. Note that this parameter works in conjunction with the daysOfWeek and hoursOfDay parameters to allow you to specify specific days of the week and hours that maintenance will be performed. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if hours_of_days is not None:
            pulumi.set(__self__, "hours_of_days", hours_of_days)
        if lead_time_in_weeks is not None:
            pulumi.set(__self__, "lead_time_in_weeks", lead_time_in_weeks)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if patching_mode is not None:
            pulumi.set(__self__, "patching_mode", patching_mode)
        if preference is not None:
            pulumi.set(__self__, "preference", preference)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        Days during the week when maintenance should be performed. Valid values are: `0` - represents time slot `0:00 - 3:59 UTC - 4` - represents time slot `4:00 - 7:59 UTC - 8` - represents time slot 8:00 - 11:59 UTC - 12 - represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 - represents time slot `20:00 - 23:59 UTC`. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @property
    @pulumi.getter(name="hoursOfDays")
    def hours_of_days(self) -> Optional[Sequence[builtins.int]]:
        """
        The window of hours during the day when maintenance should be performed. The window is a 4 hour slot. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "hours_of_days")

    @property
    @pulumi.getter(name="leadTimeInWeeks")
    def lead_time_in_weeks(self) -> Optional[builtins.int]:
        """
        Lead time window allows user to set a lead time to prepare for a down time. The lead time is in weeks and valid value is between `1` to `4`. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "lead_time_in_weeks")

    @property
    @pulumi.getter
    def months(self) -> Optional[Sequence[builtins.str]]:
        """
        Months during the year when maintenance should be performed. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> Optional[builtins.str]:
        """
        Cloud Exadata Infrastructure node patching method, either `ROLLING` or `NONROLLING`. Default value is `ROLLING`. IMPORTANT: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "patching_mode")

    @property
    @pulumi.getter
    def preference(self) -> Optional[builtins.str]:
        """
        The maintenance window scheduling preference. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "preference")

    @property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[builtins.int]]:
        """
        Weeks during the month when maintenance should be performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks start and end based on calendar dates, not days of the week. For example, to allow maintenance during the 2nd week of the month (from the 8th day to the 14th day of the month), use the value 2. Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days. Note that this parameter works in conjunction with the daysOfWeek and hoursOfDay parameters to allow you to specify specific days of the week and hours that maintenance will be performed. Changing this forces a new Cloud Exadata Infrastructure to be created.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class GetAdbsCharacterSetsCharacterSetResult(dict):
    def __init__(__self__, *,
                 character_set: builtins.str):
        """
        :param builtins.str character_set: A valid Oracle character set.
        """
        pulumi.set(__self__, "character_set", character_set)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> builtins.str:
        """
        A valid Oracle character set.
        """
        return pulumi.get(self, "character_set")


@pulumi.output_type
class GetAdbsNationalCharacterSetsCharacterSetResult(dict):
    def __init__(__self__, *,
                 character_set: builtins.str):
        """
        :param builtins.str character_set: A valid Oracle national character set.
        """
        pulumi.set(__self__, "character_set", character_set)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> builtins.str:
        """
        A valid Oracle national character set.
        """
        return pulumi.get(self, "character_set")


@pulumi.output_type
class GetCloudVmClusterDataCollectionOptionResult(dict):
    def __init__(__self__, *,
                 diagnostics_events_enabled: builtins.bool,
                 health_monitoring_enabled: builtins.bool,
                 incident_logs_enabled: builtins.bool):
        """
        :param builtins.bool diagnostics_events_enabled: Indicates whether diagnostic collection is enabled for the VM Cluster/Cloud VM Cluster/VMBM DBCS. Enabling diagnostic collection allows you to receive Events service notifications for guest VM issues. Diagnostic collection also allows Oracle to provide enhanced service and proactive support for your Exadata system. You can enable diagnostic collection during VM Cluster/Cloud VM Cluster provisioning. You can also disable or enable it at any time using the `UpdateVmCluster` or `updateCloudVmCluster` API.
        :param builtins.bool health_monitoring_enabled: Indicates whether health monitoring is enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling health monitoring allows Oracle to collect diagnostic data and share it with its operations and support personnel. You may also receive notifications for some events. Collecting health diagnostics enables Oracle to provide proactive support and enhanced service for your system. Optionally enable health monitoring while provisioning a system. You can also disable or enable health monitoring anytime using the `UpdateVmCluster`, `UpdateCloudVmCluster` or `updateDbsystem` API.
        :param builtins.bool incident_logs_enabled: Indicates whether incident logs and trace collection are enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling incident logs collection allows Oracle to receive Events service notifications for guest VM issues, collect incident logs and traces, and use them to diagnose issues and resolve them. Optionally enable incident logs collection while provisioning a system. You can also disable or enable incident logs collection anytime using the `UpdateVmCluster`, `updateCloudVmCluster` or `updateDbsystem` API.
        """
        pulumi.set(__self__, "diagnostics_events_enabled", diagnostics_events_enabled)
        pulumi.set(__self__, "health_monitoring_enabled", health_monitoring_enabled)
        pulumi.set(__self__, "incident_logs_enabled", incident_logs_enabled)

    @property
    @pulumi.getter(name="diagnosticsEventsEnabled")
    def diagnostics_events_enabled(self) -> builtins.bool:
        """
        Indicates whether diagnostic collection is enabled for the VM Cluster/Cloud VM Cluster/VMBM DBCS. Enabling diagnostic collection allows you to receive Events service notifications for guest VM issues. Diagnostic collection also allows Oracle to provide enhanced service and proactive support for your Exadata system. You can enable diagnostic collection during VM Cluster/Cloud VM Cluster provisioning. You can also disable or enable it at any time using the `UpdateVmCluster` or `updateCloudVmCluster` API.
        """
        return pulumi.get(self, "diagnostics_events_enabled")

    @property
    @pulumi.getter(name="healthMonitoringEnabled")
    def health_monitoring_enabled(self) -> builtins.bool:
        """
        Indicates whether health monitoring is enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling health monitoring allows Oracle to collect diagnostic data and share it with its operations and support personnel. You may also receive notifications for some events. Collecting health diagnostics enables Oracle to provide proactive support and enhanced service for your system. Optionally enable health monitoring while provisioning a system. You can also disable or enable health monitoring anytime using the `UpdateVmCluster`, `UpdateCloudVmCluster` or `updateDbsystem` API.
        """
        return pulumi.get(self, "health_monitoring_enabled")

    @property
    @pulumi.getter(name="incidentLogsEnabled")
    def incident_logs_enabled(self) -> builtins.bool:
        """
        Indicates whether incident logs and trace collection are enabled for the VM Cluster / Cloud VM Cluster / VMBM DBCS. Enabling incident logs collection allows Oracle to receive Events service notifications for guest VM issues, collect incident logs and traces, and use them to diagnose issues and resolve them. Optionally enable incident logs collection while provisioning a system. You can also disable or enable incident logs collection anytime using the `UpdateVmCluster`, `updateCloudVmCluster` or `updateDbsystem` API.
        """
        return pulumi.get(self, "incident_logs_enabled")


@pulumi.output_type
class GetCloudVmClusterIormConfigCachResult(dict):
    def __init__(__self__, *,
                 db_plans: Sequence['outputs.GetCloudVmClusterIormConfigCachDbPlanResult'],
                 lifecycle_details: builtins.str,
                 lifecycle_state: builtins.str,
                 objective: builtins.str):
        """
        :param Sequence['GetCloudVmClusterIormConfigCachDbPlanArgs'] db_plans: A `db_plans` block as defined above.
        :param builtins.str lifecycle_details: Additional information about the current `lifecycleState`.
        :param builtins.str lifecycle_state: The current state of IORM configuration for the Exadata DB system.
        :param builtins.str objective: The current value for the IORM objective. The default is `AUTO`.
        """
        pulumi.set(__self__, "db_plans", db_plans)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "objective", objective)

    @property
    @pulumi.getter(name="dbPlans")
    def db_plans(self) -> Sequence['outputs.GetCloudVmClusterIormConfigCachDbPlanResult']:
        """
        A `db_plans` block as defined above.
        """
        return pulumi.get(self, "db_plans")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current `lifecycleState`.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        """
        The current state of IORM configuration for the Exadata DB system.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def objective(self) -> builtins.str:
        """
        The current value for the IORM objective. The default is `AUTO`.
        """
        return pulumi.get(self, "objective")


@pulumi.output_type
class GetCloudVmClusterIormConfigCachDbPlanResult(dict):
    def __init__(__self__, *,
                 db_name: builtins.str,
                 flash_cache_limit: builtins.str,
                 share: builtins.int):
        """
        :param builtins.str db_name: The database name. For the default `DbPlan`, the `dbName` is `default`.
        :param builtins.str flash_cache_limit: The flash cache limit for this database. This value is internally configured based on the share value assigned to the database.
        :param builtins.int share: The relative priority of this database.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "flash_cache_limit", flash_cache_limit)
        pulumi.set(__self__, "share", share)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> builtins.str:
        """
        The database name. For the default `DbPlan`, the `dbName` is `default`.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="flashCacheLimit")
    def flash_cache_limit(self) -> builtins.str:
        """
        The flash cache limit for this database. This value is internally configured based on the share value assigned to the database.
        """
        return pulumi.get(self, "flash_cache_limit")

    @property
    @pulumi.getter
    def share(self) -> builtins.int:
        """
        The relative priority of this database.
        """
        return pulumi.get(self, "share")


@pulumi.output_type
class GetDbNodesDbNodeResult(dict):
    def __init__(__self__, *,
                 additional_details: builtins.str,
                 backup_ip_id: builtins.str,
                 backup_vnic2_id: builtins.str,
                 backup_vnic_id: builtins.str,
                 cpu_core_count: builtins.int,
                 db_node_storage_size_in_gbs: builtins.int,
                 db_server_id: builtins.str,
                 db_system_id: builtins.str,
                 fault_domain: builtins.str,
                 host_ip_id: builtins.str,
                 hostname: builtins.str,
                 lifecycle_details: builtins.str,
                 lifecycle_state: builtins.str,
                 maintenance_type: builtins.str,
                 memory_size_in_gbs: builtins.int,
                 ocid: builtins.str,
                 software_storage_size_in_gb: builtins.int,
                 time_created: builtins.str,
                 time_maintenance_window_end: builtins.str,
                 time_maintenance_window_start: builtins.str,
                 vnic2_id: builtins.str,
                 vnic_id: builtins.str):
        """
        :param builtins.str additional_details: Additional information about the planned maintenance.
        :param builtins.str backup_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IP address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IP address needed to make a database connection.
        :param builtins.str backup_vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup VNIC.
        :param builtins.int cpu_core_count: The number of CPU cores enabled on the DB node.
        :param builtins.int db_node_storage_size_in_gbs: The allocated local node storage in GBs on the DB node.
        :param builtins.str db_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ExaCC DB server associated with the database node.
        :param builtins.str db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param builtins.str fault_domain: The name of the Fault Domain the instance is contained in.
        :param builtins.str host_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IP address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IP address needed to make a database connection.
        :param builtins.str lifecycle_details: Information about the current lifecycle details.
        :param builtins.str lifecycle_state: Information about the current lifecycle state.
        :param builtins.str maintenance_type: The type of database node maintenance.
        :param builtins.int memory_size_in_gbs: The allocated memory in GBs on the DB Node.
        :param builtins.str ocid: The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the DB node.
        :param builtins.int software_storage_size_in_gb: The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.
        :param builtins.str time_created: The date and time that the DB node was created.
        :param builtins.str time_maintenance_window_end: End date and time of maintenance window.
        :param builtins.str time_maintenance_window_start: Start date and time of maintenance window.
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC.
        """
        pulumi.set(__self__, "additional_details", additional_details)
        pulumi.set(__self__, "backup_ip_id", backup_ip_id)
        pulumi.set(__self__, "backup_vnic2_id", backup_vnic2_id)
        pulumi.set(__self__, "backup_vnic_id", backup_vnic_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        pulumi.set(__self__, "db_server_id", db_server_id)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "host_ip_id", host_ip_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "maintenance_type", maintenance_type)
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        pulumi.set(__self__, "ocid", ocid)
        pulumi.set(__self__, "software_storage_size_in_gb", software_storage_size_in_gb)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_maintenance_window_end", time_maintenance_window_end)
        pulumi.set(__self__, "time_maintenance_window_start", time_maintenance_window_start)
        pulumi.set(__self__, "vnic2_id", vnic2_id)
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> builtins.str:
        """
        Additional information about the planned maintenance.
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="backupIpId")
    def backup_ip_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IP address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IP address needed to make a database connection.
        """
        return pulumi.get(self, "backup_ip_id")

    @property
    @pulumi.getter(name="backupVnic2Id")
    def backup_vnic2_id(self) -> builtins.str:
        return pulumi.get(self, "backup_vnic2_id")

    @property
    @pulumi.getter(name="backupVnicId")
    def backup_vnic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup VNIC.
        """
        return pulumi.get(self, "backup_vnic_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> builtins.int:
        """
        The number of CPU cores enabled on the DB node.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> builtins.int:
        """
        The allocated local node storage in GBs on the DB node.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ExaCC DB server associated with the database node.
        """
        return pulumi.get(self, "db_server_id")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> builtins.str:
        """
        The name of the Fault Domain the instance is contained in.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="hostIpId")
    def host_ip_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IP address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IP address needed to make a database connection.
        """
        return pulumi.get(self, "host_ip_id")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Information about the current lifecycle details.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        """
        Information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> builtins.str:
        """
        The type of database node maintenance.
        """
        return pulumi.get(self, "maintenance_type")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> builtins.int:
        """
        The allocated memory in GBs on the DB Node.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter
    def ocid(self) -> builtins.str:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the DB node.
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="softwareStorageSizeInGb")
    def software_storage_size_in_gb(self) -> builtins.int:
        """
        The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "software_storage_size_in_gb")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the DB node was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMaintenanceWindowEnd")
    def time_maintenance_window_end(self) -> builtins.str:
        """
        End date and time of maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_end")

    @property
    @pulumi.getter(name="timeMaintenanceWindowStart")
    def time_maintenance_window_start(self) -> builtins.str:
        """
        Start date and time of maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_start")

    @property
    @pulumi.getter(name="vnic2Id")
    def vnic2_id(self) -> builtins.str:
        return pulumi.get(self, "vnic2_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetDbServersDbServerResult(dict):
    def __init__(__self__, *,
                 autonomous_virtual_machine_ds: Sequence[builtins.str],
                 autonomous_vm_cluster_ids: Sequence[builtins.str],
                 compartment_id: builtins.str,
                 cpu_core_count: builtins.int,
                 db_node_ids: Sequence[builtins.str],
                 db_node_storage_size_in_gbs: builtins.int,
                 display_name: builtins.str,
                 exadata_infrastructure_id: builtins.str,
                 lifecycle_details: builtins.str,
                 lifecycle_state: builtins.str,
                 max_cpu_count: builtins.int,
                 max_db_node_storage_in_gbs: builtins.int,
                 max_memory_in_gbs: builtins.int,
                 memory_size_in_gbs: builtins.int,
                 ocid: builtins.str,
                 shape: builtins.str,
                 time_created: builtins.str,
                 vm_cluster_ids: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] autonomous_virtual_machine_ds: The list of [OCIDs](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Virtual Machines associated with the DB Server.
        :param Sequence[builtins.str] autonomous_vm_cluster_ids: The list of [OCIDs](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous VM Clusters associated with the DB Server.
        :param builtins.str compartment_id: The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.int cpu_core_count: The number of CPU cores enabled on the DB Server.
        :param Sequence[builtins.str] db_node_ids: The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Db nodes associated with the DB Server.
        :param builtins.int db_node_storage_size_in_gbs: The allocated local node storage in GBs on the DB Server.
        :param builtins.str display_name: The user-friendly name for the DB Server. The name does not need to be unique.
        :param builtins.str exadata_infrastructure_id: The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param builtins.str lifecycle_details: Additional information about the current lifecycle state.
        :param builtins.str lifecycle_state: The current state of the DB Server.
        :param builtins.int max_cpu_count: The total number of CPU cores available.
        :param builtins.int max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param builtins.int max_memory_in_gbs: The total memory available in GBs.
        :param builtins.int memory_size_in_gbs: The allocated memory in GBs on the DB Server.
        :param builtins.str ocid: The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the DB Server.
        :param builtins.str shape: The shape of the DB Server. The shape determines the amount of CPU, storage, and memory resources available.
        :param builtins.str time_created: The date and time that the DB Server was created.
        :param Sequence[builtins.str] vm_cluster_ids: The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the VM Clusters associated with the DB Server.
        """
        pulumi.set(__self__, "autonomous_virtual_machine_ds", autonomous_virtual_machine_ds)
        pulumi.set(__self__, "autonomous_vm_cluster_ids", autonomous_vm_cluster_ids)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "db_node_ids", db_node_ids)
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        pulumi.set(__self__, "ocid", ocid)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "vm_cluster_ids", vm_cluster_ids)

    @property
    @pulumi.getter(name="autonomousVirtualMachineDs")
    def autonomous_virtual_machine_ds(self) -> Sequence[builtins.str]:
        """
        The list of [OCIDs](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Virtual Machines associated with the DB Server.
        """
        return pulumi.get(self, "autonomous_virtual_machine_ds")

    @property
    @pulumi.getter(name="autonomousVmClusterIds")
    def autonomous_vm_cluster_ids(self) -> Sequence[builtins.str]:
        """
        The list of [OCIDs](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous VM Clusters associated with the DB Server.
        """
        return pulumi.get(self, "autonomous_vm_cluster_ids")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> builtins.int:
        """
        The number of CPU cores enabled on the DB Server.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dbNodeIds")
    def db_node_ids(self) -> Sequence[builtins.str]:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Db nodes associated with the DB Server.
        """
        return pulumi.get(self, "db_node_ids")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> builtins.int:
        """
        The allocated local node storage in GBs on the DB Server.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the DB Server. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> builtins.str:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        """
        The current state of the DB Server.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> builtins.int:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> builtins.int:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> builtins.int:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> builtins.int:
        """
        The allocated memory in GBs on the DB Server.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter
    def ocid(self) -> builtins.str:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the DB Server.
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The shape of the DB Server. The shape determines the amount of CPU, storage, and memory resources available.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the DB Server was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> Sequence[builtins.str]:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the VM Clusters associated with the DB Server.
        """
        return pulumi.get(self, "vm_cluster_ids")


@pulumi.output_type
class GetDbSystemShapesDbSystemShapeResult(dict):
    def __init__(__self__, *,
                 available_core_count: builtins.int,
                 available_core_count_per_node: builtins.int,
                 available_data_storage_in_tbs: builtins.int,
                 available_data_storage_per_server_in_tbs: builtins.int,
                 available_db_node_per_node_in_gbs: builtins.int,
                 available_db_node_storage_in_gbs: builtins.int,
                 available_memory_in_gbs: builtins.int,
                 available_memory_per_node_in_gbs: builtins.int,
                 core_count_increment: builtins.int,
                 maximum_node_count: builtins.int,
                 maximum_storage_count: builtins.int,
                 minimum_core_count: builtins.int,
                 minimum_core_count_per_node: builtins.int,
                 minimum_data_storage_in_tbs: builtins.int,
                 minimum_db_node_storage_per_node_in_gbs: builtins.int,
                 minimum_memory_per_node_in_gbs: builtins.int,
                 minimum_node_count: builtins.int,
                 minimum_storage_count: builtins.int,
                 runtime_minimum_core_count: builtins.int,
                 shape_family: builtins.str):
        """
        :param builtins.int available_core_count: The maximum number of CPU cores that can be enabled on the DB system for this shape.
        :param builtins.int available_core_count_per_node: The maximum number of CPU cores per database node that can be enabled for this shape. Only applicable to the flex Exadata shape, ExaCC Elastic shapes and VM Flex shapes.
        :param builtins.int available_data_storage_in_tbs: The maximum data storage that can be enabled for this shape.
        :param builtins.int available_data_storage_per_server_in_tbs: The maximum data storage available per storage server for this shape. Only applicable to ExaCC Elastic shapes.
        :param builtins.int available_db_node_per_node_in_gbs: The maximum DB Node storage available per database node for this shape. Only applicable to ExaCC Elastic shapes.
        :param builtins.int available_db_node_storage_in_gbs: The maximum DB Node storage that can be enabled for this shape.
        :param builtins.int available_memory_in_gbs: The maximum memory that can be enabled for this shape.
        :param builtins.int available_memory_per_node_in_gbs: The maximum memory available per database node for this shape. Only applicable to ExaCC Elastic shapes.
        :param builtins.int core_count_increment: The discrete number by which the CPU core count for this shape can be increased or decreased.
        :param builtins.int maximum_node_count: The maximum number of compute servers available for this shape.
        :param builtins.int maximum_storage_count: The maximum number of Exadata storage servers available for the Exadata infrastructure.
        :param builtins.int minimum_core_count: The minimum number of CPU cores that can be enabled on the DB system for this shape.
        :param builtins.int minimum_core_count_per_node: The minimum number of CPU cores that can be enabled per node for this shape.
        :param builtins.int minimum_data_storage_in_tbs: The minimum data storage that need be allocated for this shape.
        :param builtins.int minimum_db_node_storage_per_node_in_gbs: The minimum DB Node storage that need be allocated per node for this shape.
        :param builtins.int minimum_memory_per_node_in_gbs: The minimum memory that need be allocated per node for this shape.
        :param builtins.int minimum_node_count: The minimum number of compute servers available for this shape.
        :param builtins.int minimum_storage_count: The minimum number of Exadata storage servers available for the Exadata infrastructure.
        :param builtins.int runtime_minimum_core_count: The runtime minimum number of compute servers available for this shape.
        :param builtins.str shape_family: The family of the shape used for the DB system.
        """
        pulumi.set(__self__, "available_core_count", available_core_count)
        pulumi.set(__self__, "available_core_count_per_node", available_core_count_per_node)
        pulumi.set(__self__, "available_data_storage_in_tbs", available_data_storage_in_tbs)
        pulumi.set(__self__, "available_data_storage_per_server_in_tbs", available_data_storage_per_server_in_tbs)
        pulumi.set(__self__, "available_db_node_per_node_in_gbs", available_db_node_per_node_in_gbs)
        pulumi.set(__self__, "available_db_node_storage_in_gbs", available_db_node_storage_in_gbs)
        pulumi.set(__self__, "available_memory_in_gbs", available_memory_in_gbs)
        pulumi.set(__self__, "available_memory_per_node_in_gbs", available_memory_per_node_in_gbs)
        pulumi.set(__self__, "core_count_increment", core_count_increment)
        pulumi.set(__self__, "maximum_node_count", maximum_node_count)
        pulumi.set(__self__, "maximum_storage_count", maximum_storage_count)
        pulumi.set(__self__, "minimum_core_count", minimum_core_count)
        pulumi.set(__self__, "minimum_core_count_per_node", minimum_core_count_per_node)
        pulumi.set(__self__, "minimum_data_storage_in_tbs", minimum_data_storage_in_tbs)
        pulumi.set(__self__, "minimum_db_node_storage_per_node_in_gbs", minimum_db_node_storage_per_node_in_gbs)
        pulumi.set(__self__, "minimum_memory_per_node_in_gbs", minimum_memory_per_node_in_gbs)
        pulumi.set(__self__, "minimum_node_count", minimum_node_count)
        pulumi.set(__self__, "minimum_storage_count", minimum_storage_count)
        pulumi.set(__self__, "runtime_minimum_core_count", runtime_minimum_core_count)
        pulumi.set(__self__, "shape_family", shape_family)

    @property
    @pulumi.getter(name="availableCoreCount")
    def available_core_count(self) -> builtins.int:
        """
        The maximum number of CPU cores that can be enabled on the DB system for this shape.
        """
        return pulumi.get(self, "available_core_count")

    @property
    @pulumi.getter(name="availableCoreCountPerNode")
    def available_core_count_per_node(self) -> builtins.int:
        """
        The maximum number of CPU cores per database node that can be enabled for this shape. Only applicable to the flex Exadata shape, ExaCC Elastic shapes and VM Flex shapes.
        """
        return pulumi.get(self, "available_core_count_per_node")

    @property
    @pulumi.getter(name="availableDataStorageInTbs")
    def available_data_storage_in_tbs(self) -> builtins.int:
        """
        The maximum data storage that can be enabled for this shape.
        """
        return pulumi.get(self, "available_data_storage_in_tbs")

    @property
    @pulumi.getter(name="availableDataStoragePerServerInTbs")
    def available_data_storage_per_server_in_tbs(self) -> builtins.int:
        """
        The maximum data storage available per storage server for this shape. Only applicable to ExaCC Elastic shapes.
        """
        return pulumi.get(self, "available_data_storage_per_server_in_tbs")

    @property
    @pulumi.getter(name="availableDbNodePerNodeInGbs")
    def available_db_node_per_node_in_gbs(self) -> builtins.int:
        """
        The maximum DB Node storage available per database node for this shape. Only applicable to ExaCC Elastic shapes.
        """
        return pulumi.get(self, "available_db_node_per_node_in_gbs")

    @property
    @pulumi.getter(name="availableDbNodeStorageInGbs")
    def available_db_node_storage_in_gbs(self) -> builtins.int:
        """
        The maximum DB Node storage that can be enabled for this shape.
        """
        return pulumi.get(self, "available_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="availableMemoryInGbs")
    def available_memory_in_gbs(self) -> builtins.int:
        """
        The maximum memory that can be enabled for this shape.
        """
        return pulumi.get(self, "available_memory_in_gbs")

    @property
    @pulumi.getter(name="availableMemoryPerNodeInGbs")
    def available_memory_per_node_in_gbs(self) -> builtins.int:
        """
        The maximum memory available per database node for this shape. Only applicable to ExaCC Elastic shapes.
        """
        return pulumi.get(self, "available_memory_per_node_in_gbs")

    @property
    @pulumi.getter(name="coreCountIncrement")
    def core_count_increment(self) -> builtins.int:
        """
        The discrete number by which the CPU core count for this shape can be increased or decreased.
        """
        return pulumi.get(self, "core_count_increment")

    @property
    @pulumi.getter(name="maximumNodeCount")
    def maximum_node_count(self) -> builtins.int:
        """
        The maximum number of compute servers available for this shape.
        """
        return pulumi.get(self, "maximum_node_count")

    @property
    @pulumi.getter(name="maximumStorageCount")
    def maximum_storage_count(self) -> builtins.int:
        """
        The maximum number of Exadata storage servers available for the Exadata infrastructure.
        """
        return pulumi.get(self, "maximum_storage_count")

    @property
    @pulumi.getter(name="minimumCoreCount")
    def minimum_core_count(self) -> builtins.int:
        """
        The minimum number of CPU cores that can be enabled on the DB system for this shape.
        """
        return pulumi.get(self, "minimum_core_count")

    @property
    @pulumi.getter(name="minimumCoreCountPerNode")
    def minimum_core_count_per_node(self) -> builtins.int:
        """
        The minimum number of CPU cores that can be enabled per node for this shape.
        """
        return pulumi.get(self, "minimum_core_count_per_node")

    @property
    @pulumi.getter(name="minimumDataStorageInTbs")
    def minimum_data_storage_in_tbs(self) -> builtins.int:
        """
        The minimum data storage that need be allocated for this shape.
        """
        return pulumi.get(self, "minimum_data_storage_in_tbs")

    @property
    @pulumi.getter(name="minimumDbNodeStoragePerNodeInGbs")
    def minimum_db_node_storage_per_node_in_gbs(self) -> builtins.int:
        """
        The minimum DB Node storage that need be allocated per node for this shape.
        """
        return pulumi.get(self, "minimum_db_node_storage_per_node_in_gbs")

    @property
    @pulumi.getter(name="minimumMemoryPerNodeInGbs")
    def minimum_memory_per_node_in_gbs(self) -> builtins.int:
        """
        The minimum memory that need be allocated per node for this shape.
        """
        return pulumi.get(self, "minimum_memory_per_node_in_gbs")

    @property
    @pulumi.getter(name="minimumNodeCount")
    def minimum_node_count(self) -> builtins.int:
        """
        The minimum number of compute servers available for this shape.
        """
        return pulumi.get(self, "minimum_node_count")

    @property
    @pulumi.getter(name="minimumStorageCount")
    def minimum_storage_count(self) -> builtins.int:
        """
        The minimum number of Exadata storage servers available for the Exadata infrastructure.
        """
        return pulumi.get(self, "minimum_storage_count")

    @property
    @pulumi.getter(name="runtimeMinimumCoreCount")
    def runtime_minimum_core_count(self) -> builtins.int:
        """
        The runtime minimum number of compute servers available for this shape.
        """
        return pulumi.get(self, "runtime_minimum_core_count")

    @property
    @pulumi.getter(name="shapeFamily")
    def shape_family(self) -> builtins.str:
        """
        The family of the shape used for the DB system.
        """
        return pulumi.get(self, "shape_family")


@pulumi.output_type
class GetExadataInfrastructureEstimatedPatchingTimeResult(dict):
    def __init__(__self__, *,
                 estimated_db_server_patching_time: builtins.int,
                 estimated_network_switches_patching_time: builtins.int,
                 estimated_storage_server_patching_time: builtins.int,
                 total_estimated_patching_time: builtins.int):
        """
        :param builtins.int estimated_db_server_patching_time: The estimated time required in minutes for database server patching.
        :param builtins.int estimated_network_switches_patching_time: The estimated time required in minutes for network switch patching.
        :param builtins.int estimated_storage_server_patching_time: The estimated time required in minutes for storage server patching.
        :param builtins.int total_estimated_patching_time: The estimated total time required in minutes for all patching operations.
        """
        pulumi.set(__self__, "estimated_db_server_patching_time", estimated_db_server_patching_time)
        pulumi.set(__self__, "estimated_network_switches_patching_time", estimated_network_switches_patching_time)
        pulumi.set(__self__, "estimated_storage_server_patching_time", estimated_storage_server_patching_time)
        pulumi.set(__self__, "total_estimated_patching_time", total_estimated_patching_time)

    @property
    @pulumi.getter(name="estimatedDbServerPatchingTime")
    def estimated_db_server_patching_time(self) -> builtins.int:
        """
        The estimated time required in minutes for database server patching.
        """
        return pulumi.get(self, "estimated_db_server_patching_time")

    @property
    @pulumi.getter(name="estimatedNetworkSwitchesPatchingTime")
    def estimated_network_switches_patching_time(self) -> builtins.int:
        """
        The estimated time required in minutes for network switch patching.
        """
        return pulumi.get(self, "estimated_network_switches_patching_time")

    @property
    @pulumi.getter(name="estimatedStorageServerPatchingTime")
    def estimated_storage_server_patching_time(self) -> builtins.int:
        """
        The estimated time required in minutes for storage server patching.
        """
        return pulumi.get(self, "estimated_storage_server_patching_time")

    @property
    @pulumi.getter(name="totalEstimatedPatchingTime")
    def total_estimated_patching_time(self) -> builtins.int:
        """
        The estimated total time required in minutes for all patching operations.
        """
        return pulumi.get(self, "total_estimated_patching_time")


@pulumi.output_type
class GetExadataInfrastructureMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 custom_action_timeout_enabled: builtins.bool,
                 custom_action_timeout_in_mins: builtins.int,
                 days_of_weeks: Sequence[builtins.str],
                 hours_of_days: Sequence[builtins.int],
                 lead_time_in_weeks: builtins.int,
                 monthly_patching_enabled: builtins.bool,
                 months: Sequence[builtins.str],
                 patching_mode: builtins.str,
                 preference: builtins.str,
                 weeks_of_months: Sequence[builtins.int]):
        """
        :param builtins.bool custom_action_timeout_enabled: If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        :param Sequence[builtins.str] days_of_weeks: Days during the week when maintenance should be performed.
        :param Sequence[builtins.int] hours_of_days: The window of hours during the day when maintenance should be performed.
        :param builtins.int lead_time_in_weeks: Lead time window allows user to set a lead time to prepare for a down time.
        :param builtins.bool monthly_patching_enabled: If true, enables the monthly patching option.
        :param Sequence[builtins.str] months: A `months` block as defined below.
        :param builtins.str patching_mode: Cloud Exadata Infrastructure node patching method.
        :param builtins.str preference: The maintenance window scheduling preference.
        :param Sequence[builtins.int] weeks_of_months: Weeks during the month when maintenance should be performed.
        """
        pulumi.set(__self__, "custom_action_timeout_enabled", custom_action_timeout_enabled)
        pulumi.set(__self__, "custom_action_timeout_in_mins", custom_action_timeout_in_mins)
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hours_of_days", hours_of_days)
        pulumi.set(__self__, "lead_time_in_weeks", lead_time_in_weeks)
        pulumi.set(__self__, "monthly_patching_enabled", monthly_patching_enabled)
        pulumi.set(__self__, "months", months)
        pulumi.set(__self__, "patching_mode", patching_mode)
        pulumi.set(__self__, "preference", preference)
        pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @property
    @pulumi.getter(name="customActionTimeoutEnabled")
    def custom_action_timeout_enabled(self) -> builtins.bool:
        """
        If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        """
        return pulumi.get(self, "custom_action_timeout_enabled")

    @property
    @pulumi.getter(name="customActionTimeoutInMins")
    def custom_action_timeout_in_mins(self) -> builtins.int:
        return pulumi.get(self, "custom_action_timeout_in_mins")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence[builtins.str]:
        """
        Days during the week when maintenance should be performed.
        """
        return pulumi.get(self, "days_of_weeks")

    @property
    @pulumi.getter(name="hoursOfDays")
    def hours_of_days(self) -> Sequence[builtins.int]:
        """
        The window of hours during the day when maintenance should be performed.
        """
        return pulumi.get(self, "hours_of_days")

    @property
    @pulumi.getter(name="leadTimeInWeeks")
    def lead_time_in_weeks(self) -> builtins.int:
        """
        Lead time window allows user to set a lead time to prepare for a down time.
        """
        return pulumi.get(self, "lead_time_in_weeks")

    @property
    @pulumi.getter(name="monthlyPatchingEnabled")
    def monthly_patching_enabled(self) -> builtins.bool:
        """
        If true, enables the monthly patching option.
        """
        return pulumi.get(self, "monthly_patching_enabled")

    @property
    @pulumi.getter
    def months(self) -> Sequence[builtins.str]:
        """
        A `months` block as defined below.
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> builtins.str:
        """
        Cloud Exadata Infrastructure node patching method.
        """
        return pulumi.get(self, "patching_mode")

    @property
    @pulumi.getter
    def preference(self) -> builtins.str:
        """
        The maintenance window scheduling preference.
        """
        return pulumi.get(self, "preference")

    @property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Sequence[builtins.int]:
        """
        Weeks during the month when maintenance should be performed.
        """
        return pulumi.get(self, "weeks_of_months")


