# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContactProfileArgs', 'ContactProfile']

@pulumi.input_type
class ContactProfileArgs:
    def __init__(__self__, *,
                 auto_tracking: pulumi.Input[builtins.str],
                 links: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]],
                 minimum_variable_contact_duration: pulumi.Input[builtins.str],
                 network_configuration_subnet_id: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 event_hub_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_elevation_degrees: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ContactProfile resource.
        :param pulumi.Input[builtins.str] auto_tracking: Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        :param pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]] links: A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] minimum_variable_contact_duration: Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        :param pulumi.Input[builtins.str] network_configuration_subnet_id: ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] event_hub_uri: ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        :param pulumi.Input[builtins.str] location: The location where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] minimum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal degrees.
        :param pulumi.Input[builtins.str] name: The name of the contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "auto_tracking", auto_tracking)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "minimum_variable_contact_duration", minimum_variable_contact_duration)
        pulumi.set(__self__, "network_configuration_subnet_id", network_configuration_subnet_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if event_hub_uri is not None:
            pulumi.set(__self__, "event_hub_uri", event_hub_uri)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_elevation_degrees is not None:
            pulumi.set(__self__, "minimum_elevation_degrees", minimum_elevation_degrees)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoTracking")
    def auto_tracking(self) -> pulumi.Input[builtins.str]:
        """
        Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        """
        return pulumi.get(self, "auto_tracking")

    @auto_tracking.setter
    def auto_tracking(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auto_tracking", value)

    @property
    @pulumi.getter
    def links(self) -> pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]]:
        """
        A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter(name="minimumVariableContactDuration")
    def minimum_variable_contact_duration(self) -> pulumi.Input[builtins.str]:
        """
        Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        """
        return pulumi.get(self, "minimum_variable_contact_duration")

    @minimum_variable_contact_duration.setter
    def minimum_variable_contact_duration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "minimum_variable_contact_duration", value)

    @property
    @pulumi.getter(name="networkConfigurationSubnetId")
    def network_configuration_subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_configuration_subnet_id")

    @network_configuration_subnet_id.setter
    def network_configuration_subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_configuration_subnet_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="eventHubUri")
    def event_hub_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        """
        return pulumi.get(self, "event_hub_uri")

    @event_hub_uri.setter
    def event_hub_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_hub_uri", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the contact profile exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minimumElevationDegrees")
    def minimum_elevation_degrees(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum elevation of the antenna during the contact in decimal degrees.
        """
        return pulumi.get(self, "minimum_elevation_degrees")

    @minimum_elevation_degrees.setter
    def minimum_elevation_degrees(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "minimum_elevation_degrees", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the contact profile. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ContactProfileState:
    def __init__(__self__, *,
                 auto_tracking: Optional[pulumi.Input[builtins.str]] = None,
                 event_hub_uri: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_elevation_degrees: Optional[pulumi.Input[builtins.float]] = None,
                 minimum_variable_contact_duration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ContactProfile resources.
        :param pulumi.Input[builtins.str] auto_tracking: Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        :param pulumi.Input[builtins.str] event_hub_uri: ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        :param pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]] links: A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The location where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] minimum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal degrees.
        :param pulumi.Input[builtins.str] minimum_variable_contact_duration: Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        :param pulumi.Input[builtins.str] name: The name of the contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_configuration_subnet_id: ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if auto_tracking is not None:
            pulumi.set(__self__, "auto_tracking", auto_tracking)
        if event_hub_uri is not None:
            pulumi.set(__self__, "event_hub_uri", event_hub_uri)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_elevation_degrees is not None:
            pulumi.set(__self__, "minimum_elevation_degrees", minimum_elevation_degrees)
        if minimum_variable_contact_duration is not None:
            pulumi.set(__self__, "minimum_variable_contact_duration", minimum_variable_contact_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration_subnet_id is not None:
            pulumi.set(__self__, "network_configuration_subnet_id", network_configuration_subnet_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoTracking")
    def auto_tracking(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        """
        return pulumi.get(self, "auto_tracking")

    @auto_tracking.setter
    def auto_tracking(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_tracking", value)

    @property
    @pulumi.getter(name="eventHubUri")
    def event_hub_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        """
        return pulumi.get(self, "event_hub_uri")

    @event_hub_uri.setter
    def event_hub_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_hub_uri", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]]]:
        """
        A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the contact profile exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minimumElevationDegrees")
    def minimum_elevation_degrees(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum elevation of the antenna during the contact in decimal degrees.
        """
        return pulumi.get(self, "minimum_elevation_degrees")

    @minimum_elevation_degrees.setter
    def minimum_elevation_degrees(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "minimum_elevation_degrees", value)

    @property
    @pulumi.getter(name="minimumVariableContactDuration")
    def minimum_variable_contact_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        """
        return pulumi.get(self, "minimum_variable_contact_duration")

    @minimum_variable_contact_duration.setter
    def minimum_variable_contact_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_variable_contact_duration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the contact profile. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfigurationSubnetId")
    def network_configuration_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_configuration_subnet_id")

    @network_configuration_subnet_id.setter
    def network_configuration_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_configuration_subnet_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:orbital/contactProfile:ContactProfile")
class ContactProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_tracking: Optional[pulumi.Input[builtins.str]] = None,
                 event_hub_uri: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContactProfileLinkArgs', 'ContactProfileLinkArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_elevation_degrees: Optional[pulumi.Input[builtins.float]] = None,
                 minimum_variable_contact_duration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Contact profile.

        > **Note:** The `orbital.ContactProfile` resource has been deprecated and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="testvnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="testsubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "orbitalgateway",
                "service_delegation": {
                    "name": "Microsoft.Orbital/orbitalGateways",
                    "actions": [
                        "Microsoft.Network/publicIPAddresses/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/read",
                        "Microsoft.Network/publicIPAddresses/read",
                    ],
                },
            }])
        example_contact_profile = azure.orbital.ContactProfile("example",
            name="example-contact-profile",
            resource_group_name=example.name,
            location=example.location,
            minimum_variable_contact_duration="PT1M",
            auto_tracking="disabled",
            links=[{
                "channels": [{
                    "name": "channelname",
                    "bandwidth_mhz": 100,
                    "center_frequency_mhz": 101,
                    "end_points": [{
                        "end_point_name": "AQUA_command",
                        "ip_address": "10.0.1.0",
                        "port": "49513",
                        "protocol": "TCP",
                    }],
                }],
                "direction": "Uplink",
                "name": "RHCP_UL",
                "polarization": "RHCP",
            }],
            network_configuration_subnet_id=example_subnet.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Orbital`: 2022-11-01

        ## Import

        Contact profile can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:orbital/contactProfile:ContactProfile example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Orbital/contactProfiles/contactProfile1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_tracking: Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        :param pulumi.Input[builtins.str] event_hub_uri: ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContactProfileLinkArgs', 'ContactProfileLinkArgsDict']]]] links: A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The location where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] minimum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal degrees.
        :param pulumi.Input[builtins.str] minimum_variable_contact_duration: Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        :param pulumi.Input[builtins.str] name: The name of the contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_configuration_subnet_id: ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContactProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Contact profile.

        > **Note:** The `orbital.ContactProfile` resource has been deprecated and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="testvnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="testsubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "orbitalgateway",
                "service_delegation": {
                    "name": "Microsoft.Orbital/orbitalGateways",
                    "actions": [
                        "Microsoft.Network/publicIPAddresses/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/read",
                        "Microsoft.Network/publicIPAddresses/read",
                    ],
                },
            }])
        example_contact_profile = azure.orbital.ContactProfile("example",
            name="example-contact-profile",
            resource_group_name=example.name,
            location=example.location,
            minimum_variable_contact_duration="PT1M",
            auto_tracking="disabled",
            links=[{
                "channels": [{
                    "name": "channelname",
                    "bandwidth_mhz": 100,
                    "center_frequency_mhz": 101,
                    "end_points": [{
                        "end_point_name": "AQUA_command",
                        "ip_address": "10.0.1.0",
                        "port": "49513",
                        "protocol": "TCP",
                    }],
                }],
                "direction": "Uplink",
                "name": "RHCP_UL",
                "polarization": "RHCP",
            }],
            network_configuration_subnet_id=example_subnet.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Orbital`: 2022-11-01

        ## Import

        Contact profile can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:orbital/contactProfile:ContactProfile example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Orbital/contactProfiles/contactProfile1
        ```

        :param str resource_name: The name of the resource.
        :param ContactProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_tracking: Optional[pulumi.Input[builtins.str]] = None,
                 event_hub_uri: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContactProfileLinkArgs', 'ContactProfileLinkArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_elevation_degrees: Optional[pulumi.Input[builtins.float]] = None,
                 minimum_variable_contact_duration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactProfileArgs.__new__(ContactProfileArgs)

            if auto_tracking is None and not opts.urn:
                raise TypeError("Missing required property 'auto_tracking'")
            __props__.__dict__["auto_tracking"] = auto_tracking
            __props__.__dict__["event_hub_uri"] = event_hub_uri
            if links is None and not opts.urn:
                raise TypeError("Missing required property 'links'")
            __props__.__dict__["links"] = links
            __props__.__dict__["location"] = location
            __props__.__dict__["minimum_elevation_degrees"] = minimum_elevation_degrees
            if minimum_variable_contact_duration is None and not opts.urn:
                raise TypeError("Missing required property 'minimum_variable_contact_duration'")
            __props__.__dict__["minimum_variable_contact_duration"] = minimum_variable_contact_duration
            __props__.__dict__["name"] = name
            if network_configuration_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration_subnet_id'")
            __props__.__dict__["network_configuration_subnet_id"] = network_configuration_subnet_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
        super(ContactProfile, __self__).__init__(
            'azure:orbital/contactProfile:ContactProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_tracking: Optional[pulumi.Input[builtins.str]] = None,
            event_hub_uri: Optional[pulumi.Input[builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContactProfileLinkArgs', 'ContactProfileLinkArgsDict']]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            minimum_elevation_degrees: Optional[pulumi.Input[builtins.float]] = None,
            minimum_variable_contact_duration: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_configuration_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'ContactProfile':
        """
        Get an existing ContactProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_tracking: Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        :param pulumi.Input[builtins.str] event_hub_uri: ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContactProfileLinkArgs', 'ContactProfileLinkArgsDict']]]] links: A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The location where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] minimum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal degrees.
        :param pulumi.Input[builtins.str] minimum_variable_contact_duration: Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        :param pulumi.Input[builtins.str] name: The name of the contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_configuration_subnet_id: ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContactProfileState.__new__(_ContactProfileState)

        __props__.__dict__["auto_tracking"] = auto_tracking
        __props__.__dict__["event_hub_uri"] = event_hub_uri
        __props__.__dict__["links"] = links
        __props__.__dict__["location"] = location
        __props__.__dict__["minimum_elevation_degrees"] = minimum_elevation_degrees
        __props__.__dict__["minimum_variable_contact_duration"] = minimum_variable_contact_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["network_configuration_subnet_id"] = network_configuration_subnet_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return ContactProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoTracking")
    def auto_tracking(self) -> pulumi.Output[builtins.str]:
        """
        Auto-tracking configurations for a spacecraft. Possible values are `disabled`, `xBand` and `sBand`.
        """
        return pulumi.get(self, "auto_tracking")

    @property
    @pulumi.getter(name="eventHubUri")
    def event_hub_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
        """
        return pulumi.get(self, "event_hub_uri")

    @property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ContactProfileLink']]:
        """
        A list of spacecraft links. A `links` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the contact profile exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="minimumElevationDegrees")
    def minimum_elevation_degrees(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Maximum elevation of the antenna during the contact in decimal degrees.
        """
        return pulumi.get(self, "minimum_elevation_degrees")

    @property
    @pulumi.getter(name="minimumVariableContactDuration")
    def minimum_variable_contact_duration(self) -> pulumi.Output[builtins.str]:
        """
        Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
        """
        return pulumi.get(self, "minimum_variable_contact_duration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the contact profile. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfigurationSubnetId")
    def network_configuration_subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_configuration_subnet_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the contact profile exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

