# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLocalRulestackResult',
    'AwaitableGetLocalRulestackResult',
    'get_local_rulestack',
    'get_local_rulestack_output',
]

@pulumi.output_type
class GetLocalRulestackResult:
    """
    A collection of values returned by getLocalRulestack.
    """
    def __init__(__self__, anti_spyware_profile=None, anti_virus_profile=None, description=None, dns_subscription=None, file_blocking_profile=None, id=None, location=None, name=None, outbound_trust_certificate=None, outbound_untrust_certificate=None, resource_group_name=None, url_filtering_profile=None, vulnerability_profile=None):
        if anti_spyware_profile and not isinstance(anti_spyware_profile, str):
            raise TypeError("Expected argument 'anti_spyware_profile' to be a str")
        pulumi.set(__self__, "anti_spyware_profile", anti_spyware_profile)
        if anti_virus_profile and not isinstance(anti_virus_profile, str):
            raise TypeError("Expected argument 'anti_virus_profile' to be a str")
        pulumi.set(__self__, "anti_virus_profile", anti_virus_profile)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_subscription and not isinstance(dns_subscription, str):
            raise TypeError("Expected argument 'dns_subscription' to be a str")
        pulumi.set(__self__, "dns_subscription", dns_subscription)
        if file_blocking_profile and not isinstance(file_blocking_profile, str):
            raise TypeError("Expected argument 'file_blocking_profile' to be a str")
        pulumi.set(__self__, "file_blocking_profile", file_blocking_profile)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_trust_certificate and not isinstance(outbound_trust_certificate, str):
            raise TypeError("Expected argument 'outbound_trust_certificate' to be a str")
        pulumi.set(__self__, "outbound_trust_certificate", outbound_trust_certificate)
        if outbound_untrust_certificate and not isinstance(outbound_untrust_certificate, str):
            raise TypeError("Expected argument 'outbound_untrust_certificate' to be a str")
        pulumi.set(__self__, "outbound_untrust_certificate", outbound_untrust_certificate)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if url_filtering_profile and not isinstance(url_filtering_profile, str):
            raise TypeError("Expected argument 'url_filtering_profile' to be a str")
        pulumi.set(__self__, "url_filtering_profile", url_filtering_profile)
        if vulnerability_profile and not isinstance(vulnerability_profile, str):
            raise TypeError("Expected argument 'vulnerability_profile' to be a str")
        pulumi.set(__self__, "vulnerability_profile", vulnerability_profile)

    @property
    @pulumi.getter(name="antiSpywareProfile")
    def anti_spyware_profile(self) -> builtins.str:
        """
        The Anti-Spyware setting used by the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "anti_spyware_profile")

    @property
    @pulumi.getter(name="antiVirusProfile")
    def anti_virus_profile(self) -> builtins.str:
        """
        The Anti-Virus setting used by the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "anti_virus_profile")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsSubscription")
    def dns_subscription(self) -> builtins.str:
        """
        The DNS Subscription setting used by the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "dns_subscription")

    @property
    @pulumi.getter(name="fileBlockingProfile")
    def file_blocking_profile(self) -> builtins.str:
        """
        The File Blocking Profile used by the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "file_blocking_profile")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Palo Alto Networks Rulestack exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundTrustCertificate")
    def outbound_trust_certificate(self) -> builtins.str:
        """
        The trusted egress decryption profile data for the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "outbound_trust_certificate")

    @property
    @pulumi.getter(name="outboundUntrustCertificate")
    def outbound_untrust_certificate(self) -> builtins.str:
        """
        The untrusted egress decryption profile data for the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "outbound_untrust_certificate")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="urlFilteringProfile")
    def url_filtering_profile(self) -> builtins.str:
        """
        The URL Filtering Profile used by the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "url_filtering_profile")

    @property
    @pulumi.getter(name="vulnerabilityProfile")
    def vulnerability_profile(self) -> builtins.str:
        """
        The Vulnerability Profile used by the Palo Alto Networks Rulestack.
        """
        return pulumi.get(self, "vulnerability_profile")


class AwaitableGetLocalRulestackResult(GetLocalRulestackResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalRulestackResult(
            anti_spyware_profile=self.anti_spyware_profile,
            anti_virus_profile=self.anti_virus_profile,
            description=self.description,
            dns_subscription=self.dns_subscription,
            file_blocking_profile=self.file_blocking_profile,
            id=self.id,
            location=self.location,
            name=self.name,
            outbound_trust_certificate=self.outbound_trust_certificate,
            outbound_untrust_certificate=self.outbound_untrust_certificate,
            resource_group_name=self.resource_group_name,
            url_filtering_profile=self.url_filtering_profile,
            vulnerability_profile=self.vulnerability_profile)


def get_local_rulestack(name: Optional[builtins.str] = None,
                        resource_group_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalRulestackResult:
    """
    Use this data source to access information about an existing Palo Alto Networks Rulestack.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.paloalto.get_local_rulestack(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `PaloAltoNetworks.Cloudngfw`: 2022-08-29


    :param builtins.str name: The name of this Palo Alto Networks Rulestack.
    :param builtins.str resource_group_name: The name of the Resource Group where the Palo Alto Networks Rulestack exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:paloalto/getLocalRulestack:getLocalRulestack', __args__, opts=opts, typ=GetLocalRulestackResult).value

    return AwaitableGetLocalRulestackResult(
        anti_spyware_profile=pulumi.get(__ret__, 'anti_spyware_profile'),
        anti_virus_profile=pulumi.get(__ret__, 'anti_virus_profile'),
        description=pulumi.get(__ret__, 'description'),
        dns_subscription=pulumi.get(__ret__, 'dns_subscription'),
        file_blocking_profile=pulumi.get(__ret__, 'file_blocking_profile'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        outbound_trust_certificate=pulumi.get(__ret__, 'outbound_trust_certificate'),
        outbound_untrust_certificate=pulumi.get(__ret__, 'outbound_untrust_certificate'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        url_filtering_profile=pulumi.get(__ret__, 'url_filtering_profile'),
        vulnerability_profile=pulumi.get(__ret__, 'vulnerability_profile'))
def get_local_rulestack_output(name: Optional[pulumi.Input[builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocalRulestackResult]:
    """
    Use this data source to access information about an existing Palo Alto Networks Rulestack.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.paloalto.get_local_rulestack(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `PaloAltoNetworks.Cloudngfw`: 2022-08-29


    :param builtins.str name: The name of this Palo Alto Networks Rulestack.
    :param builtins.str resource_group_name: The name of the Resource Group where the Palo Alto Networks Rulestack exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:paloalto/getLocalRulestack:getLocalRulestack', __args__, opts=opts, typ=GetLocalRulestackResult)
    return __ret__.apply(lambda __response__: GetLocalRulestackResult(
        anti_spyware_profile=pulumi.get(__response__, 'anti_spyware_profile'),
        anti_virus_profile=pulumi.get(__response__, 'anti_virus_profile'),
        description=pulumi.get(__response__, 'description'),
        dns_subscription=pulumi.get(__response__, 'dns_subscription'),
        file_blocking_profile=pulumi.get(__response__, 'file_blocking_profile'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        outbound_trust_certificate=pulumi.get(__response__, 'outbound_trust_certificate'),
        outbound_untrust_certificate=pulumi.get(__response__, 'outbound_untrust_certificate'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        url_filtering_profile=pulumi.get(__response__, 'url_filtering_profile'),
        vulnerability_profile=pulumi.get(__response__, 'vulnerability_profile')))
