# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EligibleRoleAssignmentArgs', 'EligibleRoleAssignment']

@pulumi.input_type
class EligibleRoleAssignmentArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[builtins.str],
                 role_definition_id: pulumi.Input[builtins.str],
                 scope: pulumi.Input[builtins.str],
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['EligibleRoleAssignmentScheduleArgs']] = None,
                 ticket: Optional[pulumi.Input['EligibleRoleAssignmentTicketArgs']] = None):
        """
        The set of arguments for constructing a EligibleRoleAssignment resource.
        :param pulumi.Input[builtins.str] principal_id: Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_definition_id: The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scope: The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        :param pulumi.Input[builtins.str] justification: The justification of the role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input['EligibleRoleAssignmentScheduleArgs'] schedule: A `schedule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['EligibleRoleAssignmentTicketArgs'] ticket: A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        pulumi.set(__self__, "scope", scope)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if condition_version is not None:
            pulumi.set(__self__, "condition_version", condition_version)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if ticket is not None:
            pulumi.set(__self__, "ticket", ticket)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[builtins.str]:
        """
        Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Input[builtins.str]:
        """
        The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_definition_id", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[builtins.str]:
        """
        The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.

        > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        """
        return pulumi.get(self, "condition_version")

    @condition_version.setter
    def condition_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_version", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The justification of the role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "justification", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['EligibleRoleAssignmentScheduleArgs']]:
        """
        A `schedule` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['EligibleRoleAssignmentScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def ticket(self) -> Optional[pulumi.Input['EligibleRoleAssignmentTicketArgs']]:
        """
        A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ticket")

    @ticket.setter
    def ticket(self, value: Optional[pulumi.Input['EligibleRoleAssignmentTicketArgs']]):
        pulumi.set(self, "ticket", value)


@pulumi.input_type
class _EligibleRoleAssignmentState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['EligibleRoleAssignmentScheduleArgs']] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 ticket: Optional[pulumi.Input['EligibleRoleAssignmentTicketArgs']] = None):
        """
        Input properties used for looking up and filtering EligibleRoleAssignment resources.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        :param pulumi.Input[builtins.str] justification: The justification of the role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_id: Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_type: Type of principal to which the role will be assigned.
        :param pulumi.Input[builtins.str] role_definition_id: The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input['EligibleRoleAssignmentScheduleArgs'] schedule: A `schedule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scope: The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input['EligibleRoleAssignmentTicketArgs'] ticket: A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if condition_version is not None:
            pulumi.set(__self__, "condition_version", condition_version)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if ticket is not None:
            pulumi.set(__self__, "ticket", ticket)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.

        > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        """
        return pulumi.get(self, "condition_version")

    @condition_version.setter
    def condition_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_version", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The justification of the role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "justification", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of principal to which the role will be assigned.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['EligibleRoleAssignmentScheduleArgs']]:
        """
        A `schedule` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['EligibleRoleAssignmentScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def ticket(self) -> Optional[pulumi.Input['EligibleRoleAssignmentTicketArgs']]:
        """
        A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ticket")

    @ticket.setter
    def ticket(self, value: Optional[pulumi.Input['EligibleRoleAssignmentTicketArgs']]):
        pulumi.set(self, "ticket", value)


@pulumi.type_token("azure:pim/eligibleRoleAssignment:EligibleRoleAssignment")
class EligibleRoleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['EligibleRoleAssignmentScheduleArgs', 'EligibleRoleAssignmentScheduleArgsDict']]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 ticket: Optional[pulumi.Input[Union['EligibleRoleAssignmentTicketArgs', 'EligibleRoleAssignmentTicketArgsDict']]] = None,
                 __props__=None):
        """
        Manages a PIM Eligible Role Assignment.

        ## Example Usage

        ### Subscription)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumiverse_time as time

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_get_role_definition = azure.authorization.get_role_definition(name="Reader")
        example_static = time.Static("example")
        example_eligible_role_assignment = azure.pim.EligibleRoleAssignment("example",
            scope=primary.id,
            role_definition_id=f"{primary.id}{example_get_role_definition.id}",
            principal_id=example.object_id,
            schedule={
                "start_date_time": example_static.rfc3339,
                "expiration": {
                    "duration_hours": 8,
                },
            },
            justification="Expiration Duration Set",
            ticket={
                "number": "1",
                "system": "example ticket system",
            })
        ```

        ### Management Group)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumiverse_time as time

        example = azure.core.get_client_config()
        example_get_role_definition = azure.authorization.get_role_definition(name="Reader")
        example_group = azure.management.Group("example", name="Example-Management-Group")
        example_static = time.Static("example")
        example_eligible_role_assignment = azure.pim.EligibleRoleAssignment("example",
            scope=example_group.id,
            role_definition_id=example_get_role_definition.id,
            principal_id=example.object_id,
            schedule={
                "start_date_time": example_static.rfc3339,
                "expiration": {
                    "duration_hours": 8,
                },
            },
            justification="Expiration Duration Set",
            ticket={
                "number": "1",
                "system": "example ticket system",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization`: 2020-10-01

        ## Import

        PIM Eligible Role Assignments can be imported using the following composite resource ID, e.g.

        ```sh
        $ pulumi import azure:pim/eligibleRoleAssignment:EligibleRoleAssignment example /subscriptions/00000000-0000-0000-0000-000000000000|/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleDefinitions/00000000-0000-0000-0000-000000000000|00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        :param pulumi.Input[builtins.str] justification: The justification of the role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_id: Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_definition_id: The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EligibleRoleAssignmentScheduleArgs', 'EligibleRoleAssignmentScheduleArgsDict']] schedule: A `schedule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scope: The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EligibleRoleAssignmentTicketArgs', 'EligibleRoleAssignmentTicketArgsDict']] ticket: A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EligibleRoleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PIM Eligible Role Assignment.

        ## Example Usage

        ### Subscription)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumiverse_time as time

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_get_role_definition = azure.authorization.get_role_definition(name="Reader")
        example_static = time.Static("example")
        example_eligible_role_assignment = azure.pim.EligibleRoleAssignment("example",
            scope=primary.id,
            role_definition_id=f"{primary.id}{example_get_role_definition.id}",
            principal_id=example.object_id,
            schedule={
                "start_date_time": example_static.rfc3339,
                "expiration": {
                    "duration_hours": 8,
                },
            },
            justification="Expiration Duration Set",
            ticket={
                "number": "1",
                "system": "example ticket system",
            })
        ```

        ### Management Group)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumiverse_time as time

        example = azure.core.get_client_config()
        example_get_role_definition = azure.authorization.get_role_definition(name="Reader")
        example_group = azure.management.Group("example", name="Example-Management-Group")
        example_static = time.Static("example")
        example_eligible_role_assignment = azure.pim.EligibleRoleAssignment("example",
            scope=example_group.id,
            role_definition_id=example_get_role_definition.id,
            principal_id=example.object_id,
            schedule={
                "start_date_time": example_static.rfc3339,
                "expiration": {
                    "duration_hours": 8,
                },
            },
            justification="Expiration Duration Set",
            ticket={
                "number": "1",
                "system": "example ticket system",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization`: 2020-10-01

        ## Import

        PIM Eligible Role Assignments can be imported using the following composite resource ID, e.g.

        ```sh
        $ pulumi import azure:pim/eligibleRoleAssignment:EligibleRoleAssignment example /subscriptions/00000000-0000-0000-0000-000000000000|/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleDefinitions/00000000-0000-0000-0000-000000000000|00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param EligibleRoleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EligibleRoleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['EligibleRoleAssignmentScheduleArgs', 'EligibleRoleAssignmentScheduleArgsDict']]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 ticket: Optional[pulumi.Input[Union['EligibleRoleAssignmentTicketArgs', 'EligibleRoleAssignmentTicketArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EligibleRoleAssignmentArgs.__new__(EligibleRoleAssignmentArgs)

            __props__.__dict__["condition"] = condition
            __props__.__dict__["condition_version"] = condition_version
            __props__.__dict__["justification"] = justification
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if role_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_definition_id'")
            __props__.__dict__["role_definition_id"] = role_definition_id
            __props__.__dict__["schedule"] = schedule
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["ticket"] = ticket
            __props__.__dict__["principal_type"] = None
        super(EligibleRoleAssignment, __self__).__init__(
            'azure:pim/eligibleRoleAssignment:EligibleRoleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[builtins.str]] = None,
            condition_version: Optional[pulumi.Input[builtins.str]] = None,
            justification: Optional[pulumi.Input[builtins.str]] = None,
            principal_id: Optional[pulumi.Input[builtins.str]] = None,
            principal_type: Optional[pulumi.Input[builtins.str]] = None,
            role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['EligibleRoleAssignmentScheduleArgs', 'EligibleRoleAssignmentScheduleArgsDict']]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            ticket: Optional[pulumi.Input[Union['EligibleRoleAssignmentTicketArgs', 'EligibleRoleAssignmentTicketArgsDict']]] = None) -> 'EligibleRoleAssignment':
        """
        Get an existing EligibleRoleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        :param pulumi.Input[builtins.str] justification: The justification of the role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_id: Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_type: Type of principal to which the role will be assigned.
        :param pulumi.Input[builtins.str] role_definition_id: The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EligibleRoleAssignmentScheduleArgs', 'EligibleRoleAssignmentScheduleArgsDict']] schedule: A `schedule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scope: The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EligibleRoleAssignmentTicketArgs', 'EligibleRoleAssignmentTicketArgsDict']] ticket: A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EligibleRoleAssignmentState.__new__(_EligibleRoleAssignmentState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["condition_version"] = condition_version
        __props__.__dict__["justification"] = justification
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["role_definition_id"] = role_definition_id
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["scope"] = scope
        __props__.__dict__["ticket"] = ticket
        return EligibleRoleAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. See the [official conditions documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/conditions-overview#what-are-role-assignment-conditions) for details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the condition. Supported values include `2.0`. Changing this forces a new resource to be created.

        > **Note:** `condition_version` is required when specifying `condition` and vice versa.
        """
        return pulumi.get(self, "condition_version")

    @property
    @pulumi.getter
    def justification(self) -> pulumi.Output[builtins.str]:
        """
        The justification of the role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "justification")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[builtins.str]:
        """
        Object ID of the principal for this eligible role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of principal to which the role will be assigned.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Output[builtins.str]:
        """
        The role definition ID for this eligible role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.EligibleRoleAssignmentSchedule']:
        """
        A `schedule` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        The scope for this eligible role assignment, should be a valid resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def ticket(self) -> pulumi.Output['outputs.EligibleRoleAssignmentTicket']:
        """
        A `ticket` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ticket")

