# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ActiveRoleAssignmentSchedule',
    'ActiveRoleAssignmentScheduleExpiration',
    'ActiveRoleAssignmentTicket',
    'EligibleRoleAssignmentSchedule',
    'EligibleRoleAssignmentScheduleExpiration',
    'EligibleRoleAssignmentTicket',
    'RoleManagementPolicyActivationRules',
    'RoleManagementPolicyActivationRulesApprovalStage',
    'RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover',
    'RoleManagementPolicyActiveAssignmentRules',
    'RoleManagementPolicyEligibleAssignmentRules',
    'RoleManagementPolicyNotificationRules',
    'RoleManagementPolicyNotificationRulesActiveAssignments',
    'RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications',
    'RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications',
    'RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications',
    'RoleManagementPolicyNotificationRulesEligibleActivations',
    'RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications',
    'RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications',
    'RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications',
    'RoleManagementPolicyNotificationRulesEligibleAssignments',
    'RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications',
    'RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications',
    'RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications',
    'GetRoleAssignmentsRoleAssignmentResult',
    'GetRoleManagementPolicyActivationRuleResult',
    'GetRoleManagementPolicyActivationRuleApprovalStageResult',
    'GetRoleManagementPolicyActivationRuleApprovalStagePrimaryApproverResult',
    'GetRoleManagementPolicyActiveAssignmentRuleResult',
    'GetRoleManagementPolicyEligibleAssignmentRuleResult',
    'GetRoleManagementPolicyNotificationRuleResult',
    'GetRoleManagementPolicyNotificationRuleActiveAssignmentResult',
    'GetRoleManagementPolicyNotificationRuleActiveAssignmentAdminNotificationResult',
    'GetRoleManagementPolicyNotificationRuleActiveAssignmentApproverNotificationResult',
    'GetRoleManagementPolicyNotificationRuleActiveAssignmentAssigneeNotificationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleActivationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleActivationAdminNotificationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleActivationApproverNotificationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleActivationAssigneeNotificationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleAssignmentResult',
    'GetRoleManagementPolicyNotificationRuleEligibleAssignmentAdminNotificationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleAssignmentApproverNotificationResult',
    'GetRoleManagementPolicyNotificationRuleEligibleAssignmentAssigneeNotificationResult',
]

@pulumi.output_type
class ActiveRoleAssignmentSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startDateTime":
            suggest = "start_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveRoleAssignmentSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveRoleAssignmentSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveRoleAssignmentSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration: Optional['outputs.ActiveRoleAssignmentScheduleExpiration'] = None,
                 start_date_time: Optional[builtins.str] = None):
        """
        :param 'ActiveRoleAssignmentScheduleExpirationArgs' expiration: An `expiration` block as defined above.
        :param builtins.str start_date_time: The start date/time of the role assignment. Changing this forces a new resource to be created.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if start_date_time is not None:
            pulumi.set(__self__, "start_date_time", start_date_time)

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.ActiveRoleAssignmentScheduleExpiration']:
        """
        An `expiration` block as defined above.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="startDateTime")
    def start_date_time(self) -> Optional[builtins.str]:
        """
        The start date/time of the role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "start_date_time")


@pulumi.output_type
class ActiveRoleAssignmentScheduleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationDays":
            suggest = "duration_days"
        elif key == "durationHours":
            suggest = "duration_hours"
        elif key == "endDateTime":
            suggest = "end_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveRoleAssignmentScheduleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveRoleAssignmentScheduleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveRoleAssignmentScheduleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_days: Optional[builtins.int] = None,
                 duration_hours: Optional[builtins.int] = None,
                 end_date_time: Optional[builtins.str] = None):
        """
        :param builtins.int duration_days: The duration of the role assignment in days. Changing this forces a new resource to be created.
        :param builtins.int duration_hours: The duration of the role assignment in hours. Changing this forces a new resource to be created.
        :param builtins.str end_date_time: The end date/time of the role assignment. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `duration_days`, `duration_hours` or `end_date_time` should be specified.
        """
        if duration_days is not None:
            pulumi.set(__self__, "duration_days", duration_days)
        if duration_hours is not None:
            pulumi.set(__self__, "duration_hours", duration_hours)
        if end_date_time is not None:
            pulumi.set(__self__, "end_date_time", end_date_time)

    @property
    @pulumi.getter(name="durationDays")
    def duration_days(self) -> Optional[builtins.int]:
        """
        The duration of the role assignment in days. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_days")

    @property
    @pulumi.getter(name="durationHours")
    def duration_hours(self) -> Optional[builtins.int]:
        """
        The duration of the role assignment in hours. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_hours")

    @property
    @pulumi.getter(name="endDateTime")
    def end_date_time(self) -> Optional[builtins.str]:
        """
        The end date/time of the role assignment. Changing this forces a new resource to be created.

        > **Note:** Only one of `duration_days`, `duration_hours` or `end_date_time` should be specified.
        """
        return pulumi.get(self, "end_date_time")


@pulumi.output_type
class ActiveRoleAssignmentTicket(dict):
    def __init__(__self__, *,
                 number: Optional[builtins.str] = None,
                 system: Optional[builtins.str] = None):
        """
        :param builtins.str number: User-supplied ticket number to be included with the request. Changing this forces a new resource to be created.
        :param builtins.str system: User-supplied ticket system name to be included with the request. Changing this forces a new resource to be created.
        """
        if number is not None:
            pulumi.set(__self__, "number", number)
        if system is not None:
            pulumi.set(__self__, "system", system)

    @property
    @pulumi.getter
    def number(self) -> Optional[builtins.str]:
        """
        User-supplied ticket number to be included with the request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def system(self) -> Optional[builtins.str]:
        """
        User-supplied ticket system name to be included with the request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system")


@pulumi.output_type
class EligibleRoleAssignmentSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startDateTime":
            suggest = "start_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EligibleRoleAssignmentSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EligibleRoleAssignmentSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EligibleRoleAssignmentSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration: Optional['outputs.EligibleRoleAssignmentScheduleExpiration'] = None,
                 start_date_time: Optional[builtins.str] = None):
        """
        :param 'EligibleRoleAssignmentScheduleExpirationArgs' expiration: An `expiration` block as defined above.
        :param builtins.str start_date_time: The start date/time of the role assignment. Changing this forces a new resource to be created.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if start_date_time is not None:
            pulumi.set(__self__, "start_date_time", start_date_time)

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.EligibleRoleAssignmentScheduleExpiration']:
        """
        An `expiration` block as defined above.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="startDateTime")
    def start_date_time(self) -> Optional[builtins.str]:
        """
        The start date/time of the role assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "start_date_time")


@pulumi.output_type
class EligibleRoleAssignmentScheduleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationDays":
            suggest = "duration_days"
        elif key == "durationHours":
            suggest = "duration_hours"
        elif key == "endDateTime":
            suggest = "end_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EligibleRoleAssignmentScheduleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EligibleRoleAssignmentScheduleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EligibleRoleAssignmentScheduleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_days: Optional[builtins.int] = None,
                 duration_hours: Optional[builtins.int] = None,
                 end_date_time: Optional[builtins.str] = None):
        """
        :param builtins.int duration_days: The duration of the role assignment in days. Changing this forces a new resource to be created.
        :param builtins.int duration_hours: The duration of the role assignment in hours. Changing this forces a new resource to be created.
        :param builtins.str end_date_time: The end date/time of the role assignment. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `duration_days`, `duration_hours` or `end_date_time` should be specified.
        """
        if duration_days is not None:
            pulumi.set(__self__, "duration_days", duration_days)
        if duration_hours is not None:
            pulumi.set(__self__, "duration_hours", duration_hours)
        if end_date_time is not None:
            pulumi.set(__self__, "end_date_time", end_date_time)

    @property
    @pulumi.getter(name="durationDays")
    def duration_days(self) -> Optional[builtins.int]:
        """
        The duration of the role assignment in days. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_days")

    @property
    @pulumi.getter(name="durationHours")
    def duration_hours(self) -> Optional[builtins.int]:
        """
        The duration of the role assignment in hours. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_hours")

    @property
    @pulumi.getter(name="endDateTime")
    def end_date_time(self) -> Optional[builtins.str]:
        """
        The end date/time of the role assignment. Changing this forces a new resource to be created.

        > **Note:** Only one of `duration_days`, `duration_hours` or `end_date_time` should be specified.
        """
        return pulumi.get(self, "end_date_time")


@pulumi.output_type
class EligibleRoleAssignmentTicket(dict):
    def __init__(__self__, *,
                 number: Optional[builtins.str] = None,
                 system: Optional[builtins.str] = None):
        """
        :param builtins.str number: User-supplied ticket number to be included with the request. Changing this forces a new resource to be created.
        :param builtins.str system: User-supplied ticket system name to be included with the request. Changing this forces a new resource to be created.
        """
        if number is not None:
            pulumi.set(__self__, "number", number)
        if system is not None:
            pulumi.set(__self__, "system", system)

    @property
    @pulumi.getter
    def number(self) -> Optional[builtins.str]:
        """
        User-supplied ticket number to be included with the request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def system(self) -> Optional[builtins.str]:
        """
        User-supplied ticket system name to be included with the request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system")


@pulumi.output_type
class RoleManagementPolicyActivationRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalStage":
            suggest = "approval_stage"
        elif key == "maximumDuration":
            suggest = "maximum_duration"
        elif key == "requireApproval":
            suggest = "require_approval"
        elif key == "requireJustification":
            suggest = "require_justification"
        elif key == "requireMultifactorAuthentication":
            suggest = "require_multifactor_authentication"
        elif key == "requireTicketInfo":
            suggest = "require_ticket_info"
        elif key == "requiredConditionalAccessAuthenticationContext":
            suggest = "required_conditional_access_authentication_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyActivationRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyActivationRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyActivationRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_stage: Optional['outputs.RoleManagementPolicyActivationRulesApprovalStage'] = None,
                 maximum_duration: Optional[builtins.str] = None,
                 require_approval: Optional[builtins.bool] = None,
                 require_justification: Optional[builtins.bool] = None,
                 require_multifactor_authentication: Optional[builtins.bool] = None,
                 require_ticket_info: Optional[builtins.bool] = None,
                 required_conditional_access_authentication_context: Optional[builtins.str] = None):
        """
        :param 'RoleManagementPolicyActivationRulesApprovalStageArgs' approval_stage: An `approval_stage` block as defined below.
        :param builtins.str maximum_duration: The maximum length of time an activated role can be valid, in an ISO8601 Duration format (e.g. `PT8H`). Valid range is `PT30M` to `PT23H30M`, in 30 minute increments, or `PT1D`.
        :param builtins.bool require_approval: Is approval required for activation. If `true` an `approval_stage` block must be provided.
        :param builtins.bool require_justification: Is a justification required during activation of the role.
        :param builtins.bool require_multifactor_authentication: Is multi-factor authentication required to activate the role. Conflicts with `required_conditional_access_authentication_context`.
        :param builtins.bool require_ticket_info: Is ticket information requrired during activation of the role.
        :param builtins.str required_conditional_access_authentication_context: The Entra ID Conditional Access context that must be present for activation. Conflicts with `require_multifactor_authentication`.
        """
        if approval_stage is not None:
            pulumi.set(__self__, "approval_stage", approval_stage)
        if maximum_duration is not None:
            pulumi.set(__self__, "maximum_duration", maximum_duration)
        if require_approval is not None:
            pulumi.set(__self__, "require_approval", require_approval)
        if require_justification is not None:
            pulumi.set(__self__, "require_justification", require_justification)
        if require_multifactor_authentication is not None:
            pulumi.set(__self__, "require_multifactor_authentication", require_multifactor_authentication)
        if require_ticket_info is not None:
            pulumi.set(__self__, "require_ticket_info", require_ticket_info)
        if required_conditional_access_authentication_context is not None:
            pulumi.set(__self__, "required_conditional_access_authentication_context", required_conditional_access_authentication_context)

    @property
    @pulumi.getter(name="approvalStage")
    def approval_stage(self) -> Optional['outputs.RoleManagementPolicyActivationRulesApprovalStage']:
        """
        An `approval_stage` block as defined below.
        """
        return pulumi.get(self, "approval_stage")

    @property
    @pulumi.getter(name="maximumDuration")
    def maximum_duration(self) -> Optional[builtins.str]:
        """
        The maximum length of time an activated role can be valid, in an ISO8601 Duration format (e.g. `PT8H`). Valid range is `PT30M` to `PT23H30M`, in 30 minute increments, or `PT1D`.
        """
        return pulumi.get(self, "maximum_duration")

    @property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> Optional[builtins.bool]:
        """
        Is approval required for activation. If `true` an `approval_stage` block must be provided.
        """
        return pulumi.get(self, "require_approval")

    @property
    @pulumi.getter(name="requireJustification")
    def require_justification(self) -> Optional[builtins.bool]:
        """
        Is a justification required during activation of the role.
        """
        return pulumi.get(self, "require_justification")

    @property
    @pulumi.getter(name="requireMultifactorAuthentication")
    def require_multifactor_authentication(self) -> Optional[builtins.bool]:
        """
        Is multi-factor authentication required to activate the role. Conflicts with `required_conditional_access_authentication_context`.
        """
        return pulumi.get(self, "require_multifactor_authentication")

    @property
    @pulumi.getter(name="requireTicketInfo")
    def require_ticket_info(self) -> Optional[builtins.bool]:
        """
        Is ticket information requrired during activation of the role.
        """
        return pulumi.get(self, "require_ticket_info")

    @property
    @pulumi.getter(name="requiredConditionalAccessAuthenticationContext")
    def required_conditional_access_authentication_context(self) -> Optional[builtins.str]:
        """
        The Entra ID Conditional Access context that must be present for activation. Conflicts with `require_multifactor_authentication`.
        """
        return pulumi.get(self, "required_conditional_access_authentication_context")


@pulumi.output_type
class RoleManagementPolicyActivationRulesApprovalStage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryApprovers":
            suggest = "primary_approvers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyActivationRulesApprovalStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyActivationRulesApprovalStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyActivationRulesApprovalStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_approvers: Sequence['outputs.RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover']):
        """
        :param Sequence['RoleManagementPolicyActivationRulesApprovalStagePrimaryApproverArgs'] primary_approvers: The IDs of the users or groups who can approve the activation
        """
        pulumi.set(__self__, "primary_approvers", primary_approvers)

    @property
    @pulumi.getter(name="primaryApprovers")
    def primary_approvers(self) -> Sequence['outputs.RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover']:
        """
        The IDs of the users or groups who can approve the activation
        """
        return pulumi.get(self, "primary_approvers")


@pulumi.output_type
class RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str object_id: The ID of the object which will act as an approver.
        :param builtins.str type: The type of object acting as an approver. Possible options are `User` and `Group`.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> builtins.str:
        """
        The ID of the object which will act as an approver.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of object acting as an approver. Possible options are `User` and `Group`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RoleManagementPolicyActiveAssignmentRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationRequired":
            suggest = "expiration_required"
        elif key == "expireAfter":
            suggest = "expire_after"
        elif key == "requireJustification":
            suggest = "require_justification"
        elif key == "requireMultifactorAuthentication":
            suggest = "require_multifactor_authentication"
        elif key == "requireTicketInfo":
            suggest = "require_ticket_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyActiveAssignmentRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyActiveAssignmentRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyActiveAssignmentRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_required: Optional[builtins.bool] = None,
                 expire_after: Optional[builtins.str] = None,
                 require_justification: Optional[builtins.bool] = None,
                 require_multifactor_authentication: Optional[builtins.bool] = None,
                 require_ticket_info: Optional[builtins.bool] = None):
        """
        :param builtins.bool expiration_required: Must an assignment have an expiry date. `false` allows permanent assignment.
        :param builtins.str expire_after: The maximum length of time an assignment can be valid, as an ISO8601 duration. Permitted values: `P15D`, `P30D`, `P90D`, `P180D`, or `P365D`.
        :param builtins.bool require_justification: Is a justification required to create new assignments.
        :param builtins.bool require_multifactor_authentication: Is multi-factor authentication required to create new assignments.
        :param builtins.bool require_ticket_info: Is ticket information required to create new assignments.
               
               One of `expiration_required` or `expire_after` must be provided.
        """
        if expiration_required is not None:
            pulumi.set(__self__, "expiration_required", expiration_required)
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)
        if require_justification is not None:
            pulumi.set(__self__, "require_justification", require_justification)
        if require_multifactor_authentication is not None:
            pulumi.set(__self__, "require_multifactor_authentication", require_multifactor_authentication)
        if require_ticket_info is not None:
            pulumi.set(__self__, "require_ticket_info", require_ticket_info)

    @property
    @pulumi.getter(name="expirationRequired")
    def expiration_required(self) -> Optional[builtins.bool]:
        """
        Must an assignment have an expiry date. `false` allows permanent assignment.
        """
        return pulumi.get(self, "expiration_required")

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[builtins.str]:
        """
        The maximum length of time an assignment can be valid, as an ISO8601 duration. Permitted values: `P15D`, `P30D`, `P90D`, `P180D`, or `P365D`.
        """
        return pulumi.get(self, "expire_after")

    @property
    @pulumi.getter(name="requireJustification")
    def require_justification(self) -> Optional[builtins.bool]:
        """
        Is a justification required to create new assignments.
        """
        return pulumi.get(self, "require_justification")

    @property
    @pulumi.getter(name="requireMultifactorAuthentication")
    def require_multifactor_authentication(self) -> Optional[builtins.bool]:
        """
        Is multi-factor authentication required to create new assignments.
        """
        return pulumi.get(self, "require_multifactor_authentication")

    @property
    @pulumi.getter(name="requireTicketInfo")
    def require_ticket_info(self) -> Optional[builtins.bool]:
        """
        Is ticket information required to create new assignments.

        One of `expiration_required` or `expire_after` must be provided.
        """
        return pulumi.get(self, "require_ticket_info")


@pulumi.output_type
class RoleManagementPolicyEligibleAssignmentRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationRequired":
            suggest = "expiration_required"
        elif key == "expireAfter":
            suggest = "expire_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyEligibleAssignmentRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyEligibleAssignmentRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyEligibleAssignmentRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_required: Optional[builtins.bool] = None,
                 expire_after: Optional[builtins.str] = None):
        """
        :param builtins.bool expiration_required: Must an assignment have an expiry date. `false` allows permanent assignment.
        :param builtins.str expire_after: The maximum length of time an assignment can be valid, as an ISO8601 duration. Permitted values: `P15D`, `P30D`, `P90D`, `P180D`, or `P365D`.
               
               One of `expiration_required` or `expire_after` must be provided.
        """
        if expiration_required is not None:
            pulumi.set(__self__, "expiration_required", expiration_required)
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)

    @property
    @pulumi.getter(name="expirationRequired")
    def expiration_required(self) -> Optional[builtins.bool]:
        """
        Must an assignment have an expiry date. `false` allows permanent assignment.
        """
        return pulumi.get(self, "expiration_required")

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[builtins.str]:
        """
        The maximum length of time an assignment can be valid, as an ISO8601 duration. Permitted values: `P15D`, `P30D`, `P90D`, `P180D`, or `P365D`.

        One of `expiration_required` or `expire_after` must be provided.
        """
        return pulumi.get(self, "expire_after")


@pulumi.output_type
class RoleManagementPolicyNotificationRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeAssignments":
            suggest = "active_assignments"
        elif key == "eligibleActivations":
            suggest = "eligible_activations"
        elif key == "eligibleAssignments":
            suggest = "eligible_assignments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_assignments: Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignments'] = None,
                 eligible_activations: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivations'] = None,
                 eligible_assignments: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignments'] = None):
        """
        :param 'RoleManagementPolicyNotificationRulesActiveAssignmentsArgs' active_assignments: A `notification_target` block as defined below to configure notfications on active role assignments.
        :param 'RoleManagementPolicyNotificationRulesEligibleActivationsArgs' eligible_activations: A `notification_target` block as defined below for configuring notifications on activation of eligible role.
        :param 'RoleManagementPolicyNotificationRulesEligibleAssignmentsArgs' eligible_assignments: A `notification_target` block as defined below to configure notification on eligible role assignments.
               
               At least one `notification_target` block must be provided.
        """
        if active_assignments is not None:
            pulumi.set(__self__, "active_assignments", active_assignments)
        if eligible_activations is not None:
            pulumi.set(__self__, "eligible_activations", eligible_activations)
        if eligible_assignments is not None:
            pulumi.set(__self__, "eligible_assignments", eligible_assignments)

    @property
    @pulumi.getter(name="activeAssignments")
    def active_assignments(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignments']:
        """
        A `notification_target` block as defined below to configure notfications on active role assignments.
        """
        return pulumi.get(self, "active_assignments")

    @property
    @pulumi.getter(name="eligibleActivations")
    def eligible_activations(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivations']:
        """
        A `notification_target` block as defined below for configuring notifications on activation of eligible role.
        """
        return pulumi.get(self, "eligible_activations")

    @property
    @pulumi.getter(name="eligibleAssignments")
    def eligible_assignments(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignments']:
        """
        A `notification_target` block as defined below to configure notification on eligible role assignments.

        At least one `notification_target` block must be provided.
        """
        return pulumi.get(self, "eligible_assignments")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesActiveAssignments(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminNotifications":
            suggest = "admin_notifications"
        elif key == "approverNotifications":
            suggest = "approver_notifications"
        elif key == "assigneeNotifications":
            suggest = "assignee_notifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesActiveAssignments. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignments.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignments.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications'] = None,
                 approver_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications'] = None,
                 assignee_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications'] = None):
        """
        :param 'RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsArgs' admin_notifications: Admin notification settings
        :param 'RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsArgs' approver_notifications: Approver notification settings
        :param 'RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsArgs' assignee_notifications: Assignee notification settings
        """
        if admin_notifications is not None:
            pulumi.set(__self__, "admin_notifications", admin_notifications)
        if approver_notifications is not None:
            pulumi.set(__self__, "approver_notifications", approver_notifications)
        if assignee_notifications is not None:
            pulumi.set(__self__, "assignee_notifications", assignee_notifications)

    @property
    @pulumi.getter(name="adminNotifications")
    def admin_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications']:
        """
        Admin notification settings
        """
        return pulumi.get(self, "admin_notifications")

    @property
    @pulumi.getter(name="approverNotifications")
    def approver_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications']:
        """
        Approver notification settings
        """
        return pulumi.get(self, "approver_notifications")

    @property
    @pulumi.getter(name="assigneeNotifications")
    def assignee_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications']:
        """
        Assignee notification settings
        """
        return pulumi.get(self, "assignee_notifications")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleActivations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminNotifications":
            suggest = "admin_notifications"
        elif key == "approverNotifications":
            suggest = "approver_notifications"
        elif key == "assigneeNotifications":
            suggest = "assignee_notifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleActivations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications'] = None,
                 approver_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications'] = None,
                 assignee_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications'] = None):
        """
        :param 'RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsArgs' admin_notifications: Admin notification settings
        :param 'RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsArgs' approver_notifications: Approver notification settings
        :param 'RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsArgs' assignee_notifications: Assignee notification settings
        """
        if admin_notifications is not None:
            pulumi.set(__self__, "admin_notifications", admin_notifications)
        if approver_notifications is not None:
            pulumi.set(__self__, "approver_notifications", approver_notifications)
        if assignee_notifications is not None:
            pulumi.set(__self__, "assignee_notifications", assignee_notifications)

    @property
    @pulumi.getter(name="adminNotifications")
    def admin_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications']:
        """
        Admin notification settings
        """
        return pulumi.get(self, "admin_notifications")

    @property
    @pulumi.getter(name="approverNotifications")
    def approver_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications']:
        """
        Approver notification settings
        """
        return pulumi.get(self, "approver_notifications")

    @property
    @pulumi.getter(name="assigneeNotifications")
    def assignee_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications']:
        """
        Assignee notification settings
        """
        return pulumi.get(self, "assignee_notifications")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleAssignments(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminNotifications":
            suggest = "admin_notifications"
        elif key == "approverNotifications":
            suggest = "approver_notifications"
        elif key == "assigneeNotifications":
            suggest = "assignee_notifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleAssignments. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignments.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignments.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications'] = None,
                 approver_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications'] = None,
                 assignee_notifications: Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications'] = None):
        """
        :param 'RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsArgs' admin_notifications: Admin notification settings
        :param 'RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsArgs' approver_notifications: Approver notification settings
        :param 'RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsArgs' assignee_notifications: Assignee notification settings
        """
        if admin_notifications is not None:
            pulumi.set(__self__, "admin_notifications", admin_notifications)
        if approver_notifications is not None:
            pulumi.set(__self__, "approver_notifications", approver_notifications)
        if assignee_notifications is not None:
            pulumi.set(__self__, "assignee_notifications", assignee_notifications)

    @property
    @pulumi.getter(name="adminNotifications")
    def admin_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications']:
        """
        Admin notification settings
        """
        return pulumi.get(self, "admin_notifications")

    @property
    @pulumi.getter(name="approverNotifications")
    def approver_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications']:
        """
        Approver notification settings
        """
        return pulumi.get(self, "approver_notifications")

    @property
    @pulumi.getter(name="assigneeNotifications")
    def assignee_notifications(self) -> Optional['outputs.RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications']:
        """
        Assignee notification settings
        """
        return pulumi.get(self, "assignee_notifications")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRecipients":
            suggest = "default_recipients"
        elif key == "notificationLevel":
            suggest = "notification_level"
        elif key == "additionalRecipients":
            suggest = "additional_recipients"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_recipients: builtins.bool,
                 notification_level: builtins.str,
                 additional_recipients: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool default_recipients: Whether the default recipients are notified
        :param builtins.str notification_level: What level of notifications are sent
        :param Sequence[builtins.str] additional_recipients: The additional recipients to notify
        """
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        Whether the default recipients are notified
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        What level of notifications are sent
        """
        return pulumi.get(self, "notification_level")

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        The additional recipients to notify
        """
        return pulumi.get(self, "additional_recipients")


@pulumi.output_type
class GetRoleAssignmentsRoleAssignmentResult(dict):
    def __init__(__self__, *,
                 condition: builtins.str,
                 condition_version: builtins.str,
                 delegated_managed_identity_resource_id: builtins.str,
                 description: builtins.str,
                 principal_id: builtins.str,
                 principal_type: builtins.str,
                 role_assignment_id: builtins.str,
                 role_assignment_name: builtins.str,
                 role_assignment_scope: builtins.str,
                 role_definition_id: builtins.str):
        """
        :param builtins.str condition: The condition that limits the resource the role can be assigned to.
        :param builtins.str condition_version: The version of the condition.
        :param builtins.str delegated_managed_identity_resource_id: The ID of the delegated managed identity resource.
        :param builtins.str description: The description for this Role Assignment.
        :param builtins.str principal_id: The principal ID to filter the list of Role Assignments against.
        :param builtins.str principal_type: The type of the `principal_id`.
        :param builtins.str role_assignment_id: The ID of the Role Assignment.
        :param builtins.str role_assignment_name: The name of the Role Assignment.
        :param builtins.str role_assignment_scope: The scope of the Role Assignment.
        :param builtins.str role_definition_id: The ID of the Role Definition.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "condition_version", condition_version)
        pulumi.set(__self__, "delegated_managed_identity_resource_id", delegated_managed_identity_resource_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "role_assignment_id", role_assignment_id)
        pulumi.set(__self__, "role_assignment_name", role_assignment_name)
        pulumi.set(__self__, "role_assignment_scope", role_assignment_scope)
        pulumi.set(__self__, "role_definition_id", role_definition_id)

    @property
    @pulumi.getter
    def condition(self) -> builtins.str:
        """
        The condition that limits the resource the role can be assigned to.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> builtins.str:
        """
        The version of the condition.
        """
        return pulumi.get(self, "condition_version")

    @property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> builtins.str:
        """
        The ID of the delegated managed identity resource.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description for this Role Assignment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The principal ID to filter the list of Role Assignments against.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> builtins.str:
        """
        The type of the `principal_id`.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="roleAssignmentId")
    def role_assignment_id(self) -> builtins.str:
        """
        The ID of the Role Assignment.
        """
        return pulumi.get(self, "role_assignment_id")

    @property
    @pulumi.getter(name="roleAssignmentName")
    def role_assignment_name(self) -> builtins.str:
        """
        The name of the Role Assignment.
        """
        return pulumi.get(self, "role_assignment_name")

    @property
    @pulumi.getter(name="roleAssignmentScope")
    def role_assignment_scope(self) -> builtins.str:
        """
        The scope of the Role Assignment.
        """
        return pulumi.get(self, "role_assignment_scope")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> builtins.str:
        """
        The ID of the Role Definition.
        """
        return pulumi.get(self, "role_definition_id")


@pulumi.output_type
class GetRoleManagementPolicyActivationRuleResult(dict):
    def __init__(__self__, *,
                 approval_stages: Sequence['outputs.GetRoleManagementPolicyActivationRuleApprovalStageResult'],
                 maximum_duration: builtins.str,
                 require_approval: builtins.bool,
                 require_justification: builtins.bool,
                 require_multifactor_authentication: builtins.bool,
                 require_ticket_info: builtins.bool,
                 required_conditional_access_authentication_context: builtins.str):
        """
        :param Sequence['GetRoleManagementPolicyActivationRuleApprovalStageArgs'] approval_stages: An `approval_stage` block as defined below.
        :param builtins.str maximum_duration: (String) The maximum length of time an activated role can be valid, in an ISO8601 Duration format.
        :param builtins.bool require_approval: (Boolean) Is approval required for activation.
        :param builtins.bool require_justification: (Boolean) Is a justification required to create new assignments.
        :param builtins.bool require_multifactor_authentication: (Boolean) Is multi-factor authentication required to create new assignments.
        :param builtins.bool require_ticket_info: (Boolean) Is ticket information required to create new assignments.
        :param builtins.str required_conditional_access_authentication_context: (String) The Entra ID Conditional Access context that must be present for activation.
        """
        pulumi.set(__self__, "approval_stages", approval_stages)
        pulumi.set(__self__, "maximum_duration", maximum_duration)
        pulumi.set(__self__, "require_approval", require_approval)
        pulumi.set(__self__, "require_justification", require_justification)
        pulumi.set(__self__, "require_multifactor_authentication", require_multifactor_authentication)
        pulumi.set(__self__, "require_ticket_info", require_ticket_info)
        pulumi.set(__self__, "required_conditional_access_authentication_context", required_conditional_access_authentication_context)

    @property
    @pulumi.getter(name="approvalStages")
    def approval_stages(self) -> Sequence['outputs.GetRoleManagementPolicyActivationRuleApprovalStageResult']:
        """
        An `approval_stage` block as defined below.
        """
        return pulumi.get(self, "approval_stages")

    @property
    @pulumi.getter(name="maximumDuration")
    def maximum_duration(self) -> builtins.str:
        """
        (String) The maximum length of time an activated role can be valid, in an ISO8601 Duration format.
        """
        return pulumi.get(self, "maximum_duration")

    @property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> builtins.bool:
        """
        (Boolean) Is approval required for activation.
        """
        return pulumi.get(self, "require_approval")

    @property
    @pulumi.getter(name="requireJustification")
    def require_justification(self) -> builtins.bool:
        """
        (Boolean) Is a justification required to create new assignments.
        """
        return pulumi.get(self, "require_justification")

    @property
    @pulumi.getter(name="requireMultifactorAuthentication")
    def require_multifactor_authentication(self) -> builtins.bool:
        """
        (Boolean) Is multi-factor authentication required to create new assignments.
        """
        return pulumi.get(self, "require_multifactor_authentication")

    @property
    @pulumi.getter(name="requireTicketInfo")
    def require_ticket_info(self) -> builtins.bool:
        """
        (Boolean) Is ticket information required to create new assignments.
        """
        return pulumi.get(self, "require_ticket_info")

    @property
    @pulumi.getter(name="requiredConditionalAccessAuthenticationContext")
    def required_conditional_access_authentication_context(self) -> builtins.str:
        """
        (String) The Entra ID Conditional Access context that must be present for activation.
        """
        return pulumi.get(self, "required_conditional_access_authentication_context")


@pulumi.output_type
class GetRoleManagementPolicyActivationRuleApprovalStageResult(dict):
    def __init__(__self__, *,
                 primary_approvers: Sequence['outputs.GetRoleManagementPolicyActivationRuleApprovalStagePrimaryApproverResult']):
        """
        :param Sequence['GetRoleManagementPolicyActivationRuleApprovalStagePrimaryApproverArgs'] primary_approvers: The IDs of the users or groups who can approve the activation
        """
        pulumi.set(__self__, "primary_approvers", primary_approvers)

    @property
    @pulumi.getter(name="primaryApprovers")
    def primary_approvers(self) -> Sequence['outputs.GetRoleManagementPolicyActivationRuleApprovalStagePrimaryApproverResult']:
        """
        The IDs of the users or groups who can approve the activation
        """
        return pulumi.get(self, "primary_approvers")


@pulumi.output_type
class GetRoleManagementPolicyActivationRuleApprovalStagePrimaryApproverResult(dict):
    def __init__(__self__, *,
                 object_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str object_id: (String) The ID of the object which will act as an approver.
        :param builtins.str type: (String) The type of object acting as an approver. Either `User` or `Group`.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> builtins.str:
        """
        (String) The ID of the object which will act as an approver.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        (String) The type of object acting as an approver. Either `User` or `Group`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRoleManagementPolicyActiveAssignmentRuleResult(dict):
    def __init__(__self__, *,
                 expiration_required: builtins.bool,
                 expire_after: builtins.str,
                 require_justification: builtins.bool,
                 require_multifactor_authentication: builtins.bool,
                 require_ticket_info: builtins.bool):
        """
        :param builtins.bool expiration_required: (Boolean) Must an assignment have an expiry date.
        :param builtins.str expire_after: (String) The maximum length of time an assignment can be valid, as an ISO8601 duration.
        :param builtins.bool require_justification: (Boolean) Is a justification required to create new assignments.
        :param builtins.bool require_multifactor_authentication: (Boolean) Is multi-factor authentication required to create new assignments.
        :param builtins.bool require_ticket_info: (Boolean) Is ticket information required to create new assignments.
        """
        pulumi.set(__self__, "expiration_required", expiration_required)
        pulumi.set(__self__, "expire_after", expire_after)
        pulumi.set(__self__, "require_justification", require_justification)
        pulumi.set(__self__, "require_multifactor_authentication", require_multifactor_authentication)
        pulumi.set(__self__, "require_ticket_info", require_ticket_info)

    @property
    @pulumi.getter(name="expirationRequired")
    def expiration_required(self) -> builtins.bool:
        """
        (Boolean) Must an assignment have an expiry date.
        """
        return pulumi.get(self, "expiration_required")

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> builtins.str:
        """
        (String) The maximum length of time an assignment can be valid, as an ISO8601 duration.
        """
        return pulumi.get(self, "expire_after")

    @property
    @pulumi.getter(name="requireJustification")
    def require_justification(self) -> builtins.bool:
        """
        (Boolean) Is a justification required to create new assignments.
        """
        return pulumi.get(self, "require_justification")

    @property
    @pulumi.getter(name="requireMultifactorAuthentication")
    def require_multifactor_authentication(self) -> builtins.bool:
        """
        (Boolean) Is multi-factor authentication required to create new assignments.
        """
        return pulumi.get(self, "require_multifactor_authentication")

    @property
    @pulumi.getter(name="requireTicketInfo")
    def require_ticket_info(self) -> builtins.bool:
        """
        (Boolean) Is ticket information required to create new assignments.
        """
        return pulumi.get(self, "require_ticket_info")


@pulumi.output_type
class GetRoleManagementPolicyEligibleAssignmentRuleResult(dict):
    def __init__(__self__, *,
                 expiration_required: builtins.bool,
                 expire_after: builtins.str):
        """
        :param builtins.bool expiration_required: (Boolean) Must an assignment have an expiry date.
        :param builtins.str expire_after: (String) The maximum length of time an assignment can be valid, as an ISO8601 duration.
        """
        pulumi.set(__self__, "expiration_required", expiration_required)
        pulumi.set(__self__, "expire_after", expire_after)

    @property
    @pulumi.getter(name="expirationRequired")
    def expiration_required(self) -> builtins.bool:
        """
        (Boolean) Must an assignment have an expiry date.
        """
        return pulumi.get(self, "expiration_required")

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> builtins.str:
        """
        (String) The maximum length of time an assignment can be valid, as an ISO8601 duration.
        """
        return pulumi.get(self, "expire_after")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleResult(dict):
    def __init__(__self__, *,
                 active_assignments: Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentResult'],
                 eligible_activations: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationResult'],
                 eligible_assignments: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentResult']):
        """
        :param Sequence['GetRoleManagementPolicyNotificationRuleActiveAssignmentArgs'] active_assignments: A `notification_target` block as defined below with the details of notfications on active role assignments.
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleActivationArgs'] eligible_activations: A `notification_target` block as defined below with the details of notifications on activation of eligible role.
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleAssignmentArgs'] eligible_assignments: A `notification_target` block as defined below with the details of notifications on eligible role assignments.
        """
        pulumi.set(__self__, "active_assignments", active_assignments)
        pulumi.set(__self__, "eligible_activations", eligible_activations)
        pulumi.set(__self__, "eligible_assignments", eligible_assignments)

    @property
    @pulumi.getter(name="activeAssignments")
    def active_assignments(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentResult']:
        """
        A `notification_target` block as defined below with the details of notfications on active role assignments.
        """
        return pulumi.get(self, "active_assignments")

    @property
    @pulumi.getter(name="eligibleActivations")
    def eligible_activations(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationResult']:
        """
        A `notification_target` block as defined below with the details of notifications on activation of eligible role.
        """
        return pulumi.get(self, "eligible_activations")

    @property
    @pulumi.getter(name="eligibleAssignments")
    def eligible_assignments(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentResult']:
        """
        A `notification_target` block as defined below with the details of notifications on eligible role assignments.
        """
        return pulumi.get(self, "eligible_assignments")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleActiveAssignmentResult(dict):
    def __init__(__self__, *,
                 admin_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentAdminNotificationResult'],
                 approver_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentApproverNotificationResult'],
                 assignee_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentAssigneeNotificationResult']):
        """
        :param Sequence['GetRoleManagementPolicyNotificationRuleActiveAssignmentAdminNotificationArgs'] admin_notifications: A `notification_settings` block as defined above.
        :param Sequence['GetRoleManagementPolicyNotificationRuleActiveAssignmentApproverNotificationArgs'] approver_notifications: A `notification_settings` block as defined above.
        :param Sequence['GetRoleManagementPolicyNotificationRuleActiveAssignmentAssigneeNotificationArgs'] assignee_notifications: A `notification_settings` block as defined above.
        """
        pulumi.set(__self__, "admin_notifications", admin_notifications)
        pulumi.set(__self__, "approver_notifications", approver_notifications)
        pulumi.set(__self__, "assignee_notifications", assignee_notifications)

    @property
    @pulumi.getter(name="adminNotifications")
    def admin_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentAdminNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "admin_notifications")

    @property
    @pulumi.getter(name="approverNotifications")
    def approver_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentApproverNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "approver_notifications")

    @property
    @pulumi.getter(name="assigneeNotifications")
    def assignee_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleActiveAssignmentAssigneeNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "assignee_notifications")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleActiveAssignmentAdminNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleActiveAssignmentApproverNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleActiveAssignmentAssigneeNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleActivationResult(dict):
    def __init__(__self__, *,
                 admin_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationAdminNotificationResult'],
                 approver_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationApproverNotificationResult'],
                 assignee_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationAssigneeNotificationResult']):
        """
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleActivationAdminNotificationArgs'] admin_notifications: A `notification_settings` block as defined above.
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleActivationApproverNotificationArgs'] approver_notifications: A `notification_settings` block as defined above.
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleActivationAssigneeNotificationArgs'] assignee_notifications: A `notification_settings` block as defined above.
        """
        pulumi.set(__self__, "admin_notifications", admin_notifications)
        pulumi.set(__self__, "approver_notifications", approver_notifications)
        pulumi.set(__self__, "assignee_notifications", assignee_notifications)

    @property
    @pulumi.getter(name="adminNotifications")
    def admin_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationAdminNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "admin_notifications")

    @property
    @pulumi.getter(name="approverNotifications")
    def approver_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationApproverNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "approver_notifications")

    @property
    @pulumi.getter(name="assigneeNotifications")
    def assignee_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleActivationAssigneeNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "assignee_notifications")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleActivationAdminNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleActivationApproverNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleActivationAssigneeNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleAssignmentResult(dict):
    def __init__(__self__, *,
                 admin_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentAdminNotificationResult'],
                 approver_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentApproverNotificationResult'],
                 assignee_notifications: Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentAssigneeNotificationResult']):
        """
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleAssignmentAdminNotificationArgs'] admin_notifications: A `notification_settings` block as defined above.
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleAssignmentApproverNotificationArgs'] approver_notifications: A `notification_settings` block as defined above.
        :param Sequence['GetRoleManagementPolicyNotificationRuleEligibleAssignmentAssigneeNotificationArgs'] assignee_notifications: A `notification_settings` block as defined above.
        """
        pulumi.set(__self__, "admin_notifications", admin_notifications)
        pulumi.set(__self__, "approver_notifications", approver_notifications)
        pulumi.set(__self__, "assignee_notifications", assignee_notifications)

    @property
    @pulumi.getter(name="adminNotifications")
    def admin_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentAdminNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "admin_notifications")

    @property
    @pulumi.getter(name="approverNotifications")
    def approver_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentApproverNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "approver_notifications")

    @property
    @pulumi.getter(name="assigneeNotifications")
    def assignee_notifications(self) -> Sequence['outputs.GetRoleManagementPolicyNotificationRuleEligibleAssignmentAssigneeNotificationResult']:
        """
        A `notification_settings` block as defined above.
        """
        return pulumi.get(self, "assignee_notifications")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleAssignmentAdminNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleAssignmentApproverNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


@pulumi.output_type
class GetRoleManagementPolicyNotificationRuleEligibleAssignmentAssigneeNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 default_recipients: builtins.bool,
                 notification_level: builtins.str):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses that will receive these notifications.
        :param builtins.bool default_recipients: (Boolean) Should the default recipients receive these notifications.
        :param builtins.str notification_level: (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "default_recipients", default_recipients)
        pulumi.set(__self__, "notification_level", notification_level)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses that will receive these notifications.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="defaultRecipients")
    def default_recipients(self) -> builtins.bool:
        """
        (Boolean) Should the default recipients receive these notifications.
        """
        return pulumi.get(self, "default_recipients")

    @property
    @pulumi.getter(name="notificationLevel")
    def notification_level(self) -> builtins.str:
        """
        (String) What level of notifications should be sent. Either `All` or `Critical`.
        """
        return pulumi.get(self, "notification_level")


