# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlexibleServerArgs', 'FlexibleServer']

@pulumi.input_type
class FlexibleServerArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 authentication: Optional[pulumi.Input['FlexibleServerAuthenticationArgs']] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']] = None,
                 delegated_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']] = None,
                 identity: Optional[pulumi.Input['FlexibleServerIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_role: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FlexibleServer resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.
               
               > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        :param pulumi.Input[builtins.str] administrator_password: The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        :param pulumi.Input['FlexibleServerAuthenticationArgs'] authentication: An `authentication` block as defined below.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        :param pulumi.Input[builtins.int] backup_retention_days: The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        :param pulumi.Input['FlexibleServerCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerHighAvailabilityArgs'] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input['FlexibleServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input[builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the PostgreSQL Flexible Server.
               
               > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        :param pulumi.Input[builtins.str] replication_role: The replication role for the PostgreSQL Flexible Server. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        :param pulumi.Input[builtins.str] sku_name: The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        :param pulumi.Input[builtins.str] source_server_id: The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.int] storage_mb: The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.
               
               > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.
               
               > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] storage_tier: The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.
               
               > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.str] version: The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.
               
               > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.
               
               > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_password is not None:
            pulumi.set(__self__, "administrator_password", administrator_password)
        if administrator_password_wo_version is not None:
            pulumi.set(__self__, "administrator_password_wo_version", administrator_password_wo_version)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if auto_grow_enabled is not None:
            pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if delegated_subnet_id is not None:
            pulumi.set(__self__, "delegated_subnet_id", delegated_subnet_id)
        if geo_redundant_backup_enabled is not None:
            pulumi.set(__self__, "geo_redundant_backup_enabled", geo_redundant_backup_enabled)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if point_in_time_restore_time_in_utc is not None:
            pulumi.set(__self__, "point_in_time_restore_time_in_utc", point_in_time_restore_time_in_utc)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if replication_role is not None:
            pulumi.set(__self__, "replication_role", replication_role)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if storage_mb is not None:
            pulumi.set(__self__, "storage_mb", storage_mb)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.

        > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.

        > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "administrator_password")

    @administrator_password.setter
    def administrator_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_password", value)

    @property
    @pulumi.getter(name="administratorPasswordWoVersion")
    def administrator_password_wo_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        """
        return pulumi.get(self, "administrator_password_wo_version")

    @administrator_password_wo_version.setter
    def administrator_password_wo_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "administrator_password_wo_version", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['FlexibleServerAuthenticationArgs']]:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['FlexibleServerAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @auto_grow_enabled.setter
    def auto_grow_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_grow_enabled", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @delegated_subnet_id.setter
    def delegated_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delegated_subnet_id", value)

    @property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @geo_redundant_backup_enabled.setter
    def geo_redundant_backup_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "geo_redundant_backup_enabled", value)

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]:
        """
        A `high_availability` block as defined below.
        """
        return pulumi.get(self, "high_availability")

    @high_availability.setter
    def high_availability(self, value: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]):
        pulumi.set(self, "high_availability", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FlexibleServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FlexibleServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.

        > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pointInTimeRestoreTimeInUtc")
    def point_in_time_restore_time_in_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "point_in_time_restore_time_in_utc")

    @point_in_time_restore_time_in_utc.setter
    def point_in_time_restore_time_in_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "point_in_time_restore_time_in_utc", value)

    @property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the private DNS zone to create the PostgreSQL Flexible Server.

        > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.

        > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The replication role for the PostgreSQL Flexible Server. Possible value is `None`.

        > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        """
        return pulumi.get(self, "replication_role")

    @replication_role.setter
    def replication_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_role", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.

        > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.

        > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "storage_mb")

    @storage_mb.setter
    def storage_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_mb", value)

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.

        > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        """
        return pulumi.get(self, "storage_tier")

    @storage_tier.setter
    def storage_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_tier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.

        > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.

        > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _FlexibleServerState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 authentication: Optional[pulumi.Input['FlexibleServerAuthenticationArgs']] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']] = None,
                 delegated_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']] = None,
                 identity: Optional[pulumi.Input['FlexibleServerIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_role: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlexibleServer resources.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.
               
               > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        :param pulumi.Input[builtins.str] administrator_password: The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        :param pulumi.Input['FlexibleServerAuthenticationArgs'] authentication: An `authentication` block as defined below.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        :param pulumi.Input[builtins.int] backup_retention_days: The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        :param pulumi.Input['FlexibleServerCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] fqdn: The FQDN of the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerHighAvailabilityArgs'] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input['FlexibleServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input[builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the PostgreSQL Flexible Server.
               
               > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        :param pulumi.Input[builtins.str] replication_role: The replication role for the PostgreSQL Flexible Server. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        :param pulumi.Input[builtins.str] source_server_id: The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.int] storage_mb: The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.
               
               > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.
               
               > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] storage_tier: The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.
               
               > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.str] version: The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.
               
               > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.
               
               > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_password is not None:
            pulumi.set(__self__, "administrator_password", administrator_password)
        if administrator_password_wo_version is not None:
            pulumi.set(__self__, "administrator_password_wo_version", administrator_password_wo_version)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if auto_grow_enabled is not None:
            pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if delegated_subnet_id is not None:
            pulumi.set(__self__, "delegated_subnet_id", delegated_subnet_id)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if geo_redundant_backup_enabled is not None:
            pulumi.set(__self__, "geo_redundant_backup_enabled", geo_redundant_backup_enabled)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if point_in_time_restore_time_in_utc is not None:
            pulumi.set(__self__, "point_in_time_restore_time_in_utc", point_in_time_restore_time_in_utc)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if replication_role is not None:
            pulumi.set(__self__, "replication_role", replication_role)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if storage_mb is not None:
            pulumi.set(__self__, "storage_mb", storage_mb)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.

        > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.

        > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "administrator_password")

    @administrator_password.setter
    def administrator_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_password", value)

    @property
    @pulumi.getter(name="administratorPasswordWoVersion")
    def administrator_password_wo_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        """
        return pulumi.get(self, "administrator_password_wo_version")

    @administrator_password_wo_version.setter
    def administrator_password_wo_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "administrator_password_wo_version", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['FlexibleServerAuthenticationArgs']]:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['FlexibleServerAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @auto_grow_enabled.setter
    def auto_grow_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_grow_enabled", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @delegated_subnet_id.setter
    def delegated_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delegated_subnet_id", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FQDN of the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @geo_redundant_backup_enabled.setter
    def geo_redundant_backup_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "geo_redundant_backup_enabled", value)

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]:
        """
        A `high_availability` block as defined below.
        """
        return pulumi.get(self, "high_availability")

    @high_availability.setter
    def high_availability(self, value: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]):
        pulumi.set(self, "high_availability", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FlexibleServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FlexibleServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.

        > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pointInTimeRestoreTimeInUtc")
    def point_in_time_restore_time_in_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "point_in_time_restore_time_in_utc")

    @point_in_time_restore_time_in_utc.setter
    def point_in_time_restore_time_in_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "point_in_time_restore_time_in_utc", value)

    @property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the private DNS zone to create the PostgreSQL Flexible Server.

        > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.

        > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The replication role for the PostgreSQL Flexible Server. Possible value is `None`.

        > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        """
        return pulumi.get(self, "replication_role")

    @replication_role.setter
    def replication_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_role", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.

        > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.

        > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "storage_mb")

    @storage_mb.setter
    def storage_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_mb", value)

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.

        > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        """
        return pulumi.get(self, "storage_tier")

    @storage_tier.setter
    def storage_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_tier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.

        > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.

        > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("azure:postgresql/flexibleServer:FlexibleServer")
class FlexibleServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 authentication: Optional[pulumi.Input[Union['FlexibleServerAuthenticationArgs', 'FlexibleServerAuthenticationArgsDict']]] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']]] = None,
                 delegated_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_role: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a PostgreSQL Flexible Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-sn",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"],
            delegations=[{
                "name": "fs",
                "service_delegation": {
                    "name": "Microsoft.DBforPostgreSQL/flexibleServers",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_zone = azure.privatedns.Zone("example",
            name="example.postgres.database.azure.com",
            resource_group_name=example.name)
        example_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("example",
            name="exampleVnetZone.com",
            private_dns_zone_name=example_zone.name,
            virtual_network_id=example_virtual_network.id,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_subnet]))
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example-psqlflexibleserver",
            resource_group_name=example.name,
            location=example.location,
            version="12",
            delegated_subnet_id=example_subnet.id,
            private_dns_zone_id=example_zone.id,
            public_network_access_enabled=False,
            administrator_login="psqladmin",
            administrator_password="H@Sh1CoR3!",
            zone="1",
            storage_mb=32768,
            storage_tier="P4",
            sku_name="B_Standard_B1ms",
            opts = pulumi.ResourceOptions(depends_on=[example_zone_virtual_network_link]))
        ```

        ## `storage_tier` defaults based on `storage_mb`

        | `storage_mb` | GiB   | TiB | Default | Supported `storage_tier`'s           | Provisioned `IOPS`  |
        |:------------:|:-----:|:---:|:-------:|:------------------------------------:|:-------------------:|
        | 32768        | 32    |  -  | P4      | P4, P6, P10, P15, P20, P30, P40, P50 | 120                 |
        | 65536        | 64    |  -  | P6      | P6, P10, P15, P20, P30, P40, P50     | 240                 |
        | 131072       | 128   |  -  | P10     | P10, P15, P20, P30, P40, P50         | 500                 |
        | 262144       | 256   |  -  | P15     | P15, P20, P30, P40, P50              | 1,100               |
        | 524288       | 512   |  -  | P20     | P20, P30, P40, P50                   | 2,300               |
        | 1048576      | 1024  |  1  | P30     | P30, P40, P50                        | 5,000               |
        | 2097152      | 2048  |  2  | P40     | P40, P50                             | 7,500               |
        | 4193280      | 4095  |  4  | P50     | P50                                  | 7,500               |
        | 4194304      | 4096  |  4  | P50     | P50                                  | 7,500               |
        | 8388608      | 8192  |  8  | P60     | P60, P70                             | 16,000              |
        | 16777216     | 16384 |  16 | P70     | P70, P80                             | 18,000              |
        | 33553408     | 32767 |  32 | P80     | P80                                  | 20,000              |

        > **Note:** Host Caching (ReadOnly and Read/Write) is supported on disk sizes less than 4194304 MiB. This means any disk that is provisioned up to 4193280 MiB can take advantage of Host Caching. Host caching is not supported for disk sizes larger than 4193280 MiB. For example, a P50 premium disk provisioned at 4193280 GiB can take advantage of Host caching while a P50 disk provisioned at 4194304 MiB cannot. Moving from a smaller disk size to a larger disk size, greater than 4193280 MiB, will cause the disk to lose the disk caching ability.

        ***

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2024-08-01

        ## Import

        PostgreSQL Flexible Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/flexibleServer:FlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.DBforPostgreSQL/flexibleServers/server1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.
               
               > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        :param pulumi.Input[builtins.str] administrator_password: The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        :param pulumi.Input[Union['FlexibleServerAuthenticationArgs', 'FlexibleServerAuthenticationArgsDict']] authentication: An `authentication` block as defined below.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        :param pulumi.Input[builtins.int] backup_retention_days: The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        :param pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input[builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the PostgreSQL Flexible Server.
               
               > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        :param pulumi.Input[builtins.str] replication_role: The replication role for the PostgreSQL Flexible Server. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        :param pulumi.Input[builtins.str] source_server_id: The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.int] storage_mb: The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.
               
               > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.
               
               > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] storage_tier: The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.
               
               > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.str] version: The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.
               
               > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.
               
               > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexibleServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PostgreSQL Flexible Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-sn",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"],
            delegations=[{
                "name": "fs",
                "service_delegation": {
                    "name": "Microsoft.DBforPostgreSQL/flexibleServers",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_zone = azure.privatedns.Zone("example",
            name="example.postgres.database.azure.com",
            resource_group_name=example.name)
        example_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("example",
            name="exampleVnetZone.com",
            private_dns_zone_name=example_zone.name,
            virtual_network_id=example_virtual_network.id,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_subnet]))
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example-psqlflexibleserver",
            resource_group_name=example.name,
            location=example.location,
            version="12",
            delegated_subnet_id=example_subnet.id,
            private_dns_zone_id=example_zone.id,
            public_network_access_enabled=False,
            administrator_login="psqladmin",
            administrator_password="H@Sh1CoR3!",
            zone="1",
            storage_mb=32768,
            storage_tier="P4",
            sku_name="B_Standard_B1ms",
            opts = pulumi.ResourceOptions(depends_on=[example_zone_virtual_network_link]))
        ```

        ## `storage_tier` defaults based on `storage_mb`

        | `storage_mb` | GiB   | TiB | Default | Supported `storage_tier`'s           | Provisioned `IOPS`  |
        |:------------:|:-----:|:---:|:-------:|:------------------------------------:|:-------------------:|
        | 32768        | 32    |  -  | P4      | P4, P6, P10, P15, P20, P30, P40, P50 | 120                 |
        | 65536        | 64    |  -  | P6      | P6, P10, P15, P20, P30, P40, P50     | 240                 |
        | 131072       | 128   |  -  | P10     | P10, P15, P20, P30, P40, P50         | 500                 |
        | 262144       | 256   |  -  | P15     | P15, P20, P30, P40, P50              | 1,100               |
        | 524288       | 512   |  -  | P20     | P20, P30, P40, P50                   | 2,300               |
        | 1048576      | 1024  |  1  | P30     | P30, P40, P50                        | 5,000               |
        | 2097152      | 2048  |  2  | P40     | P40, P50                             | 7,500               |
        | 4193280      | 4095  |  4  | P50     | P50                                  | 7,500               |
        | 4194304      | 4096  |  4  | P50     | P50                                  | 7,500               |
        | 8388608      | 8192  |  8  | P60     | P60, P70                             | 16,000              |
        | 16777216     | 16384 |  16 | P70     | P70, P80                             | 18,000              |
        | 33553408     | 32767 |  32 | P80     | P80                                  | 20,000              |

        > **Note:** Host Caching (ReadOnly and Read/Write) is supported on disk sizes less than 4194304 MiB. This means any disk that is provisioned up to 4193280 MiB can take advantage of Host Caching. Host caching is not supported for disk sizes larger than 4193280 MiB. For example, a P50 premium disk provisioned at 4193280 GiB can take advantage of Host caching while a P50 disk provisioned at 4194304 MiB cannot. Moving from a smaller disk size to a larger disk size, greater than 4193280 MiB, will cause the disk to lose the disk caching ability.

        ***

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2024-08-01

        ## Import

        PostgreSQL Flexible Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/flexibleServer:FlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.DBforPostgreSQL/flexibleServers/server1
        ```

        :param str resource_name: The name of the resource.
        :param FlexibleServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexibleServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 authentication: Optional[pulumi.Input[Union['FlexibleServerAuthenticationArgs', 'FlexibleServerAuthenticationArgsDict']]] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']]] = None,
                 delegated_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_role: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexibleServerArgs.__new__(FlexibleServerArgs)

            __props__.__dict__["administrator_login"] = administrator_login
            __props__.__dict__["administrator_password"] = None if administrator_password is None else pulumi.Output.secret(administrator_password)
            __props__.__dict__["administrator_password_wo_version"] = administrator_password_wo_version
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["auto_grow_enabled"] = auto_grow_enabled
            __props__.__dict__["backup_retention_days"] = backup_retention_days
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["delegated_subnet_id"] = delegated_subnet_id
            __props__.__dict__["geo_redundant_backup_enabled"] = geo_redundant_backup_enabled
            __props__.__dict__["high_availability"] = high_availability
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            __props__.__dict__["point_in_time_restore_time_in_utc"] = point_in_time_restore_time_in_utc
            __props__.__dict__["private_dns_zone_id"] = private_dns_zone_id
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["replication_role"] = replication_role
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["source_server_id"] = source_server_id
            __props__.__dict__["storage_mb"] = storage_mb
            __props__.__dict__["storage_tier"] = storage_tier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["zone"] = zone
            __props__.__dict__["fqdn"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FlexibleServer, __self__).__init__(
            'azure:postgresql/flexibleServer:FlexibleServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[builtins.str]] = None,
            administrator_password: Optional[pulumi.Input[builtins.str]] = None,
            administrator_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
            authentication: Optional[pulumi.Input[Union['FlexibleServerAuthenticationArgs', 'FlexibleServerAuthenticationArgsDict']]] = None,
            auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
            create_mode: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']]] = None,
            delegated_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            fqdn: Optional[pulumi.Input[builtins.str]] = None,
            geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            high_availability: Optional[pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            point_in_time_restore_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
            private_dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            replication_role: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sku_name: Optional[pulumi.Input[builtins.str]] = None,
            source_server_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_mb: Optional[pulumi.Input[builtins.int]] = None,
            storage_tier: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'FlexibleServer':
        """
        Get an existing FlexibleServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.
               
               > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        :param pulumi.Input[builtins.str] administrator_password: The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        :param pulumi.Input[Union['FlexibleServerAuthenticationArgs', 'FlexibleServerAuthenticationArgsDict']] authentication: An `authentication` block as defined below.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        :param pulumi.Input[builtins.int] backup_retention_days: The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        :param pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] fqdn: The FQDN of the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.
               
               > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input[builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the PostgreSQL Flexible Server.
               
               > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        :param pulumi.Input[builtins.str] replication_role: The replication role for the PostgreSQL Flexible Server. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        :param pulumi.Input[builtins.str] source_server_id: The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.int] storage_mb: The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.
               
               > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.
               
               > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        :param pulumi.Input[builtins.str] storage_tier: The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.
               
               > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        :param pulumi.Input[builtins.str] version: The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.
               
               > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.
               
               > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexibleServerState.__new__(_FlexibleServerState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_password"] = administrator_password
        __props__.__dict__["administrator_password_wo_version"] = administrator_password_wo_version
        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["auto_grow_enabled"] = auto_grow_enabled
        __props__.__dict__["backup_retention_days"] = backup_retention_days
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["delegated_subnet_id"] = delegated_subnet_id
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["geo_redundant_backup_enabled"] = geo_redundant_backup_enabled
        __props__.__dict__["high_availability"] = high_availability
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["point_in_time_restore_time_in_utc"] = point_in_time_restore_time_in_utc
        __props__.__dict__["private_dns_zone_id"] = private_dns_zone_id
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["replication_role"] = replication_role
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["source_server_id"] = source_server_id
        __props__.__dict__["storage_mb"] = storage_mb
        __props__.__dict__["storage_tier"] = storage_tier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return FlexibleServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[builtins.str]:
        """
        The Administrator login for the PostgreSQL Flexible Server. Required when `create_mode` is `Default` and `authentication.password_auth_enabled` is `true`.

        > **Note:** Once `administrator_login` is specified, changing this forces a new PostgreSQL Flexible Server to be created.

        > **Note:** To create with `administrator_login` specified or update with it first specified , `authentication.password_auth_enabled` must be set to `true`.
        """
        return pulumi.get(self, "administrator_login")

    @property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "administrator_password")

    @property
    @pulumi.getter(name="administratorPasswordWoVersion")
    def administrator_password_wo_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
        """
        return pulumi.get(self, "administrator_password_wo_version")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.FlexibleServerAuthentication']:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the storage auto grow for PostgreSQL Flexible Server enabled? Defaults to `false`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> pulumi.Output[builtins.int]:
        """
        The backup retention days for the PostgreSQL Flexible Server. Possible values are between `7` and `35` days.
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `GeoRestore`, `PointInTimeRestore`, `Replica`, `ReviveDropped` and `Update`.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.FlexibleServerCustomerManagedKey']]:
        """
        A `customer_managed_key` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the virtual network subnet to create the PostgreSQL Flexible Server. The provided subnet should not have any other resource deployed in it and this subnet will be delegated to the PostgreSQL Flexible Server, if not already delegated. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[builtins.str]:
        """
        The FQDN of the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Geo-Redundant backup enabled on the PostgreSQL Flexible Server. Defaults to `false`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> pulumi.Output[Optional['outputs.FlexibleServerHighAvailability']]:
        """
        A `high_availability` block as defined below.
        """
        return pulumi.get(self, "high_availability")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.FlexibleServerIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.FlexibleServerMaintenanceWindow']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this PostgreSQL Flexible Server. Changing this forces a new PostgreSQL Flexible Server to be created.

        > **Note:** This must be unique across the entire Azure service, not just within the resource group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pointInTimeRestoreTimeInUtc")
    def point_in_time_restore_time_in_utc(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The point in time to restore from `source_server_id` when `create_mode` is `GeoRestore`, `PointInTimeRestore`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "point_in_time_restore_time_in_utc")

    @property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the private DNS zone to create the PostgreSQL Flexible Server.

        > **Note:** There will be a breaking change from upstream service at 15th July 2021, the `private_dns_zone_id` will be required when setting a `delegated_subnet_id`. For existing flexible servers who don't want to be recreated, you need to provide the `private_dns_zone_id` to the service team to manually migrate to the specified private DNS zone. The `privatedns.Zone` should end with suffix `.postgres.database.azure.com`.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether this PostgreSQL Flexible Server is publicly accessible. Defaults to `true`.

        > **Note:** `public_network_access_enabled` must be set to `false` when `delegated_subnet_id` and `private_dns_zone_id` have a value.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The replication role for the PostgreSQL Flexible Server. Possible value is `None`.

        > **Note:** The `replication_role` cannot be set while creating and only can be updated to `None` for replica server.
        """
        return pulumi.get(self, "replication_role")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the PostgreSQL Flexible Server should exist. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[builtins.str]:
        """
        The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource ID of the source PostgreSQL Flexible Server to be restored. Required when `create_mode` is `GeoRestore`, `PointInTimeRestore` or `Replica`. Changing this forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "source_server_id")

    @property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> pulumi.Output[builtins.int]:
        """
        The max storage allowed for the PostgreSQL Flexible Server. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4193280`, `4194304`, `8388608`, `16777216` and `33553408`.

        > **Note:** If the `storage_mb` field is undefined on the initial deployment of the PostgreSQL Flexible Server resource it will default to `32768`. If the `storage_mb` field has been defined and then removed, the `storage_mb` field will retain the previously defined value.

        > **Note:** The `storage_mb` can only be scaled up, for example, you can scale the `storage_mb` from `32768` to `65536`, but not from `65536` to `32768`. Scaling down `storage_mb` forces a new PostgreSQL Flexible Server to be created.
        """
        return pulumi.get(self, "storage_mb")

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> pulumi.Output[builtins.str]:
        """
        The name of storage performance tier for IOPS of the PostgreSQL Flexible Server. Possible values are `P4`, `P6`, `P10`, `P15`,`P20`, `P30`,`P40`, `P50`,`P60`, `P70` or `P80`. Default value is dependant on the `storage_mb` value. Please see the `storage_tier` defaults based on `storage_mb` table below.

        > **Note:** The `storage_tier` can be scaled once every 12 hours, this restriction is in place to ensure stability and performance after any changes to your PostgreSQL Flexible Server's configuration.
        """
        return pulumi.get(self, "storage_tier")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of PostgreSQL Flexible Server to use. Possible values are `11`,`12`, `13`, `14`, `15` and `16`. Required when `create_mode` is `Default`.

        > **Note:** Downgrading `version` isn't supported and will force a new PostgreSQL Flexible Server to be created.

        > **Note:** In-place version updates are irreversible and may cause downtime for the PostgreSQL Flexible Server, determined by the size of the instance.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "zone")

