# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sku_name: pulumi.Input[builtins.str],
                 ssl_enforcement_enabled: pulumi.Input[builtins.bool],
                 version: pulumi.Input[builtins.str],
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 creation_source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ServerIdentityArgs']] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 restore_point_in_time: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_minimal_tls_version_enforced: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input['ServerThreatDetectionPolicyArgs']] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.
               
               > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        :param pulumi.Input[builtins.bool] ssl_enforcement_enabled: Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.
               
               > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        :param pulumi.Input[builtins.str] version: Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        :param pulumi.Input[builtins.int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        :param pulumi.Input[builtins.str] creation_source_server_id: For creation modes other than `Default`, the source server ID to use.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        :param pulumi.Input['ServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.
               
               > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[builtins.str] restore_point_in_time: When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        :param pulumi.Input[builtins.str] ssl_minimal_tls_version_enforced: The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        :param pulumi.Input[builtins.int] storage_mb: Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['ServerThreatDetectionPolicyArgs'] threat_detection_policy: Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "ssl_enforcement_enabled", ssl_enforcement_enabled)
        pulumi.set(__self__, "version", version)
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if administrator_login_password_wo_version is not None:
            pulumi.set(__self__, "administrator_login_password_wo_version", administrator_login_password_wo_version)
        if auto_grow_enabled is not None:
            pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if creation_source_server_id is not None:
            pulumi.set(__self__, "creation_source_server_id", creation_source_server_id)
        if geo_redundant_backup_enabled is not None:
            pulumi.set(__self__, "geo_redundant_backup_enabled", geo_redundant_backup_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if restore_point_in_time is not None:
            pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        if ssl_minimal_tls_version_enforced is not None:
            pulumi.set(__self__, "ssl_minimal_tls_version_enforced", ssl_minimal_tls_version_enforced)
        if storage_mb is not None:
            pulumi.set(__self__, "storage_mb", storage_mb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_detection_policy is not None:
            pulumi.set(__self__, "threat_detection_policy", threat_detection_policy)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.

        > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="sslEnforcementEnabled")
    def ssl_enforcement_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.

        > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        """
        return pulumi.get(self, "ssl_enforcement_enabled")

    @ssl_enforcement_enabled.setter
    def ssl_enforcement_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ssl_enforcement_enabled", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="administratorLoginPasswordWoVersion")
    def administrator_login_password_wo_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        """
        return pulumi.get(self, "administrator_login_password_wo_version")

    @administrator_login_password_wo_version.setter
    def administrator_login_password_wo_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "administrator_login_password_wo_version", value)

    @property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @auto_grow_enabled.setter
    def auto_grow_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_grow_enabled", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Backup retention days for the server, supported values are between `7` and `35` days.
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="creationSourceServerId")
    def creation_source_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For creation modes other than `Default`, the source server ID to use.
        """
        return pulumi.get(self, "creation_source_server_id")

    @creation_source_server_id.setter
    def creation_source_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_source_server_id", value)

    @property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @geo_redundant_backup_enabled.setter
    def geo_redundant_backup_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "geo_redundant_backup_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.

        > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not public network access is allowed for this server. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        """
        return pulumi.get(self, "restore_point_in_time")

    @restore_point_in_time.setter
    def restore_point_in_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_point_in_time", value)

    @property
    @pulumi.getter(name="sslMinimalTlsVersionEnforced")
    def ssl_minimal_tls_version_enforced(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        """
        return pulumi.get(self, "ssl_minimal_tls_version_enforced")

    @ssl_minimal_tls_version_enforced.setter
    def ssl_minimal_tls_version_enforced(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_minimal_tls_version_enforced", value)

    @property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        """
        return pulumi.get(self, "storage_mb")

    @storage_mb.setter
    def storage_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_mb", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="threatDetectionPolicy")
    def threat_detection_policy(self) -> Optional[pulumi.Input['ServerThreatDetectionPolicyArgs']]:
        """
        Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        """
        return pulumi.get(self, "threat_detection_policy")

    @threat_detection_policy.setter
    def threat_detection_policy(self, value: Optional[pulumi.Input['ServerThreatDetectionPolicyArgs']]):
        pulumi.set(self, "threat_detection_policy", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 creation_source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ServerIdentityArgs']] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_minimal_tls_version_enforced: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input['ServerThreatDetectionPolicyArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        :param pulumi.Input[builtins.int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        :param pulumi.Input[builtins.str] creation_source_server_id: For creation modes other than `Default`, the source server ID to use.
        :param pulumi.Input[builtins.str] fqdn: The FQDN of the PostgreSQL Server.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        :param pulumi.Input['ServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.
               
               > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] restore_point_in_time: When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        :param pulumi.Input[builtins.str] sku_name: Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.
               
               > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        :param pulumi.Input[builtins.bool] ssl_enforcement_enabled: Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.
               
               > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        :param pulumi.Input[builtins.str] ssl_minimal_tls_version_enforced: The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        :param pulumi.Input[builtins.int] storage_mb: Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['ServerThreatDetectionPolicyArgs'] threat_detection_policy: Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[builtins.str] version: Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if administrator_login_password_wo_version is not None:
            pulumi.set(__self__, "administrator_login_password_wo_version", administrator_login_password_wo_version)
        if auto_grow_enabled is not None:
            pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if creation_source_server_id is not None:
            pulumi.set(__self__, "creation_source_server_id", creation_source_server_id)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if geo_redundant_backup_enabled is not None:
            pulumi.set(__self__, "geo_redundant_backup_enabled", geo_redundant_backup_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if restore_point_in_time is not None:
            pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if ssl_enforcement_enabled is not None:
            pulumi.set(__self__, "ssl_enforcement_enabled", ssl_enforcement_enabled)
        if ssl_minimal_tls_version_enforced is not None:
            pulumi.set(__self__, "ssl_minimal_tls_version_enforced", ssl_minimal_tls_version_enforced)
        if storage_mb is not None:
            pulumi.set(__self__, "storage_mb", storage_mb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_detection_policy is not None:
            pulumi.set(__self__, "threat_detection_policy", threat_detection_policy)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="administratorLoginPasswordWoVersion")
    def administrator_login_password_wo_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        """
        return pulumi.get(self, "administrator_login_password_wo_version")

    @administrator_login_password_wo_version.setter
    def administrator_login_password_wo_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "administrator_login_password_wo_version", value)

    @property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @auto_grow_enabled.setter
    def auto_grow_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_grow_enabled", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Backup retention days for the server, supported values are between `7` and `35` days.
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="creationSourceServerId")
    def creation_source_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For creation modes other than `Default`, the source server ID to use.
        """
        return pulumi.get(self, "creation_source_server_id")

    @creation_source_server_id.setter
    def creation_source_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_source_server_id", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FQDN of the PostgreSQL Server.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @geo_redundant_backup_enabled.setter
    def geo_redundant_backup_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "geo_redundant_backup_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.

        > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not public network access is allowed for this server. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        """
        return pulumi.get(self, "restore_point_in_time")

    @restore_point_in_time.setter
    def restore_point_in_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_point_in_time", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.

        > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="sslEnforcementEnabled")
    def ssl_enforcement_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.

        > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        """
        return pulumi.get(self, "ssl_enforcement_enabled")

    @ssl_enforcement_enabled.setter
    def ssl_enforcement_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_enforcement_enabled", value)

    @property
    @pulumi.getter(name="sslMinimalTlsVersionEnforced")
    def ssl_minimal_tls_version_enforced(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        """
        return pulumi.get(self, "ssl_minimal_tls_version_enforced")

    @ssl_minimal_tls_version_enforced.setter
    def ssl_minimal_tls_version_enforced(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_minimal_tls_version_enforced", value)

    @property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        """
        return pulumi.get(self, "storage_mb")

    @storage_mb.setter
    def storage_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_mb", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="threatDetectionPolicy")
    def threat_detection_policy(self) -> Optional[pulumi.Input['ServerThreatDetectionPolicyArgs']]:
        """
        Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        """
        return pulumi.get(self, "threat_detection_policy")

    @threat_detection_policy.setter
    def threat_detection_policy(self, value: Optional[pulumi.Input['ServerThreatDetectionPolicyArgs']]):
        pulumi.set(self, "threat_detection_policy", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:postgresql/server:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 creation_source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_minimal_tls_version_enforced: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input[Union['ServerThreatDetectionPolicyArgs', 'ServerThreatDetectionPolicyArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a PostgreSQL Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.postgresql.Server("example",
            name="example-psqlserver",
            location=example.location,
            resource_group_name=example.name,
            administrator_login="psqladmin",
            administrator_login_password="H@Sh1CoR3!",
            sku_name="GP_Gen5_4",
            version="11",
            storage_mb=640000,
            backup_retention_days=7,
            geo_redundant_backup_enabled=True,
            auto_grow_enabled=True,
            public_network_access_enabled=False,
            ssl_enforcement_enabled=True,
            ssl_minimal_tls_version_enforced="TLS1_2")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2017-12-01

        ## Import

        PostgreSQL Server's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/server:Server server1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.DBforPostgreSQL/servers/server1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        :param pulumi.Input[builtins.int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        :param pulumi.Input[builtins.str] creation_source_server_id: For creation modes other than `Default`, the source server ID to use.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.
               
               > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] restore_point_in_time: When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        :param pulumi.Input[builtins.str] sku_name: Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.
               
               > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        :param pulumi.Input[builtins.bool] ssl_enforcement_enabled: Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.
               
               > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        :param pulumi.Input[builtins.str] ssl_minimal_tls_version_enforced: The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        :param pulumi.Input[builtins.int] storage_mb: Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['ServerThreatDetectionPolicyArgs', 'ServerThreatDetectionPolicyArgsDict']] threat_detection_policy: Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[builtins.str] version: Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PostgreSQL Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.postgresql.Server("example",
            name="example-psqlserver",
            location=example.location,
            resource_group_name=example.name,
            administrator_login="psqladmin",
            administrator_login_password="H@Sh1CoR3!",
            sku_name="GP_Gen5_4",
            version="11",
            storage_mb=640000,
            backup_retention_days=7,
            geo_redundant_backup_enabled=True,
            auto_grow_enabled=True,
            public_network_access_enabled=False,
            ssl_enforcement_enabled=True,
            ssl_minimal_tls_version_enforced="TLS1_2")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2017-12-01

        ## Import

        PostgreSQL Server's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/server:Server server1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.DBforPostgreSQL/servers/server1
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 creation_source_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_minimal_tls_version_enforced: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mb: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input[Union['ServerThreatDetectionPolicyArgs', 'ServerThreatDetectionPolicyArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["administrator_login"] = administrator_login
            __props__.__dict__["administrator_login_password"] = None if administrator_login_password is None else pulumi.Output.secret(administrator_login_password)
            __props__.__dict__["administrator_login_password_wo_version"] = administrator_login_password_wo_version
            __props__.__dict__["auto_grow_enabled"] = auto_grow_enabled
            __props__.__dict__["backup_retention_days"] = backup_retention_days
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["creation_source_server_id"] = creation_source_server_id
            __props__.__dict__["geo_redundant_backup_enabled"] = geo_redundant_backup_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["restore_point_in_time"] = restore_point_in_time
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            if ssl_enforcement_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'ssl_enforcement_enabled'")
            __props__.__dict__["ssl_enforcement_enabled"] = ssl_enforcement_enabled
            __props__.__dict__["ssl_minimal_tls_version_enforced"] = ssl_minimal_tls_version_enforced
            __props__.__dict__["storage_mb"] = storage_mb
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threat_detection_policy"] = threat_detection_policy
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["fqdn"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Server, __self__).__init__(
            'azure:postgresql/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[builtins.str]] = None,
            administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
            administrator_login_password_wo_version: Optional[pulumi.Input[builtins.int]] = None,
            auto_grow_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            backup_retention_days: Optional[pulumi.Input[builtins.int]] = None,
            create_mode: Optional[pulumi.Input[builtins.str]] = None,
            creation_source_server_id: Optional[pulumi.Input[builtins.str]] = None,
            fqdn: Optional[pulumi.Input[builtins.str]] = None,
            geo_redundant_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']]] = None,
            infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            restore_point_in_time: Optional[pulumi.Input[builtins.str]] = None,
            sku_name: Optional[pulumi.Input[builtins.str]] = None,
            ssl_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ssl_minimal_tls_version_enforced: Optional[pulumi.Input[builtins.str]] = None,
            storage_mb: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            threat_detection_policy: Optional[pulumi.Input[Union['ServerThreatDetectionPolicyArgs', 'ServerThreatDetectionPolicyArgsDict']]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] administrator_login: The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input[builtins.bool] auto_grow_enabled: Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        :param pulumi.Input[builtins.int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days.
        :param pulumi.Input[builtins.str] create_mode: The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        :param pulumi.Input[builtins.str] creation_source_server_id: For creation modes other than `Default`, the source server ID to use.
        :param pulumi.Input[builtins.str] fqdn: The FQDN of the PostgreSQL Server.
        :param pulumi.Input[builtins.bool] geo_redundant_backup_enabled: Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.
               
               > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] restore_point_in_time: When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        :param pulumi.Input[builtins.str] sku_name: Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.
               
               > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        :param pulumi.Input[builtins.bool] ssl_enforcement_enabled: Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.
               
               > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        :param pulumi.Input[builtins.str] ssl_minimal_tls_version_enforced: The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        :param pulumi.Input[builtins.int] storage_mb: Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['ServerThreatDetectionPolicyArgs', 'ServerThreatDetectionPolicyArgsDict']] threat_detection_policy: Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[builtins.str] version: Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_login_password"] = administrator_login_password
        __props__.__dict__["administrator_login_password_wo_version"] = administrator_login_password_wo_version
        __props__.__dict__["auto_grow_enabled"] = auto_grow_enabled
        __props__.__dict__["backup_retention_days"] = backup_retention_days
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["creation_source_server_id"] = creation_source_server_id
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["geo_redundant_backup_enabled"] = geo_redundant_backup_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["restore_point_in_time"] = restore_point_in_time
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["ssl_enforcement_enabled"] = ssl_enforcement_enabled
        __props__.__dict__["ssl_minimal_tls_version_enforced"] = ssl_minimal_tls_version_enforced
        __props__.__dict__["storage_mb"] = storage_mb
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threat_detection_policy"] = threat_detection_policy
        __props__.__dict__["version"] = version
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[builtins.str]:
        """
        The Administrator login for the PostgreSQL Server. Required when `create_mode` is `Default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @property
    @pulumi.getter(name="administratorLoginPasswordWoVersion")
    def administrator_login_password_wo_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        """
        return pulumi.get(self, "administrator_login_password_wo_version")

    @property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable/Disable auto-growing of the storage. Storage auto-grow prevents your server from running out of storage and becoming read-only. If storage auto grow is enabled, the storage automatically grows without impacting the workload. Defaults to `true`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> pulumi.Output[builtins.int]:
        """
        Backup retention days for the server, supported values are between `7` and `35` days.
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The creation mode. Can be used to restore or replicate existing servers. Possible values are `Default`, `Replica`, `GeoRestore`, and `PointInTimeRestore`. Defaults to `Default`.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="creationSourceServerId")
    def creation_source_server_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For creation modes other than `Default`, the source server ID to use.
        """
        return pulumi.get(self, "creation_source_server_id")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[builtins.str]:
        """
        The FQDN of the PostgreSQL Server.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Turn Geo-redundant server backups on/off. This allows you to choose between locally redundant or geo-redundant backup storage in the General Purpose and Memory Optimized tiers. When the backups are stored in geo-redundant backup storage, they are not only stored within the region in which your server is hosted, but are also replicated to a paired data center. This provides better protection and ability to restore your server in a different region in the event of a disaster. This is not support for the Basic tier. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServerIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not infrastructure is encrypted for this server. Changing this forces a new resource to be created.

        > **Note:** This property is currently still in development and not supported by Microsoft. If the `infrastructure_encryption_enabled` attribute is set to `true` the PostgreSQL instance will incur a substantial performance degradation due to a second encryption pass on top of the existing default encryption that is already provided by Azure Storage. It is strongly suggested to leave this value `false` as not doing so can lead to unclear error messages.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not public network access is allowed for this server. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the PostgreSQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        When `create_mode` is `PointInTimeRestore` the point in time to restore from `creation_source_server_id`. It should be provided in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) format, e.g. `2013-11-08T22:00:40Z`.
        """
        return pulumi.get(self, "restore_point_in_time")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the SKU Name for this PostgreSQL Server. The name of the SKU, follows the `tier` + `family` + `cores` pattern (e.g. `B_Gen4_1`, `GP_Gen5_8`). For more information see the [product documentation](https://docs.microsoft.com/rest/api/postgresql/singleserver/servers/create#sku). Possible values are `B_Gen4_1`, `B_Gen4_2`, `B_Gen5_1`, `B_Gen5_2`, `GP_Gen4_2`, `GP_Gen4_4`, `GP_Gen4_8`, `GP_Gen4_16`, `GP_Gen4_32`, `GP_Gen5_2`, `GP_Gen5_4`, `GP_Gen5_8`, `GP_Gen5_16`, `GP_Gen5_32`, `GP_Gen5_64`, `MO_Gen5_2`, `MO_Gen5_4`, `MO_Gen5_8`, `MO_Gen5_16` and `MO_Gen5_32`.

        > **Note:** When replication is set up and `sku_name` is changed to a higher tier or more capacity for the primary, all replicas are scaled up to the same tier/capacity. This is an Azure requirement, for more information see the [replica scaling documentation](https://docs.microsoft.com/azure/postgresql/concepts-read-replicas#scaling)
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter(name="sslEnforcementEnabled")
    def ssl_enforcement_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies if SSL should be enforced on connections. Possible values are `true` and `false`.

        > **Note:** `ssl_minimal_tls_version_enforced` must be set to `TLSEnforcementDisabled` when `ssl_enforcement_enabled` is set to `false`.
        """
        return pulumi.get(self, "ssl_enforcement_enabled")

    @property
    @pulumi.getter(name="sslMinimalTlsVersionEnforced")
    def ssl_minimal_tls_version_enforced(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The minimum TLS version to support on the sever. Possible values are `TLSEnforcementDisabled`, `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2`.
        """
        return pulumi.get(self, "ssl_minimal_tls_version_enforced")

    @property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> pulumi.Output[builtins.int]:
        """
        Max storage allowed for a server. Possible values are between `5120` MB(5GB) and `1048576` MB(1TB) for the Basic SKU and between `5120` MB(5GB) and `16777216` MB(16TB) for General Purpose/Memory Optimized SKUs. For more information see the [product documentation](https://docs.microsoft.com/azure/postgresql/concepts-pricing-tiers#storage).
        """
        return pulumi.get(self, "storage_mb")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="threatDetectionPolicy")
    def threat_detection_policy(self) -> pulumi.Output[Optional['outputs.ServerThreatDetectionPolicy']]:
        """
        Threat detection policy configuration, known in the API as Server Security Alerts Policy. The `threat_detection_policy` block supports fields documented below.
        """
        return pulumi.get(self, "threat_detection_policy")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the version of PostgreSQL to use. Valid values are `9.5`, `9.6`, `10`, `10.0`, `10.2` and `11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

