# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResolverInboundEndpointResult',
    'AwaitableGetResolverInboundEndpointResult',
    'get_resolver_inbound_endpoint',
    'get_resolver_inbound_endpoint_output',
]

@pulumi.output_type
class GetResolverInboundEndpointResult:
    """
    A collection of values returned by getResolverInboundEndpoint.
    """
    def __init__(__self__, id=None, ip_configurations=None, location=None, name=None, private_dns_resolver_id=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_configurations and not isinstance(ip_configurations, list):
            raise TypeError("Expected argument 'ip_configurations' to be a list")
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_dns_resolver_id and not isinstance(private_dns_resolver_id, str):
            raise TypeError("Expected argument 'private_dns_resolver_id' to be a str")
        pulumi.set(__self__, "private_dns_resolver_id", private_dns_resolver_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetResolverInboundEndpointIpConfigurationResult']:
        """
        A list of `ip_configurations` block as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Private DNS Resolver Inbound Endpoint exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateDnsResolverId")
    def private_dns_resolver_id(self) -> builtins.str:
        return pulumi.get(self, "private_dns_resolver_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        The tags assigned to the Private DNS Resolver Inbound Endpoint.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResolverInboundEndpointResult(GetResolverInboundEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverInboundEndpointResult(
            id=self.id,
            ip_configurations=self.ip_configurations,
            location=self.location,
            name=self.name,
            private_dns_resolver_id=self.private_dns_resolver_id,
            tags=self.tags)


def get_resolver_inbound_endpoint(name: Optional[builtins.str] = None,
                                  private_dns_resolver_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverInboundEndpointResult:
    """
    Gets information about an existing Private DNS Resolver Inbound Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatedns.get_resolver_inbound_endpoint(name="example-drie",
        private_dns_resolver_id="example-private-dns-resolver-id")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2022-07-01


    :param builtins.str name: Name of the Private DNS Resolver Inbound Endpoint.
    :param builtins.str private_dns_resolver_id: ID of the Private DNS Resolver.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['privateDnsResolverId'] = private_dns_resolver_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:privatedns/getResolverInboundEndpoint:getResolverInboundEndpoint', __args__, opts=opts, typ=GetResolverInboundEndpointResult).value

    return AwaitableGetResolverInboundEndpointResult(
        id=pulumi.get(__ret__, 'id'),
        ip_configurations=pulumi.get(__ret__, 'ip_configurations'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        private_dns_resolver_id=pulumi.get(__ret__, 'private_dns_resolver_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resolver_inbound_endpoint_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                         private_dns_resolver_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverInboundEndpointResult]:
    """
    Gets information about an existing Private DNS Resolver Inbound Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatedns.get_resolver_inbound_endpoint(name="example-drie",
        private_dns_resolver_id="example-private-dns-resolver-id")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2022-07-01


    :param builtins.str name: Name of the Private DNS Resolver Inbound Endpoint.
    :param builtins.str private_dns_resolver_id: ID of the Private DNS Resolver.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['privateDnsResolverId'] = private_dns_resolver_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:privatedns/getResolverInboundEndpoint:getResolverInboundEndpoint', __args__, opts=opts, typ=GetResolverInboundEndpointResult)
    return __ret__.apply(lambda __response__: GetResolverInboundEndpointResult(
        id=pulumi.get(__response__, 'id'),
        ip_configurations=pulumi.get(__response__, 'ip_configurations'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        private_dns_resolver_id=pulumi.get(__response__, 'private_dns_resolver_id'),
        tags=pulumi.get(__response__, 'tags')))
