# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, alias=None, auto_approval_subscription_ids=None, enable_proxy_protocol=None, id=None, load_balancer_frontend_ip_configuration_ids=None, location=None, name=None, nat_ip_configurations=None, resource_group_name=None, tags=None, visibility_subscription_ids=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if auto_approval_subscription_ids and not isinstance(auto_approval_subscription_ids, list):
            raise TypeError("Expected argument 'auto_approval_subscription_ids' to be a list")
        pulumi.set(__self__, "auto_approval_subscription_ids", auto_approval_subscription_ids)
        if enable_proxy_protocol and not isinstance(enable_proxy_protocol, bool):
            raise TypeError("Expected argument 'enable_proxy_protocol' to be a bool")
        pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_frontend_ip_configuration_ids and not isinstance(load_balancer_frontend_ip_configuration_ids, list):
            raise TypeError("Expected argument 'load_balancer_frontend_ip_configuration_ids' to be a list")
        pulumi.set(__self__, "load_balancer_frontend_ip_configuration_ids", load_balancer_frontend_ip_configuration_ids)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nat_ip_configurations and not isinstance(nat_ip_configurations, list):
            raise TypeError("Expected argument 'nat_ip_configurations' to be a list")
        pulumi.set(__self__, "nat_ip_configurations", nat_ip_configurations)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if visibility_subscription_ids and not isinstance(visibility_subscription_ids, list):
            raise TypeError("Expected argument 'visibility_subscription_ids' to be a list")
        pulumi.set(__self__, "visibility_subscription_ids", visibility_subscription_ids)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        The alias is a globally unique name for your private link service which Azure generates for you. Your can use this alias to request a connection to your private link service.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="autoApprovalSubscriptionIds")
    def auto_approval_subscription_ids(self) -> Sequence[builtins.str]:
        """
        The list of subscription(s) globally unique identifiers that will be auto approved to use the private link service.
        """
        return pulumi.get(self, "auto_approval_subscription_ids")

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> builtins.bool:
        """
        Does the Private Link Service support the Proxy Protocol?
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerFrontendIpConfigurationIds")
    def load_balancer_frontend_ip_configuration_ids(self) -> Sequence[builtins.str]:
        """
        The list of Standard Load Balancer(SLB) resource IDs. The Private Link service is tied to the frontend IP address of a SLB. All traffic destined for the private link service will reach the frontend of the SLB. You can configure SLB rules to direct this traffic to appropriate backend pools where your applications are running.
        """
        return pulumi.get(self, "load_balancer_frontend_ip_configuration_ids")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The supported Azure location where the resource exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of private link service NAT IP configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natIpConfigurations")
    def nat_ip_configurations(self) -> Sequence['outputs.GetServiceNatIpConfigurationResult']:
        """
        The `nat_ip_configuration` block as defined below.
        """
        return pulumi.get(self, "nat_ip_configurations")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="visibilitySubscriptionIds")
    def visibility_subscription_ids(self) -> Sequence[builtins.str]:
        """
        The list of subscription(s) globally unique identifiers(GUID) that will be able to see the private link service.
        """
        return pulumi.get(self, "visibility_subscription_ids")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            alias=self.alias,
            auto_approval_subscription_ids=self.auto_approval_subscription_ids,
            enable_proxy_protocol=self.enable_proxy_protocol,
            id=self.id,
            load_balancer_frontend_ip_configuration_ids=self.load_balancer_frontend_ip_configuration_ids,
            location=self.location,
            name=self.name,
            nat_ip_configurations=self.nat_ip_configurations,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            visibility_subscription_ids=self.visibility_subscription_ids)


def get_service(name: Optional[builtins.str] = None,
                resource_group_name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Use this data source to access information about an existing Private Link Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatelink.get_service(name="myPrivateLinkService",
        resource_group_name="PrivateLinkServiceRG")
    pulumi.export("privateLinkServiceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: The name of the private link service.
    :param builtins.str resource_group_name: The name of the resource group in which the private link service resides.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:privatelink/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        alias=pulumi.get(__ret__, 'alias'),
        auto_approval_subscription_ids=pulumi.get(__ret__, 'auto_approval_subscription_ids'),
        enable_proxy_protocol=pulumi.get(__ret__, 'enable_proxy_protocol'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_frontend_ip_configuration_ids=pulumi.get(__ret__, 'load_balancer_frontend_ip_configuration_ids'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        nat_ip_configurations=pulumi.get(__ret__, 'nat_ip_configurations'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        visibility_subscription_ids=pulumi.get(__ret__, 'visibility_subscription_ids'))
def get_service_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Use this data source to access information about an existing Private Link Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatelink.get_service(name="myPrivateLinkService",
        resource_group_name="PrivateLinkServiceRG")
    pulumi.export("privateLinkServiceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str name: The name of the private link service.
    :param builtins.str resource_group_name: The name of the resource group in which the private link service resides.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:privatelink/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        alias=pulumi.get(__response__, 'alias'),
        auto_approval_subscription_ids=pulumi.get(__response__, 'auto_approval_subscription_ids'),
        enable_proxy_protocol=pulumi.get(__response__, 'enable_proxy_protocol'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_frontend_ip_configuration_ids=pulumi.get(__response__, 'load_balancer_frontend_ip_configuration_ids'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        nat_ip_configurations=pulumi.get(__response__, 'nat_ip_configurations'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        visibility_subscription_ids=pulumi.get(__response__, 'visibility_subscription_ids')))
