# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 ado_pipeline_service_connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 auxiliary_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_password: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_path: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 disable_correlation_request_id: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_terraform_partner_id: Optional[pulumi.Input[builtins.bool]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 features: Optional[pulumi.Input['ProviderFeaturesArgs']] = None,
                 metadata_host: Optional[pulumi.Input[builtins.str]] = None,
                 msi_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_request_token: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_request_url: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_token: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_token_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 partner_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_provider_registrations: Optional[pulumi.Input[builtins.str]] = None,
                 resource_providers_to_registers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 skip_provider_registration: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_use_azuread: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_aks_workload_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 use_cli: Optional[pulumi.Input[builtins.bool]] = None,
                 use_msi: Optional[pulumi.Input[builtins.bool]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.str] ado_pipeline_service_connection_id: The Azure DevOps Pipeline Service Connection ID.
        :param pulumi.Input[builtins.str] client_certificate: Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
        :param pulumi.Input[builtins.str] client_certificate_password: The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client
               Certificate
        :param pulumi.Input[builtins.str] client_certificate_path: The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service
               Principal using a Client Certificate.
        :param pulumi.Input[builtins.str] client_id: The Client ID which should be used.
        :param pulumi.Input[builtins.str] client_id_file_path: The path to a file containing the Client ID which should be used.
        :param pulumi.Input[builtins.str] client_secret: The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
        :param pulumi.Input[builtins.str] client_secret_file_path: The path to a file containing the Client Secret which should be used. For use When authenticating as a Service Principal
               using a Client Secret.
        :param pulumi.Input[builtins.bool] disable_correlation_request_id: This will disable the x-ms-correlation-request-id header.
        :param pulumi.Input[builtins.str] environment: The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public. Not
               used and should not be specified when `metadata_host` is specified.
        :param pulumi.Input[builtins.str] metadata_host: The Hostname which should be used for the Azure Metadata Service.
        :param pulumi.Input[builtins.str] msi_endpoint: The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected
               automatically.
        :param pulumi.Input[builtins.str] oidc_request_token: The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID
               Connect.
        :param pulumi.Input[builtins.str] oidc_request_url: The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal
               using OpenID Connect.
        :param pulumi.Input[builtins.str] oidc_token: The OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[builtins.str] oidc_token_file_path: The path to a file containing an OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[builtins.str] partner_id: A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
        :param pulumi.Input[builtins.str] resource_provider_registrations: The set of Resource Providers which should be automatically registered for the subscription.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_providers_to_registers: A list of Resource Providers to explicitly register for the subscription, in addition to those specified by the
               `resource_provider_registrations` property.
        :param pulumi.Input[builtins.bool] skip_provider_registration: Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already
               registered?
        :param pulumi.Input[builtins.bool] storage_use_azuread: Should the AzureRM Provider use Azure AD Authentication when accessing the Storage Data Plane APIs?
        :param pulumi.Input[builtins.str] subscription_id: The Subscription ID which should be used.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID which should be used.
        :param pulumi.Input[builtins.bool] use_aks_workload_identity: Allow Azure AKS Workload Identity to be used for Authentication.
        :param pulumi.Input[builtins.bool] use_cli: Allow Azure CLI to be used for Authentication.
        :param pulumi.Input[builtins.bool] use_msi: Allow Managed Service Identity to be used for Authentication.
        :param pulumi.Input[builtins.bool] use_oidc: Allow OpenID Connect to be used for authentication
        """
        if ado_pipeline_service_connection_id is not None:
            pulumi.set(__self__, "ado_pipeline_service_connection_id", ado_pipeline_service_connection_id)
        if auxiliary_tenant_ids is not None:
            pulumi.set(__self__, "auxiliary_tenant_ids", auxiliary_tenant_ids)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_password is not None:
            pulumi.set(__self__, "client_certificate_password", client_certificate_password)
        if client_certificate_path is not None:
            pulumi.set(__self__, "client_certificate_path", client_certificate_path)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_id_file_path is not None:
            pulumi.set(__self__, "client_id_file_path", client_id_file_path)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if client_secret_file_path is not None:
            pulumi.set(__self__, "client_secret_file_path", client_secret_file_path)
        if disable_correlation_request_id is not None:
            pulumi.set(__self__, "disable_correlation_request_id", disable_correlation_request_id)
        if disable_terraform_partner_id is not None:
            pulumi.set(__self__, "disable_terraform_partner_id", disable_terraform_partner_id)
        if environment is None:
            environment = (_utilities.get_env('AZURE_ENVIRONMENT', 'ARM_ENVIRONMENT') or 'public')
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if metadata_host is None:
            metadata_host = _utilities.get_env('ARM_METADATA_HOSTNAME')
        if metadata_host is not None:
            pulumi.set(__self__, "metadata_host", metadata_host)
        if msi_endpoint is not None:
            pulumi.set(__self__, "msi_endpoint", msi_endpoint)
        if oidc_request_token is not None:
            pulumi.set(__self__, "oidc_request_token", oidc_request_token)
        if oidc_request_url is not None:
            pulumi.set(__self__, "oidc_request_url", oidc_request_url)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)
        if oidc_token_file_path is not None:
            pulumi.set(__self__, "oidc_token_file_path", oidc_token_file_path)
        if partner_id is not None:
            pulumi.set(__self__, "partner_id", partner_id)
        if resource_provider_registrations is not None:
            pulumi.set(__self__, "resource_provider_registrations", resource_provider_registrations)
        if resource_providers_to_registers is not None:
            pulumi.set(__self__, "resource_providers_to_registers", resource_providers_to_registers)
        if skip_provider_registration is not None:
            warnings.warn("""This property is deprecated and will be removed in v5.0 of the AzureRM provider. Please use the `resource_provider_registrations` property instead.""", DeprecationWarning)
            pulumi.log.warn("""skip_provider_registration is deprecated: This property is deprecated and will be removed in v5.0 of the AzureRM provider. Please use the `resource_provider_registrations` property instead.""")
        if skip_provider_registration is None:
            skip_provider_registration = (_utilities.get_env_bool('ARM_SKIP_PROVIDER_REGISTRATION') or False)
        if skip_provider_registration is not None:
            pulumi.set(__self__, "skip_provider_registration", skip_provider_registration)
        if storage_use_azuread is None:
            storage_use_azuread = (_utilities.get_env_bool('ARM_STORAGE_USE_AZUREAD') or False)
        if storage_use_azuread is not None:
            pulumi.set(__self__, "storage_use_azuread", storage_use_azuread)
        if subscription_id is None:
            subscription_id = (_utilities.get_env('ARM_SUBSCRIPTION_ID') or '')
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_aks_workload_identity is not None:
            pulumi.set(__self__, "use_aks_workload_identity", use_aks_workload_identity)
        if use_cli is not None:
            pulumi.set(__self__, "use_cli", use_cli)
        if use_msi is not None:
            pulumi.set(__self__, "use_msi", use_msi)
        if use_oidc is not None:
            pulumi.set(__self__, "use_oidc", use_oidc)

    @property
    @pulumi.getter(name="adoPipelineServiceConnectionId")
    def ado_pipeline_service_connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure DevOps Pipeline Service Connection ID.
        """
        return pulumi.get(self, "ado_pipeline_service_connection_id")

    @ado_pipeline_service_connection_id.setter
    def ado_pipeline_service_connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ado_pipeline_service_connection_id", value)

    @property
    @pulumi.getter(name="auxiliaryTenantIds")
    def auxiliary_tenant_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "auxiliary_tenant_ids")

    @auxiliary_tenant_ids.setter
    def auxiliary_tenant_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "auxiliary_tenant_ids", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client
        Certificate
        """
        return pulumi.get(self, "client_certificate_password")

    @client_certificate_password.setter
    def client_certificate_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_password", value)

    @property
    @pulumi.getter(name="clientCertificatePath")
    def client_certificate_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service
        Principal using a Client Certificate.
        """
        return pulumi.get(self, "client_certificate_path")

    @client_certificate_path.setter
    def client_certificate_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_path", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID which should be used.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientIdFilePath")
    def client_id_file_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a file containing the Client ID which should be used.
        """
        return pulumi.get(self, "client_id_file_path")

    @client_id_file_path.setter
    def client_id_file_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id_file_path", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="clientSecretFilePath")
    def client_secret_file_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a file containing the Client Secret which should be used. For use When authenticating as a Service Principal
        using a Client Secret.
        """
        return pulumi.get(self, "client_secret_file_path")

    @client_secret_file_path.setter
    def client_secret_file_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret_file_path", value)

    @property
    @pulumi.getter(name="disableCorrelationRequestId")
    def disable_correlation_request_id(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This will disable the x-ms-correlation-request-id header.
        """
        return pulumi.get(self, "disable_correlation_request_id")

    @disable_correlation_request_id.setter
    def disable_correlation_request_id(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_correlation_request_id", value)

    @property
    @pulumi.getter(name="disableTerraformPartnerId")
    def disable_terraform_partner_id(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "disable_terraform_partner_id")

    @disable_terraform_partner_id.setter
    def disable_terraform_partner_id(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_terraform_partner_id", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public. Not
        used and should not be specified when `metadata_host` is specified.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ProviderFeaturesArgs']]:
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ProviderFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="metadataHost")
    def metadata_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Hostname which should be used for the Azure Metadata Service.
        """
        return pulumi.get(self, "metadata_host")

    @metadata_host.setter
    def metadata_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata_host", value)

    @property
    @pulumi.getter(name="msiEndpoint")
    def msi_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected
        automatically.
        """
        return pulumi.get(self, "msi_endpoint")

    @msi_endpoint.setter
    def msi_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msi_endpoint", value)

    @property
    @pulumi.getter(name="oidcRequestToken")
    def oidc_request_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID
        Connect.
        """
        return pulumi.get(self, "oidc_request_token")

    @oidc_request_token.setter
    def oidc_request_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oidc_request_token", value)

    @property
    @pulumi.getter(name="oidcRequestUrl")
    def oidc_request_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal
        using OpenID Connect.
        """
        return pulumi.get(self, "oidc_request_url")

    @oidc_request_url.setter
    def oidc_request_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oidc_request_url", value)

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_token")

    @oidc_token.setter
    def oidc_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oidc_token", value)

    @property
    @pulumi.getter(name="oidcTokenFilePath")
    def oidc_token_file_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a file containing an OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_token_file_path")

    @oidc_token_file_path.setter
    def oidc_token_file_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oidc_token_file_path", value)

    @property
    @pulumi.getter(name="partnerId")
    def partner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
        """
        return pulumi.get(self, "partner_id")

    @partner_id.setter
    def partner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partner_id", value)

    @property
    @pulumi.getter(name="resourceProviderRegistrations")
    def resource_provider_registrations(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of Resource Providers which should be automatically registered for the subscription.
        """
        return pulumi.get(self, "resource_provider_registrations")

    @resource_provider_registrations.setter
    def resource_provider_registrations(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_provider_registrations", value)

    @property
    @pulumi.getter(name="resourceProvidersToRegisters")
    def resource_providers_to_registers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Resource Providers to explicitly register for the subscription, in addition to those specified by the
        `resource_provider_registrations` property.
        """
        return pulumi.get(self, "resource_providers_to_registers")

    @resource_providers_to_registers.setter
    def resource_providers_to_registers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resource_providers_to_registers", value)

    @property
    @pulumi.getter(name="skipProviderRegistration")
    @_utilities.deprecated("""This property is deprecated and will be removed in v5.0 of the AzureRM provider. Please use the `resource_provider_registrations` property instead.""")
    def skip_provider_registration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already
        registered?
        """
        return pulumi.get(self, "skip_provider_registration")

    @skip_provider_registration.setter
    def skip_provider_registration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_provider_registration", value)

    @property
    @pulumi.getter(name="storageUseAzuread")
    def storage_use_azuread(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the AzureRM Provider use Azure AD Authentication when accessing the Storage Data Plane APIs?
        """
        return pulumi.get(self, "storage_use_azuread")

    @storage_use_azuread.setter
    def storage_use_azuread(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_use_azuread", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Subscription ID which should be used.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID which should be used.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useAksWorkloadIdentity")
    def use_aks_workload_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow Azure AKS Workload Identity to be used for Authentication.
        """
        return pulumi.get(self, "use_aks_workload_identity")

    @use_aks_workload_identity.setter
    def use_aks_workload_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_aks_workload_identity", value)

    @property
    @pulumi.getter(name="useCli")
    def use_cli(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow Azure CLI to be used for Authentication.
        """
        return pulumi.get(self, "use_cli")

    @use_cli.setter
    def use_cli(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_cli", value)

    @property
    @pulumi.getter(name="useMsi")
    def use_msi(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow Managed Service Identity to be used for Authentication.
        """
        return pulumi.get(self, "use_msi")

    @use_msi.setter
    def use_msi(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_msi", value)

    @property
    @pulumi.getter(name="useOidc")
    def use_oidc(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow OpenID Connect to be used for authentication
        """
        return pulumi.get(self, "use_oidc")

    @use_oidc.setter
    def use_oidc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_oidc", value)


@pulumi.type_token("pulumi:providers:azure")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ado_pipeline_service_connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 auxiliary_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_password: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_path: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 disable_correlation_request_id: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_terraform_partner_id: Optional[pulumi.Input[builtins.bool]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 features: Optional[pulumi.Input[Union['ProviderFeaturesArgs', 'ProviderFeaturesArgsDict']]] = None,
                 metadata_host: Optional[pulumi.Input[builtins.str]] = None,
                 msi_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_request_token: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_request_url: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_token: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_token_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 partner_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_provider_registrations: Optional[pulumi.Input[builtins.str]] = None,
                 resource_providers_to_registers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 skip_provider_registration: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_use_azuread: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_aks_workload_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 use_cli: Optional[pulumi.Input[builtins.bool]] = None,
                 use_msi: Optional[pulumi.Input[builtins.bool]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the azurerm package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ado_pipeline_service_connection_id: The Azure DevOps Pipeline Service Connection ID.
        :param pulumi.Input[builtins.str] client_certificate: Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
        :param pulumi.Input[builtins.str] client_certificate_password: The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client
               Certificate
        :param pulumi.Input[builtins.str] client_certificate_path: The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service
               Principal using a Client Certificate.
        :param pulumi.Input[builtins.str] client_id: The Client ID which should be used.
        :param pulumi.Input[builtins.str] client_id_file_path: The path to a file containing the Client ID which should be used.
        :param pulumi.Input[builtins.str] client_secret: The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
        :param pulumi.Input[builtins.str] client_secret_file_path: The path to a file containing the Client Secret which should be used. For use When authenticating as a Service Principal
               using a Client Secret.
        :param pulumi.Input[builtins.bool] disable_correlation_request_id: This will disable the x-ms-correlation-request-id header.
        :param pulumi.Input[builtins.str] environment: The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public. Not
               used and should not be specified when `metadata_host` is specified.
        :param pulumi.Input[builtins.str] metadata_host: The Hostname which should be used for the Azure Metadata Service.
        :param pulumi.Input[builtins.str] msi_endpoint: The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected
               automatically.
        :param pulumi.Input[builtins.str] oidc_request_token: The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID
               Connect.
        :param pulumi.Input[builtins.str] oidc_request_url: The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal
               using OpenID Connect.
        :param pulumi.Input[builtins.str] oidc_token: The OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[builtins.str] oidc_token_file_path: The path to a file containing an OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[builtins.str] partner_id: A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
        :param pulumi.Input[builtins.str] resource_provider_registrations: The set of Resource Providers which should be automatically registered for the subscription.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_providers_to_registers: A list of Resource Providers to explicitly register for the subscription, in addition to those specified by the
               `resource_provider_registrations` property.
        :param pulumi.Input[builtins.bool] skip_provider_registration: Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already
               registered?
        :param pulumi.Input[builtins.bool] storage_use_azuread: Should the AzureRM Provider use Azure AD Authentication when accessing the Storage Data Plane APIs?
        :param pulumi.Input[builtins.str] subscription_id: The Subscription ID which should be used.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID which should be used.
        :param pulumi.Input[builtins.bool] use_aks_workload_identity: Allow Azure AKS Workload Identity to be used for Authentication.
        :param pulumi.Input[builtins.bool] use_cli: Allow Azure CLI to be used for Authentication.
        :param pulumi.Input[builtins.bool] use_msi: Allow Managed Service Identity to be used for Authentication.
        :param pulumi.Input[builtins.bool] use_oidc: Allow OpenID Connect to be used for authentication
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the azurerm package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ado_pipeline_service_connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 auxiliary_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_password: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_path: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 disable_correlation_request_id: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_terraform_partner_id: Optional[pulumi.Input[builtins.bool]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 features: Optional[pulumi.Input[Union['ProviderFeaturesArgs', 'ProviderFeaturesArgsDict']]] = None,
                 metadata_host: Optional[pulumi.Input[builtins.str]] = None,
                 msi_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_request_token: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_request_url: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_token: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_token_file_path: Optional[pulumi.Input[builtins.str]] = None,
                 partner_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_provider_registrations: Optional[pulumi.Input[builtins.str]] = None,
                 resource_providers_to_registers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 skip_provider_registration: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_use_azuread: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_aks_workload_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 use_cli: Optional[pulumi.Input[builtins.bool]] = None,
                 use_msi: Optional[pulumi.Input[builtins.bool]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["ado_pipeline_service_connection_id"] = ado_pipeline_service_connection_id
            __props__.__dict__["auxiliary_tenant_ids"] = pulumi.Output.secret(auxiliary_tenant_ids).apply(pulumi.runtime.to_json) if auxiliary_tenant_ids is not None else None
            __props__.__dict__["client_certificate"] = None if client_certificate is None else pulumi.Output.secret(client_certificate)
            __props__.__dict__["client_certificate_password"] = None if client_certificate_password is None else pulumi.Output.secret(client_certificate_password)
            __props__.__dict__["client_certificate_path"] = None if client_certificate_path is None else pulumi.Output.secret(client_certificate_path)
            __props__.__dict__["client_id"] = None if client_id is None else pulumi.Output.secret(client_id)
            __props__.__dict__["client_id_file_path"] = None if client_id_file_path is None else pulumi.Output.secret(client_id_file_path)
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["client_secret_file_path"] = None if client_secret_file_path is None else pulumi.Output.secret(client_secret_file_path)
            __props__.__dict__["disable_correlation_request_id"] = pulumi.Output.from_input(disable_correlation_request_id).apply(pulumi.runtime.to_json) if disable_correlation_request_id is not None else None
            __props__.__dict__["disable_terraform_partner_id"] = pulumi.Output.from_input(disable_terraform_partner_id).apply(pulumi.runtime.to_json) if disable_terraform_partner_id is not None else None
            if environment is None:
                environment = (_utilities.get_env('AZURE_ENVIRONMENT', 'ARM_ENVIRONMENT') or 'public')
            __props__.__dict__["environment"] = environment
            __props__.__dict__["features"] = pulumi.Output.from_input(features).apply(pulumi.runtime.to_json) if features is not None else None
            if metadata_host is None:
                metadata_host = _utilities.get_env('ARM_METADATA_HOSTNAME')
            __props__.__dict__["metadata_host"] = metadata_host
            __props__.__dict__["msi_endpoint"] = msi_endpoint
            __props__.__dict__["oidc_request_token"] = None if oidc_request_token is None else pulumi.Output.secret(oidc_request_token)
            __props__.__dict__["oidc_request_url"] = oidc_request_url
            __props__.__dict__["oidc_token"] = None if oidc_token is None else pulumi.Output.secret(oidc_token)
            __props__.__dict__["oidc_token_file_path"] = None if oidc_token_file_path is None else pulumi.Output.secret(oidc_token_file_path)
            __props__.__dict__["partner_id"] = partner_id
            __props__.__dict__["resource_provider_registrations"] = resource_provider_registrations
            __props__.__dict__["resource_providers_to_registers"] = pulumi.Output.from_input(resource_providers_to_registers).apply(pulumi.runtime.to_json) if resource_providers_to_registers is not None else None
            if skip_provider_registration is None:
                skip_provider_registration = (_utilities.get_env_bool('ARM_SKIP_PROVIDER_REGISTRATION') or False)
            __props__.__dict__["skip_provider_registration"] = pulumi.Output.from_input(skip_provider_registration).apply(pulumi.runtime.to_json) if skip_provider_registration is not None else None
            if storage_use_azuread is None:
                storage_use_azuread = (_utilities.get_env_bool('ARM_STORAGE_USE_AZUREAD') or False)
            __props__.__dict__["storage_use_azuread"] = pulumi.Output.from_input(storage_use_azuread).apply(pulumi.runtime.to_json) if storage_use_azuread is not None else None
            if subscription_id is None:
                subscription_id = (_utilities.get_env('ARM_SUBSCRIPTION_ID') or '')
            __props__.__dict__["subscription_id"] = None if subscription_id is None else pulumi.Output.secret(subscription_id)
            __props__.__dict__["tenant_id"] = None if tenant_id is None else pulumi.Output.secret(tenant_id)
            __props__.__dict__["use_aks_workload_identity"] = pulumi.Output.from_input(use_aks_workload_identity).apply(pulumi.runtime.to_json) if use_aks_workload_identity is not None else None
            __props__.__dict__["use_cli"] = pulumi.Output.from_input(use_cli).apply(pulumi.runtime.to_json) if use_cli is not None else None
            __props__.__dict__["use_msi"] = pulumi.Output.from_input(use_msi).apply(pulumi.runtime.to_json) if use_msi is not None else None
            __props__.__dict__["use_oidc"] = pulumi.Output.from_input(use_oidc).apply(pulumi.runtime.to_json) if use_oidc is not None else None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientCertificate", "clientCertificatePassword", "clientCertificatePath", "clientId", "clientIdFilePath", "clientSecret", "clientSecretFilePath", "oidcRequestToken", "oidcToken", "oidcTokenFilePath", "subscriptionId", "tenantId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'azure',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="adoPipelineServiceConnectionId")
    def ado_pipeline_service_connection_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Azure DevOps Pipeline Service Connection ID.
        """
        return pulumi.get(self, "ado_pipeline_service_connection_id")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client
        Certificate
        """
        return pulumi.get(self, "client_certificate_password")

    @property
    @pulumi.getter(name="clientCertificatePath")
    def client_certificate_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service
        Principal using a Client Certificate.
        """
        return pulumi.get(self, "client_certificate_path")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Client ID which should be used.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientIdFilePath")
    def client_id_file_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a file containing the Client ID which should be used.
        """
        return pulumi.get(self, "client_id_file_path")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clientSecretFilePath")
    def client_secret_file_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a file containing the Client Secret which should be used. For use When authenticating as a Service Principal
        using a Client Secret.
        """
        return pulumi.get(self, "client_secret_file_path")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public. Not
        used and should not be specified when `metadata_host` is specified.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="metadataHost")
    def metadata_host(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Hostname which should be used for the Azure Metadata Service.
        """
        return pulumi.get(self, "metadata_host")

    @property
    @pulumi.getter(name="msiEndpoint")
    def msi_endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected
        automatically.
        """
        return pulumi.get(self, "msi_endpoint")

    @property
    @pulumi.getter(name="oidcRequestToken")
    def oidc_request_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID
        Connect.
        """
        return pulumi.get(self, "oidc_request_token")

    @property
    @pulumi.getter(name="oidcRequestUrl")
    def oidc_request_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal
        using OpenID Connect.
        """
        return pulumi.get(self, "oidc_request_url")

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_token")

    @property
    @pulumi.getter(name="oidcTokenFilePath")
    def oidc_token_file_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a file containing an OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_token_file_path")

    @property
    @pulumi.getter(name="partnerId")
    def partner_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
        """
        return pulumi.get(self, "partner_id")

    @property
    @pulumi.getter(name="resourceProviderRegistrations")
    def resource_provider_registrations(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The set of Resource Providers which should be automatically registered for the subscription.
        """
        return pulumi.get(self, "resource_provider_registrations")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Subscription ID which should be used.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Tenant ID which should be used.
        """
        return pulumi.get(self, "tenant_id")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:azure/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

