# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[builtins.str],
                 email: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 storage_sku: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str],
                 zone: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[builtins.str] admin_password: The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_sku: The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] zone: The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_id: Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan_id: Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher_id: Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the File System.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_sku", storage_sku)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zone", zone)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offer_id is not None:
            pulumi.set(__self__, "offer_id", offer_id)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if publisher_id is not None:
            pulumi.set(__self__, "publisher_id", publisher_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[builtins.str]:
        """
        The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageSku")
    def storage_sku(self) -> pulumi.Input[builtins.str]:
        """
        The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_sku")

    @storage_sku.setter
    def storage_sku(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_sku", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[builtins.str]:
        """
        The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer_id", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher_id")

    @publisher_id.setter
    def publisher_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the File System.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[builtins.str] admin_password: The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_id: Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan_id: Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher_id: Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_sku: The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the File System.
        :param pulumi.Input[builtins.str] zone: The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offer_id is not None:
            pulumi.set(__self__, "offer_id", offer_id)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if publisher_id is not None:
            pulumi.set(__self__, "publisher_id", publisher_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_sku is not None:
            pulumi.set(__self__, "storage_sku", storage_sku)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer_id", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher_id")

    @publisher_id.setter
    def publisher_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageSku")
    def storage_sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_sku")

    @storage_sku.setter
    def storage_sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_sku", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the File System.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("azure:qumulo/fileSystem:FileSystem")
class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Native Qumulo Scalable File System.

        ## Import

        An existing File System can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:qumulo/fileSystem:FileSystem example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Qumulo.Storage/fileSystems/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_password: The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_id: Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan_id: Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher_id: Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_sku: The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the File System.
        :param pulumi.Input[builtins.str] zone: The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Native Qumulo Scalable File System.

        ## Import

        An existing File System can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:qumulo/fileSystem:FileSystem example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Qumulo.Storage/fileSystems/example
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            if admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'admin_password'")
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["offer_id"] = offer_id
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["publisher_id"] = publisher_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if storage_sku is None and not opts.urn:
                raise TypeError("Missing required property 'storage_sku'")
            __props__.__dict__["storage_sku"] = storage_sku
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FileSystem, __self__).__init__(
            'azure:qumulo/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_password: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            offer_id: Optional[pulumi.Input[builtins.str]] = None,
            plan_id: Optional[pulumi.Input[builtins.str]] = None,
            publisher_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            storage_sku: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_password: The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_id: Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan_id: Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher_id: Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_sku: The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the File System.
        :param pulumi.Input[builtins.str] zone: The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["email"] = email
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["offer_id"] = offer_id
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["publisher_id"] = publisher_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_sku"] = storage_sku
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[builtins.str]:
        """
        The initial administrator password of the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email address used for the Azure Native Qumulo Scalable File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of this Azure Native Qumulo Scalable File System resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the marketplace offer ID. Defaults to `qumulo-saas-mpp`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer_id")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the marketplace plan ID. Defaults to `azure-native-qumulo-v3`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the marketplace publisher ID. Defaults to `qumulo1584033880660`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group within which this Azure Native Qumulo Scalable File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="storageSku")
    def storage_sku(self) -> pulumi.Output[builtins.str]:
        """
        The storage Sku. Possible values are `Cold_LRS`, `Hot_LRS` and `Hot_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_sku")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The delegated subnet ID for Vnet injection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the File System.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The Availability Zone in which the Azure Native Qumulo Scalable File system is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

