# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterApiServerProfileArgs',
    'ClusterApiServerProfileArgsDict',
    'ClusterClusterProfileArgs',
    'ClusterClusterProfileArgsDict',
    'ClusterIngressProfileArgs',
    'ClusterIngressProfileArgsDict',
    'ClusterMainProfileArgs',
    'ClusterMainProfileArgsDict',
    'ClusterNetworkProfileArgs',
    'ClusterNetworkProfileArgsDict',
    'ClusterServicePrincipalArgs',
    'ClusterServicePrincipalArgsDict',
    'ClusterWorkerProfileArgs',
    'ClusterWorkerProfileArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterApiServerProfileArgsDict(TypedDict):
        visibility: pulumi.Input[builtins.str]
        """
        Cluster API server visibility. Supported values are `Public` and `Private`. Changing this forces a new resource to be created.
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP Address the Ingress Profile is associated with.
        """
        url: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL the API Server Profile is associated with.
        """
elif False:
    ClusterApiServerProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterApiServerProfileArgs:
    def __init__(__self__, *,
                 visibility: pulumi.Input[builtins.str],
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] visibility: Cluster API server visibility. Supported values are `Public` and `Private`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ip_address: The IP Address the Ingress Profile is associated with.
        :param pulumi.Input[builtins.str] url: The URL the API Server Profile is associated with.
        """
        pulumi.set(__self__, "visibility", visibility)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Input[builtins.str]:
        """
        Cluster API server visibility. Supported values are `Public` and `Private`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Address the Ingress Profile is associated with.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL the API Server Profile is associated with.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class ClusterClusterProfileArgsDict(TypedDict):
        domain: pulumi.Input[builtins.str]
        """
        The custom domain for the cluster. For more info, see [Prepare a custom domain for your cluster](https://docs.microsoft.com/azure/openshift/tutorial-create-cluster#prepare-a-custom-domain-for-your-cluster-optional). Changing this forces a new resource to be created.
        """
        version: pulumi.Input[builtins.str]
        """
        The version of the OpenShift cluster. Available versions can be found with the Azure CLI command `az aro get-versions --location <region>`. Changing this forces a new resource to be created.
        """
        fips_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether Federal Information Processing Standard (FIPS) validated cryptographic modules are used. Defaults to `false`. Changing this forces a new resource to be created.
        """
        managed_resource_group_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of a Resource Group which will be created to host VMs of Azure Red Hat OpenShift Cluster. The value cannot contain uppercase characters. Defaults to `aro-{domain}`. Changing this forces a new resource to be created.
        """
        pull_secret: NotRequired[pulumi.Input[builtins.str]]
        """
        The Red Hat pull secret for the cluster. For more info, see [Get a Red Hat pull secret](https://learn.microsoft.com/azure/openshift/tutorial-create-cluster#get-a-red-hat-pull-secret-optional). Changing this forces a new resource to be created.
        """
        resource_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource group that the cluster profile is attached to.
        """
elif False:
    ClusterClusterProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClusterProfileArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str],
                 fips_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 pull_secret: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] domain: The custom domain for the cluster. For more info, see [Prepare a custom domain for your cluster](https://docs.microsoft.com/azure/openshift/tutorial-create-cluster#prepare-a-custom-domain-for-your-cluster-optional). Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] version: The version of the OpenShift cluster. Available versions can be found with the Azure CLI command `az aro get-versions --location <region>`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] fips_enabled: Whether Federal Information Processing Standard (FIPS) validated cryptographic modules are used. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_resource_group_name: The name of a Resource Group which will be created to host VMs of Azure Red Hat OpenShift Cluster. The value cannot contain uppercase characters. Defaults to `aro-{domain}`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] pull_secret: The Red Hat pull secret for the cluster. For more info, see [Get a Red Hat pull secret](https://learn.microsoft.com/azure/openshift/tutorial-create-cluster#get-a-red-hat-pull-secret-optional). Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_id: The resource group that the cluster profile is attached to.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "version", version)
        if fips_enabled is not None:
            pulumi.set(__self__, "fips_enabled", fips_enabled)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if pull_secret is not None:
            pulumi.set(__self__, "pull_secret", pull_secret)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        The custom domain for the cluster. For more info, see [Prepare a custom domain for your cluster](https://docs.microsoft.com/azure/openshift/tutorial-create-cluster#prepare-a-custom-domain-for-your-cluster-optional). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the OpenShift cluster. Available versions can be found with the Azure CLI command `az aro get-versions --location <region>`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Federal Information Processing Standard (FIPS) validated cryptographic modules are used. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "fips_enabled")

    @fips_enabled.setter
    def fips_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fips_enabled", value)

    @property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a Resource Group which will be created to host VMs of Azure Red Hat OpenShift Cluster. The value cannot contain uppercase characters. Defaults to `aro-{domain}`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @property
    @pulumi.getter(name="pullSecret")
    def pull_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Red Hat pull secret for the cluster. For more info, see [Get a Red Hat pull secret](https://learn.microsoft.com/azure/openshift/tutorial-create-cluster#get-a-red-hat-pull-secret-optional). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "pull_secret")

    @pull_secret.setter
    def pull_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pull_secret", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource group that the cluster profile is attached to.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_id", value)


if not MYPY:
    class ClusterIngressProfileArgsDict(TypedDict):
        visibility: pulumi.Input[builtins.str]
        """
        Cluster Ingress visibility. Supported values are `Public` and `Private`. Changing this forces a new resource to be created.
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP Address the Ingress Profile is associated with.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        """
elif False:
    ClusterIngressProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterIngressProfileArgs:
    def __init__(__self__, *,
                 visibility: pulumi.Input[builtins.str],
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] visibility: Cluster Ingress visibility. Supported values are `Public` and `Private`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ip_address: The IP Address the Ingress Profile is associated with.
        :param pulumi.Input[builtins.str] name: The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "visibility", visibility)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Input[builtins.str]:
        """
        Cluster Ingress visibility. Supported values are `Public` and `Private`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Address the Ingress Profile is associated with.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ClusterMainProfileArgsDict(TypedDict):
        subnet_id: pulumi.Input[builtins.str]
        """
        The ID of the subnet where main nodes will be hosted. Changing this forces a new resource to be created.
        """
        vm_size: pulumi.Input[builtins.str]
        """
        The size of the Virtual Machines for the main nodes. Changing this forces a new resource to be created.
        """
        disk_encryption_set_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource ID of an associated disk encryption set. Changing this forces a new resource to be created.
        """
        encryption_at_host_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether main virtual machines are encrypted at host. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** `encryption_at_host_enabled` is only available for certain VM sizes and the `EncryptionAtHost` feature must be enabled for your subscription. Please see the [Azure documentation](https://learn.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal?tabs=azure-powershell) for more information.
        """
elif False:
    ClusterMainProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMainProfileArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str],
                 vm_size: pulumi.Input[builtins.str],
                 disk_encryption_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet where main nodes will be hosted. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vm_size: The size of the Virtual Machines for the main nodes. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] disk_encryption_set_id: The resource ID of an associated disk encryption set. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] encryption_at_host_enabled: Whether main virtual machines are encrypted at host. Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** `encryption_at_host_enabled` is only available for certain VM sizes and the `EncryptionAtHost` feature must be enabled for your subscription. Please see the [Azure documentation](https://learn.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal?tabs=azure-powershell) for more information.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vm_size", vm_size)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the subnet where main nodes will be hosted. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[builtins.str]:
        """
        The size of the Virtual Machines for the main nodes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of an associated disk encryption set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether main virtual machines are encrypted at host. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** `encryption_at_host_enabled` is only available for certain VM sizes and the `EncryptionAtHost` feature must be enabled for your subscription. Please see the [Azure documentation](https://learn.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal?tabs=azure-powershell) for more information.
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)


if not MYPY:
    class ClusterNetworkProfileArgsDict(TypedDict):
        pod_cidr: pulumi.Input[builtins.str]
        """
        The CIDR to use for pod IP addresses. Changing this forces a new resource to be created.
        """
        service_cidr: pulumi.Input[builtins.str]
        """
        The network range used by the OpenShift service. Changing this forces a new resource to be created.
        """
        outbound_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The outbound (egress) routing method. Possible values are `Loadbalancer` and `UserDefinedRouting`. Defaults to `Loadbalancer`. Changing this forces a new resource to be created.
        """
        preconfigured_network_security_group_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether a preconfigured network security group is being used on the subnets.  Defaults to `false`.  Changing this forces a new resource to be created.
        """
elif False:
    ClusterNetworkProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNetworkProfileArgs:
    def __init__(__self__, *,
                 pod_cidr: pulumi.Input[builtins.str],
                 service_cidr: pulumi.Input[builtins.str],
                 outbound_type: Optional[pulumi.Input[builtins.str]] = None,
                 preconfigured_network_security_group_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] pod_cidr: The CIDR to use for pod IP addresses. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] service_cidr: The network range used by the OpenShift service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] outbound_type: The outbound (egress) routing method. Possible values are `Loadbalancer` and `UserDefinedRouting`. Defaults to `Loadbalancer`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] preconfigured_network_security_group_enabled: Whether a preconfigured network security group is being used on the subnets.  Defaults to `false`.  Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "pod_cidr", pod_cidr)
        pulumi.set(__self__, "service_cidr", service_cidr)
        if outbound_type is not None:
            pulumi.set(__self__, "outbound_type", outbound_type)
        if preconfigured_network_security_group_enabled is not None:
            pulumi.set(__self__, "preconfigured_network_security_group_enabled", preconfigured_network_security_group_enabled)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> pulumi.Input[builtins.str]:
        """
        The CIDR to use for pod IP addresses. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Input[builtins.str]:
        """
        The network range used by the OpenShift service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="outboundType")
    def outbound_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The outbound (egress) routing method. Possible values are `Loadbalancer` and `UserDefinedRouting`. Defaults to `Loadbalancer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "outbound_type")

    @outbound_type.setter
    def outbound_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outbound_type", value)

    @property
    @pulumi.getter(name="preconfiguredNetworkSecurityGroupEnabled")
    def preconfigured_network_security_group_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether a preconfigured network security group is being used on the subnets.  Defaults to `false`.  Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "preconfigured_network_security_group_enabled")

    @preconfigured_network_security_group_enabled.setter
    def preconfigured_network_security_group_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preconfigured_network_security_group_enabled", value)


if not MYPY:
    class ClusterServicePrincipalArgsDict(TypedDict):
        client_id: pulumi.Input[builtins.str]
        """
        The Client ID for the Service Principal.
        """
        client_secret: pulumi.Input[builtins.str]
        """
        The Client Secret for the Service Principal.

        > **Note:** Currently a service principal cannot be associated with more than one ARO clusters on the Azure subscription.
        """
elif False:
    ClusterServicePrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterServicePrincipalArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[builtins.str],
                 client_secret: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] client_id: The Client ID for the Service Principal.
        :param pulumi.Input[builtins.str] client_secret: The Client Secret for the Service Principal.
               
               > **Note:** Currently a service principal cannot be associated with more than one ARO clusters on the Azure subscription.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The Client ID for the Service Principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[builtins.str]:
        """
        The Client Secret for the Service Principal.

        > **Note:** Currently a service principal cannot be associated with more than one ARO clusters on the Azure subscription.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_secret", value)


if not MYPY:
    class ClusterWorkerProfileArgsDict(TypedDict):
        disk_size_gb: pulumi.Input[builtins.int]
        """
        The internal OS disk size of the worker Virtual Machines in GB. Changing this forces a new resource to be created.
        """
        node_count: pulumi.Input[builtins.int]
        """
        The initial number of worker nodes which should exist in the cluster. Changing this forces a new resource to be created.
        """
        subnet_id: pulumi.Input[builtins.str]
        """
        The ID of the subnet where worker nodes will be hosted. Changing this forces a new resource to be created.
        """
        vm_size: pulumi.Input[builtins.str]
        """
        The size of the Virtual Machines for the worker nodes. Changing this forces a new resource to be created.
        """
        disk_encryption_set_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource ID of an associated disk encryption set. Changing this forces a new resource to be created.
        """
        encryption_at_host_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether worker virtual machines are encrypted at host. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** `encryption_at_host_enabled` is only available for certain VM sizes and the `EncryptionAtHost` feature must be enabled for your subscription. Please see the [Azure documentation](https://learn.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal?tabs=azure-powershell) for more information.
        """
elif False:
    ClusterWorkerProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterWorkerProfileArgs:
    def __init__(__self__, *,
                 disk_size_gb: pulumi.Input[builtins.int],
                 node_count: pulumi.Input[builtins.int],
                 subnet_id: pulumi.Input[builtins.str],
                 vm_size: pulumi.Input[builtins.str],
                 disk_encryption_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] disk_size_gb: The internal OS disk size of the worker Virtual Machines in GB. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] node_count: The initial number of worker nodes which should exist in the cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet where worker nodes will be hosted. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vm_size: The size of the Virtual Machines for the worker nodes. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] disk_encryption_set_id: The resource ID of an associated disk encryption set. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] encryption_at_host_enabled: Whether worker virtual machines are encrypted at host. Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** `encryption_at_host_enabled` is only available for certain VM sizes and the `EncryptionAtHost` feature must be enabled for your subscription. Please see the [Azure documentation](https://learn.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal?tabs=azure-powershell) for more information.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vm_size", vm_size)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Input[builtins.int]:
        """
        The internal OS disk size of the worker Virtual Machines in GB. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        The initial number of worker nodes which should exist in the cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the subnet where worker nodes will be hosted. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[builtins.str]:
        """
        The size of the Virtual Machines for the worker nodes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of an associated disk encryption set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether worker virtual machines are encrypted at host. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** `encryption_at_host_enabled` is only available for certain VM sizes and the `EncryptionAtHost` feature must be enabled for your subscription. Please see the [Azure documentation](https://learn.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal?tabs=azure-powershell) for more information.
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)


