# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CacheIdentityArgs',
    'CacheIdentityArgsDict',
    'CachePatchScheduleArgs',
    'CachePatchScheduleArgsDict',
    'CacheRedisConfigurationArgs',
    'CacheRedisConfigurationArgsDict',
    'EnterpriseDatabaseModuleArgs',
    'EnterpriseDatabaseModuleArgsDict',
]

MYPY = False

if not MYPY:
    class CacheIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    CacheIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class CachePatchScheduleArgsDict(TypedDict):
        day_of_week: pulumi.Input[builtins.str]
        """
        the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        """
        maintenance_window: NotRequired[pulumi.Input[builtins.str]]
        """
        The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        """
        start_hour_utc: NotRequired[pulumi.Input[builtins.int]]
        """
        the Start Hour for maintenance in UTC - possible values range from `0 - 23`.

        > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
elif False:
    CachePatchScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CachePatchScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[builtins.str],
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 start_hour_utc: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] day_of_week: the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        :param pulumi.Input[builtins.str] maintenance_window: The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        :param pulumi.Input[builtins.int] start_hour_utc: the Start Hour for maintenance in UTC - possible values range from `0 - 23`.
               
               > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if start_hour_utc is not None:
            pulumi.set(__self__, "start_hour_utc", start_hour_utc)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[builtins.str]:
        """
        the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="startHourUtc")
    def start_hour_utc(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        the Start Hour for maintenance in UTC - possible values range from `0 - 23`.

        > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
        return pulumi.get(self, "start_hour_utc")

    @start_hour_utc.setter
    def start_hour_utc(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_hour_utc", value)


if not MYPY:
    class CacheRedisConfigurationArgsDict(TypedDict):
        active_directory_authentication_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        """
        aof_backup_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.

        > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        """
        aof_storage_connection_string0: NotRequired[pulumi.Input[builtins.str]]
        """
        First Storage Account connection string for AOF persistence.
        """
        aof_storage_connection_string1: NotRequired[pulumi.Input[builtins.str]]
        """
        Second Storage Account connection string for AOF persistence.

        Example usage:
        """
        authentication_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.

        > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        """
        data_persistence_authentication_method: NotRequired[pulumi.Input[builtins.str]]
        """
        Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        """
        maxclients: NotRequired[pulumi.Input[builtins.int]]
        """
        Returns the max number of connected clients at the same time.
        """
        maxfragmentationmemory_reserved: NotRequired[pulumi.Input[builtins.int]]
        """
        Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        """
        maxmemory_delta: NotRequired[pulumi.Input[builtins.int]]
        """
        The max-memory delta for this Redis instance. Defaults are shown below.
        """
        maxmemory_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        """
        maxmemory_reserved: NotRequired[pulumi.Input[builtins.int]]
        """
        Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        """
        notify_keyspace_events: NotRequired[pulumi.Input[builtins.str]]
        """
        Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        """
        rdb_backup_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.

        > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        """
        rdb_backup_frequency: NotRequired[pulumi.Input[builtins.int]]
        """
        The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        """
        rdb_backup_max_snapshot_count: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        """
        rdb_storage_connection_string: NotRequired[pulumi.Input[builtins.str]]
        """
        The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.

        > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        """
        storage_account_subscription_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the Subscription containing the Storage Account.
        """
elif False:
    CacheRedisConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheRedisConfigurationArgs:
    def __init__(__self__, *,
                 active_directory_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 aof_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 aof_storage_connection_string0: Optional[pulumi.Input[builtins.str]] = None,
                 aof_storage_connection_string1: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 data_persistence_authentication_method: Optional[pulumi.Input[builtins.str]] = None,
                 maxclients: Optional[pulumi.Input[builtins.int]] = None,
                 maxfragmentationmemory_reserved: Optional[pulumi.Input[builtins.int]] = None,
                 maxmemory_delta: Optional[pulumi.Input[builtins.int]] = None,
                 maxmemory_policy: Optional[pulumi.Input[builtins.str]] = None,
                 maxmemory_reserved: Optional[pulumi.Input[builtins.int]] = None,
                 notify_keyspace_events: Optional[pulumi.Input[builtins.str]] = None,
                 rdb_backup_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 rdb_backup_frequency: Optional[pulumi.Input[builtins.int]] = None,
                 rdb_backup_max_snapshot_count: Optional[pulumi.Input[builtins.int]] = None,
                 rdb_storage_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_subscription_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] active_directory_authentication_enabled: Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        :param pulumi.Input[builtins.bool] aof_backup_enabled: Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.
               
               > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        :param pulumi.Input[builtins.str] aof_storage_connection_string0: First Storage Account connection string for AOF persistence.
        :param pulumi.Input[builtins.str] aof_storage_connection_string1: Second Storage Account connection string for AOF persistence.
               
               Example usage:
        :param pulumi.Input[builtins.bool] authentication_enabled: If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.
               
               > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        :param pulumi.Input[builtins.str] data_persistence_authentication_method: Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        :param pulumi.Input[builtins.int] maxclients: Returns the max number of connected clients at the same time.
        :param pulumi.Input[builtins.int] maxfragmentationmemory_reserved: Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        :param pulumi.Input[builtins.int] maxmemory_delta: The max-memory delta for this Redis instance. Defaults are shown below.
        :param pulumi.Input[builtins.str] maxmemory_policy: How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        :param pulumi.Input[builtins.int] maxmemory_reserved: Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        :param pulumi.Input[builtins.str] notify_keyspace_events: Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        :param pulumi.Input[builtins.bool] rdb_backup_enabled: Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.
               
               > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        :param pulumi.Input[builtins.int] rdb_backup_frequency: The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        :param pulumi.Input[builtins.int] rdb_backup_max_snapshot_count: The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        :param pulumi.Input[builtins.str] rdb_storage_connection_string: The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.
               
               > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        :param pulumi.Input[builtins.str] storage_account_subscription_id: The ID of the Subscription containing the Storage Account.
        """
        if active_directory_authentication_enabled is not None:
            pulumi.set(__self__, "active_directory_authentication_enabled", active_directory_authentication_enabled)
        if aof_backup_enabled is not None:
            pulumi.set(__self__, "aof_backup_enabled", aof_backup_enabled)
        if aof_storage_connection_string0 is not None:
            pulumi.set(__self__, "aof_storage_connection_string0", aof_storage_connection_string0)
        if aof_storage_connection_string1 is not None:
            pulumi.set(__self__, "aof_storage_connection_string1", aof_storage_connection_string1)
        if authentication_enabled is not None:
            pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        if data_persistence_authentication_method is not None:
            pulumi.set(__self__, "data_persistence_authentication_method", data_persistence_authentication_method)
        if maxclients is not None:
            pulumi.set(__self__, "maxclients", maxclients)
        if maxfragmentationmemory_reserved is not None:
            pulumi.set(__self__, "maxfragmentationmemory_reserved", maxfragmentationmemory_reserved)
        if maxmemory_delta is not None:
            pulumi.set(__self__, "maxmemory_delta", maxmemory_delta)
        if maxmemory_policy is not None:
            pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        if maxmemory_reserved is not None:
            pulumi.set(__self__, "maxmemory_reserved", maxmemory_reserved)
        if notify_keyspace_events is not None:
            pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        if rdb_backup_enabled is not None:
            pulumi.set(__self__, "rdb_backup_enabled", rdb_backup_enabled)
        if rdb_backup_frequency is not None:
            pulumi.set(__self__, "rdb_backup_frequency", rdb_backup_frequency)
        if rdb_backup_max_snapshot_count is not None:
            pulumi.set(__self__, "rdb_backup_max_snapshot_count", rdb_backup_max_snapshot_count)
        if rdb_storage_connection_string is not None:
            pulumi.set(__self__, "rdb_storage_connection_string", rdb_storage_connection_string)
        if storage_account_subscription_id is not None:
            pulumi.set(__self__, "storage_account_subscription_id", storage_account_subscription_id)

    @property
    @pulumi.getter(name="activeDirectoryAuthenticationEnabled")
    def active_directory_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        """
        return pulumi.get(self, "active_directory_authentication_enabled")

    @active_directory_authentication_enabled.setter
    def active_directory_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active_directory_authentication_enabled", value)

    @property
    @pulumi.getter(name="aofBackupEnabled")
    def aof_backup_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.

        > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        """
        return pulumi.get(self, "aof_backup_enabled")

    @aof_backup_enabled.setter
    def aof_backup_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aof_backup_enabled", value)

    @property
    @pulumi.getter(name="aofStorageConnectionString0")
    def aof_storage_connection_string0(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        First Storage Account connection string for AOF persistence.
        """
        return pulumi.get(self, "aof_storage_connection_string0")

    @aof_storage_connection_string0.setter
    def aof_storage_connection_string0(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aof_storage_connection_string0", value)

    @property
    @pulumi.getter(name="aofStorageConnectionString1")
    def aof_storage_connection_string1(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Second Storage Account connection string for AOF persistence.

        Example usage:
        """
        return pulumi.get(self, "aof_storage_connection_string1")

    @aof_storage_connection_string1.setter
    def aof_storage_connection_string1(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aof_storage_connection_string1", value)

    @property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.

        > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        """
        return pulumi.get(self, "authentication_enabled")

    @authentication_enabled.setter
    def authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_enabled", value)

    @property
    @pulumi.getter(name="dataPersistenceAuthenticationMethod")
    def data_persistence_authentication_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        """
        return pulumi.get(self, "data_persistence_authentication_method")

    @data_persistence_authentication_method.setter
    def data_persistence_authentication_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_persistence_authentication_method", value)

    @property
    @pulumi.getter
    def maxclients(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Returns the max number of connected clients at the same time.
        """
        return pulumi.get(self, "maxclients")

    @maxclients.setter
    def maxclients(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maxclients", value)

    @property
    @pulumi.getter(name="maxfragmentationmemoryReserved")
    def maxfragmentationmemory_reserved(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        """
        return pulumi.get(self, "maxfragmentationmemory_reserved")

    @maxfragmentationmemory_reserved.setter
    def maxfragmentationmemory_reserved(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maxfragmentationmemory_reserved", value)

    @property
    @pulumi.getter(name="maxmemoryDelta")
    def maxmemory_delta(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max-memory delta for this Redis instance. Defaults are shown below.
        """
        return pulumi.get(self, "maxmemory_delta")

    @maxmemory_delta.setter
    def maxmemory_delta(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maxmemory_delta", value)

    @property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        """
        return pulumi.get(self, "maxmemory_policy")

    @maxmemory_policy.setter
    def maxmemory_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maxmemory_policy", value)

    @property
    @pulumi.getter(name="maxmemoryReserved")
    def maxmemory_reserved(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        """
        return pulumi.get(self, "maxmemory_reserved")

    @maxmemory_reserved.setter
    def maxmemory_reserved(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maxmemory_reserved", value)

    @property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        """
        return pulumi.get(self, "notify_keyspace_events")

    @notify_keyspace_events.setter
    def notify_keyspace_events(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notify_keyspace_events", value)

    @property
    @pulumi.getter(name="rdbBackupEnabled")
    def rdb_backup_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.

        > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        """
        return pulumi.get(self, "rdb_backup_enabled")

    @rdb_backup_enabled.setter
    def rdb_backup_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "rdb_backup_enabled", value)

    @property
    @pulumi.getter(name="rdbBackupFrequency")
    def rdb_backup_frequency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        """
        return pulumi.get(self, "rdb_backup_frequency")

    @rdb_backup_frequency.setter
    def rdb_backup_frequency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rdb_backup_frequency", value)

    @property
    @pulumi.getter(name="rdbBackupMaxSnapshotCount")
    def rdb_backup_max_snapshot_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_max_snapshot_count")

    @rdb_backup_max_snapshot_count.setter
    def rdb_backup_max_snapshot_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rdb_backup_max_snapshot_count", value)

    @property
    @pulumi.getter(name="rdbStorageConnectionString")
    def rdb_storage_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.

        > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        """
        return pulumi.get(self, "rdb_storage_connection_string")

    @rdb_storage_connection_string.setter
    def rdb_storage_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rdb_storage_connection_string", value)

    @property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Subscription containing the Storage Account.
        """
        return pulumi.get(self, "storage_account_subscription_id")

    @storage_account_subscription_id.setter
    def storage_account_subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_subscription_id", value)


if not MYPY:
    class EnterpriseDatabaseModuleArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        """
        args: NotRequired[pulumi.Input[builtins.str]]
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    EnterpriseDatabaseModuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnterpriseDatabaseModuleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 args: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[builtins.str] args: Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


