# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FirewallRuleArgs', 'FirewallRule']

@pulumi.input_type
class FirewallRuleArgs:
    def __init__(__self__, *,
                 end_ip: pulumi.Input[builtins.str],
                 redis_cache_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 start_ip: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FirewallRule resource.
        :param pulumi.Input[builtins.str] end_ip: The highest IP address included in the range.
        :param pulumi.Input[builtins.str] redis_cache_name: The name of the Redis Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] start_ip: The lowest IP address included in the range
        :param pulumi.Input[builtins.str] name: The name of the Firewall Rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "end_ip", end_ip)
        pulumi.set(__self__, "redis_cache_name", redis_cache_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "start_ip", start_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endIp")
    def end_ip(self) -> pulumi.Input[builtins.str]:
        """
        The highest IP address included in the range.
        """
        return pulumi.get(self, "end_ip")

    @end_ip.setter
    def end_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "end_ip", value)

    @property
    @pulumi.getter(name="redisCacheName")
    def redis_cache_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Redis Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "redis_cache_name")

    @redis_cache_name.setter
    def redis_cache_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "redis_cache_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="startIp")
    def start_ip(self) -> pulumi.Input[builtins.str]:
        """
        The lowest IP address included in the range
        """
        return pulumi.get(self, "start_ip")

    @start_ip.setter
    def start_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Firewall Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FirewallRuleState:
    def __init__(__self__, *,
                 end_ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redis_cache_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 start_ip: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallRule resources.
        :param pulumi.Input[builtins.str] end_ip: The highest IP address included in the range.
        :param pulumi.Input[builtins.str] name: The name of the Firewall Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redis_cache_name: The name of the Redis Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] start_ip: The lowest IP address included in the range
        """
        if end_ip is not None:
            pulumi.set(__self__, "end_ip", end_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redis_cache_name is not None:
            pulumi.set(__self__, "redis_cache_name", redis_cache_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if start_ip is not None:
            pulumi.set(__self__, "start_ip", start_ip)

    @property
    @pulumi.getter(name="endIp")
    def end_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The highest IP address included in the range.
        """
        return pulumi.get(self, "end_ip")

    @end_ip.setter
    def end_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Firewall Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redisCacheName")
    def redis_cache_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Redis Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "redis_cache_name")

    @redis_cache_name.setter
    def redis_cache_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redis_cache_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="startIp")
    def start_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lowest IP address included in the range
        """
        return pulumi.get(self, "start_ip")

    @start_ip.setter
    def start_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_ip", value)


@pulumi.type_token("azure:redis/firewallRule:FirewallRule")
class FirewallRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redis_cache_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 start_ip: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Firewall Rule associated with a Redis Cache.

        ## Import

        Redis Firewall Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/firewallRule:FirewallRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redis/cache1/firewallRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] end_ip: The highest IP address included in the range.
        :param pulumi.Input[builtins.str] name: The name of the Firewall Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redis_cache_name: The name of the Redis Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] start_ip: The lowest IP address included in the range
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Firewall Rule associated with a Redis Cache.

        ## Import

        Redis Firewall Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/firewallRule:FirewallRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redis/cache1/firewallRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param FirewallRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redis_cache_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 start_ip: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallRuleArgs.__new__(FirewallRuleArgs)

            if end_ip is None and not opts.urn:
                raise TypeError("Missing required property 'end_ip'")
            __props__.__dict__["end_ip"] = end_ip
            __props__.__dict__["name"] = name
            if redis_cache_name is None and not opts.urn:
                raise TypeError("Missing required property 'redis_cache_name'")
            __props__.__dict__["redis_cache_name"] = redis_cache_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if start_ip is None and not opts.urn:
                raise TypeError("Missing required property 'start_ip'")
            __props__.__dict__["start_ip"] = start_ip
        super(FirewallRule, __self__).__init__(
            'azure:redis/firewallRule:FirewallRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            end_ip: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            redis_cache_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            start_ip: Optional[pulumi.Input[builtins.str]] = None) -> 'FirewallRule':
        """
        Get an existing FirewallRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] end_ip: The highest IP address included in the range.
        :param pulumi.Input[builtins.str] name: The name of the Firewall Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redis_cache_name: The name of the Redis Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] start_ip: The lowest IP address included in the range
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallRuleState.__new__(_FirewallRuleState)

        __props__.__dict__["end_ip"] = end_ip
        __props__.__dict__["name"] = name
        __props__.__dict__["redis_cache_name"] = redis_cache_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["start_ip"] = start_ip
        return FirewallRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="endIp")
    def end_ip(self) -> pulumi.Output[builtins.str]:
        """
        The highest IP address included in the range.
        """
        return pulumi.get(self, "end_ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Firewall Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redisCacheName")
    def redis_cache_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Redis Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "redis_cache_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which this Redis Cache exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="startIp")
    def start_ip(self) -> pulumi.Output[builtins.str]:
        """
        The lowest IP address included in the range
        """
        return pulumi.get(self, "start_ip")

