# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CacheIdentity',
    'CachePatchSchedule',
    'CacheRedisConfiguration',
    'EnterpriseDatabaseModule',
    'GetCachePatchScheduleResult',
    'GetCacheRedisConfigurationResult',
]

@pulumi.output_type
class CacheIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CachePatchSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "startHourUtc":
            suggest = "start_hour_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePatchSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePatchSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePatchSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 maintenance_window: Optional[builtins.str] = None,
                 start_hour_utc: Optional[builtins.int] = None):
        """
        :param builtins.str day_of_week: the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        :param builtins.str maintenance_window: The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        :param builtins.int start_hour_utc: the Start Hour for maintenance in UTC - possible values range from `0 - 23`.
               
               > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if start_hour_utc is not None:
            pulumi.set(__self__, "start_hour_utc", start_hour_utc)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[builtins.str]:
        """
        The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="startHourUtc")
    def start_hour_utc(self) -> Optional[builtins.int]:
        """
        the Start Hour for maintenance in UTC - possible values range from `0 - 23`.

        > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
        return pulumi.get(self, "start_hour_utc")


@pulumi.output_type
class CacheRedisConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryAuthenticationEnabled":
            suggest = "active_directory_authentication_enabled"
        elif key == "aofBackupEnabled":
            suggest = "aof_backup_enabled"
        elif key == "aofStorageConnectionString0":
            suggest = "aof_storage_connection_string0"
        elif key == "aofStorageConnectionString1":
            suggest = "aof_storage_connection_string1"
        elif key == "authenticationEnabled":
            suggest = "authentication_enabled"
        elif key == "dataPersistenceAuthenticationMethod":
            suggest = "data_persistence_authentication_method"
        elif key == "maxfragmentationmemoryReserved":
            suggest = "maxfragmentationmemory_reserved"
        elif key == "maxmemoryDelta":
            suggest = "maxmemory_delta"
        elif key == "maxmemoryPolicy":
            suggest = "maxmemory_policy"
        elif key == "maxmemoryReserved":
            suggest = "maxmemory_reserved"
        elif key == "notifyKeyspaceEvents":
            suggest = "notify_keyspace_events"
        elif key == "rdbBackupEnabled":
            suggest = "rdb_backup_enabled"
        elif key == "rdbBackupFrequency":
            suggest = "rdb_backup_frequency"
        elif key == "rdbBackupMaxSnapshotCount":
            suggest = "rdb_backup_max_snapshot_count"
        elif key == "rdbStorageConnectionString":
            suggest = "rdb_storage_connection_string"
        elif key == "storageAccountSubscriptionId":
            suggest = "storage_account_subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheRedisConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheRedisConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheRedisConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_authentication_enabled: Optional[builtins.bool] = None,
                 aof_backup_enabled: Optional[builtins.bool] = None,
                 aof_storage_connection_string0: Optional[builtins.str] = None,
                 aof_storage_connection_string1: Optional[builtins.str] = None,
                 authentication_enabled: Optional[builtins.bool] = None,
                 data_persistence_authentication_method: Optional[builtins.str] = None,
                 maxclients: Optional[builtins.int] = None,
                 maxfragmentationmemory_reserved: Optional[builtins.int] = None,
                 maxmemory_delta: Optional[builtins.int] = None,
                 maxmemory_policy: Optional[builtins.str] = None,
                 maxmemory_reserved: Optional[builtins.int] = None,
                 notify_keyspace_events: Optional[builtins.str] = None,
                 rdb_backup_enabled: Optional[builtins.bool] = None,
                 rdb_backup_frequency: Optional[builtins.int] = None,
                 rdb_backup_max_snapshot_count: Optional[builtins.int] = None,
                 rdb_storage_connection_string: Optional[builtins.str] = None,
                 storage_account_subscription_id: Optional[builtins.str] = None):
        """
        :param builtins.bool active_directory_authentication_enabled: Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        :param builtins.bool aof_backup_enabled: Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.
               
               > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        :param builtins.str aof_storage_connection_string0: First Storage Account connection string for AOF persistence.
        :param builtins.str aof_storage_connection_string1: Second Storage Account connection string for AOF persistence.
               
               Example usage:
        :param builtins.bool authentication_enabled: If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.
               
               > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        :param builtins.str data_persistence_authentication_method: Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        :param builtins.int maxclients: Returns the max number of connected clients at the same time.
        :param builtins.int maxfragmentationmemory_reserved: Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        :param builtins.int maxmemory_delta: The max-memory delta for this Redis instance. Defaults are shown below.
        :param builtins.str maxmemory_policy: How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        :param builtins.int maxmemory_reserved: Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        :param builtins.str notify_keyspace_events: Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        :param builtins.bool rdb_backup_enabled: Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.
               
               > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        :param builtins.int rdb_backup_frequency: The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        :param builtins.int rdb_backup_max_snapshot_count: The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        :param builtins.str rdb_storage_connection_string: The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.
               
               > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        :param builtins.str storage_account_subscription_id: The ID of the Subscription containing the Storage Account.
        """
        if active_directory_authentication_enabled is not None:
            pulumi.set(__self__, "active_directory_authentication_enabled", active_directory_authentication_enabled)
        if aof_backup_enabled is not None:
            pulumi.set(__self__, "aof_backup_enabled", aof_backup_enabled)
        if aof_storage_connection_string0 is not None:
            pulumi.set(__self__, "aof_storage_connection_string0", aof_storage_connection_string0)
        if aof_storage_connection_string1 is not None:
            pulumi.set(__self__, "aof_storage_connection_string1", aof_storage_connection_string1)
        if authentication_enabled is not None:
            pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        if data_persistence_authentication_method is not None:
            pulumi.set(__self__, "data_persistence_authentication_method", data_persistence_authentication_method)
        if maxclients is not None:
            pulumi.set(__self__, "maxclients", maxclients)
        if maxfragmentationmemory_reserved is not None:
            pulumi.set(__self__, "maxfragmentationmemory_reserved", maxfragmentationmemory_reserved)
        if maxmemory_delta is not None:
            pulumi.set(__self__, "maxmemory_delta", maxmemory_delta)
        if maxmemory_policy is not None:
            pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        if maxmemory_reserved is not None:
            pulumi.set(__self__, "maxmemory_reserved", maxmemory_reserved)
        if notify_keyspace_events is not None:
            pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        if rdb_backup_enabled is not None:
            pulumi.set(__self__, "rdb_backup_enabled", rdb_backup_enabled)
        if rdb_backup_frequency is not None:
            pulumi.set(__self__, "rdb_backup_frequency", rdb_backup_frequency)
        if rdb_backup_max_snapshot_count is not None:
            pulumi.set(__self__, "rdb_backup_max_snapshot_count", rdb_backup_max_snapshot_count)
        if rdb_storage_connection_string is not None:
            pulumi.set(__self__, "rdb_storage_connection_string", rdb_storage_connection_string)
        if storage_account_subscription_id is not None:
            pulumi.set(__self__, "storage_account_subscription_id", storage_account_subscription_id)

    @property
    @pulumi.getter(name="activeDirectoryAuthenticationEnabled")
    def active_directory_authentication_enabled(self) -> Optional[builtins.bool]:
        """
        Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        """
        return pulumi.get(self, "active_directory_authentication_enabled")

    @property
    @pulumi.getter(name="aofBackupEnabled")
    def aof_backup_enabled(self) -> Optional[builtins.bool]:
        """
        Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.

        > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        """
        return pulumi.get(self, "aof_backup_enabled")

    @property
    @pulumi.getter(name="aofStorageConnectionString0")
    def aof_storage_connection_string0(self) -> Optional[builtins.str]:
        """
        First Storage Account connection string for AOF persistence.
        """
        return pulumi.get(self, "aof_storage_connection_string0")

    @property
    @pulumi.getter(name="aofStorageConnectionString1")
    def aof_storage_connection_string1(self) -> Optional[builtins.str]:
        """
        Second Storage Account connection string for AOF persistence.

        Example usage:
        """
        return pulumi.get(self, "aof_storage_connection_string1")

    @property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> Optional[builtins.bool]:
        """
        If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.

        > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        """
        return pulumi.get(self, "authentication_enabled")

    @property
    @pulumi.getter(name="dataPersistenceAuthenticationMethod")
    def data_persistence_authentication_method(self) -> Optional[builtins.str]:
        """
        Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        """
        return pulumi.get(self, "data_persistence_authentication_method")

    @property
    @pulumi.getter
    def maxclients(self) -> Optional[builtins.int]:
        """
        Returns the max number of connected clients at the same time.
        """
        return pulumi.get(self, "maxclients")

    @property
    @pulumi.getter(name="maxfragmentationmemoryReserved")
    def maxfragmentationmemory_reserved(self) -> Optional[builtins.int]:
        """
        Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        """
        return pulumi.get(self, "maxfragmentationmemory_reserved")

    @property
    @pulumi.getter(name="maxmemoryDelta")
    def maxmemory_delta(self) -> Optional[builtins.int]:
        """
        The max-memory delta for this Redis instance. Defaults are shown below.
        """
        return pulumi.get(self, "maxmemory_delta")

    @property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> Optional[builtins.str]:
        """
        How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        """
        return pulumi.get(self, "maxmemory_policy")

    @property
    @pulumi.getter(name="maxmemoryReserved")
    def maxmemory_reserved(self) -> Optional[builtins.int]:
        """
        Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        """
        return pulumi.get(self, "maxmemory_reserved")

    @property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> Optional[builtins.str]:
        """
        Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        """
        return pulumi.get(self, "notify_keyspace_events")

    @property
    @pulumi.getter(name="rdbBackupEnabled")
    def rdb_backup_enabled(self) -> Optional[builtins.bool]:
        """
        Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.

        > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        """
        return pulumi.get(self, "rdb_backup_enabled")

    @property
    @pulumi.getter(name="rdbBackupFrequency")
    def rdb_backup_frequency(self) -> Optional[builtins.int]:
        """
        The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        """
        return pulumi.get(self, "rdb_backup_frequency")

    @property
    @pulumi.getter(name="rdbBackupMaxSnapshotCount")
    def rdb_backup_max_snapshot_count(self) -> Optional[builtins.int]:
        """
        The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_max_snapshot_count")

    @property
    @pulumi.getter(name="rdbStorageConnectionString")
    def rdb_storage_connection_string(self) -> Optional[builtins.str]:
        """
        The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.

        > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        """
        return pulumi.get(self, "rdb_storage_connection_string")

    @property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> Optional[builtins.str]:
        """
        The ID of the Subscription containing the Storage Account.
        """
        return pulumi.get(self, "storage_account_subscription_id")


@pulumi.output_type
class EnterpriseDatabaseModule(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 args: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        :param builtins.str args: Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def args(self) -> Optional[builtins.str]:
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCachePatchScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 maintenance_window: builtins.str,
                 start_hour_utc: builtins.int):
        """
        :param builtins.str day_of_week: the Weekday name for the patch item
        :param builtins.str maintenance_window: The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated.
        :param builtins.int start_hour_utc: The Start Hour for maintenance in UTC
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "start_hour_utc", start_hour_utc)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        the Weekday name for the patch item
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> builtins.str:
        """
        The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="startHourUtc")
    def start_hour_utc(self) -> builtins.int:
        """
        The Start Hour for maintenance in UTC
        """
        return pulumi.get(self, "start_hour_utc")


@pulumi.output_type
class GetCacheRedisConfigurationResult(dict):
    def __init__(__self__, *,
                 active_directory_authentication_enabled: builtins.bool,
                 aof_backup_enabled: builtins.bool,
                 aof_storage_connection_string0: builtins.str,
                 aof_storage_connection_string1: builtins.str,
                 authentication_enabled: builtins.bool,
                 data_persistence_authentication_method: builtins.str,
                 maxclients: builtins.int,
                 maxfragmentationmemory_reserved: builtins.int,
                 maxmemory_delta: builtins.int,
                 maxmemory_policy: builtins.str,
                 maxmemory_reserved: builtins.int,
                 notify_keyspace_events: builtins.str,
                 rdb_backup_enabled: builtins.bool,
                 rdb_backup_frequency: builtins.int,
                 rdb_backup_max_snapshot_count: builtins.int,
                 rdb_storage_connection_string: builtins.str,
                 storage_account_subscription_id: builtins.str):
        """
        :param builtins.bool active_directory_authentication_enabled: Specifies if Microsoft Entra (AAD) authentication is enabled.
        :param builtins.int maxfragmentationmemory_reserved: Value in megabytes reserved to accommodate for memory fragmentation.
        :param builtins.int maxmemory_delta: The max-memory delta for this Redis instance.
        :param builtins.str maxmemory_policy: How Redis will select what to remove when `maxmemory` is reached.
        :param builtins.int maxmemory_reserved: The value in megabytes reserved for non-cache usage e.g. failover
        :param builtins.bool rdb_backup_enabled: Is Backup Enabled? Only supported on Premium SKUs.
        :param builtins.int rdb_backup_frequency: The Backup Frequency in Minutes. Only supported on Premium SKUs.
        :param builtins.int rdb_backup_max_snapshot_count: The maximum number of snapshots that can be created as a backup.
        :param builtins.str rdb_storage_connection_string: The Connection String to the Storage Account. Only supported for Premium SKUs.
        :param builtins.str storage_account_subscription_id: The ID of the Subscription containing the Storage Account.
        """
        pulumi.set(__self__, "active_directory_authentication_enabled", active_directory_authentication_enabled)
        pulumi.set(__self__, "aof_backup_enabled", aof_backup_enabled)
        pulumi.set(__self__, "aof_storage_connection_string0", aof_storage_connection_string0)
        pulumi.set(__self__, "aof_storage_connection_string1", aof_storage_connection_string1)
        pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        pulumi.set(__self__, "data_persistence_authentication_method", data_persistence_authentication_method)
        pulumi.set(__self__, "maxclients", maxclients)
        pulumi.set(__self__, "maxfragmentationmemory_reserved", maxfragmentationmemory_reserved)
        pulumi.set(__self__, "maxmemory_delta", maxmemory_delta)
        pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        pulumi.set(__self__, "maxmemory_reserved", maxmemory_reserved)
        pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        pulumi.set(__self__, "rdb_backup_enabled", rdb_backup_enabled)
        pulumi.set(__self__, "rdb_backup_frequency", rdb_backup_frequency)
        pulumi.set(__self__, "rdb_backup_max_snapshot_count", rdb_backup_max_snapshot_count)
        pulumi.set(__self__, "rdb_storage_connection_string", rdb_storage_connection_string)
        pulumi.set(__self__, "storage_account_subscription_id", storage_account_subscription_id)

    @property
    @pulumi.getter(name="activeDirectoryAuthenticationEnabled")
    def active_directory_authentication_enabled(self) -> builtins.bool:
        """
        Specifies if Microsoft Entra (AAD) authentication is enabled.
        """
        return pulumi.get(self, "active_directory_authentication_enabled")

    @property
    @pulumi.getter(name="aofBackupEnabled")
    def aof_backup_enabled(self) -> builtins.bool:
        return pulumi.get(self, "aof_backup_enabled")

    @property
    @pulumi.getter(name="aofStorageConnectionString0")
    def aof_storage_connection_string0(self) -> builtins.str:
        return pulumi.get(self, "aof_storage_connection_string0")

    @property
    @pulumi.getter(name="aofStorageConnectionString1")
    def aof_storage_connection_string1(self) -> builtins.str:
        return pulumi.get(self, "aof_storage_connection_string1")

    @property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> builtins.bool:
        return pulumi.get(self, "authentication_enabled")

    @property
    @pulumi.getter(name="dataPersistenceAuthenticationMethod")
    def data_persistence_authentication_method(self) -> builtins.str:
        return pulumi.get(self, "data_persistence_authentication_method")

    @property
    @pulumi.getter
    def maxclients(self) -> builtins.int:
        return pulumi.get(self, "maxclients")

    @property
    @pulumi.getter(name="maxfragmentationmemoryReserved")
    def maxfragmentationmemory_reserved(self) -> builtins.int:
        """
        Value in megabytes reserved to accommodate for memory fragmentation.
        """
        return pulumi.get(self, "maxfragmentationmemory_reserved")

    @property
    @pulumi.getter(name="maxmemoryDelta")
    def maxmemory_delta(self) -> builtins.int:
        """
        The max-memory delta for this Redis instance.
        """
        return pulumi.get(self, "maxmemory_delta")

    @property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> builtins.str:
        """
        How Redis will select what to remove when `maxmemory` is reached.
        """
        return pulumi.get(self, "maxmemory_policy")

    @property
    @pulumi.getter(name="maxmemoryReserved")
    def maxmemory_reserved(self) -> builtins.int:
        """
        The value in megabytes reserved for non-cache usage e.g. failover
        """
        return pulumi.get(self, "maxmemory_reserved")

    @property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> builtins.str:
        return pulumi.get(self, "notify_keyspace_events")

    @property
    @pulumi.getter(name="rdbBackupEnabled")
    def rdb_backup_enabled(self) -> builtins.bool:
        """
        Is Backup Enabled? Only supported on Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_enabled")

    @property
    @pulumi.getter(name="rdbBackupFrequency")
    def rdb_backup_frequency(self) -> builtins.int:
        """
        The Backup Frequency in Minutes. Only supported on Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_frequency")

    @property
    @pulumi.getter(name="rdbBackupMaxSnapshotCount")
    def rdb_backup_max_snapshot_count(self) -> builtins.int:
        """
        The maximum number of snapshots that can be created as a backup.
        """
        return pulumi.get(self, "rdb_backup_max_snapshot_count")

    @property
    @pulumi.getter(name="rdbStorageConnectionString")
    def rdb_storage_connection_string(self) -> builtins.str:
        """
        The Connection String to the Storage Account. Only supported for Premium SKUs.
        """
        return pulumi.get(self, "rdb_storage_connection_string")

    @property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> builtins.str:
        """
        The ID of the Subscription containing the Storage Account.
        """
        return pulumi.get(self, "storage_account_subscription_id")


