# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRoleDefinitionResult',
    'AwaitableGetRoleDefinitionResult',
    'get_role_definition',
    'get_role_definition_output',
]

warnings.warn("""azure.role.getRoleDefinition has been deprecated in favor of azure.authorization.getRoleDefinition""", DeprecationWarning)

@pulumi.output_type
class GetRoleDefinitionResult:
    """
    A collection of values returned by getRoleDefinition.
    """
    def __init__(__self__, assignable_scopes=None, description=None, id=None, name=None, permissions=None, role_definition_id=None, scope=None, type=None):
        if assignable_scopes and not isinstance(assignable_scopes, list):
            raise TypeError("Expected argument 'assignable_scopes' to be a list")
        pulumi.set(__self__, "assignable_scopes", assignable_scopes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if role_definition_id and not isinstance(role_definition_id, str):
            raise TypeError("Expected argument 'role_definition_id' to be a str")
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> Sequence[builtins.str]:
        """
        One or more assignable scopes for this Role Definition, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`.
        """
        return pulumi.get(self, "assignable_scopes")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The Description of the built-in Role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetRoleDefinitionPermissionResult']:
        """
        A `permissions` block as documented below.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> builtins.str:
        return pulumi.get(self, "role_definition_id")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of the Role.
        """
        return pulumi.get(self, "type")


class AwaitableGetRoleDefinitionResult(GetRoleDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleDefinitionResult(
            assignable_scopes=self.assignable_scopes,
            description=self.description,
            id=self.id,
            name=self.name,
            permissions=self.permissions,
            role_definition_id=self.role_definition_id,
            scope=self.scope,
            type=self.type)


def get_role_definition(name: Optional[builtins.str] = None,
                        role_definition_id: Optional[builtins.str] = None,
                        scope: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleDefinitionResult:
    """
    Use this data source to access information about an existing Role Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    primary = azure.core.get_subscription()
    custom_role_definition = azure.authorization.RoleDefinition("custom",
        role_definition_id="00000000-0000-0000-0000-000000000000",
        name="CustomRoleDef",
        scope=primary.id)
    custom = custom_role_definition.role_definition_id.apply(lambda role_definition_id: azure.authorization.get_role_definition(role_definition_id=role_definition_id,
        scope=primary.id))
    custom_byname = custom_role_definition.name.apply(lambda name: azure.authorization.get_role_definition(name=name,
        scope=primary.id))
    builtin = azure.authorization.get_role_definition(name="Contributor")
    pulumi.export("customRoleDefinitionId", custom.id)
    pulumi.export("contributorRoleDefinitionId", builtin.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Authorization`: 2022-05-01-preview


    :param builtins.str name: Specifies the Name of either a built-in or custom Role Definition.
           
           > **Note:** You can also use this for built-in roles such as `Contributor`, `Owner`, `Reader` and `Virtual Machine Contributor`
    :param builtins.str role_definition_id: Specifies the ID of the Role Definition as a UUID/GUID.
    :param builtins.str scope: Specifies the Scope at which the Custom Role Definition exists.
           
           > **Note:** One of `name` or `role_definition_id` must be specified.
    """
    pulumi.log.warn("""get_role_definition is deprecated: azure.role.getRoleDefinition has been deprecated in favor of azure.authorization.getRoleDefinition""")
    __args__ = dict()
    __args__['name'] = name
    __args__['roleDefinitionId'] = role_definition_id
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:role/getRoleDefinition:getRoleDefinition', __args__, opts=opts, typ=GetRoleDefinitionResult).value

    return AwaitableGetRoleDefinitionResult(
        assignable_scopes=pulumi.get(__ret__, 'assignable_scopes'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        role_definition_id=pulumi.get(__ret__, 'role_definition_id'),
        scope=pulumi.get(__ret__, 'scope'),
        type=pulumi.get(__ret__, 'type'))
def get_role_definition_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               role_definition_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               scope: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoleDefinitionResult]:
    """
    Use this data source to access information about an existing Role Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    primary = azure.core.get_subscription()
    custom_role_definition = azure.authorization.RoleDefinition("custom",
        role_definition_id="00000000-0000-0000-0000-000000000000",
        name="CustomRoleDef",
        scope=primary.id)
    custom = custom_role_definition.role_definition_id.apply(lambda role_definition_id: azure.authorization.get_role_definition(role_definition_id=role_definition_id,
        scope=primary.id))
    custom_byname = custom_role_definition.name.apply(lambda name: azure.authorization.get_role_definition(name=name,
        scope=primary.id))
    builtin = azure.authorization.get_role_definition(name="Contributor")
    pulumi.export("customRoleDefinitionId", custom.id)
    pulumi.export("contributorRoleDefinitionId", builtin.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Authorization`: 2022-05-01-preview


    :param builtins.str name: Specifies the Name of either a built-in or custom Role Definition.
           
           > **Note:** You can also use this for built-in roles such as `Contributor`, `Owner`, `Reader` and `Virtual Machine Contributor`
    :param builtins.str role_definition_id: Specifies the ID of the Role Definition as a UUID/GUID.
    :param builtins.str scope: Specifies the Scope at which the Custom Role Definition exists.
           
           > **Note:** One of `name` or `role_definition_id` must be specified.
    """
    pulumi.log.warn("""get_role_definition is deprecated: azure.role.getRoleDefinition has been deprecated in favor of azure.authorization.getRoleDefinition""")
    __args__ = dict()
    __args__['name'] = name
    __args__['roleDefinitionId'] = role_definition_id
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:role/getRoleDefinition:getRoleDefinition', __args__, opts=opts, typ=GetRoleDefinitionResult)
    return __ret__.apply(lambda __response__: GetRoleDefinitionResult(
        assignable_scopes=pulumi.get(__response__, 'assignable_scopes'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        role_definition_id=pulumi.get(__response__, 'role_definition_id'),
        scope=pulumi.get(__response__, 'scope'),
        type=pulumi.get(__response__, 'type')))
