# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServiceIdentityArgs',
    'ServiceIdentityArgsDict',
    'ServiceQueryKeyArgs',
    'ServiceQueryKeyArgsDict',
]

MYPY = False

if not MYPY:
    class ServiceIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Search Service. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the list of User Assigned Managed Service Identity IDs which should be assigned to this Search Service.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    ServiceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Search Service. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies the list of User Assigned Managed Service Identity IDs which should be assigned to this Search Service.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Search Service. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of User Assigned Managed Service Identity IDs which should be assigned to this Search Service.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ServiceQueryKeyArgsDict(TypedDict):
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of this Query Key.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        """
elif False:
    ServiceQueryKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceQueryKeyArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] key: The value of this Query Key.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of this Query Key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


