# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sku: pulumi.Input[builtins.str],
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hosting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[builtins.int]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 semantic_search_sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] sku: The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.
               
               > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.
               
               > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_ips: Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.
               
               > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        :param pulumi.Input[builtins.str] authentication_failure_mode: Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.
               
               > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        :param pulumi.Input[builtins.bool] customer_managed_key_enforcement_enabled: Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        :param pulumi.Input[builtins.str] hosting_mode: Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.
               
               > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] local_authentication_enabled: Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        :param pulumi.Input[builtins.int] partition_count: Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.
               
               > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        :param pulumi.Input[builtins.str] semantic_search_sku: Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.
               
               > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Specifies a mapping of tags which should be assigned to this Search Service.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)
        if authentication_failure_mode is not None:
            pulumi.set(__self__, "authentication_failure_mode", authentication_failure_mode)
        if customer_managed_key_enforcement_enabled is not None:
            pulumi.set(__self__, "customer_managed_key_enforcement_enabled", customer_managed_key_enforcement_enabled)
        if hosting_mode is not None:
            pulumi.set(__self__, "hosting_mode", hosting_mode)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rule_bypass_option is not None:
            pulumi.set(__self__, "network_rule_bypass_option", network_rule_bypass_option)
        if partition_count is not None:
            pulumi.set(__self__, "partition_count", partition_count)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if semantic_search_sku is not None:
            pulumi.set(__self__, "semantic_search_sku", semantic_search_sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input[builtins.str]:
        """
        The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.

        > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.

        > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.

        > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_ips", value)

    @property
    @pulumi.getter(name="authenticationFailureMode")
    def authentication_failure_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.

        > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        """
        return pulumi.get(self, "authentication_failure_mode")

    @authentication_failure_mode.setter
    def authentication_failure_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_failure_mode", value)

    @property
    @pulumi.getter(name="customerManagedKeyEnforcementEnabled")
    def customer_managed_key_enforcement_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        """
        return pulumi.get(self, "customer_managed_key_enforcement_enabled")

    @customer_managed_key_enforcement_enabled.setter
    def customer_managed_key_enforcement_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "customer_managed_key_enforcement_enabled", value)

    @property
    @pulumi.getter(name="hostingMode")
    def hosting_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.

        > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        """
        return pulumi.get(self, "hosting_mode")

    @hosting_mode.setter
    def hosting_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosting_mode", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRuleBypassOption")
    def network_rule_bypass_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        """
        return pulumi.get(self, "network_rule_bypass_option")

    @network_rule_bypass_option.setter
    def network_rule_bypass_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_rule_bypass_option", value)

    @property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.

        > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        """
        return pulumi.get(self, "partition_count")

    @partition_count.setter
    def partition_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "partition_count", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="semanticSearchSku")
    def semantic_search_sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.

        > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        """
        return pulumi.get(self, "semantic_search_sku")

    @semantic_search_sku.setter
    def semantic_search_sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "semantic_search_sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a mapping of tags which should be assigned to this Search Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_encryption_compliance_status: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hosting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[builtins.int]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 query_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceQueryKeyArgs']]]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 semantic_search_sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_ips: Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.
               
               > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        :param pulumi.Input[builtins.str] authentication_failure_mode: Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.
               
               > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        :param pulumi.Input[builtins.str] customer_managed_key_encryption_compliance_status: Describes whether the search service is compliant or not with respect to having non-customer encrypted resources. If a service has more than one non-customer encrypted resource and `Enforcement` is `enabled` then the service will be marked as `NonCompliant`. If all the resources are customer encrypted, then the service will be marked as `Compliant`.
        :param pulumi.Input[builtins.bool] customer_managed_key_enforcement_enabled: Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        :param pulumi.Input[builtins.str] hosting_mode: Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.
               
               > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] local_authentication_enabled: Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        :param pulumi.Input[builtins.int] partition_count: Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.
               
               > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        :param pulumi.Input[builtins.str] primary_key: The Primary Key used for Search Service Administration.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceQueryKeyArgs']]] query_keys: A `query_keys` block as defined below.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] secondary_key: The Secondary Key used for Search Service Administration.
        :param pulumi.Input[builtins.str] semantic_search_sku: Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.
               
               > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        :param pulumi.Input[builtins.str] sku: The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.
               
               > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.
               
               > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Specifies a mapping of tags which should be assigned to this Search Service.
        """
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)
        if authentication_failure_mode is not None:
            pulumi.set(__self__, "authentication_failure_mode", authentication_failure_mode)
        if customer_managed_key_encryption_compliance_status is not None:
            pulumi.set(__self__, "customer_managed_key_encryption_compliance_status", customer_managed_key_encryption_compliance_status)
        if customer_managed_key_enforcement_enabled is not None:
            pulumi.set(__self__, "customer_managed_key_enforcement_enabled", customer_managed_key_enforcement_enabled)
        if hosting_mode is not None:
            pulumi.set(__self__, "hosting_mode", hosting_mode)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rule_bypass_option is not None:
            pulumi.set(__self__, "network_rule_bypass_option", network_rule_bypass_option)
        if partition_count is not None:
            pulumi.set(__self__, "partition_count", partition_count)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if query_keys is not None:
            pulumi.set(__self__, "query_keys", query_keys)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if semantic_search_sku is not None:
            pulumi.set(__self__, "semantic_search_sku", semantic_search_sku)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.

        > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_ips", value)

    @property
    @pulumi.getter(name="authenticationFailureMode")
    def authentication_failure_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.

        > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        """
        return pulumi.get(self, "authentication_failure_mode")

    @authentication_failure_mode.setter
    def authentication_failure_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_failure_mode", value)

    @property
    @pulumi.getter(name="customerManagedKeyEncryptionComplianceStatus")
    def customer_managed_key_encryption_compliance_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes whether the search service is compliant or not with respect to having non-customer encrypted resources. If a service has more than one non-customer encrypted resource and `Enforcement` is `enabled` then the service will be marked as `NonCompliant`. If all the resources are customer encrypted, then the service will be marked as `Compliant`.
        """
        return pulumi.get(self, "customer_managed_key_encryption_compliance_status")

    @customer_managed_key_encryption_compliance_status.setter
    def customer_managed_key_encryption_compliance_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key_encryption_compliance_status", value)

    @property
    @pulumi.getter(name="customerManagedKeyEnforcementEnabled")
    def customer_managed_key_enforcement_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        """
        return pulumi.get(self, "customer_managed_key_enforcement_enabled")

    @customer_managed_key_enforcement_enabled.setter
    def customer_managed_key_enforcement_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "customer_managed_key_enforcement_enabled", value)

    @property
    @pulumi.getter(name="hostingMode")
    def hosting_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.

        > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        """
        return pulumi.get(self, "hosting_mode")

    @hosting_mode.setter
    def hosting_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosting_mode", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRuleBypassOption")
    def network_rule_bypass_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        """
        return pulumi.get(self, "network_rule_bypass_option")

    @network_rule_bypass_option.setter
    def network_rule_bypass_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_rule_bypass_option", value)

    @property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.

        > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        """
        return pulumi.get(self, "partition_count")

    @partition_count.setter
    def partition_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "partition_count", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Primary Key used for Search Service Administration.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="queryKeys")
    def query_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceQueryKeyArgs']]]]:
        """
        A `query_keys` block as defined below.
        """
        return pulumi.get(self, "query_keys")

    @query_keys.setter
    def query_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceQueryKeyArgs']]]]):
        pulumi.set(self, "query_keys", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary Key used for Search Service Administration.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @property
    @pulumi.getter(name="semanticSearchSku")
    def semantic_search_sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.

        > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        """
        return pulumi.get(self, "semantic_search_sku")

    @semantic_search_sku.setter
    def semantic_search_sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "semantic_search_sku", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.

        > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.

        > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a mapping of tags which should be assigned to this Search Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:search/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hosting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[builtins.int]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 semantic_search_sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Search Service.

        ## Example Usage

        ### Supporting API Keys)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.search.Service("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            sku="standard")
        ```

        ### Using Both AzureAD And API Keys)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.search.Service("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            sku="standard",
            local_authentication_enabled=True,
            authentication_failure_mode="http403")
        ```

        ### Supporting Only AzureAD Authentication)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.search.Service("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            sku="standard",
            local_authentication_enabled=False)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Search`: 2024-06-01-preview

        ## Import

        Search Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:search/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Search/searchServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_ips: Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.
               
               > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        :param pulumi.Input[builtins.str] authentication_failure_mode: Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.
               
               > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        :param pulumi.Input[builtins.bool] customer_managed_key_enforcement_enabled: Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        :param pulumi.Input[builtins.str] hosting_mode: Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.
               
               > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] local_authentication_enabled: Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        :param pulumi.Input[builtins.int] partition_count: Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.
               
               > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] semantic_search_sku: Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.
               
               > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        :param pulumi.Input[builtins.str] sku: The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.
               
               > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.
               
               > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Specifies a mapping of tags which should be assigned to this Search Service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Search Service.

        ## Example Usage

        ### Supporting API Keys)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.search.Service("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            sku="standard")
        ```

        ### Using Both AzureAD And API Keys)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.search.Service("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            sku="standard",
            local_authentication_enabled=True,
            authentication_failure_mode="http403")
        ```

        ### Supporting Only AzureAD Authentication)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.search.Service("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            sku="standard",
            local_authentication_enabled=False)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Search`: 2024-06-01-preview

        ## Import

        Search Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:search/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Search/searchServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hosting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[builtins.int]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 semantic_search_sku: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["allowed_ips"] = allowed_ips
            __props__.__dict__["authentication_failure_mode"] = authentication_failure_mode
            __props__.__dict__["customer_managed_key_enforcement_enabled"] = customer_managed_key_enforcement_enabled
            __props__.__dict__["hosting_mode"] = hosting_mode
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_rule_bypass_option"] = network_rule_bypass_option
            __props__.__dict__["partition_count"] = partition_count
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["replica_count"] = replica_count
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["semantic_search_sku"] = semantic_search_sku
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["customer_managed_key_encryption_compliance_status"] = None
            __props__.__dict__["primary_key"] = None
            __props__.__dict__["query_keys"] = None
            __props__.__dict__["secondary_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryKey", "secondaryKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Service, __self__).__init__(
            'azure:search/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            authentication_failure_mode: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_key_encryption_compliance_status: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_key_enforcement_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            hosting_mode: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
            local_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_rule_bypass_option: Optional[pulumi.Input[builtins.str]] = None,
            partition_count: Optional[pulumi.Input[builtins.int]] = None,
            primary_key: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            query_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceQueryKeyArgs', 'ServiceQueryKeyArgsDict']]]]] = None,
            replica_count: Optional[pulumi.Input[builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_key: Optional[pulumi.Input[builtins.str]] = None,
            semantic_search_sku: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_ips: Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.
               
               > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        :param pulumi.Input[builtins.str] authentication_failure_mode: Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.
               
               > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        :param pulumi.Input[builtins.str] customer_managed_key_encryption_compliance_status: Describes whether the search service is compliant or not with respect to having non-customer encrypted resources. If a service has more than one non-customer encrypted resource and `Enforcement` is `enabled` then the service will be marked as `NonCompliant`. If all the resources are customer encrypted, then the service will be marked as `Compliant`.
        :param pulumi.Input[builtins.bool] customer_managed_key_enforcement_enabled: Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        :param pulumi.Input[builtins.str] hosting_mode: Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.
               
               > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.bool] local_authentication_enabled: Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        :param pulumi.Input[builtins.int] partition_count: Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.
               
               > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        :param pulumi.Input[builtins.str] primary_key: The Primary Key used for Search Service Administration.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceQueryKeyArgs', 'ServiceQueryKeyArgsDict']]]] query_keys: A `query_keys` block as defined below.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        :param pulumi.Input[builtins.str] secondary_key: The Secondary Key used for Search Service Administration.
        :param pulumi.Input[builtins.str] semantic_search_sku: Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.
               
               > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        :param pulumi.Input[builtins.str] sku: The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.
               
               > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.
               
               > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Specifies a mapping of tags which should be assigned to this Search Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["allowed_ips"] = allowed_ips
        __props__.__dict__["authentication_failure_mode"] = authentication_failure_mode
        __props__.__dict__["customer_managed_key_encryption_compliance_status"] = customer_managed_key_encryption_compliance_status
        __props__.__dict__["customer_managed_key_enforcement_enabled"] = customer_managed_key_enforcement_enabled
        __props__.__dict__["hosting_mode"] = hosting_mode
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_rule_bypass_option"] = network_rule_bypass_option
        __props__.__dict__["partition_count"] = partition_count
        __props__.__dict__["primary_key"] = primary_key
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["query_keys"] = query_keys
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_key"] = secondary_key
        __props__.__dict__["semantic_search_sku"] = semantic_search_sku
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of inbound IPv4 or CIDRs that are allowed to access the Search Service. If the incoming IP request is from an IP address which is not included in the `allowed_ips` it will be blocked by the Search Services firewall.

        > **Note:** The `allowed_ips` are only applied if the `public_network_access_enabled` field has been set to `true`, else all traffic over the public interface will be rejected, even if the `allowed_ips` field has been defined. When the `public_network_access_enabled` field has been set to `false` the private endpoint connections are the only allowed access point to the Search Service.
        """
        return pulumi.get(self, "allowed_ips")

    @property
    @pulumi.getter(name="authenticationFailureMode")
    def authentication_failure_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the response that the Search Service should return for requests that fail authentication. Possible values include `http401WithBearerChallenge` or `http403`.

        > **Note:** `authentication_failure_mode` can only be configured when using `local_authentication_enabled` is set to `true` - which when set together specifies that both API Keys and AzureAD Authentication should be supported.
        """
        return pulumi.get(self, "authentication_failure_mode")

    @property
    @pulumi.getter(name="customerManagedKeyEncryptionComplianceStatus")
    def customer_managed_key_encryption_compliance_status(self) -> pulumi.Output[builtins.str]:
        """
        Describes whether the search service is compliant or not with respect to having non-customer encrypted resources. If a service has more than one non-customer encrypted resource and `Enforcement` is `enabled` then the service will be marked as `NonCompliant`. If all the resources are customer encrypted, then the service will be marked as `Compliant`.
        """
        return pulumi.get(self, "customer_managed_key_encryption_compliance_status")

    @property
    @pulumi.getter(name="customerManagedKeyEnforcementEnabled")
    def customer_managed_key_enforcement_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the Search Service should enforce that non-customer resources are encrypted. Defaults to `false`.
        """
        return pulumi.get(self, "customer_managed_key_enforcement_enabled")

    @property
    @pulumi.getter(name="hostingMode")
    def hosting_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Hosting Mode, which allows for High Density partitions (that allow for up to 1000 indexes) should be supported. Possible values are `highDensity` or `default`. Defaults to `default`. Changing this forces a new Search Service to be created.

        > **Note:** `hosting_mode` can only be configured when `sku` is set to `standard3`.
        """
        return pulumi.get(self, "hosting_mode")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServiceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the Search Service allows authenticating using API Keys? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Search Service should exist. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The Name which should be used for this Search Service. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkRuleBypassOption")
    def network_rule_bypass_option(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether to allow trusted Azure services to access a network restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `None`.
        """
        return pulumi.get(self, "network_rule_bypass_option")

    @property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the number of partitions which should be created. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)). Possible values include `1`, `2`, `3`, `4`, `6`, or `12`. Defaults to `1`.

        > **Note:** when `hosting_mode` is set to `highDensity` the maximum number of partitions allowed is `3`.
        """
        return pulumi.get(self, "partition_count")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[builtins.str]:
        """
        The Primary Key used for Search Service Administration.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether Public Network Access is allowed for this resource. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="queryKeys")
    def query_keys(self) -> pulumi.Output[Sequence['outputs.ServiceQueryKey']]:
        """
        A `query_keys` block as defined below.
        """
        return pulumi.get(self, "query_keys")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the number of Replica's which should be created for this Search Service. This field cannot be set when using a `free` sku ([see the Microsoft documentation](https://learn.microsoft.com/azure/search/search-sku-tier)).
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Search Service should exist. Changing this forces a new Search Service to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[builtins.str]:
        """
        The Secondary Key used for Search Service Administration.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter(name="semanticSearchSku")
    def semantic_search_sku(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Semantic Search SKU which should be used for this Search Service. Possible values include `free` and `standard`.

        > **Note:** The `semantic_search_sku` cannot be defined if your Search Services `sku` is set to `free`. The Semantic Search feature is only available in certain regions, please see the [product documentation](https://learn.microsoft.com/azure/search/semantic-search-overview#availability-and-pricing) for more information.
        """
        return pulumi.get(self, "semantic_search_sku")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[builtins.str]:
        """
        The SKU which should be used for this Search Service. Possible values include `basic`, `free`, `standard`, `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2`. Changing this forces a new Search Service to be created.

        > **Note:** The `basic` and `free` SKUs provision the Search Service in a Shared Cluster - the `standard` SKUs use a Dedicated Cluster.

        > **Note:** The SKUs `standard2`, `standard3`, `storage_optimized_l1` and `storage_optimized_l2` are only available by submitting a quota increase request to Microsoft. Please see the [product documentation](https://learn.microsoft.com/azure/azure-resource-manager/troubleshooting/error-resource-quota?tabs=azure-cli) on how to submit a quota increase request.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Specifies a mapping of tags which should be assigned to this Search Service.
        """
        return pulumi.get(self, "tags")

