# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AdvancedThreatProtectionArgs', 'AdvancedThreatProtection']

@pulumi.input_type
class AdvancedThreatProtectionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 target_resource_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a AdvancedThreatProtection resource.
        :param pulumi.Input[builtins.bool] enabled: Should Advanced Threat Protection be enabled on this resource?
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Should Advanced Threat Protection be enabled on this resource?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.input_type
class _AdvancedThreatProtectionState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdvancedThreatProtection resources.
        :param pulumi.Input[builtins.bool] enabled: Should Advanced Threat Protection be enabled on this resource?
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should Advanced Threat Protection be enabled on this resource?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.type_token("azure:securitycenter/advancedThreatProtection:AdvancedThreatProtection")
class AdvancedThreatProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a resources Advanced Threat Protection setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="atp-example",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "example",
            })
        example_advanced_threat_protection = azure.securitycenter.AdvancedThreatProtection("example",
            target_resource_id=example_account.id,
            enabled=True)
        ```

        ## Import

        Advanced Threat Protection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/advancedThreatProtection:AdvancedThreatProtection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleaccount/providers/Microsoft.Security/advancedThreatProtectionSettings/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Should Advanced Threat Protection be enabled on this resource?
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdvancedThreatProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a resources Advanced Threat Protection setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="atp-example",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "example",
            })
        example_advanced_threat_protection = azure.securitycenter.AdvancedThreatProtection("example",
            target_resource_id=example_account.id,
            enabled=True)
        ```

        ## Import

        Advanced Threat Protection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/advancedThreatProtection:AdvancedThreatProtection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleaccount/providers/Microsoft.Security/advancedThreatProtectionSettings/default
        ```

        :param str resource_name: The name of the resource.
        :param AdvancedThreatProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdvancedThreatProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdvancedThreatProtectionArgs.__new__(AdvancedThreatProtectionArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
        super(AdvancedThreatProtection, __self__).__init__(
            'azure:securitycenter/advancedThreatProtection:AdvancedThreatProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            target_resource_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AdvancedThreatProtection':
        """
        Get an existing AdvancedThreatProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Should Advanced Threat Protection be enabled on this resource?
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdvancedThreatProtectionState.__new__(_AdvancedThreatProtectionState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["target_resource_id"] = target_resource_id
        return AdvancedThreatProtection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should Advanced Threat Protection be enabled on this resource?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Azure Resource which to enable Advanced Threat Protection on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

