# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssessmentArgs', 'Assessment']

@pulumi.input_type
class AssessmentArgs:
    def __init__(__self__, *,
                 assessment_policy_id: pulumi.Input[builtins.str],
                 status: pulumi.Input['AssessmentStatusArgs'],
                 target_resource_id: pulumi.Input[builtins.str],
                 additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Assessment resource.
        :param pulumi.Input[builtins.str] assessment_policy_id: The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        :param pulumi.Input['AssessmentStatusArgs'] status: A `status` block as defined below.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new security Assessment to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_data: A map of additional data to associate with the assessment.
        """
        pulumi.set(__self__, "assessment_policy_id", assessment_policy_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if additional_data is not None:
            pulumi.set(__self__, "additional_data", additional_data)

    @property
    @pulumi.getter(name="assessmentPolicyId")
    def assessment_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        """
        return pulumi.get(self, "assessment_policy_id")

    @assessment_policy_id.setter
    def assessment_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "assessment_policy_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['AssessmentStatusArgs']:
        """
        A `status` block as defined below.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['AssessmentStatusArgs']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the target resource. Changing this forces a new security Assessment to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional data to associate with the assessment.
        """
        return pulumi.get(self, "additional_data")

    @additional_data.setter
    def additional_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_data", value)


@pulumi.input_type
class _AssessmentState:
    def __init__(__self__, *,
                 additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 assessment_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['AssessmentStatusArgs']] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Assessment resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_data: A map of additional data to associate with the assessment.
        :param pulumi.Input[builtins.str] assessment_policy_id: The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        :param pulumi.Input['AssessmentStatusArgs'] status: A `status` block as defined below.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new security Assessment to be created.
        """
        if additional_data is not None:
            pulumi.set(__self__, "additional_data", additional_data)
        if assessment_policy_id is not None:
            pulumi.set(__self__, "assessment_policy_id", assessment_policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional data to associate with the assessment.
        """
        return pulumi.get(self, "additional_data")

    @additional_data.setter
    def additional_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_data", value)

    @property
    @pulumi.getter(name="assessmentPolicyId")
    def assessment_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        """
        return pulumi.get(self, "assessment_policy_id")

    @assessment_policy_id.setter
    def assessment_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "assessment_policy_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['AssessmentStatusArgs']]:
        """
        A `status` block as defined below.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['AssessmentStatusArgs']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the target resource. Changing this forces a new security Assessment to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.type_token("azure:securitycenter/assessment:Assessment")
class Assessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 assessment_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[Union['AssessmentStatusArgs', 'AssessmentStatusArgsDict']]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the Security Center Assessment for Azure Security Center.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.0.0.0/16"])
        internal = azure.network.Subnet("internal",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="example-vmss",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard_F2",
            instances=1,
            admin_username="adminuser",
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            },
            network_interfaces=[{
                "name": "example",
                "primary": True,
                "ip_configurations": [{
                    "name": "internal",
                    "primary": True,
                    "subnet_id": internal.id,
                }],
            }])
        example_assessment_policy = azure.securitycenter.AssessmentPolicy("example",
            display_name="Test Display Name",
            severity="Medium",
            description="Test Description")
        example_assessment = azure.securitycenter.Assessment("example",
            assessment_policy_id=example_assessment_policy.id,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            status={
                "code": "Healthy",
            })
        ```

        ## Import

        Security Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/assessment:Assessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Compute/virtualMachineScaleSets/vmss1/providers/Microsoft.Security/assessments/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_data: A map of additional data to associate with the assessment.
        :param pulumi.Input[builtins.str] assessment_policy_id: The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        :param pulumi.Input[Union['AssessmentStatusArgs', 'AssessmentStatusArgsDict']] status: A `status` block as defined below.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new security Assessment to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Security Center Assessment for Azure Security Center.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.0.0.0/16"])
        internal = azure.network.Subnet("internal",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="example-vmss",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard_F2",
            instances=1,
            admin_username="adminuser",
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            },
            network_interfaces=[{
                "name": "example",
                "primary": True,
                "ip_configurations": [{
                    "name": "internal",
                    "primary": True,
                    "subnet_id": internal.id,
                }],
            }])
        example_assessment_policy = azure.securitycenter.AssessmentPolicy("example",
            display_name="Test Display Name",
            severity="Medium",
            description="Test Description")
        example_assessment = azure.securitycenter.Assessment("example",
            assessment_policy_id=example_assessment_policy.id,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            status={
                "code": "Healthy",
            })
        ```

        ## Import

        Security Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/assessment:Assessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Compute/virtualMachineScaleSets/vmss1/providers/Microsoft.Security/assessments/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param AssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 assessment_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[Union['AssessmentStatusArgs', 'AssessmentStatusArgsDict']]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssessmentArgs.__new__(AssessmentArgs)

            __props__.__dict__["additional_data"] = additional_data
            if assessment_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'assessment_policy_id'")
            __props__.__dict__["assessment_policy_id"] = assessment_policy_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
        super(Assessment, __self__).__init__(
            'azure:securitycenter/assessment:Assessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            assessment_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[Union['AssessmentStatusArgs', 'AssessmentStatusArgsDict']]] = None,
            target_resource_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Assessment':
        """
        Get an existing Assessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_data: A map of additional data to associate with the assessment.
        :param pulumi.Input[builtins.str] assessment_policy_id: The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        :param pulumi.Input[Union['AssessmentStatusArgs', 'AssessmentStatusArgsDict']] status: A `status` block as defined below.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new security Assessment to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssessmentState.__new__(_AssessmentState)

        __props__.__dict__["additional_data"] = additional_data
        __props__.__dict__["assessment_policy_id"] = assessment_policy_id
        __props__.__dict__["status"] = status
        __props__.__dict__["target_resource_id"] = target_resource_id
        return Assessment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of additional data to associate with the assessment.
        """
        return pulumi.get(self, "additional_data")

    @property
    @pulumi.getter(name="assessmentPolicyId")
    def assessment_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the security Assessment policy to apply to this resource. Changing this forces a new security Assessment to be created.
        """
        return pulumi.get(self, "assessment_policy_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.AssessmentStatus']:
        """
        A `status` block as defined below.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the target resource. Changing this forces a new security Assessment to be created.
        """
        return pulumi.get(self, "target_resource_id")

