# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContactArgs', 'Contact']

@pulumi.input_type
class ContactArgs:
    def __init__(__self__, *,
                 alert_notifications: pulumi.Input[builtins.bool],
                 alerts_to_admins: pulumi.Input[builtins.bool],
                 email: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Contact resource.
        :param pulumi.Input[builtins.bool] alert_notifications: Whether to send security alerts notifications to the security contact.
        :param pulumi.Input[builtins.bool] alerts_to_admins: Whether to send security alerts notifications to subscription admins.
        :param pulumi.Input[builtins.str] email: The email of the Security Center Contact.
        :param pulumi.Input[builtins.str] name: The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        :param pulumi.Input[builtins.str] phone: The phone number of the Security Center Contact.
        """
        pulumi.set(__self__, "alert_notifications", alert_notifications)
        pulumi.set(__self__, "alerts_to_admins", alerts_to_admins)
        pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)

    @property
    @pulumi.getter(name="alertNotifications")
    def alert_notifications(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to send security alerts notifications to the security contact.
        """
        return pulumi.get(self, "alert_notifications")

    @alert_notifications.setter
    def alert_notifications(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "alert_notifications", value)

    @property
    @pulumi.getter(name="alertsToAdmins")
    def alerts_to_admins(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to send security alerts notifications to subscription admins.
        """
        return pulumi.get(self, "alerts_to_admins")

    @alerts_to_admins.setter
    def alerts_to_admins(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "alerts_to_admins", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The email of the Security Center Contact.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The phone number of the Security Center Contact.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "phone", value)


@pulumi.input_type
class _ContactState:
    def __init__(__self__, *,
                 alert_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 alerts_to_admins: Optional[pulumi.Input[builtins.bool]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Contact resources.
        :param pulumi.Input[builtins.bool] alert_notifications: Whether to send security alerts notifications to the security contact.
        :param pulumi.Input[builtins.bool] alerts_to_admins: Whether to send security alerts notifications to subscription admins.
        :param pulumi.Input[builtins.str] email: The email of the Security Center Contact.
        :param pulumi.Input[builtins.str] name: The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        :param pulumi.Input[builtins.str] phone: The phone number of the Security Center Contact.
        """
        if alert_notifications is not None:
            pulumi.set(__self__, "alert_notifications", alert_notifications)
        if alerts_to_admins is not None:
            pulumi.set(__self__, "alerts_to_admins", alerts_to_admins)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)

    @property
    @pulumi.getter(name="alertNotifications")
    def alert_notifications(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to send security alerts notifications to the security contact.
        """
        return pulumi.get(self, "alert_notifications")

    @alert_notifications.setter
    def alert_notifications(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "alert_notifications", value)

    @property
    @pulumi.getter(name="alertsToAdmins")
    def alerts_to_admins(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to send security alerts notifications to subscription admins.
        """
        return pulumi.get(self, "alerts_to_admins")

    @alerts_to_admins.setter
    def alerts_to_admins(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "alerts_to_admins", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email of the Security Center Contact.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The phone number of the Security Center Contact.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "phone", value)


@pulumi.type_token("azure:securitycenter/contact:Contact")
class Contact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 alerts_to_admins: Optional[pulumi.Input[builtins.bool]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the subscription's Security Center Contact.

        > **Note:** Owner access permission is required.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.Contact("example",
            name="contact",
            email="contact@example.com",
            phone="+1-555-555-5555",
            alert_notifications=True,
            alerts_to_admins=True)
        ```

        ## Import

        Security Center Contacts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/contact:Contact example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/securityContacts/default1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] alert_notifications: Whether to send security alerts notifications to the security contact.
        :param pulumi.Input[builtins.bool] alerts_to_admins: Whether to send security alerts notifications to subscription admins.
        :param pulumi.Input[builtins.str] email: The email of the Security Center Contact.
        :param pulumi.Input[builtins.str] name: The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        :param pulumi.Input[builtins.str] phone: The phone number of the Security Center Contact.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the subscription's Security Center Contact.

        > **Note:** Owner access permission is required.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.Contact("example",
            name="contact",
            email="contact@example.com",
            phone="+1-555-555-5555",
            alert_notifications=True,
            alerts_to_admins=True)
        ```

        ## Import

        Security Center Contacts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/contact:Contact example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/securityContacts/default1
        ```

        :param str resource_name: The name of the resource.
        :param ContactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 alerts_to_admins: Optional[pulumi.Input[builtins.bool]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactArgs.__new__(ContactArgs)

            if alert_notifications is None and not opts.urn:
                raise TypeError("Missing required property 'alert_notifications'")
            __props__.__dict__["alert_notifications"] = alert_notifications
            if alerts_to_admins is None and not opts.urn:
                raise TypeError("Missing required property 'alerts_to_admins'")
            __props__.__dict__["alerts_to_admins"] = alerts_to_admins
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["name"] = name
            __props__.__dict__["phone"] = phone
        super(Contact, __self__).__init__(
            'azure:securitycenter/contact:Contact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_notifications: Optional[pulumi.Input[builtins.bool]] = None,
            alerts_to_admins: Optional[pulumi.Input[builtins.bool]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            phone: Optional[pulumi.Input[builtins.str]] = None) -> 'Contact':
        """
        Get an existing Contact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] alert_notifications: Whether to send security alerts notifications to the security contact.
        :param pulumi.Input[builtins.bool] alerts_to_admins: Whether to send security alerts notifications to subscription admins.
        :param pulumi.Input[builtins.str] email: The email of the Security Center Contact.
        :param pulumi.Input[builtins.str] name: The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        :param pulumi.Input[builtins.str] phone: The phone number of the Security Center Contact.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContactState.__new__(_ContactState)

        __props__.__dict__["alert_notifications"] = alert_notifications
        __props__.__dict__["alerts_to_admins"] = alerts_to_admins
        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["phone"] = phone
        return Contact(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertNotifications")
    def alert_notifications(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to send security alerts notifications to the security contact.
        """
        return pulumi.get(self, "alert_notifications")

    @property
    @pulumi.getter(name="alertsToAdmins")
    def alerts_to_admins(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to send security alerts notifications to subscription admins.
        """
        return pulumi.get(self, "alerts_to_admins")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email of the Security Center Contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Security Center Contact. Changing this forces a new Security Center Contact to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The phone number of the Security Center Contact.
        """
        return pulumi.get(self, "phone")

