# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AssessmentStatus',
    'AutomationAction',
    'AutomationSource',
    'AutomationSourceRuleSet',
    'AutomationSourceRuleSetRule',
    'SubscriptionPricingExtension',
]

@pulumi.output_type
class AssessmentStatus(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 cause: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str code: Specifies the programmatic code of the assessment status. Possible values are `Healthy`, `Unhealthy` and `NotApplicable`.
        :param builtins.str cause: Specifies the cause of the assessment status.
        :param builtins.str description: Specifies the human readable description of the assessment status.
        """
        pulumi.set(__self__, "code", code)
        if cause is not None:
            pulumi.set(__self__, "cause", cause)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        Specifies the programmatic code of the assessment status. Possible values are `Healthy`, `Unhealthy` and `NotApplicable`.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def cause(self) -> Optional[builtins.str]:
        """
        Specifies the cause of the assessment status.
        """
        return pulumi.get(self, "cause")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Specifies the human readable description of the assessment status.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AutomationAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "triggerUrl":
            suggest = "trigger_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: builtins.str,
                 type: builtins.str,
                 connection_string: Optional[builtins.str] = None,
                 trigger_url: Optional[builtins.str] = None):
        """
        :param builtins.str resource_id: The resource id of the target Logic App, Event Hub namespace or Log Analytics workspace.
        :param builtins.str type: Type of Azure resource to send data to. Must be set to one of: `logicapp`, `eventhub` or `loganalytics`.
        :param builtins.str connection_string: (Optional, but required when `type` is `eventhub`) A connection string to send data to the target Event Hub namespace, this should include a key with send permissions.
        :param builtins.str trigger_url: (Optional, but required when `type` is `logicapp`) The callback URL to trigger the Logic App that will receive and process data sent by this automation. This can be found in the Azure Portal under "See trigger history"
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "type", type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if trigger_url is not None:
            pulumi.set(__self__, "trigger_url", trigger_url)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The resource id of the target Logic App, Event Hub namespace or Log Analytics workspace.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Azure resource to send data to. Must be set to one of: `logicapp`, `eventhub` or `loganalytics`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        (Optional, but required when `type` is `eventhub`) A connection string to send data to the target Event Hub namespace, this should include a key with send permissions.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="triggerUrl")
    def trigger_url(self) -> Optional[builtins.str]:
        """
        (Optional, but required when `type` is `logicapp`) The callback URL to trigger the Logic App that will receive and process data sent by this automation. This can be found in the Azure Portal under "See trigger history"
        """
        return pulumi.get(self, "trigger_url")


@pulumi.output_type
class AutomationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventSource":
            suggest = "event_source"
        elif key == "ruleSets":
            suggest = "rule_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_source: builtins.str,
                 rule_sets: Optional[Sequence['outputs.AutomationSourceRuleSet']] = None):
        """
        :param builtins.str event_source: Type of data that will trigger this automation. Must be one of `Alerts`, `Assessments`, `AssessmentsSnapshot`, `RegulatoryComplianceAssessment`, `RegulatoryComplianceAssessmentSnapshot`, `SecureScoreControls`, `SecureScoreControlsSnapshot`, `SecureScores`, `SecureScoresSnapshot`, `SubAssessments` or `SubAssessmentsSnapshot`. Note. assessments are also referred to as recommendations
        :param Sequence['AutomationSourceRuleSetArgs'] rule_sets: A set of rules which evaluate upon event and data interception. This is defined in one or more `rule_set` blocks as defined below.
               
               > **Note:** When multiple `rule_set` block are provided, a logical 'OR' is applied to the evaluation of them.
        """
        pulumi.set(__self__, "event_source", event_source)
        if rule_sets is not None:
            pulumi.set(__self__, "rule_sets", rule_sets)

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> builtins.str:
        """
        Type of data that will trigger this automation. Must be one of `Alerts`, `Assessments`, `AssessmentsSnapshot`, `RegulatoryComplianceAssessment`, `RegulatoryComplianceAssessmentSnapshot`, `SecureScoreControls`, `SecureScoreControlsSnapshot`, `SecureScores`, `SecureScoresSnapshot`, `SubAssessments` or `SubAssessmentsSnapshot`. Note. assessments are also referred to as recommendations
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Optional[Sequence['outputs.AutomationSourceRuleSet']]:
        """
        A set of rules which evaluate upon event and data interception. This is defined in one or more `rule_set` blocks as defined below.

        > **Note:** When multiple `rule_set` block are provided, a logical 'OR' is applied to the evaluation of them.
        """
        return pulumi.get(self, "rule_sets")


@pulumi.output_type
class AutomationSourceRuleSet(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.AutomationSourceRuleSetRule']):
        """
        :param Sequence['AutomationSourceRuleSetRuleArgs'] rules: One or more `rule` blocks as defined below.
               
               > **Note:** This automation will trigger when all of the `rule`s in this `rule_set` are evaluated as 'true'. This is equivalent to a logical 'AND'.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.AutomationSourceRuleSetRule']:
        """
        One or more `rule` blocks as defined below.

        > **Note:** This automation will trigger when all of the `rule`s in this `rule_set` are evaluated as 'true'. This is equivalent to a logical 'AND'.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AutomationSourceRuleSetRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "propertyPath":
            suggest = "property_path"
        elif key == "propertyType":
            suggest = "property_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationSourceRuleSetRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationSourceRuleSetRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationSourceRuleSetRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expected_value: builtins.str,
                 operator: builtins.str,
                 property_path: builtins.str,
                 property_type: builtins.str):
        """
        :param builtins.str expected_value: A value that will be compared with the value in `property_path`.
        :param builtins.str operator: The comparison operator to use, must be one of: `Contains`, `EndsWith`, `Equals`, `GreaterThan`, `GreaterThanOrEqualTo`, `LesserThan`, `LesserThanOrEqualTo`, `NotEquals`, `StartsWith`
        :param builtins.str property_path: The JPath of the entity model property that should be checked.
        :param builtins.str property_type: The data type of the compared operands, must be one of: `Integer`, `String`, `Boolean` or `Number`.
               
               > **Note:** The schema for Security Center alerts (when `event_source` is "Alerts") [can be found here](https://docs.microsoft.com/azure/security-center/alerts-schemas?tabs=schema-continuousexport)
        """
        pulumi.set(__self__, "expected_value", expected_value)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "property_path", property_path)
        pulumi.set(__self__, "property_type", property_type)

    @property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> builtins.str:
        """
        A value that will be compared with the value in `property_path`.
        """
        return pulumi.get(self, "expected_value")

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        The comparison operator to use, must be one of: `Contains`, `EndsWith`, `Equals`, `GreaterThan`, `GreaterThanOrEqualTo`, `LesserThan`, `LesserThanOrEqualTo`, `NotEquals`, `StartsWith`
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="propertyPath")
    def property_path(self) -> builtins.str:
        """
        The JPath of the entity model property that should be checked.
        """
        return pulumi.get(self, "property_path")

    @property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> builtins.str:
        """
        The data type of the compared operands, must be one of: `Integer`, `String`, `Boolean` or `Number`.

        > **Note:** The schema for Security Center alerts (when `event_source` is "Alerts") [can be found here](https://docs.microsoft.com/azure/security-center/alerts-schemas?tabs=schema-continuousexport)
        """
        return pulumi.get(self, "property_type")


@pulumi.output_type
class SubscriptionPricingExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExtensionProperties":
            suggest = "additional_extension_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPricingExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPricingExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPricingExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 additional_extension_properties: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str name: The name of extension.
        :param Mapping[str, builtins.str] additional_extension_properties: Key/Value pairs that are required for some extensions.
               
               > **Note:** If an extension is not defined, it will not be enabled.
               
               > **Note:** Changing the pricing tier to `Standard` affects all resources of the given type in the subscription and could be quite costly.
        """
        pulumi.set(__self__, "name", name)
        if additional_extension_properties is not None:
            pulumi.set(__self__, "additional_extension_properties", additional_extension_properties)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of extension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="additionalExtensionProperties")
    def additional_extension_properties(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key/Value pairs that are required for some extensions.

        > **Note:** If an extension is not defined, it will not be enabled.

        > **Note:** Changing the pricing tier to `Standard` affects all resources of the given type in the subscription and could be quite costly.
        """
        return pulumi.get(self, "additional_extension_properties")


