# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SettingArgs', 'Setting']

@pulumi.input_type
class SettingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 setting_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a Setting resource.
        :param pulumi.Input[builtins.bool] enabled: Boolean flag to enable/disable data access.
        :param pulumi.Input[builtins.str] setting_name: The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "setting_name", setting_name)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Boolean flag to enable/disable data access.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> pulumi.Input[builtins.str]:
        """
        The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "setting_name")

    @setting_name.setter
    def setting_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "setting_name", value)


@pulumi.input_type
class _SettingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 setting_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Setting resources.
        :param pulumi.Input[builtins.bool] enabled: Boolean flag to enable/disable data access.
        :param pulumi.Input[builtins.str] setting_name: The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if setting_name is not None:
            pulumi.set(__self__, "setting_name", setting_name)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag to enable/disable data access.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "setting_name")

    @setting_name.setter
    def setting_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "setting_name", value)


@pulumi.type_token("azure:securitycenter/setting:Setting")
class Setting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 setting_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the Data Access Settings for Azure Security Center.

        > **Note:** This resource requires the `Owner` permission on the Subscription.

        > **Note:** Deletion of this resource disables the setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.Setting("example",
            setting_name="MCAS",
            enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security`: 2022-05-01

        ## Import

        The setting can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/setting:Setting example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/settings/<setting_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Boolean flag to enable/disable data access.
        :param pulumi.Input[builtins.str] setting_name: The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Data Access Settings for Azure Security Center.

        > **Note:** This resource requires the `Owner` permission on the Subscription.

        > **Note:** Deletion of this resource disables the setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.Setting("example",
            setting_name="MCAS",
            enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security`: 2022-05-01

        ## Import

        The setting can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/setting:Setting example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/settings/<setting_name>
        ```

        :param str resource_name: The name of the resource.
        :param SettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 setting_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingArgs.__new__(SettingArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if setting_name is None and not opts.urn:
                raise TypeError("Missing required property 'setting_name'")
            __props__.__dict__["setting_name"] = setting_name
        super(Setting, __self__).__init__(
            'azure:securitycenter/setting:Setting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            setting_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Setting':
        """
        Get an existing Setting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Boolean flag to enable/disable data access.
        :param pulumi.Input[builtins.str] setting_name: The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingState.__new__(_SettingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["setting_name"] = setting_name
        return Setting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean flag to enable/disable data access.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> pulumi.Output[builtins.str]:
        """
        The setting to manage. Possible values are `MCAS` , `WDATP`, `WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW`, `WDATP_UNIFIED_SOLUTION` and `Sentinel`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "setting_name")

