# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertRuleAnomalyDuplicateArgs', 'AlertRuleAnomalyDuplicate']

@pulumi.input_type
class AlertRuleAnomalyDuplicateArgs:
    def __init__(__self__, *,
                 built_in_rule_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 log_analytics_workspace_id: pulumi.Input[builtins.str],
                 mode: pulumi.Input[builtins.str],
                 multi_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]]] = None,
                 prioritized_exclude_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]]] = None,
                 single_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]]] = None,
                 threshold_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]]] = None):
        """
        The set of arguments for constructing a AlertRuleAnomalyDuplicate resource.
        :param pulumi.Input[builtins.str] built_in_rule_id: The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] display_name: The Display Name of the built-in Anomaly Alert Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Duplicated Anomaly Alert Rule be enabled?
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] mode: mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]] multi_select_observations: A list of `multi_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]] prioritized_exclude_observations: A list of `prioritized_exclude_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]] single_select_observations: A list of `single_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]] threshold_observations: A list of `threshold_observation` blocks as defined below.
               
               > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        pulumi.set(__self__, "built_in_rule_id", built_in_rule_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "mode", mode)
        if multi_select_observations is not None:
            pulumi.set(__self__, "multi_select_observations", multi_select_observations)
        if prioritized_exclude_observations is not None:
            pulumi.set(__self__, "prioritized_exclude_observations", prioritized_exclude_observations)
        if single_select_observations is not None:
            pulumi.set(__self__, "single_select_observations", single_select_observations)
        if threshold_observations is not None:
            pulumi.set(__self__, "threshold_observations", threshold_observations)

    @property
    @pulumi.getter(name="builtInRuleId")
    def built_in_rule_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        """
        return pulumi.get(self, "built_in_rule_id")

    @built_in_rule_id.setter
    def built_in_rule_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "built_in_rule_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The Display Name of the built-in Anomaly Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Should the Duplicated Anomaly Alert Rule be enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="multiSelectObservations")
    def multi_select_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]]]:
        """
        A list of `multi_select_observation` blocks as defined below.
        """
        return pulumi.get(self, "multi_select_observations")

    @multi_select_observations.setter
    def multi_select_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]]]):
        pulumi.set(self, "multi_select_observations", value)

    @property
    @pulumi.getter(name="prioritizedExcludeObservations")
    def prioritized_exclude_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]]]:
        """
        A list of `prioritized_exclude_observation` blocks as defined below.
        """
        return pulumi.get(self, "prioritized_exclude_observations")

    @prioritized_exclude_observations.setter
    def prioritized_exclude_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]]]):
        pulumi.set(self, "prioritized_exclude_observations", value)

    @property
    @pulumi.getter(name="singleSelectObservations")
    def single_select_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]]]:
        """
        A list of `single_select_observation` blocks as defined below.
        """
        return pulumi.get(self, "single_select_observations")

    @single_select_observations.setter
    def single_select_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]]]):
        pulumi.set(self, "single_select_observations", value)

    @property
    @pulumi.getter(name="thresholdObservations")
    def threshold_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]]]:
        """
        A list of `threshold_observation` blocks as defined below.

        > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        return pulumi.get(self, "threshold_observations")

    @threshold_observations.setter
    def threshold_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]]]):
        pulumi.set(self, "threshold_observations", value)


@pulumi.input_type
class _AlertRuleAnomalyDuplicateState:
    def __init__(__self__, *,
                 anomaly_settings_version: Optional[pulumi.Input[builtins.int]] = None,
                 anomaly_version: Optional[pulumi.Input[builtins.str]] = None,
                 built_in_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 is_default_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 multi_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 prioritized_exclude_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]]] = None,
                 required_data_connectors: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateRequiredDataConnectorArgs']]]] = None,
                 settings_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 single_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threshold_observations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]]] = None):
        """
        Input properties used for looking up and filtering AlertRuleAnomalyDuplicate resources.
        :param pulumi.Input[builtins.int] anomaly_settings_version: The version of the Anomaly Security ML Analytics Settings.
        :param pulumi.Input[builtins.str] anomaly_version: The anomaly version of the Anomaly Alert Rule.
        :param pulumi.Input[builtins.str] built_in_rule_id: The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] description: The description of the Anomaly Alert Rule.
        :param pulumi.Input[builtins.str] display_name: The Display Name of the built-in Anomaly Alert Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Duplicated Anomaly Alert Rule be enabled?
        :param pulumi.Input[builtins.str] frequency: The frequency the Anomaly Alert Rule will be run, such as "P1D".
        :param pulumi.Input[builtins.bool] is_default_settings: Whether the current settings of the Anomaly Alert Rule equals default settings.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] mode: mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]] multi_select_observations: A list of `multi_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]] prioritized_exclude_observations: A list of `prioritized_exclude_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateRequiredDataConnectorArgs']]] required_data_connectors: A `required_data_connector` block as defined below.
        :param pulumi.Input[builtins.str] settings_definition_id: The ID of the anomaly settings definition Id.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]] single_select_observations: A list of `single_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tactics: A list of categories of attacks by which to classify the rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]] threshold_observations: A list of `threshold_observation` blocks as defined below.
               
               > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        if anomaly_settings_version is not None:
            pulumi.set(__self__, "anomaly_settings_version", anomaly_settings_version)
        if anomaly_version is not None:
            pulumi.set(__self__, "anomaly_version", anomaly_version)
        if built_in_rule_id is not None:
            pulumi.set(__self__, "built_in_rule_id", built_in_rule_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if is_default_settings is not None:
            pulumi.set(__self__, "is_default_settings", is_default_settings)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if multi_select_observations is not None:
            pulumi.set(__self__, "multi_select_observations", multi_select_observations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prioritized_exclude_observations is not None:
            pulumi.set(__self__, "prioritized_exclude_observations", prioritized_exclude_observations)
        if required_data_connectors is not None:
            pulumi.set(__self__, "required_data_connectors", required_data_connectors)
        if settings_definition_id is not None:
            pulumi.set(__self__, "settings_definition_id", settings_definition_id)
        if single_select_observations is not None:
            pulumi.set(__self__, "single_select_observations", single_select_observations)
        if tactics is not None:
            pulumi.set(__self__, "tactics", tactics)
        if techniques is not None:
            pulumi.set(__self__, "techniques", techniques)
        if threshold_observations is not None:
            pulumi.set(__self__, "threshold_observations", threshold_observations)

    @property
    @pulumi.getter(name="anomalySettingsVersion")
    def anomaly_settings_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Anomaly Security ML Analytics Settings.
        """
        return pulumi.get(self, "anomaly_settings_version")

    @anomaly_settings_version.setter
    def anomaly_settings_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anomaly_settings_version", value)

    @property
    @pulumi.getter(name="anomalyVersion")
    def anomaly_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The anomaly version of the Anomaly Alert Rule.
        """
        return pulumi.get(self, "anomaly_version")

    @anomaly_version.setter
    def anomaly_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anomaly_version", value)

    @property
    @pulumi.getter(name="builtInRuleId")
    def built_in_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        """
        return pulumi.get(self, "built_in_rule_id")

    @built_in_rule_id.setter
    def built_in_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "built_in_rule_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Anomaly Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Display Name of the built-in Anomaly Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Duplicated Anomaly Alert Rule be enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The frequency the Anomaly Alert Rule will be run, such as "P1D".
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="isDefaultSettings")
    def is_default_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the current settings of the Anomaly Alert Rule equals default settings.
        """
        return pulumi.get(self, "is_default_settings")

    @is_default_settings.setter
    def is_default_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default_settings", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="multiSelectObservations")
    def multi_select_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]]]:
        """
        A list of `multi_select_observation` blocks as defined below.
        """
        return pulumi.get(self, "multi_select_observations")

    @multi_select_observations.setter
    def multi_select_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateMultiSelectObservationArgs']]]]):
        pulumi.set(self, "multi_select_observations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="prioritizedExcludeObservations")
    def prioritized_exclude_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]]]:
        """
        A list of `prioritized_exclude_observation` blocks as defined below.
        """
        return pulumi.get(self, "prioritized_exclude_observations")

    @prioritized_exclude_observations.setter
    def prioritized_exclude_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs']]]]):
        pulumi.set(self, "prioritized_exclude_observations", value)

    @property
    @pulumi.getter(name="requiredDataConnectors")
    def required_data_connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateRequiredDataConnectorArgs']]]]:
        """
        A `required_data_connector` block as defined below.
        """
        return pulumi.get(self, "required_data_connectors")

    @required_data_connectors.setter
    def required_data_connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateRequiredDataConnectorArgs']]]]):
        pulumi.set(self, "required_data_connectors", value)

    @property
    @pulumi.getter(name="settingsDefinitionId")
    def settings_definition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the anomaly settings definition Id.
        """
        return pulumi.get(self, "settings_definition_id")

    @settings_definition_id.setter
    def settings_definition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "settings_definition_id", value)

    @property
    @pulumi.getter(name="singleSelectObservations")
    def single_select_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]]]:
        """
        A list of `single_select_observation` blocks as defined below.
        """
        return pulumi.get(self, "single_select_observations")

    @single_select_observations.setter
    def single_select_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateSingleSelectObservationArgs']]]]):
        pulumi.set(self, "single_select_observations", value)

    @property
    @pulumi.getter
    def tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of categories of attacks by which to classify the rule.
        """
        return pulumi.get(self, "tactics")

    @tactics.setter
    def tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tactics", value)

    @property
    @pulumi.getter
    def techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @techniques.setter
    def techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "techniques", value)

    @property
    @pulumi.getter(name="thresholdObservations")
    def threshold_observations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]]]:
        """
        A list of `threshold_observation` blocks as defined below.

        > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        return pulumi.get(self, "threshold_observations")

    @threshold_observations.setter
    def threshold_observations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleAnomalyDuplicateThresholdObservationArgs']]]]):
        pulumi.set(self, "threshold_observations", value)


@pulumi.type_token("azure:sentinel/alertRuleAnomalyDuplicate:AlertRuleAnomalyDuplicate")
class AlertRuleAnomalyDuplicate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 built_in_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 multi_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateMultiSelectObservationArgs', 'AlertRuleAnomalyDuplicateMultiSelectObservationArgsDict']]]]] = None,
                 prioritized_exclude_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs', 'AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgsDict']]]]] = None,
                 single_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateSingleSelectObservationArgs', 'AlertRuleAnomalyDuplicateSingleSelectObservationArgsDict']]]]] = None,
                 threshold_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateThresholdObservationArgs', 'AlertRuleAnomalyDuplicateThresholdObservationArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Duplicated Anomaly Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-law",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example",
            workspace_id=example_analytics_workspace.id,
            customer_managed_key_enabled=False)
        example = azure.sentinel.get_alert_rule_anomaly_output(log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="UEBA Anomalous Sign In")
        example_alert_rule_anomaly_duplicate = azure.sentinel.AlertRuleAnomalyDuplicate("example",
            display_name="example duplicated UEBA Anomalous Sign In",
            log_analytics_workspace_id=example_analytics_workspace.id,
            built_in_rule_id=example.id,
            enabled=True,
            mode="Flighting",
            threshold_observations=[{
                "name": "Anomaly score threshold",
                "value": "0.6",
            }])
        ```

        ## Import

        Built In Anomaly Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleAnomalyDuplicate:AlertRuleAnomalyDuplicate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/securityMLAnalyticsSettings/setting1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] built_in_rule_id: The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] display_name: The Display Name of the built-in Anomaly Alert Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Duplicated Anomaly Alert Rule be enabled?
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] mode: mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateMultiSelectObservationArgs', 'AlertRuleAnomalyDuplicateMultiSelectObservationArgsDict']]]] multi_select_observations: A list of `multi_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs', 'AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgsDict']]]] prioritized_exclude_observations: A list of `prioritized_exclude_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateSingleSelectObservationArgs', 'AlertRuleAnomalyDuplicateSingleSelectObservationArgsDict']]]] single_select_observations: A list of `single_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateThresholdObservationArgs', 'AlertRuleAnomalyDuplicateThresholdObservationArgsDict']]]] threshold_observations: A list of `threshold_observation` blocks as defined below.
               
               > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertRuleAnomalyDuplicateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Duplicated Anomaly Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-law",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example",
            workspace_id=example_analytics_workspace.id,
            customer_managed_key_enabled=False)
        example = azure.sentinel.get_alert_rule_anomaly_output(log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="UEBA Anomalous Sign In")
        example_alert_rule_anomaly_duplicate = azure.sentinel.AlertRuleAnomalyDuplicate("example",
            display_name="example duplicated UEBA Anomalous Sign In",
            log_analytics_workspace_id=example_analytics_workspace.id,
            built_in_rule_id=example.id,
            enabled=True,
            mode="Flighting",
            threshold_observations=[{
                "name": "Anomaly score threshold",
                "value": "0.6",
            }])
        ```

        ## Import

        Built In Anomaly Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleAnomalyDuplicate:AlertRuleAnomalyDuplicate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/securityMLAnalyticsSettings/setting1
        ```

        :param str resource_name: The name of the resource.
        :param AlertRuleAnomalyDuplicateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertRuleAnomalyDuplicateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 built_in_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 multi_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateMultiSelectObservationArgs', 'AlertRuleAnomalyDuplicateMultiSelectObservationArgsDict']]]]] = None,
                 prioritized_exclude_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs', 'AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgsDict']]]]] = None,
                 single_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateSingleSelectObservationArgs', 'AlertRuleAnomalyDuplicateSingleSelectObservationArgsDict']]]]] = None,
                 threshold_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateThresholdObservationArgs', 'AlertRuleAnomalyDuplicateThresholdObservationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertRuleAnomalyDuplicateArgs.__new__(AlertRuleAnomalyDuplicateArgs)

            if built_in_rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'built_in_rule_id'")
            __props__.__dict__["built_in_rule_id"] = built_in_rule_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["multi_select_observations"] = multi_select_observations
            __props__.__dict__["prioritized_exclude_observations"] = prioritized_exclude_observations
            __props__.__dict__["single_select_observations"] = single_select_observations
            __props__.__dict__["threshold_observations"] = threshold_observations
            __props__.__dict__["anomaly_settings_version"] = None
            __props__.__dict__["anomaly_version"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["frequency"] = None
            __props__.__dict__["is_default_settings"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["required_data_connectors"] = None
            __props__.__dict__["settings_definition_id"] = None
            __props__.__dict__["tactics"] = None
            __props__.__dict__["techniques"] = None
        super(AlertRuleAnomalyDuplicate, __self__).__init__(
            'azure:sentinel/alertRuleAnomalyDuplicate:AlertRuleAnomalyDuplicate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anomaly_settings_version: Optional[pulumi.Input[builtins.int]] = None,
            anomaly_version: Optional[pulumi.Input[builtins.str]] = None,
            built_in_rule_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            frequency: Optional[pulumi.Input[builtins.str]] = None,
            is_default_settings: Optional[pulumi.Input[builtins.bool]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            multi_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateMultiSelectObservationArgs', 'AlertRuleAnomalyDuplicateMultiSelectObservationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            prioritized_exclude_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs', 'AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgsDict']]]]] = None,
            required_data_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateRequiredDataConnectorArgs', 'AlertRuleAnomalyDuplicateRequiredDataConnectorArgsDict']]]]] = None,
            settings_definition_id: Optional[pulumi.Input[builtins.str]] = None,
            single_select_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateSingleSelectObservationArgs', 'AlertRuleAnomalyDuplicateSingleSelectObservationArgsDict']]]]] = None,
            tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            threshold_observations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateThresholdObservationArgs', 'AlertRuleAnomalyDuplicateThresholdObservationArgsDict']]]]] = None) -> 'AlertRuleAnomalyDuplicate':
        """
        Get an existing AlertRuleAnomalyDuplicate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] anomaly_settings_version: The version of the Anomaly Security ML Analytics Settings.
        :param pulumi.Input[builtins.str] anomaly_version: The anomaly version of the Anomaly Alert Rule.
        :param pulumi.Input[builtins.str] built_in_rule_id: The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] description: The description of the Anomaly Alert Rule.
        :param pulumi.Input[builtins.str] display_name: The Display Name of the built-in Anomaly Alert Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Duplicated Anomaly Alert Rule be enabled?
        :param pulumi.Input[builtins.str] frequency: The frequency the Anomaly Alert Rule will be run, such as "P1D".
        :param pulumi.Input[builtins.bool] is_default_settings: Whether the current settings of the Anomaly Alert Rule equals default settings.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        :param pulumi.Input[builtins.str] mode: mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateMultiSelectObservationArgs', 'AlertRuleAnomalyDuplicateMultiSelectObservationArgsDict']]]] multi_select_observations: A list of `multi_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgs', 'AlertRuleAnomalyDuplicatePrioritizedExcludeObservationArgsDict']]]] prioritized_exclude_observations: A list of `prioritized_exclude_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateRequiredDataConnectorArgs', 'AlertRuleAnomalyDuplicateRequiredDataConnectorArgsDict']]]] required_data_connectors: A `required_data_connector` block as defined below.
        :param pulumi.Input[builtins.str] settings_definition_id: The ID of the anomaly settings definition Id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateSingleSelectObservationArgs', 'AlertRuleAnomalyDuplicateSingleSelectObservationArgsDict']]]] single_select_observations: A list of `single_select_observation` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tactics: A list of categories of attacks by which to classify the rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleAnomalyDuplicateThresholdObservationArgs', 'AlertRuleAnomalyDuplicateThresholdObservationArgsDict']]]] threshold_observations: A list of `threshold_observation` blocks as defined below.
               
               > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertRuleAnomalyDuplicateState.__new__(_AlertRuleAnomalyDuplicateState)

        __props__.__dict__["anomaly_settings_version"] = anomaly_settings_version
        __props__.__dict__["anomaly_version"] = anomaly_version
        __props__.__dict__["built_in_rule_id"] = built_in_rule_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["is_default_settings"] = is_default_settings
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["mode"] = mode
        __props__.__dict__["multi_select_observations"] = multi_select_observations
        __props__.__dict__["name"] = name
        __props__.__dict__["prioritized_exclude_observations"] = prioritized_exclude_observations
        __props__.__dict__["required_data_connectors"] = required_data_connectors
        __props__.__dict__["settings_definition_id"] = settings_definition_id
        __props__.__dict__["single_select_observations"] = single_select_observations
        __props__.__dict__["tactics"] = tactics
        __props__.__dict__["techniques"] = techniques
        __props__.__dict__["threshold_observations"] = threshold_observations
        return AlertRuleAnomalyDuplicate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anomalySettingsVersion")
    def anomaly_settings_version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Anomaly Security ML Analytics Settings.
        """
        return pulumi.get(self, "anomaly_settings_version")

    @property
    @pulumi.getter(name="anomalyVersion")
    def anomaly_version(self) -> pulumi.Output[builtins.str]:
        """
        The anomaly version of the Anomaly Alert Rule.
        """
        return pulumi.get(self, "anomaly_version")

    @property
    @pulumi.getter(name="builtInRuleId")
    def built_in_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the built-in Anomaly Alert Rule. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        """
        return pulumi.get(self, "built_in_rule_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the Anomaly Alert Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The Display Name of the built-in Anomaly Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should the Duplicated Anomaly Alert Rule be enabled?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[builtins.str]:
        """
        The frequency the Anomaly Alert Rule will be run, such as "P1D".
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="isDefaultSettings")
    def is_default_settings(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the current settings of the Anomaly Alert Rule equals default settings.
        """
        return pulumi.get(self, "is_default_settings")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Duplicated Anomaly Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[builtins.str]:
        """
        mode of the Duplicated Anomaly Alert Rule. Possible Values are `Production` and `Flighting`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="multiSelectObservations")
    def multi_select_observations(self) -> pulumi.Output[Sequence['outputs.AlertRuleAnomalyDuplicateMultiSelectObservation']]:
        """
        A list of `multi_select_observation` blocks as defined below.
        """
        return pulumi.get(self, "multi_select_observations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="prioritizedExcludeObservations")
    def prioritized_exclude_observations(self) -> pulumi.Output[Sequence['outputs.AlertRuleAnomalyDuplicatePrioritizedExcludeObservation']]:
        """
        A list of `prioritized_exclude_observation` blocks as defined below.
        """
        return pulumi.get(self, "prioritized_exclude_observations")

    @property
    @pulumi.getter(name="requiredDataConnectors")
    def required_data_connectors(self) -> pulumi.Output[Sequence['outputs.AlertRuleAnomalyDuplicateRequiredDataConnector']]:
        """
        A `required_data_connector` block as defined below.
        """
        return pulumi.get(self, "required_data_connectors")

    @property
    @pulumi.getter(name="settingsDefinitionId")
    def settings_definition_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the anomaly settings definition Id.
        """
        return pulumi.get(self, "settings_definition_id")

    @property
    @pulumi.getter(name="singleSelectObservations")
    def single_select_observations(self) -> pulumi.Output[Sequence['outputs.AlertRuleAnomalyDuplicateSingleSelectObservation']]:
        """
        A list of `single_select_observation` blocks as defined below.
        """
        return pulumi.get(self, "single_select_observations")

    @property
    @pulumi.getter
    def tactics(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of categories of attacks by which to classify the rule.
        """
        return pulumi.get(self, "tactics")

    @property
    @pulumi.getter
    def techniques(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @property
    @pulumi.getter(name="thresholdObservations")
    def threshold_observations(self) -> pulumi.Output[Sequence['outputs.AlertRuleAnomalyDuplicateThresholdObservation']]:
        """
        A list of `threshold_observation` blocks as defined below.

        > **Note:** un-specified `multi_select_observation`, `single_select_observation`, `prioritized_exclude_observation` and `threshold_observation` will be inherited from the built-in Anomaly Alert Rule.
        """
        return pulumi.get(self, "threshold_observations")

