# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlertRuleMsSecurityIncidentArgs', 'AlertRuleMsSecurityIncident']

@pulumi.input_type
class AlertRuleMsSecurityIncidentArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 log_analytics_workspace_id: pulumi.Input[builtins.str],
                 product_filter: pulumi.Input[builtins.str],
                 severity_filters: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 alert_rule_template_guid: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name_exclude_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AlertRuleMsSecurityIncident resource.
        :param pulumi.Input[builtins.str] display_name: The friendly name of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] product_filter: The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] severity_filters: Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.
               
               > **Note:** At least one of the severity filters need to be set.
        :param pulumi.Input[builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_exclude_filters: Only create incidents when the alert display name doesn't contain text from this list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_filters: Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        :param pulumi.Input[builtins.bool] enabled: Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "product_filter", product_filter)
        pulumi.set(__self__, "severity_filters", severity_filters)
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name_exclude_filters is not None:
            pulumi.set(__self__, "display_name_exclude_filters", display_name_exclude_filters)
        if display_name_filters is not None:
            pulumi.set(__self__, "display_name_filters", display_name_filters)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The friendly name of this Sentinel MS Security Incident Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter(name="productFilter")
    def product_filter(self) -> pulumi.Input[builtins.str]:
        """
        The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        """
        return pulumi.get(self, "product_filter")

    @product_filter.setter
    def product_filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "product_filter", value)

    @property
    @pulumi.getter(name="severityFilters")
    def severity_filters(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.

        > **Note:** At least one of the severity filters need to be set.
        """
        return pulumi.get(self, "severity_filters")

    @severity_filters.setter
    def severity_filters(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "severity_filters", value)

    @property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of this Sentinel MS Security Incident Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayNameExcludeFilters")
    def display_name_exclude_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only create incidents when the alert display name doesn't contain text from this list.
        """
        return pulumi.get(self, "display_name_exclude_filters")

    @display_name_exclude_filters.setter
    def display_name_exclude_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "display_name_exclude_filters", value)

    @property
    @pulumi.getter(name="displayNameFilters")
    def display_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        """
        return pulumi.get(self, "display_name_filters")

    @display_name_filters.setter
    def display_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "display_name_filters", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AlertRuleMsSecurityIncidentState:
    def __init__(__self__, *,
                 alert_rule_template_guid: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name_exclude_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 product_filter: Optional[pulumi.Input[builtins.str]] = None,
                 severity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AlertRuleMsSecurityIncident resources.
        :param pulumi.Input[builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[builtins.str] display_name: The friendly name of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_exclude_filters: Only create incidents when the alert display name doesn't contain text from this list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_filters: Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        :param pulumi.Input[builtins.bool] enabled: Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] product_filter: The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] severity_filters: Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.
               
               > **Note:** At least one of the severity filters need to be set.
        """
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if display_name_exclude_filters is not None:
            pulumi.set(__self__, "display_name_exclude_filters", display_name_exclude_filters)
        if display_name_filters is not None:
            pulumi.set(__self__, "display_name_filters", display_name_filters)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_filter is not None:
            pulumi.set(__self__, "product_filter", product_filter)
        if severity_filters is not None:
            pulumi.set(__self__, "severity_filters", severity_filters)

    @property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of this Sentinel MS Security Incident Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The friendly name of this Sentinel MS Security Incident Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="displayNameExcludeFilters")
    def display_name_exclude_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only create incidents when the alert display name doesn't contain text from this list.
        """
        return pulumi.get(self, "display_name_exclude_filters")

    @display_name_exclude_filters.setter
    def display_name_exclude_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "display_name_exclude_filters", value)

    @property
    @pulumi.getter(name="displayNameFilters")
    def display_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        """
        return pulumi.get(self, "display_name_filters")

    @display_name_filters.setter
    def display_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "display_name_filters", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productFilter")
    def product_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        """
        return pulumi.get(self, "product_filter")

    @product_filter.setter
    def product_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "product_filter", value)

    @property
    @pulumi.getter(name="severityFilters")
    def severity_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.

        > **Note:** At least one of the severity filters need to be set.
        """
        return pulumi.get(self, "severity_filters")

    @severity_filters.setter
    def severity_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "severity_filters", value)


@pulumi.type_token("azure:sentinel/alertRuleMsSecurityIncident:AlertRuleMsSecurityIncident")
class AlertRuleMsSecurityIncident(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name_exclude_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 product_filter: Optional[pulumi.Input[builtins.str]] = None,
                 severity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Sentinel MS Security Incident Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_ms_security_incident = azure.sentinel.AlertRuleMsSecurityIncident("example",
            name="example-ms-security-incident-alert-rule",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            product_filter="Microsoft Cloud App Security",
            display_name="example rule",
            severity_filters=["High"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2023-12-01-preview

        ## Import

        Sentinel MS Security Incident Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleMsSecurityIncident:AlertRuleMsSecurityIncident example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[builtins.str] display_name: The friendly name of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_exclude_filters: Only create incidents when the alert display name doesn't contain text from this list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_filters: Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        :param pulumi.Input[builtins.bool] enabled: Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] product_filter: The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] severity_filters: Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.
               
               > **Note:** At least one of the severity filters need to be set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertRuleMsSecurityIncidentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel MS Security Incident Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_ms_security_incident = azure.sentinel.AlertRuleMsSecurityIncident("example",
            name="example-ms-security-incident-alert-rule",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            product_filter="Microsoft Cloud App Security",
            display_name="example rule",
            severity_filters=["High"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2023-12-01-preview

        ## Import

        Sentinel MS Security Incident Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleMsSecurityIncident:AlertRuleMsSecurityIncident example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param AlertRuleMsSecurityIncidentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertRuleMsSecurityIncidentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name_exclude_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 product_filter: Optional[pulumi.Input[builtins.str]] = None,
                 severity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertRuleMsSecurityIncidentArgs.__new__(AlertRuleMsSecurityIncidentArgs)

            __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["display_name_exclude_filters"] = display_name_exclude_filters
            __props__.__dict__["display_name_filters"] = display_name_filters
            __props__.__dict__["enabled"] = enabled
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            if product_filter is None and not opts.urn:
                raise TypeError("Missing required property 'product_filter'")
            __props__.__dict__["product_filter"] = product_filter
            if severity_filters is None and not opts.urn:
                raise TypeError("Missing required property 'severity_filters'")
            __props__.__dict__["severity_filters"] = severity_filters
        super(AlertRuleMsSecurityIncident, __self__).__init__(
            'azure:sentinel/alertRuleMsSecurityIncident:AlertRuleMsSecurityIncident',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_rule_template_guid: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            display_name_exclude_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            display_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            product_filter: Optional[pulumi.Input[builtins.str]] = None,
            severity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'AlertRuleMsSecurityIncident':
        """
        Get an existing AlertRuleMsSecurityIncident resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[builtins.str] display_name: The friendly name of this Sentinel MS Security Incident Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_exclude_filters: Only create incidents when the alert display name doesn't contain text from this list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] display_name_filters: Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        :param pulumi.Input[builtins.bool] enabled: Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        :param pulumi.Input[builtins.str] product_filter: The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] severity_filters: Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.
               
               > **Note:** At least one of the severity filters need to be set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertRuleMsSecurityIncidentState.__new__(_AlertRuleMsSecurityIncidentState)

        __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["display_name_exclude_filters"] = display_name_exclude_filters
        __props__.__dict__["display_name_filters"] = display_name_filters
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["product_filter"] = product_filter
        __props__.__dict__["severity_filters"] = severity_filters
        return AlertRuleMsSecurityIncident(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The GUID of the alert rule template which is used to create this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of this Sentinel MS Security Incident Alert Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The friendly name of this Sentinel MS Security Incident Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameExcludeFilters")
    def display_name_exclude_filters(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Only create incidents when the alert display name doesn't contain text from this list.
        """
        return pulumi.get(self, "display_name_exclude_filters")

    @property
    @pulumi.getter(name="displayNameFilters")
    def display_name_filters(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Only create incidents when the alert display name contain text from this list, leave empty to apply no filter.
        """
        return pulumi.get(self, "display_name_filters")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should this Sentinel MS Security Incident Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel MS Security Incident Alert Rule belongs to. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Sentinel MS Security Incident Alert Rule. Changing this forces a new Sentinel MS Security Incident Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productFilter")
    def product_filter(self) -> pulumi.Output[builtins.str]:
        """
        The Microsoft Security Service from where the alert will be generated. Possible values are `Azure Active Directory Identity Protection`, `Azure Advanced Threat Protection`, `Azure Security Center`, `Azure Security Center for IoT`, `Microsoft Cloud App Security`, `Microsoft Defender Advanced Threat Protection` and `Office 365 Advanced Threat Protection`.
        """
        return pulumi.get(self, "product_filter")

    @property
    @pulumi.getter(name="severityFilters")
    def severity_filters(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Only create incidents from alerts when alert severity level is contained in this list. Possible values are `High`, `Medium`, `Low` and `Informational`.

        > **Note:** At least one of the severity filters need to be set.
        """
        return pulumi.get(self, "severity_filters")

