# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthomationRuleArgs', 'AuthomationRule']

@pulumi.input_type
class AuthomationRuleArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 log_analytics_workspace_id: pulumi.Input[builtins.str],
                 order: pulumi.Input[builtins.int],
                 action_incidents: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]]] = None,
                 action_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]]] = None,
                 condition_json: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 triggers_on: Optional[pulumi.Input[builtins.str]] = None,
                 triggers_when: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthomationRule resource.
        :param pulumi.Input[builtins.str] display_name: The display name which should be used for this Sentinel Automation Rule.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.int] order: The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        :param pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]] action_incidents: One or more `action_incident` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]] action_playbooks: One or more `action_playbook` blocks as defined below.
               
               > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        :param pulumi.Input[builtins.str] condition_json: A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        :param pulumi.Input[builtins.bool] enabled: Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] expiration: The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        :param pulumi.Input[builtins.str] name: The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.str] triggers_on: Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        :param pulumi.Input[builtins.str] triggers_when: Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "order", order)
        if action_incidents is not None:
            pulumi.set(__self__, "action_incidents", action_incidents)
        if action_playbooks is not None:
            pulumi.set(__self__, "action_playbooks", action_playbooks)
        if condition_json is not None:
            pulumi.set(__self__, "condition_json", condition_json)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if triggers_on is not None:
            pulumi.set(__self__, "triggers_on", triggers_on)
        if triggers_when is not None:
            pulumi.set(__self__, "triggers_when", triggers_when)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name which should be used for this Sentinel Automation Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[builtins.int]:
        """
        The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="actionIncidents")
    def action_incidents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]]]:
        """
        One or more `action_incident` blocks as defined below.
        """
        return pulumi.get(self, "action_incidents")

    @action_incidents.setter
    def action_incidents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]]]):
        pulumi.set(self, "action_incidents", value)

    @property
    @pulumi.getter(name="actionPlaybooks")
    def action_playbooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]]]:
        """
        One or more `action_playbook` blocks as defined below.

        > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        """
        return pulumi.get(self, "action_playbooks")

    @action_playbooks.setter
    def action_playbooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]]]):
        pulumi.set(self, "action_playbooks", value)

    @property
    @pulumi.getter(name="conditionJson")
    def condition_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        """
        return pulumi.get(self, "condition_json")

    @condition_json.setter
    def condition_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_json", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        """
        return pulumi.get(self, "triggers_on")

    @triggers_on.setter
    def triggers_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "triggers_on", value)

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        return pulumi.get(self, "triggers_when")

    @triggers_when.setter
    def triggers_when(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "triggers_when", value)


@pulumi.input_type
class _AuthomationRuleState:
    def __init__(__self__, *,
                 action_incidents: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]]] = None,
                 action_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]]] = None,
                 condition_json: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 triggers_on: Optional[pulumi.Input[builtins.str]] = None,
                 triggers_when: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthomationRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]] action_incidents: One or more `action_incident` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]] action_playbooks: One or more `action_playbook` blocks as defined below.
               
               > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        :param pulumi.Input[builtins.str] condition_json: A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        :param pulumi.Input[builtins.str] display_name: The display name which should be used for this Sentinel Automation Rule.
        :param pulumi.Input[builtins.bool] enabled: Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] expiration: The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.str] name: The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.int] order: The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        :param pulumi.Input[builtins.str] triggers_on: Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        :param pulumi.Input[builtins.str] triggers_when: Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        if action_incidents is not None:
            pulumi.set(__self__, "action_incidents", action_incidents)
        if action_playbooks is not None:
            pulumi.set(__self__, "action_playbooks", action_playbooks)
        if condition_json is not None:
            pulumi.set(__self__, "condition_json", condition_json)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if triggers_on is not None:
            pulumi.set(__self__, "triggers_on", triggers_on)
        if triggers_when is not None:
            pulumi.set(__self__, "triggers_when", triggers_when)

    @property
    @pulumi.getter(name="actionIncidents")
    def action_incidents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]]]:
        """
        One or more `action_incident` blocks as defined below.
        """
        return pulumi.get(self, "action_incidents")

    @action_incidents.setter
    def action_incidents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionIncidentArgs']]]]):
        pulumi.set(self, "action_incidents", value)

    @property
    @pulumi.getter(name="actionPlaybooks")
    def action_playbooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]]]:
        """
        One or more `action_playbook` blocks as defined below.

        > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        """
        return pulumi.get(self, "action_playbooks")

    @action_playbooks.setter
    def action_playbooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthomationRuleActionPlaybookArgs']]]]):
        pulumi.set(self, "action_playbooks", value)

    @property
    @pulumi.getter(name="conditionJson")
    def condition_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        """
        return pulumi.get(self, "condition_json")

    @condition_json.setter
    def condition_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_json", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name which should be used for this Sentinel Automation Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        """
        return pulumi.get(self, "triggers_on")

    @triggers_on.setter
    def triggers_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "triggers_on", value)

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        return pulumi.get(self, "triggers_when")

    @triggers_when.setter
    def triggers_when(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "triggers_when", value)


warnings.warn("""azure.sentinel.AuthomationRule has been deprecated in favor of azure.sentinel.AutomationRule""", DeprecationWarning)


@pulumi.type_token("azure:sentinel/authomationRule:AuthomationRule")
class AuthomationRule(pulumi.CustomResource):
    warnings.warn("""azure.sentinel.AuthomationRule has been deprecated in favor of azure.sentinel.AutomationRule""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_incidents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionIncidentArgs', 'AuthomationRuleActionIncidentArgsDict']]]]] = None,
                 action_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionPlaybookArgs', 'AuthomationRuleActionPlaybookArgsDict']]]]] = None,
                 condition_json: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 triggers_on: Optional[pulumi.Input[builtins.str]] = None,
                 triggers_when: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Sentinel Automation Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_automation_rule = azure.sentinel.AutomationRule("example",
            name="56094f72-ac3f-40e7-a0c0-47bd95f70336",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="automation_rule1",
            order=1,
            action_incidents=[{
                "order": 1,
                "status": "Active",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2024-09-01

        ## Import

        Sentinel Automation Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/authomationRule:AuthomationRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/automationRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionIncidentArgs', 'AuthomationRuleActionIncidentArgsDict']]]] action_incidents: One or more `action_incident` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionPlaybookArgs', 'AuthomationRuleActionPlaybookArgsDict']]]] action_playbooks: One or more `action_playbook` blocks as defined below.
               
               > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        :param pulumi.Input[builtins.str] condition_json: A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        :param pulumi.Input[builtins.str] display_name: The display name which should be used for this Sentinel Automation Rule.
        :param pulumi.Input[builtins.bool] enabled: Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] expiration: The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.str] name: The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.int] order: The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        :param pulumi.Input[builtins.str] triggers_on: Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        :param pulumi.Input[builtins.str] triggers_when: Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthomationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Automation Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_automation_rule = azure.sentinel.AutomationRule("example",
            name="56094f72-ac3f-40e7-a0c0-47bd95f70336",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="automation_rule1",
            order=1,
            action_incidents=[{
                "order": 1,
                "status": "Active",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2024-09-01

        ## Import

        Sentinel Automation Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/authomationRule:AuthomationRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/automationRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param AuthomationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthomationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_incidents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionIncidentArgs', 'AuthomationRuleActionIncidentArgsDict']]]]] = None,
                 action_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionPlaybookArgs', 'AuthomationRuleActionPlaybookArgsDict']]]]] = None,
                 condition_json: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 triggers_on: Optional[pulumi.Input[builtins.str]] = None,
                 triggers_when: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""AuthomationRule is deprecated: azure.sentinel.AuthomationRule has been deprecated in favor of azure.sentinel.AutomationRule""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthomationRuleArgs.__new__(AuthomationRuleArgs)

            __props__.__dict__["action_incidents"] = action_incidents
            __props__.__dict__["action_playbooks"] = action_playbooks
            __props__.__dict__["condition_json"] = condition_json
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["expiration"] = expiration
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            if order is None and not opts.urn:
                raise TypeError("Missing required property 'order'")
            __props__.__dict__["order"] = order
            __props__.__dict__["triggers_on"] = triggers_on
            __props__.__dict__["triggers_when"] = triggers_when
        super(AuthomationRule, __self__).__init__(
            'azure:sentinel/authomationRule:AuthomationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_incidents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionIncidentArgs', 'AuthomationRuleActionIncidentArgsDict']]]]] = None,
            action_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionPlaybookArgs', 'AuthomationRuleActionPlaybookArgsDict']]]]] = None,
            condition_json: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            expiration: Optional[pulumi.Input[builtins.str]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            order: Optional[pulumi.Input[builtins.int]] = None,
            triggers_on: Optional[pulumi.Input[builtins.str]] = None,
            triggers_when: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthomationRule':
        """
        Get an existing AuthomationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionIncidentArgs', 'AuthomationRuleActionIncidentArgsDict']]]] action_incidents: One or more `action_incident` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthomationRuleActionPlaybookArgs', 'AuthomationRuleActionPlaybookArgsDict']]]] action_playbooks: One or more `action_playbook` blocks as defined below.
               
               > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        :param pulumi.Input[builtins.str] condition_json: A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        :param pulumi.Input[builtins.str] display_name: The display name which should be used for this Sentinel Automation Rule.
        :param pulumi.Input[builtins.bool] enabled: Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] expiration: The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.str] name: The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        :param pulumi.Input[builtins.int] order: The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        :param pulumi.Input[builtins.str] triggers_on: Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        :param pulumi.Input[builtins.str] triggers_when: Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthomationRuleState.__new__(_AuthomationRuleState)

        __props__.__dict__["action_incidents"] = action_incidents
        __props__.__dict__["action_playbooks"] = action_playbooks
        __props__.__dict__["condition_json"] = condition_json
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["order"] = order
        __props__.__dict__["triggers_on"] = triggers_on
        __props__.__dict__["triggers_when"] = triggers_when
        return AuthomationRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionIncidents")
    def action_incidents(self) -> pulumi.Output[Optional[Sequence['outputs.AuthomationRuleActionIncident']]]:
        """
        One or more `action_incident` blocks as defined below.
        """
        return pulumi.get(self, "action_incidents")

    @property
    @pulumi.getter(name="actionPlaybooks")
    def action_playbooks(self) -> pulumi.Output[Optional[Sequence['outputs.AuthomationRuleActionPlaybook']]]:
        """
        One or more `action_playbook` blocks as defined below.

        > **Note:** Either one `action_incident` block or `action_playbook` block has to be specified.
        """
        return pulumi.get(self, "action_playbooks")

    @property
    @pulumi.getter(name="conditionJson")
    def condition_json(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A JSON array of one or more condition JSON objects as is defined [here](https://learn.microsoft.com/en-us/rest/api/securityinsights/preview/automation-rules/create-or-update?tabs=HTTP#automationruletriggeringlogic).
        """
        return pulumi.get(self, "condition_json")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name which should be used for this Sentinel Automation Rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this Sentinel Automation Rule is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The time in RFC3339 format of kind `UTC` that determines when this Automation Rule should expire and be disabled.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace where this Sentinel applies to. Changing this forces a new Sentinel Automation Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The UUID which should be used for this Sentinel Automation Rule. Changing this forces a new Sentinel Automation Rule to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> pulumi.Output[builtins.int]:
        """
        The order of this Sentinel Automation Rule. Possible values varies between `1` and `1000`.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies what triggers this automation rule. Possible values are `Alerts` and `Incidents`. Defaults to `Incidents`.
        """
        return pulumi.get(self, "triggers_on")

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies when will this automation rule be triggered. Possible values are `Created` and `Updated`. Defaults to `Created`.
        """
        return pulumi.get(self, "triggers_when")

