# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataConnectorAwsS3Args', 'DataConnectorAwsS3']

@pulumi.input_type
class DataConnectorAwsS3Args:
    def __init__(__self__, *,
                 aws_role_arn: pulumi.Input[builtins.str],
                 destination_table: pulumi.Input[builtins.str],
                 log_analytics_workspace_id: pulumi.Input[builtins.str],
                 sqs_urls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataConnectorAwsS3 resource.
        :param pulumi.Input[builtins.str] aws_role_arn: The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        :param pulumi.Input[builtins.str] destination_table: The name of the Log Analytics table that will store the ingested data.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sqs_urls: Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        :param pulumi.Input[builtins.str] name: The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "destination_table", destination_table)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "sqs_urls", sqs_urls)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        """
        return pulumi.get(self, "aws_role_arn")

    @aws_role_arn.setter
    def aws_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_role_arn", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Log Analytics table that will store the ingested data.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter(name="sqsUrls")
    def sqs_urls(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        """
        return pulumi.get(self, "sqs_urls")

    @sqs_urls.setter
    def sqs_urls(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "sqs_urls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DataConnectorAwsS3State:
    def __init__(__self__, *,
                 aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_table: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sqs_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DataConnectorAwsS3 resources.
        :param pulumi.Input[builtins.str] aws_role_arn: The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        :param pulumi.Input[builtins.str] destination_table: The name of the Log Analytics table that will store the ingested data.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sqs_urls: Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        """
        if aws_role_arn is not None:
            pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sqs_urls is not None:
            pulumi.set(__self__, "sqs_urls", sqs_urls)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        """
        return pulumi.get(self, "aws_role_arn")

    @aws_role_arn.setter
    def aws_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_role_arn", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Log Analytics table that will store the ingested data.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sqsUrls")
    def sqs_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        """
        return pulumi.get(self, "sqs_urls")

    @sqs_urls.setter
    def sqs_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sqs_urls", value)


@pulumi.type_token("azure:sentinel/dataConnectorAwsS3:DataConnectorAwsS3")
class DataConnectorAwsS3(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_table: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sqs_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a AWS S3 Data Connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_data_connector_aws_s3 = azure.sentinel.DataConnectorAwsS3("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            aws_role_arn="arn:aws:iam::000000000000:role/role1",
            destination_table="AWSGuardDuty",
            sqs_urls=["https://sqs.us-east-1.amazonaws.com/000000000000/example"])
        ```

        ## Import

        AWS S3 Data Connectors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/dataConnectorAwsS3:DataConnectorAwsS3 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/dataConnectors/dc1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_role_arn: The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        :param pulumi.Input[builtins.str] destination_table: The name of the Log Analytics table that will store the ingested data.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sqs_urls: Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataConnectorAwsS3Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a AWS S3 Data Connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_data_connector_aws_s3 = azure.sentinel.DataConnectorAwsS3("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            aws_role_arn="arn:aws:iam::000000000000:role/role1",
            destination_table="AWSGuardDuty",
            sqs_urls=["https://sqs.us-east-1.amazonaws.com/000000000000/example"])
        ```

        ## Import

        AWS S3 Data Connectors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/dataConnectorAwsS3:DataConnectorAwsS3 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/dataConnectors/dc1
        ```

        :param str resource_name: The name of the resource.
        :param DataConnectorAwsS3Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataConnectorAwsS3Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_table: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sqs_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataConnectorAwsS3Args.__new__(DataConnectorAwsS3Args)

            if aws_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'aws_role_arn'")
            __props__.__dict__["aws_role_arn"] = aws_role_arn
            if destination_table is None and not opts.urn:
                raise TypeError("Missing required property 'destination_table'")
            __props__.__dict__["destination_table"] = destination_table
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            if sqs_urls is None and not opts.urn:
                raise TypeError("Missing required property 'sqs_urls'")
            __props__.__dict__["sqs_urls"] = sqs_urls
        super(DataConnectorAwsS3, __self__).__init__(
            'azure:sentinel/dataConnectorAwsS3:DataConnectorAwsS3',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            destination_table: Optional[pulumi.Input[builtins.str]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            sqs_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'DataConnectorAwsS3':
        """
        Get an existing DataConnectorAwsS3 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_role_arn: The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        :param pulumi.Input[builtins.str] destination_table: The name of the Log Analytics table that will store the ingested data.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sqs_urls: Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataConnectorAwsS3State.__new__(_DataConnectorAwsS3State)

        __props__.__dict__["aws_role_arn"] = aws_role_arn
        __props__.__dict__["destination_table"] = destination_table
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["sqs_urls"] = sqs_urls
        return DataConnectorAwsS3(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the AWS role, which is connected to this AWS CloudTrail Data Connector. See the [Azure document](https://docs.microsoft.com/azure/sentinel/connect-aws?tabs=s3#create-an-aws-assumed-role-and-grant-access-to-the-aws-sentinel-account) for details.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Log Analytics table that will store the ingested data.
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace that this AWS S3 Data Connector resides in. Changing this forces a new AWS S3 Data Connector to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this AWS S3 Data Connector. Changing this forces a new AWS S3 Data Connector to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sqsUrls")
    def sqs_urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies a list of AWS SQS urls for the AWS S3 Data Connector.
        """
        return pulumi.get(self, "sqs_urls")

